/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.graph.PruningIterator;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.ui.tests.egit.CompareGitTestCase;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.api.Status;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModelResolverRemoteTest
extends CompareGitTestCase {
    private static final String PROJECT2_NAME = "Project-2";
    private static final String FILE1_NAME = "file1.ecore";
    private static final String FILE2_NAME = "file2.ecore";
    private static final String FILE3_NAME = "file3.ecore";
    private static final String FILE4_NAME = "file4.ecore";
    private static final String FILE1_SUFFIX = "_file1";
    private static final String FILE2_SUFFIX = "_file2";
    private static final String FILE3_SUFFIX = "_file3";
    private static final String FILE4_SUFFIX = "_file4";
    private TestProject project2;
    private IFile iFile1;
    private IFile iFile2;
    private IFile iFile3;
    private IFile iFile4;
    private String initialCommit;
    private String targetCommit;
    private CrossReferenceResolutionScope originalResolutionScope;

    @Override
    @Before
    public void setUp() throws Exception {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        String stringValue = store.getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
        this.originalResolutionScope = CrossReferenceResolutionScope.valueOf((String)stringValue);
        this.project2 = new TestProject(PROJECT2_NAME);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        EMFModelProvider emfModelProvider = (EMFModelProvider)ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider").getModelProvider();
        emfModelProvider.clear();
        this.setResolutionScope(this.originalResolutionScope);
        this.iFile1 = null;
        this.iFile2 = null;
        this.project2.dispose();
        super.tearDown();
    }

    private List<IFile> setUpCase1() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.save((ResourceSet)resourceSet);
        this.initialCommit = this.repository.addAllAndCommit("initial-commit").getId().getName();
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        this.addWhiteLine(this.iFile2);
        this.targetCommit = this.repository.addAllAndCommit("first-commit").getId().getName();
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.repository.checkoutBranch(this.initialCommit);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case1_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase1();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}), this.uriSet(new IStorage[]{this.iFile2}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1, this.iFile2}));
        StorageTraversal expectedFile2Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile2Traversal, expectedFile2Traversal, expectedFile2Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Result);
        }
    }

    @Test
    public void test_case1_outgoing() throws Exception {
        List<IFile> files = this.setUpCase1();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}), this.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile2}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1, this.iFile2}));
        StorageTraversal expectedFile2Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, expectedFile2Traversal, expectedFile2Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Result);
    }

    @Test
    public void test_case1_self() throws Exception {
        List<IFile> files = this.setUpCase1();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile2}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1}));
        StorageTraversal expectedFile2Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, expectedFile2Traversal, expectedFile2Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Result);
    }

    private List<IFile> setUpCase2() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        this.iFile2 = this.project.getIFile(iProject, file2);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.save((ResourceSet)resourceSet);
        this.initialCommit = this.repository.addAllAndCommit("initial-commit").getId().getName();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        this.addWhiteLine(this.iFile2);
        this.targetCommit = this.repository.addAllAndCommit("first-commit").getId().getName();
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.repository.checkoutBranch(this.initialCommit);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case2_workspace_project_container_outgoing_self() throws Exception {
        List<IFile> files = this.setUpCase2();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile2}));
        StorageTraversal expectedTraversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, expectedTraversal, expectedTraversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, expectedTraversal, expectedTraversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER, CrossReferenceResolutionScope.OUTGOING, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(accessor, Arrays.asList(this.iFile2), expectedFile1Result, expectedFile2Result);
        }
    }

    private List<IFile> setUpCase3() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        this.iFile3 = this.project.getIFile(iProject, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource2, resource3);
        this.save((ResourceSet)resourceSet);
        this.initialCommit = this.repository.addAllAndCommit("initial-commit").getId().getName();
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        this.addWhiteLine(this.iFile2);
        this.addWhiteLine(this.iFile3);
        this.targetCommit = this.repository.addAllAndCommit("first-commit").getId().getName();
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.repository.checkoutBranch(this.initialCommit);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case3_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase3();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}), this.uriSet(new IStorage[]{this.iFile2, this.iFile3}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        StorageTraversal expectedFile2Or3Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2, this.iFile3}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Or3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile2Or3Traversal, expectedFile2Or3Traversal, expectedFile2Or3Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Or3Result, expectedFile2Or3Result);
        }
    }

    @Test
    public void test_case3_outgoing() throws Exception {
        List<IFile> files = this.setUpCase3();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}), this.uriSet(new IStorage[]{this.iFile2, this.iFile3}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile2, this.iFile3}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile3}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        StorageTraversal expectedFile2Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2, this.iFile3}));
        StorageTraversal expectedFile3Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile3}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, expectedFile2Traversal, expectedFile2Traversal);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, expectedFile3Traversal, expectedFile3Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case3_self() throws Exception {
        List<IFile> files = this.setUpCase3();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile3}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1}));
        StorageTraversal expectedFile2Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2}));
        StorageTraversal expectedFile3Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile3}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, expectedFile2Traversal, expectedFile2Traversal);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, expectedFile3Traversal, expectedFile3Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase4() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject, FILE3_NAME);
        File file4 = this.project.getOrCreateFile(iProject, FILE4_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        this.iFile3 = this.project.getIFile(iProject, file3);
        this.iFile4 = this.project.getIFile(iProject, file4);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        Resource resource4 = this.connectResource(this.iFile4, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        resource4.getContents().add((Object)this.createBasicModel(FILE4_SUFFIX));
        this.makeCrossReference(resource2, resource3);
        this.save((ResourceSet)resourceSet);
        this.initialCommit = this.repository.addAllAndCommit("initial-commit").getId().getName();
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource3, resource4);
        this.save((ResourceSet)resourceSet);
        this.addWhiteLine(this.iFile2);
        this.addWhiteLine(this.iFile4);
        this.targetCommit = this.repository.addAllAndCommit("first-commit").getId().getName();
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        this.repository.checkoutBranch(this.initialCommit);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3, this.iFile4);
    }

    @Test
    public void test_case4_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase4();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}), this.uriSet(new IStorage[]{this.iFile2, this.iFile3}), this.uriSet(new IStorage[]{this.iFile4}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3, this.iFile4}));
        StorageTraversal expectedFile2Or3Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2, this.iFile3, this.iFile4}));
        StorageTraversal expectedFile4Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile4}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Or3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile2Or3Traversal, expectedFile2Or3Traversal, expectedFile2Or3Traversal);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile4Traversal, expectedFile4Traversal, expectedFile4Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Or3Result, expectedFile2Or3Result, expectedFile4Result);
        }
    }

    @Test
    public void test_case4_outgoing() throws Exception {
        List<IFile> files = this.setUpCase4();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}), this.uriSet(new IStorage[]{this.iFile2, this.iFile3}), this.uriSet(new IStorage[]{this.iFile4}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile2, this.iFile3}), this.uriSet(new IStorage[]{this.iFile4}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile3}), this.uriSet(new IStorage[]{this.iFile4}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile4}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3, this.iFile4}));
        StorageTraversal expectedFile2Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2, this.iFile3, this.iFile4}));
        StorageTraversal expectedFile3Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile3, this.iFile4}));
        StorageTraversal expectedFile4Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile4}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, expectedFile2Traversal, expectedFile2Traversal);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, expectedFile3Traversal, expectedFile3Traversal);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, expectedFile4Traversal, expectedFile4Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    @Test
    public void test_case4_self() throws Exception {
        List<IFile> files = this.setUpCase4();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile3}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(this.uriSet(new IStorage[]{this.iFile4}));
        StorageTraversal expectedFile1Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile1}));
        StorageTraversal expectedFile2Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile2}));
        StorageTraversal expectedFile3Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile3}));
        StorageTraversal expectedFile4Traversal = this.expectedTraversal(0, this.storageSet(new IStorage[]{this.iFile4}));
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, expectedFile1Traversal, expectedFile1Traversal);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, expectedFile2Traversal, expectedFile2Traversal);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, expectedFile3Traversal, expectedFile3Traversal);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, expectedFile4Traversal, expectedFile4Traversal);
        IStorageProviderAccessor accessor = this.createAccessorForComparison(this.initialCommit, this.targetCommit, true);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(accessor, files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    private void setResolutionScope(CrossReferenceResolutionScope scope) {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", scope.name());
    }

    private void resolveAndCheckResult(IStorageProviderAccessor accessor, List<IFile> files, ExpectedResult ... expected) throws Exception {
        int i = 0;
        while (i < files.size()) {
            ResolvingResult resolutionResult = this.resolveTraversalOf(accessor, files.get(i));
            this.assertResultMatches(expected[i], resolutionResult);
            ++i;
        }
    }

    private void assertResultMatches(ExpectedResult expected, ResolvingResult actual) {
        this.assertTraversalsMatch(expected.getLeftTraversal(), actual.getSyncModel().getLeftTraversal());
        this.assertTraversalsMatch(expected.getRightTraversal(), actual.getSyncModel().getRightTraversal());
        this.assertTraversalsMatch(expected.getOriginTraversal(), actual.getSyncModel().getOriginTraversal());
        Set<Set<URI>> actualGraph = actual.getSubGraphs();
        Set<? extends Set<URI>> expectedGraph = expected.getSubGraphs();
        Assert.assertEquals((long)expectedGraph.size(), (long)actualGraph.size());
        Assert.assertTrue((boolean)actualGraph.containsAll(expectedGraph));
    }

    private void assertTraversalsMatch(StorageTraversal expected, StorageTraversal actual) {
        Assert.assertEquals((long)expected.getDiagnostic().getSeverity(), (long)actual.getDiagnostic().getSeverity());
        Set actualStorages = actual.getStorages();
        Set expectedStorages = expected.getStorages();
        Assert.assertEquals((long)expectedStorages.size(), (long)actualStorages.size());
        Iterator expectedIt = expectedStorages.iterator();
        while (expectedIt.hasNext()) {
            Assert.assertTrue((boolean)this.contains(actualStorages, (IStorage)expectedIt.next()));
        }
    }

    private boolean contains(Set<? extends IStorage> set, IStorage element) {
        IPath elementPath = ResourceUtil.getFixedPath((IStorage)element);
        for (IStorage iStorage : set) {
            IPath nextPath = ResourceUtil.getFixedPath((IStorage)iStorage);
            if (!nextPath.isPrefixOf(elementPath)) continue;
            return true;
        }
        return false;
    }

    private Set<URI> uriSet(IStorage ... storages) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(storages), (Function)ResourceUtil.asURI()));
    }

    private Set<IStorage> storageSet(IStorage ... storages) {
        return Sets.newLinkedHashSet(Arrays.asList(storages));
    }

    private StorageTraversal expectedTraversal(int severity, Set<IStorage> storages) {
        return new StorageTraversal(storages, (Diagnostic)new BasicDiagnostic(severity, "", 0, "", null));
    }

    private ResolvingResult resolveTraversalOf(IStorageProviderAccessor accessor, IFile file) throws Exception {
        ThreadedModelResolver resolver = new ThreadedModelResolver();
        resolver.setGraph((IGraph)new Graph());
        resolver.initialize();
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        IStorage leftStorage = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.SOURCE).getStorage((IProgressMonitor)nullMonitor);
        IStorage rightStorage = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.REMOTE).getStorage((IProgressMonitor)nullMonitor);
        IStorage originStorage = accessor.getStorageProvider((IResource)file, IStorageProviderAccessor.DiffSide.ORIGIN).getStorage((IProgressMonitor)nullMonitor);
        SynchronizationModel syncModel = resolver.resolveModels(accessor, leftStorage, rightStorage, originStorage, (IProgressMonitor)nullMonitor);
        Set<Set<URI>> subGraphs = this.getSubGraphs((IGraphView<URI>)resolver.getGraphView());
        return new ResolvingResult(subGraphs, syncModel);
    }

    private Set<Set<URI>> getSubGraphs(IGraphView<URI> graph) {
        PruningIterator iterator = graph.breadthFirstIterator();
        LinkedHashSet<URI> roots = new LinkedHashSet<URI>();
        while (iterator.hasNext()) {
            roots.add((URI)iterator.next());
            iterator.prune();
        }
        LinkedHashSet<Set<URI>> subgraphs = new LinkedHashSet<Set<URI>>();
        HashSet knownURIs = new HashSet();
        for (URI root : roots) {
            if (knownURIs.contains(root)) continue;
            ImmutableSet subgraph = graph.getSubgraphContaining((Object)root);
            knownURIs.addAll(subgraph);
            subgraphs.add((Set<URI>)subgraph);
        }
        return subgraphs;
    }

    private void addWhiteLine(IFile file) throws Exception {
        Scanner scanner = null;
        InputStream outputSource = null;
        try {
            scanner = new Scanner(file.getContents()).useDelimiter("\\A");
            String fileContent = "";
            if (scanner.hasNext()) {
                fileContent = scanner.next();
            }
            fileContent = String.valueOf(fileContent) + '\n';
            outputSource = new ByteArrayInputStream(fileContent.getBytes());
            file.setContents(outputSource, 2, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (outputSource != null) {
                outputSource.close();
            }
        }
    }

    private static class ExpectedResult {
        private final Set<? extends Set<URI>> subGraphs;
        private final StorageTraversal leftTraversal;
        private final StorageTraversal rightTraversal;
        private final StorageTraversal originTraversal;

        public ExpectedResult(Set<? extends Set<URI>> subGraphs, StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal) {
            this.subGraphs = subGraphs;
            this.leftTraversal = leftTraversal;
            this.rightTraversal = rightTraversal;
            this.originTraversal = originTraversal;
        }

        public Set<? extends Set<URI>> getSubGraphs() {
            return this.subGraphs;
        }

        public StorageTraversal getLeftTraversal() {
            return this.leftTraversal;
        }

        public StorageTraversal getRightTraversal() {
            return this.rightTraversal;
        }

        public StorageTraversal getOriginTraversal() {
            return this.originTraversal;
        }
    }

    private static class ResolvingResult {
        private final Set<Set<URI>> subGraphs;
        private final SynchronizationModel syncModel;

        public ResolvingResult(Set<Set<URI>> subGraphs, SynchronizationModel syncModel) {
            this.subGraphs = subGraphs;
            this.syncModel = syncModel;
        }

        public Set<Set<URI>> getSubGraphs() {
            return this.subGraphs;
        }

        public SynchronizationModel getSyncModel() {
            return this.syncModel;
        }
    }
}

