/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public abstract class AbstractMergeRunnable {
    private static final Predicate<? super Diff> HAS_UNRESOLVED_STATE = EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED});
    private final boolean isLeftEditable;
    private final boolean isRightEditable;
    private final MergeMode mergeMode;
    private IDiffRelationshipComputer diffRelationshipComputer;

    public AbstractMergeRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode, IDiffRelationshipComputer diffRelationshipComputer) {
        this.isLeftEditable = isLeftEditable;
        this.isRightEditable = isRightEditable;
        this.mergeMode = mergeMode;
        this.diffRelationshipComputer = diffRelationshipComputer;
    }

    protected boolean isLeftEditable() {
        return this.isLeftEditable;
    }

    protected boolean isRightEditable() {
        return this.isRightEditable;
    }

    protected MergeMode getMergeMode() {
        return this.mergeMode;
    }

    protected IDiffRelationshipComputer getDiffRelationshipComputer(IMerger.Registry mergerRegistry) {
        if (this.diffRelationshipComputer == null) {
            this.diffRelationshipComputer = new DiffRelationshipComputer(mergerRegistry);
        }
        this.diffRelationshipComputer.setMergerRegistry(mergerRegistry);
        return this.diffRelationshipComputer;
    }

    protected void markAllAsMerged(Collection<? extends Diff> diffToMarkAsMerged, MergeMode mode, IMerger.Registry mergerRegistry) {
        Iterator<? extends Diff> iterator = diffToMarkAsMerged.iterator();
        while (iterator.hasNext()) {
            Diff diff;
            boolean isLeftToRight = mode.isLeftToRight(diff = iterator.next(), this.isLeftEditable(), this.isRightEditable());
            this.markAsMerged(diff, mode, !isLeftToRight, mergerRegistry);
        }
    }

    protected void markAsMerged(Diff diff, MergeMode mode, boolean mergeRightToLeft, IMerger.Registry mergerRegistry) {
        if (AbstractMerger.isInTerminalState((Diff)diff)) {
            return;
        }
        IDiffRelationshipComputer computer = this.getDiffRelationshipComputer(mergerRegistry);
        if (AbstractMerger.isAccepting((Diff)diff, (boolean)mergeRightToLeft)) {
            Set implied = computer.getAllResultingMerges(diff, mergeRightToLeft, HAS_UNRESOLVED_STATE);
            Set rejections = computer.getAllResultingRejections(diff, mergeRightToLeft, HAS_UNRESOLVED_STATE);
            for (Diff impliedDiff : Sets.difference((Set)implied, (Set)rejections)) {
                this.setState(impliedDiff, DifferenceState.MERGED);
            }
            for (Diff impliedRejection : rejections) {
                this.setState(impliedRejection, DifferenceState.DISCARDED);
            }
        } else {
            Set implied = computer.getAllResultingMerges(diff, mergeRightToLeft, HAS_UNRESOLVED_STATE);
            for (Diff impliedDiff : implied) {
                this.setState(impliedDiff, DifferenceState.DISCARDED);
            }
        }
    }

    private void setState(Diff diff, DifferenceState state) {
        if (diff.getState() != state) {
            diff.setState(state);
        }
    }

    protected void mergeAll(Collection<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        BatchMerger merger = new BatchMerger(this.getDiffRelationshipComputer(mergerRegistry));
        if (leftToRight) {
            merger.copyAllLeftToRight(differences, (Monitor)new BasicMonitor());
        } else {
            merger.copyAllRightToLeft(differences, (Monitor)new BasicMonitor());
        }
    }
}

