/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.conflict;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.PseudoConflictMerger;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.conflict.data.ConflictInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class PseudoConflictTest
extends AbstractUMLTest {
    private ConflictInputData input = new ConflictInputData();

    @BeforeClass
    public static void setupClass() {
        PseudoConflictTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        PseudoConflictTest.resetRegistries();
    }

    @Test
    public void testPseudoConflictMergerPriority() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Resource origin = this.input.getA1Origin();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        EList differences = comparison.getDifferences();
        UnmodifiableIterator conflicts = Iterators.filter((Iterator)differences.iterator(), (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
        IMerger.Registry registry = this.getMergerRegistry();
        while (conflicts.hasNext()) {
            Diff conflict = (Diff)conflicts.next();
            IMerger merger = registry.getHighestRankingMerger(conflict);
            MatcherAssert.assertThat((Object)merger, (Matcher)CoreMatchers.instanceOf(PseudoConflictMerger.class));
        }
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

