/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import java.util.Arrays;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.AbstractMergeRunnableTest;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.junit.Test;

public class MergeNonConflictingRunnableTest
extends AbstractMergeRunnableTest {
    private Diff leftDelete;
    private Diff leftAdd;
    private Diff rightDelete;
    private Diff rightAdd;

    @Test
    public void testMergeAllLeftToRightWithConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeLeftToRightWithConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete, this.leftAdd), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeLeftToRightWithConflictsAndLimitedSetOfDifferences() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeAllLeftToRightWithoutConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete, this.leftAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeLeftToRightWithoutConflicts() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.leftAdd, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeAllRightToLeftWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.leftDelete, this.leftAdd);
        this.verifyStateIsUnchanged(this.rightDelete, this.leftDelete, this.leftAdd);
    }

    @Test
    public void testMergeRightToLeftWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete, this.rightAdd), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.leftAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete, this.leftAdd);
    }

    @Test
    public void testMergeRightToLeftWithConflictsAndLimitedSetOfDifferences() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.leftDelete, this.rightDelete, this.rightAdd);
    }

    @Test
    public void testMergeAllRightToLeftWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete, this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testMergeRightToLeftWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftAdd, this.leftDelete, this.rightAdd);
        this.verifyStateIsUnchanged(this.leftAdd, this.leftDelete, this.rightAdd);
    }

    @Test
    public void testAcceptAllWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete, this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftAdd, this.leftDelete);
    }

    @Test
    public void testAcceptWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftAdd, this.leftDelete, this.rightDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightDelete);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftAdd, this.leftDelete);
        this.verifyStateIsUnchanged(this.rightAdd);
    }

    @Test
    public void testRejectAllWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.leftAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.rightAdd);
        this.verifyHasBeenMarkedAsMerged(this.rightAdd, this.rightDelete);
    }

    @Test
    public void testRejectWithoutConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.setNoConflictsInMockComparison();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete, this.rightDelete, this.rightAdd), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.rightDelete, this.rightAdd);
        this.verifyHasBeenMarkedAsMerged(this.rightAdd, this.rightDelete);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testAcceptAllWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.rightAdd);
        this.verifyHasNotBeenMerged(this.leftDelete, this.rightDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete);
    }

    @Test
    public void testRejectAllWithConflicts() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide();
        this.addConflictsToMockComparison(this.newConflict(this.leftDelete, this.rightDelete));
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.rightDelete, this.leftDelete, this.rightAdd);
        this.verifyHasBeenMarkedAsMerged(this.rightAdd);
        this.verifyStateIsUnchanged(this.leftDelete, this.rightDelete);
    }

    @Test
    public void testTwoWayMergeAllLeftToRight() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayMergeLeftToRight() {
        boolean isLeftToRight = true;
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete), true, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedLeftToRightOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.leftAdd);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testTwoWayMergeAllRightToLeft() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayMergeRightToLeft() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete);
        this.verifyHasNotBeenMerged(this.leftAdd);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testTwoWayAcceptAll() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftDelete, this.leftAdd);
        this.verifyHasBeenMarkedAsMerged(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayAccept() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.ACCEPT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftDelete), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasNotBeenMerged(this.leftDelete);
        this.verifyHasBeenMarkedAsMerged(this.leftDelete);
        this.verifyStateIsUnchanged(this.leftAdd);
    }

    @Test
    public void testTwoWayRejectAll() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(this.comparison, false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftDelete, this.leftAdd);
    }

    @Test
    public void testTwoWayReject() {
        boolean isLeftToRight = false;
        MergeMode mergeMode = MergeMode.REJECT;
        this.setUpTwoWayComparisonWithOneAdditionAndOneDeletion();
        MergeNonConflictingRunnable sut = this.newMergeAllNonConflictingRunnable(mergeMode);
        sut.merge(Arrays.asList(this.leftAdd), false, (IMerger.Registry)this.mergerRegistry);
        this.verifyHasBeenMergedRightToLeftOnly(this.leftAdd);
        this.verifyHasNotBeenMerged(this.leftDelete);
    }

    private void setUpThreeWayComparisonWithOneAdditionAndDeletionOnEachSide() {
        this.leftDelete = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.DELETE, "leftDelete");
        this.leftAdd = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.ADD, "leftAdd");
        this.rightDelete = this.mockReferenceChange(DifferenceSource.RIGHT, DifferenceKind.DELETE, "rightDelete");
        this.rightAdd = this.mockReferenceChange(DifferenceSource.RIGHT, DifferenceKind.ADD, "rightAdd");
        this.addDifferencesToMockComparison(this.leftDelete, this.leftAdd, this.rightDelete, this.rightAdd);
        this.setThreeWayComparison();
    }

    private void setUpTwoWayComparisonWithOneAdditionAndOneDeletion() {
        this.leftDelete = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.DELETE, "leftDelete");
        this.leftAdd = this.mockReferenceChange(DifferenceSource.LEFT, DifferenceKind.ADD, "leftAdd");
        this.addDifferencesToMockComparison(this.leftDelete, this.leftAdd);
        this.setNoConflictsInMockComparison();
        this.setTwoWayComparison();
    }

    private MergeNonConflictingRunnable newMergeAllNonConflictingRunnable(MergeMode mergeMode) {
        boolean isRightEditable;
        boolean isLeftEditable;
        switch (mergeMode) {
            case LEFT_TO_RIGHT: 
            case RIGHT_TO_LEFT: {
                isLeftEditable = true;
                isRightEditable = true;
                break;
            }
            case ACCEPT: 
            case REJECT: {
                isLeftEditable = true;
                isRightEditable = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer((IMerger.Registry)this.mergerRegistry)){

            protected void markAsMerged(Diff diff, MergeMode mode, boolean mergeRightToLeft, IMerger.Registry registry) {
                diff.setState(DifferenceState.MERGED);
            }
        };
    }
}

