/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.monitor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.DefaultEquiEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.req.DefaultReqEngine;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.scope.AbstractComparisonScope;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.monitor.data.MonitorCancelInputData;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MonitorCancelTest {
    private Comparison fComparison;
    private Comparison fComparisonWithDiff;

    @Test
    public void testCancelDuringMatch() {
        EMFCompare compare = EMFCompare.builder().setMatchEngineFactoryRegistry((IMatchEngine.Factory.Registry)TestRegistry.INSTANCE).build();
        Comparison comparison = compare.compare(this.getEmptyScope(), (Monitor)new BasicMonitor());
        Assert.assertEquals((long)8L, (long)comparison.getDiagnostic().getSeverity());
    }

    @Test
    public void testCancelDuringDiff() {
        EMFCompare compare = EMFCompare.builder().setDiffEngine(new IDiffEngine(){

            public void diff(Comparison comparison, Monitor monitor) {
                throw new ComparisonCanceledException();
            }
        }).build();
        Comparison comparison = compare.compare(this.getEmptyScope(), (Monitor)new BasicMonitor());
        Assert.assertEquals((long)8L, (long)comparison.getDiagnostic().getSeverity());
    }

    @Test
    public void testCancelDuringReq() {
        EMFCompare compare = EMFCompare.builder().setRequirementEngine(new IReqEngine(){

            public void computeRequirements(Comparison comparison, Monitor monitor) {
                throw new ComparisonCanceledException();
            }
        }).build();
        Comparison comparison = compare.compare(this.getEmptyScope(), (Monitor)new BasicMonitor());
        Assert.assertEquals((long)8L, (long)comparison.getDiagnostic().getSeverity());
    }

    @Test
    public void testCancelDuringEqui() {
        EMFCompare compare = EMFCompare.builder().setEquivalenceEngine(new IEquiEngine(){

            public void computeEquivalences(Comparison comparison, Monitor monitor) {
                throw new ComparisonCanceledException();
            }
        }).build();
        Comparison comparison = compare.compare(this.getEmptyScope(), (Monitor)new BasicMonitor());
        Assert.assertEquals((long)8L, (long)comparison.getDiagnostic().getSeverity());
    }

    @Test(expected=ComparisonCanceledException.class)
    public void testMonitorCancelInMatch() throws IOException {
        IMatchEngine engine = DefaultMatchEngine.create((UseIdentifiers)UseIdentifiers.WHEN_AVAILABLE);
        engine.match(this.getNonEmptyTestScope(), (Monitor)this.getCanceledMonitor());
    }

    @Test(expected=ComparisonCanceledException.class)
    public void testMonitorCancelInDiff() throws IOException {
        DefaultDiffEngine diffEngine = new DefaultDiffEngine();
        diffEngine.diff(this.fComparison, (Monitor)this.getCanceledMonitor());
    }

    @Test(expected=ComparisonCanceledException.class)
    public void testMonitorCancelInReq() throws IOException {
        DefaultReqEngine reqEngine = new DefaultReqEngine();
        reqEngine.computeRequirements(this.fComparisonWithDiff, (Monitor)this.getCanceledMonitor());
    }

    @Test(expected=ComparisonCanceledException.class)
    public void testMonitorCancelInEqui() throws IOException {
        DefaultEquiEngine equiEngine = new DefaultEquiEngine();
        equiEngine.computeEquivalences(this.fComparisonWithDiff, (Monitor)this.getCanceledMonitor());
    }

    @Before
    public void setUp() throws IOException {
        IMatchEngine matchEngine = DefaultMatchEngine.create((UseIdentifiers)UseIdentifiers.WHEN_AVAILABLE);
        this.fComparison = matchEngine.match(this.getNonEmptyTestScope(), (Monitor)new BasicMonitor());
        this.fComparisonWithDiff = matchEngine.match(this.getNonEmptyTestScope(), (Monitor)new BasicMonitor());
        DefaultDiffEngine diffEngine = new DefaultDiffEngine();
        diffEngine.diff(this.fComparisonWithDiff, (Monitor)new BasicMonitor());
    }

    private BasicMonitor getCanceledMonitor() {
        return new BasicMonitor(){

            public boolean isCanceled() {
                return true;
            }
        };
    }

    private IComparisonScope getNonEmptyTestScope() throws IOException {
        MonitorCancelInputData testData = new MonitorCancelInputData();
        return new DefaultComparisonScope((Notifier)testData.getLeft(), (Notifier)testData.getRight(), (Notifier)testData.getOrigin());
    }

    private IComparisonScope getEmptyScope() {
        return new AbstractComparisonScope(null, null, null){

            public Iterator<? extends Resource> getCoveredResources(ResourceSet resourceSet) {
                return Collections.emptyIterator();
            }

            public Iterator<? extends EObject> getCoveredEObjects(Resource resource) {
                return Collections.emptyIterator();
            }

            public Iterator<? extends EObject> getChildren(EObject eObject) {
                return Collections.emptyIterator();
            }
        };
    }

    private static final class CanceledMatchEngine
    implements IMatchEngine {
        private static final CanceledMatchEngine INSTANCE = new CanceledMatchEngine();

        private CanceledMatchEngine() {
        }

        public Comparison match(IComparisonScope scope, Monitor monitor) {
            throw new ComparisonCanceledException();
        }
    }

    private static final class TestFactory
    implements IMatchEngine.Factory {
        private static final TestFactory INSTANCE = new TestFactory();

        private TestFactory() {
        }

        public IMatchEngine getMatchEngine() {
            return CanceledMatchEngine.INSTANCE;
        }

        public int getRanking() {
            return 0;
        }

        public void setRanking(int parseInt) {
        }

        public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
            return true;
        }
    }

    private static final class TestRegistry
    implements IMatchEngine.Factory.Registry {
        private static final TestRegistry INSTANCE = new TestRegistry();

        private TestRegistry() {
        }

        public IMatchEngine.Factory getHighestRankingMatchEngineFactory(IComparisonScope scope) {
            return TestFactory.INSTANCE;
        }

        public List<IMatchEngine.Factory> getMatchEngineFactories(IComparisonScope scope) {
            return Arrays.asList(TestFactory.INSTANCE);
        }

        public IMatchEngine.Factory add(IMatchEngine.Factory matchEngineFactory) {
            throw new RuntimeException();
        }

        public IMatchEngine.Factory remove(String className) {
            return null;
        }

        public void clear() {
        }
    }
}

