/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.diff.data.featurefilter.featuremap.FeatureFilterFeatureMapsInputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class FeatureFilterTest {
    @Test
    public void testOnFeatureMaps() throws IOException {
        FeatureFilterFeatureMapsInputData inputData = new FeatureFilterFeatureMapsInputData();
        Resource left = inputData.getNodesLeft();
        Resource right = inputData.getNodesRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        FeatureFilter filter = new FeatureFilter();
        Collection<Match> allMatches = this.getAllMatches(comparison);
        Assert.assertFalse((boolean)allMatches.isEmpty());
        for (Match m : allMatches) {
            Iterator referencesToCheck = filter.getReferencesToCheck(m);
            EObject rhsMatch = m.getRight();
            if (rhsMatch == null) continue;
            for (EStructuralFeature sf : rhsMatch.eClass().getEAllStructuralFeatures()) {
                if (sf != null) continue;
                Assert.assertFalse((boolean)Iterators.contains((Iterator)referencesToCheck, (Object)sf));
            }
        }
    }

    private Collection<Match> getAllMatches(Comparison comparison) {
        LinkedHashSet matches = Sets.newLinkedHashSet();
        for (Match match : comparison.getMatches()) {
            matches.add(match);
            for (Match subMatch : match.getAllSubmatches()) {
                matches.add(subMatch);
            }
        }
        return matches;
    }
}

