/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.merge;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.merge.data.InstanceSpecificationClassifiersMergeInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstanceSpecificationClassifiersMergeTest
extends AbstractUMLTest {
    private InstanceSpecificationClassifiersMergeInputData input = new InstanceSpecificationClassifiersMergeInputData();

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }

    @BeforeClass
    public static void setupClass() {
        InstanceSpecificationClassifiersMergeTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        InstanceSpecificationClassifiersMergeTest.resetRegistries();
    }

    @Test
    public void testMergeOfMovedEnumerationLiteral() throws IOException {
        Resource left = this.input.getInstanceSpec1Left();
        Resource right = this.input.getInstanceSpec1Right();
        this.testMergeBothDirections(left, right);
    }

    @Test
    public void testMergeOfAddedOrDeletedEnumerationLiteral() throws IOException {
        Resource left = this.input.getInstanceSpec2Left();
        Resource right = this.input.getInstanceSpec2Right();
        this.testMergeBothDirections(left, right);
    }

    @Test
    public void testMergeOfAddedOrDeletedInstanceSpecificationClassifier() throws IOException {
        Resource left = this.input.getInstanceSpec3Left();
        Resource right = this.input.getInstanceSpec3Right();
        this.testMergeBothDirections(left, right);
    }

    @Test
    public void testMergeOfChangedInstanceSpecificationClassifier() throws IOException {
        Resource left = this.input.getInstanceSpec4Left();
        Resource right = this.input.getInstanceSpec4Right();
        this.testMergeBothDirections(left, right);
    }

    private void testMergeBothDirections(Resource left, Resource right) throws IOException {
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.reload(left, right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
        this.reload(left, right);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.reload(left, right);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    private void reload(Resource ... resources) throws IOException {
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            resource.unload();
            resource.load(Collections.EMPTY_MAP);
            ++n2;
        }
    }
}

