/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.opaque;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.opaque.data.OpaqueInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.OpaqueAction;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OpaqueElementBodyChangeDiffTest
extends AbstractUMLTest {
    private static final Predicate<Diff> IS_OPAQUE_ELEMENT_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return diff instanceof OpaqueElementBodyChange;
        }
    };
    private static final String OPAQUE_ACTION1_ID = "_opaqueAction1";
    private OpaqueInputData input = new OpaqueInputData();

    @BeforeClass
    public static void setupClass() {
        OpaqueElementBodyChangeDiffTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        OpaqueElementBodyChangeDiffTest.resetRegistries();
    }

    @Test
    public void testA1UseCaseLeft() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)origin, null);
        EList diffs = comparison.getDifferences();
        Iterable opaqueChanges = Iterables.filter((Iterable)diffs, IS_OPAQUE_ELEMENT_CHANGE);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)opaqueChanges));
        Diff firstDiff = (Diff)opaqueChanges.iterator().next();
        OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)firstDiff;
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)bodyChange.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)bodyChange.getSource());
        Assert.assertEquals((long)2L, (long)bodyChange.getRefinedBy().size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
    }

    @Test
    public void testA1UseCase() throws IOException {
        Resource origin = this.input.getA1Origin();
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        EList diffs = comparison.getDifferences();
        Iterable leftOpaqueChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftOpaqueChanges));
        Diff firstLeftDiff = (Diff)leftOpaqueChanges.iterator().next();
        OpaqueElementBodyChange leftBodyChange = (OpaqueElementBodyChange)firstLeftDiff;
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)leftBodyChange.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)leftBodyChange.getSource());
        Assert.assertEquals((long)2L, (long)leftBodyChange.getRefinedBy().size());
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)leftBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)leftBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)leftBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)leftBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE))));
        Iterable rightOpaqueChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightOpaqueChanges));
        Diff firstRightDiff = (Diff)rightOpaqueChanges.iterator().next();
        OpaqueElementBodyChange rightBodyChange = (OpaqueElementBodyChange)firstRightDiff;
        Assert.assertEquals((Object)DifferenceKind.CHANGE, (Object)rightBodyChange.getKind());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)rightBodyChange.getSource());
        Assert.assertEquals((long)2L, (long)rightBodyChange.getRefinedBy().size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)rightBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)rightBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)rightBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)rightBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE))));
    }

    @Test
    public void testA5UseCaseLeft() throws IOException {
        Resource origin = this.input.getA5Origin();
        Resource left = this.input.getA5Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)origin, null);
        EList diffs = comparison.getDifferences();
        Iterable opaqueChanges = Iterables.filter((Iterable)diffs, IS_OPAQUE_ELEMENT_CHANGE);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)opaqueChanges));
        Diff firstDiff = (Diff)opaqueChanges.iterator().next();
        OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)firstDiff;
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)bodyChange.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)bodyChange.getSource());
        Assert.assertEquals((long)2L, (long)bodyChange.getRefinedBy().size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
    }

    @Test
    public void testA5UseCase() throws IOException {
        Resource origin = this.input.getA5Origin();
        Resource left = this.input.getA5Left();
        Resource right = this.input.getA5Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        EList diffs = comparison.getDifferences();
        Iterable leftOpaqueChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)leftOpaqueChanges));
        Diff firstLeftDiff = (Diff)leftOpaqueChanges.iterator().next();
        OpaqueElementBodyChange leftBodyChange = (OpaqueElementBodyChange)firstLeftDiff;
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)leftBodyChange.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)leftBodyChange.getSource());
        Assert.assertEquals((long)2L, (long)leftBodyChange.getRefinedBy().size());
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)leftBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)leftBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)leftBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))));
        Iterable rightOpaqueChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)rightOpaqueChanges));
        Diff firstRightDiff = (Diff)rightOpaqueChanges.iterator().next();
        OpaqueElementBodyChange rightBodyChange = (OpaqueElementBodyChange)firstRightDiff;
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)rightBodyChange.getKind());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)rightBodyChange.getSource());
        Assert.assertEquals((long)2L, (long)rightBodyChange.getRefinedBy().size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)rightBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT))));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)rightBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT))));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)rightBodyChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))));
    }

    @Test
    public void testA7UseCaseRight_MoveAndChange() throws IOException {
        Resource origin = this.input.getA7Origin();
        Resource right = this.input.getA7Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)origin, null);
        EList diffs = comparison.getDifferences();
        Iterable opaqueChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)opaqueChanges));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)opaqueChanges, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)opaqueChanges, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE))));
    }

    @Test
    public void testA7UseCaseRight_Move() throws IOException {
        Resource origin = this.input.getA7Origin();
        Resource right = this.input.getA7Right();
        OpaqueAction rightAction = (OpaqueAction)right.getEObject(OPAQUE_ACTION1_ID);
        OpaqueAction originAction = (OpaqueAction)origin.getEObject(OPAQUE_ACTION1_ID);
        String bodyJava = (String)originAction.getBodies().get(0);
        rightAction.getBodies().set(1, (Object)bodyJava);
        Comparison comparison = this.compare((Notifier)right, (Notifier)origin, null);
        EList diffs = comparison.getDifferences();
        Iterable opaqueChanges = Iterables.filter((Iterable)diffs, (Predicate)Predicates.and(IS_OPAQUE_ELEMENT_CHANGE, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT)));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)opaqueChanges));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)opaqueChanges, (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE))));
        Diff opaqueChangeDiff = (Diff)opaqueChanges.iterator().next();
        OpaqueElementBodyChange opaqueChange = (OpaqueElementBodyChange)opaqueChangeDiff;
        Assert.assertEquals((long)2L, (long)opaqueChange.getRefinedBy().size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)opaqueChange.getRefinedBy(), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE))));
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

