/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.sirius.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusDiffPostProcessor
implements IPostProcessor {
    private static Predicate<ReferenceChange> valueIsKindOf(final EClass clazz) {
        return new Predicate<ReferenceChange>(){

            public boolean apply(ReferenceChange diff) {
                return clazz.isSuperTypeOf(diff.getValue().eClass());
            }
        };
    }

    private static Function<? super ReferenceChange, EObject> getReferenceChangeValue() {
        return new Function<ReferenceChange, EObject>(){

            public EObject apply(ReferenceChange diff) {
                return diff.getValue();
            }
        };
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
        Iterable allContainmentRefChanges = Iterables.filter((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), ReferenceChange.class), (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE);
        Iterable addedOrRemovedSemanticDecorators = Iterables.filter((Iterable)allContainmentRefChanges, SiriusDiffPostProcessor.valueIsKindOf(ViewpointPackage.eINSTANCE.getDSemanticDecorator()));
        ImmutableListMultimap diffsByValue = Multimaps.index((Iterable)allContainmentRefChanges, SiriusDiffPostProcessor.getReferenceChangeValue());
        for (ReferenceChange referenceChange : addedOrRemovedSemanticDecorators) {
            NodeMapping map;
            DSemanticDecorator value = (DSemanticDecorator)referenceChange.getValue();
            if (value.getTarget() != null) {
                EObject semanticTarget = value.getTarget();
                this.addRequiresToDecoratedElement((Multimap<EObject, ReferenceChange>)diffsByValue, referenceChange, semanticTarget);
            }
            if (!(value instanceof DNode) || (map = ((DNode)value).getActualMapping()) == null) continue;
            for (ReferenceChange actualMappingChange : Iterables.filter((Iterable)comparison.getDifferences((EObject)map), ReferenceChange.class)) {
                if (actualMappingChange.getReference() != DiagramPackage.eINSTANCE.getDNode_ActualMapping() || !EMFComparePredicates.fromSide((DifferenceSource)referenceChange.getSource()).apply((Object)actualMappingChange)) continue;
                referenceChange.getImplies().add((Object)actualMappingChange);
            }
        }
        Iterable addedOrRemovedGmfView = Iterables.filter((Iterable)allContainmentRefChanges, SiriusDiffPostProcessor.valueIsKindOf(NotationPackage.eINSTANCE.getView()));
        for (ReferenceChange referenceChange : addedOrRemovedGmfView) {
            View value = (View)referenceChange.getValue();
            if (value.getElement() == null) continue;
            EObject semanticTarget = value.getElement();
            this.addRequiresToDecoratedElement((Multimap<EObject, ReferenceChange>)diffsByValue, referenceChange, semanticTarget);
        }
    }

    private void addRequiresToDecoratedElement(Multimap<EObject, ReferenceChange> diffsByValue, ReferenceChange referenceChange, EObject semanticTarget) {
        for (Diff valueDiff : diffsByValue.get((Object)semanticTarget)) {
            if (referenceChange.getKind() == DifferenceKind.ADD) {
                if (valueDiff.getKind() != DifferenceKind.ADD || !EMFComparePredicates.fromSide((DifferenceSource)referenceChange.getSource()).apply((Object)valueDiff)) continue;
                referenceChange.getRequires().add((Object)valueDiff);
                continue;
            }
            if (referenceChange.getKind() != DifferenceKind.DELETE || valueDiff.getKind() != DifferenceKind.DELETE || !EMFComparePredicates.fromSide((DifferenceSource)referenceChange.getSource()).apply((Object)valueDiff)) continue;
            referenceChange.getRequires().add((Object)valueDiff);
        }
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        UnmodifiableIterator it = Iterators.filter((Iterator)comparison.eAllContents(), DiagramDiff.class);
        while (it.hasNext()) {
            DiagramDiff next = (DiagramDiff)it.next();
            LinkedHashSet refinesToAdd = Sets.newLinkedHashSet();
            for (Diff refined : next.getRefinedBy()) {
                this.collectDifferenceRefines(comparison, refinesToAdd, refined.getMatch().getLeft());
                this.collectDifferenceRefines(comparison, refinesToAdd, refined.getMatch().getRight());
            }
            next.getRefinedBy().addAll(Collections2.filter((Collection)refinesToAdd, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)next.getSource())));
        }
    }

    private void collectDifferenceRefines(Comparison comparison, Set<Diff> refinesToAdd, EObject changedEObject) {
        View gmfView;
        if (changedEObject instanceof View && (gmfView = (View)changedEObject).getElement() instanceof DSemanticDecorator) {
            for (Diff diffOnSemanticDecorator : comparison.getDifferences(gmfView.getElement())) {
                refinesToAdd.add(diffOnSemanticDecorator);
            }
        }
    }
}

