/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.merge;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AttributeChangeMerger;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;

public class OpaqueElementBodyChangeMerger
extends AttributeChangeMerger {
    private static final Logger LOGGER = Logger.getLogger(OpaqueElementBodyChangeMerger.class);

    public boolean isMergerFor(Diff target) {
        return this.isOrRefinesOpaqueElementBodyChange(target);
    }

    private boolean isOrRefinesOpaqueElementBodyChange(Diff target) {
        return this.getOpaqueElementBodyChange(target).isPresent();
    }

    private Optional<OpaqueElementBodyChange> getOpaqueElementBodyChange(Diff diff) {
        Object bodyChange = diff instanceof OpaqueElementBodyChange ? Optional.of((Object)((OpaqueElementBodyChange)diff)) : (!diff.getRefines().isEmpty() ? this.getRefinedOpaqueElementBodyChange(diff) : Optional.absent());
        return bodyChange;
    }

    private Optional<OpaqueElementBodyChange> getRefinedOpaqueElementBodyChange(Diff diff) {
        for (Diff refinedDiff : diff.getRefines()) {
            if (!(refinedDiff instanceof OpaqueElementBodyChange)) continue;
            return Optional.of((Object)((OpaqueElementBodyChange)refinedDiff));
        }
        return Optional.absent();
    }

    private boolean isFullyMerged(OpaqueElementBodyChange bodyChange) {
        if (!OpaqueElementBodyChangeMerger.isInTerminalState((Diff)bodyChange)) {
            return false;
        }
        for (Diff refiningDiff : bodyChange.getRefinedBy()) {
            if (OpaqueElementBodyChangeMerger.isInTerminalState((Diff)refiningDiff)) continue;
            return false;
        }
        return true;
    }

    protected void accept(Diff diff, boolean rightToLeft) {
        Optional<OpaqueElementBodyChange> possibleBodyChange = this.getOpaqueElementBodyChange(diff);
        if (possibleBodyChange.isPresent()) {
            OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)this.getOpaqueElementBodyChange(diff).get();
            if (this.isFullyMerged(bodyChange)) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                int refinedElementCount = bodyChange.getRefinedBy().size();
                LOGGER.debug((Object)("accept(Diff, boolean) - " + refinedElementCount + " refined diffs to merge for diff " + diff.hashCode()));
            }
            switch (bodyChange.getKind()) {
                case ADD: {
                    this.acceptRefiningDiffs(bodyChange, rightToLeft);
                    break;
                }
                case DELETE: {
                    this.acceptRefiningDiffs(bodyChange, rightToLeft);
                    break;
                }
                case CHANGE: {
                    this.changeElement(bodyChange, rightToLeft);
                    break;
                }
                case MOVE: {
                    this.moveElement(bodyChange, rightToLeft);
                    break;
                }
            }
            this.setFullyMerged(bodyChange, rightToLeft);
        }
    }

    protected void reject(Diff diff, boolean rightToLeft) {
        Optional<OpaqueElementBodyChange> possibleBodyChange = this.getOpaqueElementBodyChange(diff);
        if (possibleBodyChange.isPresent()) {
            OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)possibleBodyChange.get();
            if (this.isFullyMerged(bodyChange)) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                int refinedElementCount = bodyChange.getRefinedBy().size();
                LOGGER.debug((Object)("Reject(Diff, boolean)" + refinedElementCount + " refined diffs to merge for diff " + diff.hashCode()));
            }
            switch (bodyChange.getKind()) {
                case ADD: {
                    this.rejectRefiningDiffs(bodyChange, rightToLeft);
                    break;
                }
                case DELETE: {
                    this.rejectRefiningDiffs(bodyChange, rightToLeft);
                    break;
                }
                case CHANGE: {
                    this.changeElement(bodyChange, rightToLeft);
                    break;
                }
                case MOVE: {
                    this.moveElement(bodyChange, rightToLeft);
                    break;
                }
            }
            this.setFullyMerged(bodyChange, rightToLeft);
        }
    }

    private void acceptRefiningDiffs(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        List<Diff> sortedRefiningDiffs = this.sortByMergePriority((List<Diff>)bodyChange.getRefinedBy());
        for (Diff refiningDiff : sortedRefiningDiffs) {
            super.accept(refiningDiff, rightToLeft);
        }
    }

    private void rejectRefiningDiffs(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        List<Diff> sortedRefiningDiffs = this.sortByMergePriority((List<Diff>)bodyChange.getRefinedBy());
        for (Diff refiningDiff : sortedRefiningDiffs) {
            super.reject(refiningDiff, rightToLeft);
        }
    }

    private List<Diff> sortByMergePriority(List<Diff> refiningDiffs) {
        LinkedList<Diff> sortedRefiningDiffs = new LinkedList<Diff>(refiningDiffs);
        Collections.sort(sortedRefiningDiffs, new Comparator<Diff>(){

            @Override
            public int compare(Diff diff1, Diff diff2) {
                int compare = UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute(diff1) && !UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute(diff2) ? -1 : (!UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute(diff1) && UMLCompareUtil.isChangeOfOpaqueElementLanguageAttribute(diff2) ? 1 : 0);
                return compare;
            }
        });
        return sortedRefiningDiffs;
    }

    private void changeElement(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        EObject targetContainer = this.getTargetContainer(bodyChange.getMatch(), rightToLeft);
        String targetValue = this.getTargetBodyValue(bodyChange, rightToLeft);
        this.setBody(targetContainer, targetValue, bodyChange.getLanguage());
    }

    private void setBody(EObject container, String newBody, String language) {
        List<String> languages = UMLCompareUtil.getOpaqueElementLanguages(container);
        List<String> bodies = UMLCompareUtil.getOpaqueElementBodies(container);
        int index = languages.indexOf(language);
        bodies.set(index, newBody);
    }

    private String getTargetBodyValue(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        boolean hasRealConflict = EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)bodyChange);
        String newBody = bodyChange.getMatch().getComparison().isThreeWay() && !hasRealConflict ? this.performThreeWayTextMerge(bodyChange, rightToLeft) : (rightToLeft ? this.getRightBodyValue(bodyChange) : this.getLeftBodyValue(bodyChange));
        return newBody;
    }

    private String performThreeWayTextMerge(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        if (this.isAcceptingChange(bodyChange, rightToLeft)) {
            return this.performAcceptingThreeWayTextMerge(bodyChange);
        }
        return this.performRejectingThreeWayTextMerge(bodyChange);
    }

    private boolean isAcceptingChange(Diff diff, boolean rightToLeft) {
        return diff.getSource() == DifferenceSource.LEFT && !rightToLeft || diff.getSource() == DifferenceSource.RIGHT && rightToLeft;
    }

    private String performAcceptingThreeWayTextMerge(OpaqueElementBodyChange bodyChange) {
        String leftBodyValue = this.getLeftBodyValue(bodyChange);
        String rightBodyValue = this.getRightBodyValue(bodyChange);
        String originBodyValue = this.getOriginBodyValue(bodyChange);
        return this.performThreeWayTextMerge(leftBodyValue, rightBodyValue, originBodyValue);
    }

    private String performRejectingThreeWayTextMerge(OpaqueElementBodyChange bodyChange) {
        String originBodyValue = this.getOriginBodyValue(bodyChange);
        AttributeChange bodyValueAddition = (AttributeChange)this.getBodyValueAddition(bodyChange).get();
        String changedValueFromDiff = (String)bodyValueAddition.getValue();
        String changedValueFromModel = DifferenceSource.LEFT.equals((Object)bodyValueAddition.getSource()) ? this.getLeftBodyValue(bodyChange) : this.getRightBodyValue(bodyChange);
        return this.performThreeWayTextMerge(changedValueFromModel, originBodyValue, changedValueFromDiff);
    }

    private Optional<AttributeChange> getBodyValueAddition(OpaqueElementBodyChange bodyChange) {
        for (Diff diff : bodyChange.getRefinedBy()) {
            if (!UMLCompareUtil.isChangeOfOpaqueElementBodyAttribute(diff) || !DifferenceKind.ADD.equals((Object)diff.getKind())) continue;
            return Optional.of((Object)((AttributeChange)diff));
        }
        return Optional.absent();
    }

    private String getLeftBodyValue(OpaqueElementBodyChange bodyChange) {
        EObject leftContainer = bodyChange.getMatch().getLeft();
        return UMLCompareUtil.getOpaqueElementBody(leftContainer, bodyChange.getLanguage());
    }

    private String getRightBodyValue(OpaqueElementBodyChange bodyChange) {
        EObject rightContainer = bodyChange.getMatch().getRight();
        return UMLCompareUtil.getOpaqueElementBody(rightContainer, bodyChange.getLanguage());
    }

    private String getOriginBodyValue(OpaqueElementBodyChange bodyChange) {
        EObject originContainer = bodyChange.getMatch().getOrigin();
        return UMLCompareUtil.getOpaqueElementBody(originContainer, bodyChange.getLanguage());
    }

    private void moveElement(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        Match match = bodyChange.getMatch();
        Comparison comparison = match.getComparison();
        String language = bodyChange.getLanguage();
        Diff languageAttributeMove = (Diff)this.getLanguageAttributeMove(bodyChange).get();
        EObject container = this.getTargetContainer(match, rightToLeft);
        int sourceIndex = this.getLanguageIndex(container, language);
        int targetIndex = DiffUtil.findInsertionIndex((Comparison)comparison, (Diff)languageAttributeMove, (boolean)rightToLeft);
        this.doMove(container, sourceIndex, targetIndex);
    }

    private Optional<Diff> getLanguageAttributeMove(OpaqueElementBodyChange bodyChange) {
        for (Diff diff : bodyChange.getRefinedBy()) {
            if (!(diff instanceof AttributeChange) || !DifferenceKind.MOVE.equals((Object)diff.getKind())) continue;
            return Optional.of((Object)diff);
        }
        return Optional.absent();
    }

    private EObject getTargetContainer(Match match, boolean rightToLeft) {
        if (rightToLeft) {
            return match.getLeft();
        }
        return match.getRight();
    }

    private int getLanguageIndex(EObject container, String language) {
        return UMLCompareUtil.getOpaqueElementLanguages(container).indexOf(language);
    }

    private void doMove(EObject container, int sourceIndex, int targetIndex) {
        List<String> languages = UMLCompareUtil.getOpaqueElementLanguages(container);
        List<String> bodies = UMLCompareUtil.getOpaqueElementBodies(container);
        String bodyValueToMove = bodies.get(sourceIndex);
        String languageValueToMove = languages.get(sourceIndex);
        int insertionIndex = targetIndex;
        if (sourceIndex < targetIndex) {
            --insertionIndex;
        }
        this.move(languages, languageValueToMove, insertionIndex);
        this.move(bodies, bodyValueToMove, insertionIndex);
    }

    private void move(List<String> list, String value, int targetIndex) {
        list.remove(value);
        if (targetIndex < 0 || targetIndex > list.size()) {
            list.add(value);
        } else {
            list.add(targetIndex, value);
        }
    }

    private void setFullyMerged(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        if (OpaqueElementBodyChangeMerger.isAccepting((Diff)bodyChange, (boolean)rightToLeft)) {
            bodyChange.setState(DifferenceState.MERGED);
            for (Diff refiningDiff : bodyChange.getRefinedBy()) {
                refiningDiff.setState(DifferenceState.MERGED);
            }
        } else {
            bodyChange.setState(DifferenceState.DISCARDED);
            for (Diff refiningDiff : bodyChange.getRefinedBy()) {
                refiningDiff.setState(DifferenceState.DISCARDED);
            }
        }
    }

    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        Set dependencies = super.getDirectMergeDependencies(diff, mergeRightToLeft);
        dependencies.removeAll((Collection<?>)diff.getRefinedBy());
        return dependencies;
    }

    protected int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        if (this.shouldUseInsertionIndexOfAffectedLanguage(diff, rightToLeft)) {
            EObject expectedContainer = this.getExpectedContainer(diff, rightToLeft);
            Optional<String> language = this.getAffectedLanguage(diff);
            return UMLCompareUtil.getOpaqueElementLanguages(expectedContainer).indexOf(language.get());
        }
        return super.findInsertionIndex(comparison, diff, rightToLeft);
    }

    private EObject getExpectedContainer(Diff diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        return expectedContainer;
    }

    private Optional<String> getAffectedLanguage(Diff diff) {
        Optional<OpaqueElementBodyChange> bodyChange = this.getRefinedOpaqueElementBodyChange(diff);
        if (bodyChange.isPresent()) {
            return Optional.of((Object)((OpaqueElementBodyChange)bodyChange.get()).getLanguage());
        }
        return Optional.absent();
    }

    private boolean shouldUseInsertionIndexOfAffectedLanguage(Diff diff, boolean rightToLeft) {
        if (UMLCompareUtil.isChangeOfOpaqueElementBodyAttribute(diff)) {
            Optional<String> affectedLanguage = this.getAffectedLanguage(diff);
            EObject expectedContainer = this.getExpectedContainer(diff, rightToLeft);
            return affectedLanguage.isPresent() && UMLCompareUtil.getOpaqueElementLanguages(expectedContainer).contains(affectedLanguage.get());
        }
        return false;
    }
}

