/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.compare.egit.internal.merge.DirCacheResourceVariantTreeProvider;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitInput;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMerge;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitTest;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.lib.Repository;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=GitTestRunner.class)
public class DirCacheResourceVariantTreeProviderTest {
    @GitTest
    @GitInput(value="data/dirCacheResourceVariantTreeProvider/dirCacheAddToIndex.zip")
    public void testDirCacheAddToIndex(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject project = projects.get(0);
        IFile iFile1 = project.getFile("file1");
        DirCacheResourceVariantTreeProvider treeProvider = new DirCacheResourceVariantTreeProvider(repository, true);
        Assert.assertTrue((boolean)treeProvider.getKnownResources().isEmpty());
        Assert.assertFalse((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile1));
        Assert.assertFalse((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile1));
        Assert.assertFalse((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile1));
        iFile1.toString();
        this.addToIndex(repository, iFile1);
        treeProvider = new DirCacheResourceVariantTreeProvider(repository, true);
        Assert.assertEquals((long)1L, (long)treeProvider.getKnownResources().size());
        Assert.assertTrue((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile1));
    }

    @GitMerge(local="master", remote="branch")
    @GitInput(value="data/dirCacheResourceVariantTreeProvider/dirCacheTreesNoConflict.zip")
    public void testDirCacheTreesNoConflict(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject iProject = projects.get(0);
        IFile iFile1 = iProject.getFile("file1");
        IFile iFile2 = iProject.getFile("file2");
        DirCacheResourceVariantTreeProvider treeProvider = new DirCacheResourceVariantTreeProvider(repository, true);
        Assert.assertEquals((long)3L, (long)treeProvider.getKnownResources().size());
        Assert.assertTrue((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile2));
        Assert.assertTrue((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile2));
        Assert.assertTrue((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile2));
    }

    @GitMerge(local="master", remote="branch")
    @GitInput(value="data/dirCacheResourceVariantTreeProvider/dirCacheTreesConflictOnOne.zip")
    public void testDirCacheTreesConflictOnOne(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject iProject = projects.get(0);
        IFile iFile1 = iProject.getFile("file1");
        IFile iFile2 = iProject.getFile("file2");
        DirCacheResourceVariantTreeProvider treeProvider = new DirCacheResourceVariantTreeProvider(repository, true);
        Assert.assertTrue((boolean)treeProvider.getKnownResources().contains(iFile1));
        Assert.assertTrue((boolean)treeProvider.getKnownResources().contains(iFile2));
        Assert.assertTrue((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile2));
        Assert.assertTrue((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile2));
        Assert.assertTrue((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile2));
    }

    @GitMerge(local="master", remote="branch")
    @GitInput(value="data/dirCacheResourceVariantTreeProvider/dirCacheTreesConflict.zip")
    public void testDirCacheTreesConflict(Status status, Repository repository, List<IProject> projects) throws Exception {
        IProject iProject = projects.get(0);
        IFile iFile1 = iProject.getFile("file1");
        IFile iFile2 = iProject.getFile("file2");
        DirCacheResourceVariantTreeProvider treeProvider = new DirCacheResourceVariantTreeProvider(repository, true);
        Assert.assertTrue((boolean)treeProvider.getKnownResources().contains(iFile1));
        Assert.assertTrue((boolean)treeProvider.getKnownResources().contains(iFile2));
        Assert.assertTrue((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile1));
        Assert.assertFalse((boolean)treeProvider.getBaseTree().hasResourceVariant((IResource)iFile2));
        Assert.assertTrue((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getSourceTree().hasResourceVariant((IResource)iFile2));
        Assert.assertTrue((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile1));
        Assert.assertTrue((boolean)treeProvider.getRemoteTree().hasResourceVariant((IResource)iFile2));
    }

    private void addToIndex(Repository repository, IFile file) throws CoreException, IOException, NoFilepatternException, GitAPIException {
        String filePath = String.valueOf(file.getProject().getName()) + "/" + file.getProjectRelativePath();
        try (Git git = new Git(repository);){
            git.add().addFilepattern(filePath).call();
        }
    }

    private String getRepoRelativePath(String repoPath, String path) {
        int pfxLen = repoPath.length();
        int pLen = path.length();
        if (pLen > pfxLen) {
            return path.substring(pfxLen);
        }
        if (path.length() == pfxLen - 1) {
            return "";
        }
        return null;
    }
}

