/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.nodes.Node;
import org.eclipse.emf.compare.tests.nodes.NodesFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LCSPerformanceTest {
    private XMIResource left;
    private XMIResource right;

    @Before
    public void setup() {
        this.left = new XMIResourceImpl(URI.createURI((String)"left.xmi"));
        this.right = new XMIResourceImpl(URI.createURI((String)"right.xmi"));
        this.createNode(this.left, 2000, 0, 1);
        this.createNode(this.right, 200, 0, 1901);
    }

    @Test
    public void checkTestData() {
        Assert.assertTrue((this.left.getContents().size() == 1 ? 1 : 0) != 0);
        Node leftRoot = (Node)this.left.getContents().get(0);
        Assert.assertTrue((leftRoot.eContents().size() == 2000 ? 1 : 0) != 0);
        Assert.assertTrue((this.right.getContents().size() == 1 ? 1 : 0) != 0);
        Node rightRoot = (Node)this.right.getContents().get(0);
        Assert.assertTrue((rightRoot.eContents().size() == 200 ? 1 : 0) != 0);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        ArrayList additions = Lists.newArrayList();
        ArrayList deletions = Lists.newArrayList();
        for (Diff difference : comparison.getDifferences()) {
            if (difference.getKind() == DifferenceKind.ADD) {
                additions.add(difference);
                continue;
            }
            deletions.add(difference);
        }
        Assert.assertEquals((long)1900L, (long)additions.size());
        Assert.assertEquals((long)100L, (long)deletions.size());
    }

    @Ignore
    @Test(timeout=40000L)
    public void copyLeftToRight() {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        IMerger.Registry registry = IMerger.RegistryImpl.createStandaloneInstance();
        BatchMerger merger = new BatchMerger(registry);
        merger.copyAllLeftToRight((Iterable)comparison.getDifferences(), (Monitor)new BasicMonitor());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    @Ignore
    @Test(timeout=3000L)
    public void copyRightToLeft() {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        IMerger.Registry registry = IMerger.RegistryImpl.createStandaloneInstance();
        BatchMerger merger = new BatchMerger(registry);
        merger.copyAllRightToLeft((Iterable)comparison.getDifferences(), (Monitor)new BasicMonitor());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
    }

    private void createNode(XMIResource resource, int childCount, int nodeId, int idGap) {
        resource.eSetDeliver(false);
        Node node = NodesFactory.eINSTANCE.createNode();
        node.setName("node" + nodeId);
        resource.getContents().add((Object)node);
        resource.setID((EObject)node, Integer.toString(nodeId));
        int childId = nodeId + Math.max(1, idGap);
        int i = 0;
        while (i < childCount) {
            Node child = NodesFactory.eINSTANCE.createNode();
            child.setName("node" + childId);
            node.getContainmentRef1().add((Object)child);
            resource.setID((EObject)child, Integer.toString(childId));
            ++childId;
            ++i;
        }
        resource.eSetDeliver(true);
    }
}

