/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.dependency.DependencyProviderDescriptor;
import org.eclipse.emf.compare.ide.ui.dependency.IDependencyProvider;
import org.eclipse.emf.compare.ide.ui.dependency.ModelDependencyProviderRegistry;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.tests.egit.CompareGitTestCase;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jgit.api.ResetCommand;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MovedImplicitResourceAmongChangedResourcesTest
extends CompareGitTestCase {
    private static final HashMap<Object, Object> EMPTY_MAP = new HashMap();
    private static final String MASTER = "refs/heads/master";
    private static final String MOVED_MODEL_BRANCH = "refs/heads/movedModelBranch";
    private static final String CHANGED_MODEL_BRANCH = "refs/heads/changedModelBranch";
    private static final String ROOT_FILE_PATH = "directory1/file1.ecore";
    private static final String IMPLICIT_FILE_PATH = "directory1/file2.ecore";
    private static final String IMPLICIT_FILE_MOVED_PATH = "directory2/file2.ecore";
    private static final String SUBMODEL_FILE_PATH = "directory1/file3.ecore";
    private static final String SUBMODEL_FILE_MOVED_PATH = "directory2/file3.ecore";
    private File rootFile;
    private File identicalFile;
    private File submodelFile;
    private IFile rootIFile;
    private IFile identicalIFile;
    private IFile submodelIFile;
    private ResourceSet resourceSet;
    private IProject iProject;
    private Resource rootResource;
    private Resource identicalResource;
    private Resource submodelResource;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.iProject = this.project.getProject();
        this.resourceSet = new ResourceSetImpl();
        this.rootFile = this.project.getOrCreateFile(this.iProject, ROOT_FILE_PATH);
        this.identicalFile = this.project.getOrCreateFile(this.iProject, IMPLICIT_FILE_PATH);
        this.submodelFile = this.project.getOrCreateFile(this.iProject, SUBMODEL_FILE_PATH);
        this.rootIFile = this.project.getIFile(this.iProject, this.rootFile);
        this.identicalIFile = this.project.getIFile(this.iProject, this.identicalFile);
        this.submodelIFile = this.project.getIFile(this.iProject, this.submodelFile);
        this.rootResource = this.connectResource(this.rootIFile, this.resourceSet);
        this.identicalResource = this.connectResource(this.identicalIFile, this.resourceSet);
        this.submodelResource = this.connectResource(this.submodelIFile, this.resourceSet);
    }

    @Ignore(value="Due to Bug 464379, this test no longer works. It needs management of resource renaming via ResourceAttachmentChange.MOVE")
    @Test
    public void testRebaseNoConflictMovedSubmodel() throws Exception {
        this.setUpMovedIdenticalResourceAndChangedResourceBranches();
        this.installMockModelDependencyProvider((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)this.submodelFile.getName(), (Object)ImmutableSet.of((Object)this.identicalFile.getName())));
        this.repository.checkoutBranch(MOVED_MODEL_BRANCH);
        this.iProject.refreshLocal(2, null);
        this.repository.rebaseLogical(CHANGED_MODEL_BRANCH);
        this.iProject.refreshLocal(2, null);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertFalse((boolean)this.iProject.getFile(IMPLICIT_FILE_PATH).exists());
        Assert.assertFalse((boolean)this.iProject.getFile(SUBMODEL_FILE_PATH).exists());
        IFile movedSubmodelFile = this.iProject.getFile(SUBMODEL_FILE_MOVED_PATH);
        IFile movedIdenticalFile = this.iProject.getFile(IMPLICIT_FILE_MOVED_PATH);
        Assert.assertTrue((boolean)this.iProject.getFile(ROOT_FILE_PATH).exists());
        Assert.assertTrue((boolean)movedSubmodelFile.exists());
        Assert.assertTrue((boolean)movedIdenticalFile.exists());
        this.unload(new Resource[]{this.rootResource, this.identicalResource, this.submodelResource});
        this.resourceSet.getResources().clear();
        this.rootResource = this.connectResource(this.iProject.getFile(ROOT_FILE_PATH), this.resourceSet);
        Resource movedIdenticalResource = this.connectResource(movedIdenticalFile, this.resourceSet);
        Resource movedSubmodelResource = this.connectResource(movedSubmodelFile, this.resourceSet);
        this.rootResource.load(EMPTY_MAP);
        movedIdenticalResource.load(EMPTY_MAP);
        movedSubmodelResource.load(EMPTY_MAP);
        EPackage testRootPack = (EPackage)this.rootResource.getContents().get(0);
        Assert.assertEquals((Object)"parent1", (Object)testRootPack.getName());
        EPackage testImplicitRootPack = (EPackage)movedIdenticalResource.getContents().get(0);
        Assert.assertEquals((Object)"parent2", (Object)testImplicitRootPack.getName());
        EPackage testSubmodelPack = (EPackage)testRootPack.getESubpackages().get(0);
        Assert.assertEquals((Object)"child", (Object)testSubmodelPack.getName());
        Assert.assertSame((Object)movedSubmodelResource, (Object)((InternalEObject)testSubmodelPack).eDirectResource());
        EClass testC1 = (EClass)testSubmodelPack.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        EClass nonConflictingClass = (EClass)testSubmodelPack.getEClassifiers().get(1);
        Assert.assertEquals((Object)"NonConflicting", (Object)nonConflictingClass.getName());
    }

    public void setUpMovedIdenticalResourceAndChangedResourceBranches() throws Exception {
        EPackage root = this.createPackage(null, "parent1");
        EPackage implicitRoot = this.createPackage(null, "parent2");
        EPackage submodelChild = this.createPackage(root, "child");
        this.createClass(submodelChild, "C1");
        this.saveTestResource(this.submodelResource, submodelChild);
        this.saveTestResource(this.identicalResource, implicitRoot);
        this.saveTestResource(this.rootResource, root);
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch(MASTER, MOVED_MODEL_BRANCH);
        this.repository.checkoutBranch(MOVED_MODEL_BRANCH);
        this.iProject.refreshLocal(2, null);
        this.reload(new Resource[]{this.rootResource, this.submodelResource, this.identicalResource});
        IFile movedSubmodelFile = this.project.getIFile(this.iProject, this.project.getOrCreateFile(this.iProject, SUBMODEL_FILE_MOVED_PATH));
        IFile movedIdenticalFile = this.project.getIFile(this.iProject, this.project.getOrCreateFile(this.iProject, IMPLICIT_FILE_MOVED_PATH));
        Resource movedSubRes = this.connectResource(movedSubmodelFile, this.resourceSet);
        Resource movedIdenticalRes = this.connectResource(movedIdenticalFile, this.resourceSet);
        this.saveTestResource(movedSubRes, (EPackage)this.findObject(this.submodelResource, "child"));
        this.saveTestResource(movedIdenticalRes, (EPackage)this.findObject(this.identicalResource, "parent2"));
        this.save(new Resource[]{this.rootResource, this.submodelResource, this.identicalResource});
        this.iProject.getFile(IMPLICIT_FILE_PATH).delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.iProject.getFile(SUBMODEL_FILE_PATH).delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.repository.removeFromIndex(new IResource[]{this.submodelIFile});
        this.repository.removeFromIndex(new IResource[]{this.identicalIFile});
        this.repository.addAllAndCommit("Moved submodel file and implicit dependency to other directory");
        this.repository.createBranch(MASTER, CHANGED_MODEL_BRANCH);
        this.repository.checkoutBranch(CHANGED_MODEL_BRANCH);
        this.repository.reset(CHANGED_MODEL_BRANCH, ResetCommand.ResetType.HARD);
        this.iProject.refreshLocal(2, null);
        this.unload(new Resource[]{this.rootResource, this.identicalResource, this.submodelResource, movedIdenticalRes, movedSubRes});
        this.resourceSet.getResources().clear();
        this.reload(new Resource[]{this.rootResource, this.identicalResource, this.submodelResource});
        this.createClass((EPackage)this.submodelResource.getContents().get(0), "NonConflicting");
        this.save(new Resource[]{this.submodelResource});
        this.save(new Resource[]{this.identicalResource});
        this.save(new Resource[]{this.rootResource});
        this.repository.addAllAndCommit("Added class to child.");
        this.repository.checkoutBranch(MASTER);
        this.repository.reset(MASTER, ResetCommand.ResetType.HARD);
        this.iProject.refreshLocal(2, null);
        this.unload(new Resource[]{this.rootResource, this.identicalResource, this.submodelResource, movedIdenticalRes, movedSubRes});
        this.resourceSet.getResources().clear();
    }

    protected void saveTestResource(Resource resource, EPackage pkg) throws IOException, CoreException {
        resource.getContents().clear();
        resource.getContents().add((Object)pkg);
        this.save(new Resource[]{resource});
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.getModelDependencyProviderRegistry().clear();
        this.unload(new Resource[]{this.rootResource, this.identicalResource, this.submodelResource});
        super.tearDown();
    }

    private ModelDependencyProviderRegistry getModelDependencyProviderRegistry() {
        return EMFCompareIDEUIPlugin.getDefault().getModelDependencyProviderRegistry();
    }

    private void installMockModelDependencyProvider(ImmutableMap<String, ImmutableSet<String>> dependencies) {
        this.getModelDependencyProviderRegistry().addProvider("mock", new DependencyProviderDescriptor(null, null, dependencies){
            private final IDependencyProvider mock;
            {
                this.mock = new MockDependencyProvider((ImmutableMap<String, ImmutableSet<String>>)immutableMap);
            }

            public IDependencyProvider getDependencyProvider() {
                return this.mock;
            }
        });
    }

    private class MockDependencyProvider
    implements IDependencyProvider {
        private ImmutableMap<String, ImmutableSet<String>> dependencies;

        public MockDependencyProvider(ImmutableMap<String, ImmutableSet<String>> dependencies) {
            this.dependencies = dependencies;
        }

        public boolean apply(URI uri) {
            return this.dependencies.containsKey((Object)uri.lastSegment());
        }

        public Set<URI> getDependencies(URI uri, URIConverter uriConverter) {
            if (this.dependencies.containsKey((Object)uri.lastSegment())) {
                HashSet<URI> uris = new HashSet<URI>();
                for (String fileName : (ImmutableSet)this.dependencies.get((Object)uri.lastSegment())) {
                    URI dependentUri = uri.trimSegments(1).appendSegment(fileName);
                    if (!uriConverter.exists(dependentUri, Collections.emptyMap())) continue;
                    uris.add(dependentUri);
                }
                return uris;
            }
            return Collections.emptySet();
        }
    }
}

