/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import java.util.Arrays;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComparisonUtilDeleteTest {
    private static final CompareFactory COMPARE_FACTORY = CompareFactory.eINSTANCE;
    private Match match;
    private Diff diffToDelete;

    @Before
    public void setUp() {
        this.match = this.createMatch(COMPARE_FACTORY.createComparison());
        this.diffToDelete = this.createDiff(DifferenceSource.LEFT);
    }

    private Match createMatch(Comparison comparison) {
        Match newMatch = COMPARE_FACTORY.createMatch();
        comparison.getMatches().add((Object)newMatch);
        return newMatch;
    }

    private Diff createDiff(DifferenceSource side) {
        Diff newDiff = COMPARE_FACTORY.createDiff();
        this.match.getDifferences().add((Object)newDiff);
        newDiff.setSource(side);
        return newDiff;
    }

    private Conflict createConflict(Diff ... diffs) {
        Conflict newConflict = COMPARE_FACTORY.createConflict();
        newConflict.getDifferences().addAll(Arrays.asList(diffs));
        this.match.getComparison().getConflicts().add((Object)newConflict);
        return newConflict;
    }

    private Equivalence createEquivalence(Diff ... diffs) {
        Equivalence newEquivalence = COMPARE_FACTORY.createEquivalence();
        newEquivalence.getDifferences().addAll(Arrays.asList(diffs));
        this.match.getComparison().getEquivalences().add((Object)newEquivalence);
        return newEquivalence;
    }

    @Test
    public void testDeleteDiff() {
        ComparisonUtil.delete((Diff)this.diffToDelete);
        Assert.assertFalse((boolean)this.match.getDifferences().contains((Object)this.diffToDelete));
    }

    @Test
    public void testDeleteDiff_WithConflictsToDelete() {
        Diff conflictingDiff = this.createDiff(DifferenceSource.RIGHT);
        Conflict conflictToDelete = this.createConflict(this.diffToDelete, conflictingDiff);
        Conflict otherConflict = this.createConflict(this.createDiff(DifferenceSource.LEFT), this.createDiff(DifferenceSource.RIGHT));
        ComparisonUtil.delete((Diff)this.diffToDelete);
        Assert.assertFalse((boolean)this.match.getDifferences().contains((Object)this.diffToDelete));
        Assert.assertNull((Object)conflictingDiff.getConflict());
        Assert.assertFalse((boolean)this.match.getComparison().getConflicts().contains((Object)conflictToDelete));
        Assert.assertTrue((boolean)this.match.getComparison().getConflicts().contains((Object)otherConflict));
        Assert.assertEquals((long)2L, (long)otherConflict.getDifferences().size());
    }

    @Test
    public void testDeleteDiff_WithConflictToKeep() {
        Conflict conflictToKeep = this.createConflict(this.diffToDelete, this.createDiff(DifferenceSource.LEFT), this.createDiff(DifferenceSource.RIGHT));
        ComparisonUtil.delete((Diff)this.diffToDelete);
        Assert.assertFalse((boolean)this.match.getDifferences().contains((Object)this.diffToDelete));
        Assert.assertFalse((boolean)conflictToKeep.getDifferences().contains((Object)this.diffToDelete));
        Assert.assertTrue((boolean)this.match.getComparison().getConflicts().contains((Object)conflictToKeep));
        Assert.assertEquals((long)1L, (long)conflictToKeep.getLeftDifferences().size());
        Assert.assertEquals((long)1L, (long)conflictToKeep.getRightDifferences().size());
    }

    @Test
    public void testDeleteDiff_WithEquivalencesToDelete() {
        Diff equivalentDiff = this.createDiff(DifferenceSource.RIGHT);
        Equivalence equivalenceToDelete = this.createEquivalence(this.diffToDelete, equivalentDiff);
        Equivalence otherEquivalence = this.createEquivalence(this.createDiff(DifferenceSource.LEFT), this.createDiff(DifferenceSource.RIGHT));
        ComparisonUtil.delete((Diff)this.diffToDelete);
        Assert.assertFalse((boolean)this.match.getDifferences().contains((Object)this.diffToDelete));
        Assert.assertNull((Object)equivalentDiff.getEquivalence());
        Assert.assertFalse((boolean)this.match.getComparison().getEquivalences().contains((Object)equivalenceToDelete));
        Assert.assertTrue((boolean)this.match.getComparison().getEquivalences().contains((Object)otherEquivalence));
        Assert.assertEquals((long)2L, (long)otherEquivalence.getDifferences().size());
    }

    @Test
    public void testDeleteDiff_WithEquivalenceToKeep() {
        Equivalence equivalenceToKeep = this.createEquivalence(this.diffToDelete, this.createDiff(DifferenceSource.LEFT), this.createDiff(DifferenceSource.RIGHT));
        ComparisonUtil.delete((Diff)this.diffToDelete);
        Assert.assertFalse((boolean)this.match.getDifferences().contains((Object)this.diffToDelete));
        Assert.assertFalse((boolean)equivalenceToKeep.getDifferences().contains((Object)this.diffToDelete));
        Assert.assertTrue((boolean)this.match.getComparison().getEquivalences().contains((Object)equivalenceToKeep));
        Assert.assertEquals((long)2L, (long)equivalenceToKeep.getDifferences().size());
    }
}

