/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.match;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.resource.RootIDMatchingStrategy;
import org.eclipse.emf.compare.tests.match.data.MatchInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class RootIDMatchingTest {
    private MatchInputData input = new MatchInputData();

    @Test
    public void testRootIDTwoWayA1() throws IOException {
        List<Resource> left = this.input.getRootIDTwoWayA1Left();
        List<Resource> right = this.input.getRootIDTwoWayA1Right();
        LinkedList origin = Lists.newLinkedList();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, (Iterable)origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    @Test
    public void testRootIDTwoWayA2() throws IOException {
        List<Resource> left = this.input.getRootIDTwoWayA2Left();
        List<Resource> right = this.input.getRootIDTwoWayA2Right();
        LinkedList origin = Lists.newLinkedList();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, (Iterable)origin);
        Assert.assertEquals((long)1L, (long)matchResources.size());
    }

    @Test
    public void testRootIDTwoWayA3() throws IOException {
        List<Resource> left = this.input.getRootIDTwoWayA3Left();
        List<Resource> right = this.input.getRootIDTwoWayA3Right();
        LinkedList origin = Lists.newLinkedList();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, (Iterable)origin);
        Assert.assertEquals((long)2L, (long)matchResources.size());
    }

    @Test
    public void testRootIDTwoWayA4() throws IOException {
        List<Resource> left = this.input.getRootIDTwoWayA4Left();
        List<Resource> right = this.input.getRootIDTwoWayA4Right();
        LinkedList origin = Lists.newLinkedList();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, (Iterable)origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    @Test
    public void testRootIDTwoWayA5() throws IOException {
        List<Resource> left = this.input.getRootIDTwoWayA5Left();
        List<Resource> right = this.input.getRootIDTwoWayA5Right();
        LinkedList origin = Lists.newLinkedList();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, (Iterable)origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    @Test
    public void testRootIDTwoWayA6() throws IOException {
        List<Resource> left = this.input.getRootIDTwoWayA6Left();
        List<Resource> right = this.input.getRootIDTwoWayA6Right();
        LinkedList origin = Lists.newLinkedList();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, (Iterable)origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    @Test
    public void testRootIDThreeWayA1() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA1Left();
        List<Resource> right = this.input.getRootIDThreeWayA1Right();
        List<Resource> origin = this.input.getRootIDThreeWayA1Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    @Test
    public void testRootIDThreeWayA2() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA2Left();
        List<Resource> right = this.input.getRootIDThreeWayA2Right();
        List<Resource> origin = this.input.getRootIDThreeWayA2Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)2L, (long)matchResources.size());
        this.assertContainsMatching(matchResources, "left.nodes", null, "origin2.nodes");
        this.assertContainsMatching(matchResources, null, "right2.nodes", "origin.nodes");
    }

    @Test
    public void testRootIDThreeWayA3() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA3Left();
        List<Resource> right = this.input.getRootIDThreeWayA3Right();
        List<Resource> origin = this.input.getRootIDThreeWayA3Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)1L, (long)matchResources.size());
        this.assertContainsMatching(matchResources, "left.nodes", "right.nodes", "origin.nodes");
    }

    @Test
    public void testRootIDThreeWayA4() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA4Left();
        List<Resource> right = this.input.getRootIDThreeWayA4Right();
        List<Resource> origin = this.input.getRootIDThreeWayA4Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)1L, (long)matchResources.size());
        this.assertContainsMatching(matchResources, "left.nodes", "right2.nodes", "origin.nodes");
    }

    @Test
    public void testRootIDThreeWayA5() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA5Left();
        List<Resource> right = this.input.getRootIDThreeWayA5Right();
        List<Resource> origin = this.input.getRootIDThreeWayA5Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)1L, (long)matchResources.size());
        this.assertContainsMatching(matchResources, "left2.nodes", "right.nodes", "origin.nodes");
    }

    @Test
    public void testRootIDThreeWayA6() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA6Left();
        List<Resource> right = this.input.getRootIDThreeWayA6Right();
        List<Resource> origin = this.input.getRootIDThreeWayA6Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)2L, (long)matchResources.size());
        this.assertContainsMatching(matchResources, "left.nodes", "right.nodes", "origin.nodes");
        this.assertContainsMatching(matchResources, "left2.nodes", "right2.nodes", "origin2.nodes");
    }

    @Test
    public void testRootIDThreeWayA7() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA7Left();
        List<Resource> right = this.input.getRootIDThreeWayA7Right();
        List<Resource> origin = this.input.getRootIDThreeWayA7Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    @Test
    public void testRootIDThreeWayA8() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA8Left();
        List<Resource> right = this.input.getRootIDThreeWayA8Right();
        List<Resource> origin = this.input.getRootIDThreeWayA8Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    @Test
    public void testRootIDThreeWayA9() throws IOException {
        List<Resource> left = this.input.getRootIDThreeWayA9Left();
        List<Resource> right = this.input.getRootIDThreeWayA9Right();
        List<Resource> origin = this.input.getRootIDThreeWayA9Origin();
        RootIDMatchingStrategy strategy = new RootIDMatchingStrategy();
        List matchResources = strategy.matchResources(left, right, origin);
        Assert.assertEquals((long)0L, (long)matchResources.size());
    }

    private void assertContainsMatching(Collection<MatchResource> matchResources, String left, String right, String origin) {
        boolean foundMatching = false;
        for (MatchResource matchResource : matchResources) {
            if (!this.nameEquals(matchResource.getLeftURI(), left) || !this.nameEquals(matchResource.getRightURI(), right) || !this.nameEquals(matchResource.getOriginURI(), origin)) continue;
            foundMatching = true;
            break;
        }
        Assert.assertTrue((boolean)foundMatching);
    }

    private boolean nameEquals(String uri, String name) {
        if (uri == null && name == null) {
            return true;
        }
        if (uri == null || name == null) {
            return false;
        }
        return uri.endsWith(name);
    }
}

