/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.internal.spec.DiffSpec;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.junit.Assert;
import org.junit.Test;

public class RefineMergeTest {
    private static final boolean MERGE_RIGHT_TO_LEFT = true;
    private final AbstractMerger merger = new AbstractMerger(){

        public boolean isMergerFor(Diff target) {
            return true;
        }
    };

    @Test
    public void testRefineOnGetDirectResultingMerges() {
        DiffSpec diff1 = new DiffSpec();
        DiffSpec diff2 = new DiffSpec();
        DiffSpec diff3 = new DiffSpec();
        diff3.getRefinedBy().add((Object)diff1);
        diff3.getRefinedBy().add((Object)diff2);
        Set directMergeDependencies = this.merger.getDirectMergeDependencies((Diff)diff1, true);
        Set resultingMerges = this.merger.getDirectResultingMerges((Diff)diff1, true);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diff3));
        Assert.assertTrue((boolean)directMergeDependencies.isEmpty());
        directMergeDependencies = this.merger.getDirectMergeDependencies((Diff)diff2, true);
        resultingMerges = this.merger.getDirectResultingMerges((Diff)diff2, true);
        Assert.assertTrue((boolean)directMergeDependencies.isEmpty());
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diff3));
        directMergeDependencies = this.merger.getDirectMergeDependencies((Diff)diff3, true);
        resultingMerges = this.merger.getDirectResultingMerges((Diff)diff3, true);
        Assert.assertEquals((long)2L, (long)directMergeDependencies.size());
        Assert.assertTrue((boolean)directMergeDependencies.contains(diff1));
        Assert.assertTrue((boolean)directMergeDependencies.contains(diff2));
        Assert.assertTrue((boolean)resultingMerges.isEmpty());
        diff2.setState(DifferenceState.MERGED);
        directMergeDependencies = this.merger.getDirectMergeDependencies((Diff)diff1, true);
        resultingMerges = this.merger.getDirectResultingMerges((Diff)diff1, true);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diff3));
        Assert.assertTrue((boolean)directMergeDependencies.isEmpty());
        directMergeDependencies = this.merger.getDirectMergeDependencies((Diff)diff2, true);
        resultingMerges = this.merger.getDirectResultingMerges((Diff)diff2, true);
        Assert.assertTrue((boolean)directMergeDependencies.isEmpty());
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diff3));
        directMergeDependencies = this.merger.getDirectMergeDependencies((Diff)diff3, true);
        resultingMerges = this.merger.getDirectResultingMerges((Diff)diff3, true);
        Assert.assertEquals((long)2L, (long)directMergeDependencies.size());
        Assert.assertTrue((boolean)directMergeDependencies.contains(diff1));
        Assert.assertTrue((boolean)directMergeDependencies.contains(diff2));
        Assert.assertTrue((boolean)resultingMerges.isEmpty());
    }
}

