/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.unit;

import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.junit.Assert;
import org.junit.Test;

public class CompareFactoryTest {
    @Test
    public void testCreateComparison() {
        Comparison result = CompareFactory.eINSTANCE.createComparison();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Comparison));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.COMPARISON);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Comparison));
    }

    @Test
    public void testCreateMatchResource() {
        MatchResource result = CompareFactory.eINSTANCE.createMatchResource();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MatchResource));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.MATCH_RESOURCE);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MatchResource));
    }

    @Test
    public void testCreateMatch() {
        Match result = CompareFactory.eINSTANCE.createMatch();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Match));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.MATCH);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Match));
    }

    @Test
    public void testCreateDiff() {
        Diff result = CompareFactory.eINSTANCE.createDiff();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Diff));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.DIFF);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Diff));
    }

    @Test
    public void testCreateResourceAttachmentChange() {
        ResourceAttachmentChange result = CompareFactory.eINSTANCE.createResourceAttachmentChange();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ResourceAttachmentChange));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.RESOURCE_ATTACHMENT_CHANGE);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ResourceAttachmentChange));
    }

    @Test
    public void testCreateReferenceChange() {
        ReferenceChange result = CompareFactory.eINSTANCE.createReferenceChange();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ReferenceChange));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.REFERENCE_CHANGE);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ReferenceChange));
    }

    @Test
    public void testCreateAttributeChange() {
        AttributeChange result = CompareFactory.eINSTANCE.createAttributeChange();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof AttributeChange));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.ATTRIBUTE_CHANGE);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof AttributeChange));
    }

    @Test
    public void testCreateConflict() {
        Conflict result = CompareFactory.eINSTANCE.createConflict();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Conflict));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.CONFLICT);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Conflict));
    }

    @Test
    public void testCreateEquivalence() {
        Equivalence result = CompareFactory.eINSTANCE.createEquivalence();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Equivalence));
        result = CompareFactory.eINSTANCE.create(ComparePackage.Literals.EQUIVALENCE);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Equivalence));
    }

    @Test
    public void testCreateUnknownEClass() {
        try {
            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
            ((EClassifierImpl)eClass).setClassifierID(-1);
            CompareFactory.eINSTANCE.create(eClass);
            Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConvertDifferenceKindToString() {
        for (DifferenceKind value : DifferenceKind.VALUES) {
            String result = CompareFactory.eINSTANCE.convertToString((EDataType)ComparePackage.Literals.DIFFERENCE_KIND, (Object)value);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)value.toString(), (Object)result);
        }
    }

    @Test
    public void testConvertDifferenceSourceToString() {
        for (DifferenceSource value : DifferenceSource.VALUES) {
            String result = CompareFactory.eINSTANCE.convertToString((EDataType)ComparePackage.Literals.DIFFERENCE_SOURCE, (Object)value);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)value.toString(), (Object)result);
        }
    }

    @Test
    public void testConvertDifferenceStateToString() {
        for (DifferenceState value : DifferenceState.VALUES) {
            String result = CompareFactory.eINSTANCE.convertToString((EDataType)ComparePackage.Literals.DIFFERENCE_STATE, (Object)value);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)value.toString(), (Object)result);
        }
    }

    @Test
    public void testConvertConflictKindToString() {
        for (ConflictKind value : ConflictKind.VALUES) {
            String result = CompareFactory.eINSTANCE.convertToString((EDataType)ComparePackage.Literals.CONFLICT_KIND, (Object)value);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)value.toString(), (Object)result);
        }
    }

    @Test
    public void testConvertUnknownEEnumToString() {
        try {
            EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
            ((EClassifierImpl)eEnum).setClassifierID(-1);
            CompareFactory.eINSTANCE.convertToString((EDataType)eEnum, (Object)eEnum);
            Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDifferenceKindFromString() {
        for (DifferenceKind value : DifferenceKind.VALUES) {
            Object result = CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.DIFFERENCE_KIND, value.getLiteral());
            Assert.assertNotNull((Object)result);
            Assert.assertSame((Object)value, (Object)result);
            try {
                CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.DIFFERENCE_KIND, "ThisShouldntBeAKnownEEnumLiteral");
                Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateDifferenceSourceFromString() {
        for (DifferenceSource value : DifferenceSource.VALUES) {
            Object result = CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.DIFFERENCE_SOURCE, value.getLiteral());
            Assert.assertNotNull((Object)result);
            Assert.assertSame((Object)value, (Object)result);
            try {
                CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.DIFFERENCE_SOURCE, "ThisShouldntBeAKnownEEnumLiteral");
                Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateDifferenceStateFromString() {
        for (DifferenceState value : DifferenceState.VALUES) {
            Object result = CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.DIFFERENCE_STATE, value.getLiteral());
            Assert.assertNotNull((Object)result);
            Assert.assertSame((Object)value, (Object)result);
            try {
                CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.DIFFERENCE_STATE, "ThisShouldntBeAKnownEEnumLiteral");
                Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateConflictKindFromString() {
        for (ConflictKind value : ConflictKind.VALUES) {
            Object result = CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.CONFLICT_KIND, value.getLiteral());
            Assert.assertNotNull((Object)result);
            Assert.assertSame((Object)value, (Object)result);
            try {
                CompareFactory.eINSTANCE.createFromString((EDataType)ComparePackage.Literals.CONFLICT_KIND, "ThisShouldntBeAKnownEEnumLiteral");
                Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateUnknownEEnumFromString() {
        try {
            EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
            ((EClassifierImpl)eEnum).setClassifierID(-1);
            CompareFactory.eINSTANCE.createFromString((EDataType)eEnum, "ThisShouldntBeAKnownEEnumLiteral");
            Assert.fail((String)"Expected IllegalArgumentException hasn't been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

