/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.util.Set;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.tests.unit.AbstractGitLogicalModelTest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.api.Status;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitMergeTest
extends AbstractGitLogicalModelTest {
    private final IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.store.setValue("org.eclipse.emf.compare.ide.ui.preference.preMergeOnConflict", true);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.store.setToDefault("org.eclipse.emf.compare.ide.ui.preference.preMergeOnConflict");
    }

    private void setup001() throws Exception {
        EPackage ePackage = this.createPackage(null, "P1");
        EClass class1 = this.createClass(ePackage, "C1");
        this.resource1.getContents().add((Object)ePackage);
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch("refs/heads/master", "refs/heads/branch");
        this.createClass(ePackage, "C2");
        class1.setName("C1new");
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("update-C1-add-C2");
        this.repository.checkoutBranch("refs/heads/branch");
        this.reload(new Resource[]{this.resource1});
        ePackage = (EPackage)this.findObject(this.resource1, "P1");
        class1 = (EClass)this.findObject(this.resource1, "C1");
        ePackage.getEClassifiers().remove((Object)class1);
        this.createClass(ePackage, "C3");
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("remove-C1-add-C3");
        this.repository.checkoutBranch("refs/heads/master");
        this.reload(new Resource[]{this.resource1});
    }

    @Test
    public void merge001() throws Exception {
        this.setup001();
        this.repository.mergeLogical("refs/heads/branch");
        this.reload(new Resource[]{this.resource1});
        Status status = this.repository.status();
        Set conflicting = status.getConflicting();
        Assert.assertEquals((long)1L, (long)conflicting.size());
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C1new"));
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C2"));
        Assert.assertNotNull((Object)this.findObject(this.resource1, "C3"));
    }
}

