/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ocl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.helper.OCLHelper;

public abstract class AbstractOCLModelConstraint<C, CT, CLS, E>
implements IModelConstraint {
    private final IConstraintDescriptor descriptor;
    private final Map<EClass, Reference<?>> queries = new WeakHashMap();
    private QueryManager queryManager;

    public AbstractOCLModelConstraint(IConstraintDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected EnvironmentFactory<?, C, ?, ?, ?, ?, ?, ?, ?, CT, CLS, E> createOCLEnvironmentFactory() {
        return null;
    }

    public Query<C, CLS, E> getConstraintCondition(EObject target) {
        Query result = null;
        EClass eClass = target.eClass();
        Reference<?> reference = this.queries.get(eClass);
        if (reference != null) {
            result = (Query)reference.get();
        }
        if (result == null) {
            OCL ocl = OCL.newInstance(this.createOCLEnvironmentFactory());
            OCLHelper helper = ocl.createOCLHelper();
            helper.setInstanceContext((Object)target);
            try {
                result = ocl.createQuery(helper.createInvariant(this.getDescriptor().getBody()));
            }
            catch (ParserException e) {
                throw new RuntimeException(e);
            }
            this.queries.put(eClass, new WeakReference<Query>(result));
        }
        return result;
    }

    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        if (this.getQueryManager().check(target)) {
            return ctx.createSuccessStatus();
        }
        return ctx.createFailureStatus(new Object[]{target});
    }

    private QueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.queryManager = new QueryManager();
        }
        return this.queryManager;
    }

    public IConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    private final class QueryManager {
        QueryManager() {
        }

        boolean check(EObject target) {
            Query query = AbstractOCLModelConstraint.this.getConstraintCondition(target);
            return query.check((Object)target);
        }
    }
}

