/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.internal.page;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.internal.EEFTabbedPropertyViewPlugin;
import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFTabbedPropertyList;
import org.eclipse.eef.properties.ui.internal.registry.EEFTabbedPropertyRegistry;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class EEFTabbedPropertyViewer {
    private List<IEEFTabDescriptor> elements = new ArrayList<IEEFTabDescriptor>();
    private List<IEEFTabDescriptorChangedListener> listeners = new ArrayList<IEEFTabDescriptorChangedListener>();
    private EEFTabbedPropertyList list;
    private IWorkbenchPart part;
    private EEFTabbedPropertyRegistry registry;
    private ISelection input;

    public EEFTabbedPropertyViewer(EEFTabbedPropertyList tabbedPropertyList, EEFTabbedPropertyRegistry registry) {
        this.list = tabbedPropertyList;
        this.registry = registry;
        OpenStrategy handler = new OpenStrategy((Control)this.list);
        handler.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = EEFTabbedPropertyViewer.this.list.getSelectionIndex();
                IEEFTabDescriptor descriptor = EEFTabbedPropertyViewer.this.getTabDescriptionAtIndex(index);
                EEFTabbedPropertyViewer.this.fireSelectionChanged(descriptor);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void fireSelectionChanged(IEEFTabDescriptor descriptor) {
        for (IEEFTabDescriptorChangedListener listener : this.listeners) {
            listener.selectionChanged(descriptor);
        }
    }

    public void addSelectionListener(IEEFTabDescriptorChangedListener listener) {
        this.listeners.add(listener);
    }

    public void setInput(IWorkbenchPart workbenchPart, ISelection selection) {
        EEFTabbedPropertyViewPlugin.getPlugin().debug("EEFTabbedPropertyViewer#setInput()");
        this.part = workbenchPart;
        this.input = selection;
        this.elements.clear();
        List<IEEFTabDescriptor> descriptors = this.registry.getTabDescriptors(this.part, selection);
        this.list.removeAll();
        for (IEEFTabDescriptor descriptor : descriptors) {
            this.elements.add(descriptor);
        }
        this.list.setElements(descriptors.toArray());
    }

    public ISelection getInput() {
        return this.input;
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.part;
    }

    public List<IEEFTabDescriptor> getElements() {
        return this.elements;
    }

    public int getSelectionIndex() {
        return this.list.getSelectionIndex();
    }

    public IEEFTabDescriptor getTabDescriptionAtIndex(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public void setSelectedTabDescriptor(IEEFTabDescriptor descriptor) {
        if (descriptor == null) {
            this.list.deselectAll();
        } else {
            int index = -1;
            int i = 0;
            while (i < this.elements.size()) {
                if (this.elements.get(i) == descriptor) {
                    index = i;
                }
                ++i;
            }
            this.list.select(index);
        }
    }

    public static interface IEEFTabDescriptorChangedListener {
        public void selectionChanged(IEEFTabDescriptor var1);
    }
}

