/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;

public class HenshinEGraph
extends EGraphImpl
implements Adapter {
    private static final long serialVersionUID = -2408288653525326829L;
    protected final Graph henshinGraph;
    protected Map<Node, EObject> node2object;
    protected Map<EObject, Node> object2node;

    public HenshinEGraph(Graph graph) {
        this.henshinGraph = graph;
        this.node2object = new HashMap<Node, EObject>();
        this.object2node = new HashMap<EObject, Node>();
        this.henshin2emfGraph();
    }

    private void henshin2emfGraph() {
        this.clear();
        this.object2node.clear();
        this.node2object.clear();
        for (Node node : this.henshinGraph.getNodes()) {
            EObject eObject = this.node2object.get(node);
            if (eObject == null) {
                EClass nodeType = node.getType();
                Iterator factory = nodeType.getEPackage().getEFactoryInstance();
                eObject = factory.create(nodeType);
                this.add(eObject);
                this.addSynchronizedPair(node, eObject);
            }
            for (Attribute attr : node.getAttributes()) {
                eObject.eAdapters().remove((Object)this);
                EAttribute attrType = attr.getType();
                String attrValue = attr.getValue();
                attrValue = attrValue.replaceAll("\"", "");
                if (attrType.isMany()) {
                    List attrValues = (List)eObject.eGet((EStructuralFeature)attrType);
                    attrValues.add(attrValue);
                } else {
                    eObject.eSet((EStructuralFeature)attrType, EcoreUtil.createFromString((EDataType)attrType.getEAttributeType(), (String)attrValue));
                }
                eObject.eAdapters().add((Object)this);
            }
        }
        for (Edge edge : new ArrayList(this.henshinGraph.getEdges())) {
            EReference edgeType = edge.getType();
            if (edgeType.isDerived()) continue;
            EObject ownerObject = this.node2object.get(edge.getSource());
            EObject targetObject = this.node2object.get(edge.getTarget());
            if (!edgeType.isChangeable()) {
                if (edgeType.getEOpposite() == null || !edgeType.getEOpposite().isChangeable()) continue;
                edgeType = edgeType.getEOpposite();
                EObject temp = ownerObject;
                ownerObject = targetObject;
                targetObject = temp;
            }
            ownerObject.eAdapters().remove((Object)this);
            if (edgeType.isMany()) {
                List edgeValues = (List)ownerObject.eGet((EStructuralFeature)edgeType);
                edgeValues.add(targetObject);
            } else {
                ownerObject.eSet((EStructuralFeature)edgeType, (Object)targetObject);
            }
            ownerObject.eAdapters().add((Object)this);
        }
    }

    @Override
    public boolean add(EObject eObject) {
        boolean isNew = super.add(eObject);
        if (isNew) {
            Node node = this.object2node.get(eObject);
            if (node == null) {
                node = this.createNode();
                node.setType(eObject.eClass());
                this.henshinGraph.getNodes().add((Object)node);
                this.addSynchronizedPair(node, eObject);
            } else if (!this.henshinGraph.getNodes().contains((Object)node)) {
                this.henshinGraph.getNodes().add((Object)node);
            }
        }
        return isNew;
    }

    protected Attribute createAttribute() {
        return HenshinFactory.eINSTANCE.createAttribute();
    }

    protected Edge createEdge() {
        return HenshinFactory.eINSTANCE.createEdge();
    }

    protected Node createNode() {
        return HenshinFactory.eINSTANCE.createNode();
    }

    @Override
    public boolean remove(Object object) {
        Node node;
        boolean removed = super.remove(object);
        if (removed && (node = this.object2node.get(object)) != null) {
            this.henshinGraph.getNodes().remove((Object)node);
            ArrayList list = new ArrayList(node.getIncoming());
            list.addAll(node.getOutgoing());
            for (Edge edge : list) {
                edge.setSource(null);
                edge.setTarget(null);
                edge.setGraph(null);
            }
            this.removeSynchronizedPair(node, (EObject)object);
        }
        return removed;
    }

    public void updateEGraph() {
        this.henshin2emfGraph();
    }

    private void addSynchronizedPair(Node node, EObject eObject) {
        this.node2object.put(node, eObject);
        this.object2node.put(eObject, node);
        eObject.eAdapters().add((Object)this);
    }

    private void removeSynchronizedPair(Node node, EObject eObject) {
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        EObject owner = (EObject)notification.getNotifier();
        Node ownerNode = this.object2node.get(owner);
        Object feature = notification.getFeature();
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        if (feature instanceof EStructuralFeature && ownerNode != null) {
            if (oldValue != null && newValue != oldValue) {
                this.removeFromHenshinGraph(ownerNode, (EStructuralFeature)feature, oldValue);
            }
            if (newValue != null) {
                this.addToHenshinGraph(owner, (EStructuralFeature)feature, newValue);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
    }

    private void removeFromHenshinGraph(Node owner, EStructuralFeature feature, Object value) {
        if (feature instanceof EAttribute) {
            Attribute attribute = null;
            for (Attribute nodeAttribute : owner.getAttributes()) {
                if (nodeAttribute.getType() != feature) continue;
                attribute = nodeAttribute;
                break;
            }
            if (attribute != null) {
                attribute.setNode(null);
            }
        } else if (feature instanceof EReference) {
            Edge edge = null;
            if (value instanceof EObject) {
                Node targetNode = this.object2node.get(value);
                for (Edge outgoingEdge : owner.getOutgoing()) {
                    if (outgoingEdge.getTarget() != targetNode || outgoingEdge.getType() != feature) continue;
                    edge = outgoingEdge;
                    break;
                }
                if (edge != null) {
                    edge.setSource(null);
                    edge.setTarget(null);
                    edge.setGraph(null);
                }
            }
        }
    }

    private void addToHenshinGraph(EObject owner, EStructuralFeature feature, Object value) {
        Node node = this.object2node.get(owner);
        if (node != null && value != null) {
            if (feature instanceof EAttribute) {
                Attribute attribute = null;
                for (Attribute nodeAttribute : node.getAttributes()) {
                    if (nodeAttribute.getType() != feature) continue;
                    attribute = nodeAttribute;
                    break;
                }
                if (attribute == null) {
                    attribute = this.createAttribute();
                    attribute.setType((EAttribute)feature);
                    attribute.setNode(node);
                }
                attribute.setValue(value.toString());
            } else if (feature instanceof EReference) {
                Edge edge = null;
                if (value instanceof EObject) {
                    Node targetNode = this.object2node.get(value);
                    for (Edge outgoingEdge : node.getOutgoing()) {
                        if (outgoingEdge.getTarget() != targetNode || outgoingEdge.getType() != feature) continue;
                        edge = outgoingEdge;
                        break;
                    }
                    if (edge == null) {
                        edge = this.createEdge();
                        edge.setSource(node);
                        edge.setTarget(targetNode);
                        edge.setGraph(this.henshinGraph);
                        edge.setType((EReference)feature);
                    }
                }
            }
        }
    }

    public Map<Node, EObject> getNode2ObjectMap() {
        return this.node2object;
    }

    public void setNode2ObjectMap(Map<Node, EObject> node2object) {
        this.node2object = node2object;
    }

    public Map<EObject, Node> getObject2NodeMap() {
        return this.object2node;
    }

    public void setObject2NodeMap(Map<EObject, Node> object2node) {
        this.object2node = object2node;
    }
}

