/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.gui.impl;

import agg.attribute.AttrInstance;
import agg.attribute.AttrInstanceMember;
import agg.attribute.AttrManager;
import agg.attribute.AttrTuple;
import agg.attribute.gui.AttrEditorManager;
import agg.attribute.gui.AttrTupleEditor;
import agg.attribute.gui.impl.AbstractEditor;
import agg.attribute.gui.impl.HandlerSelectionEditor;
import agg.attribute.gui.impl.MemberEditorDispatcher;
import agg.attribute.gui.impl.TupleTableModel;
import agg.attribute.gui.impl.TupleTableModelConstants;
import agg.attribute.impl.AttrSession;
import agg.attribute.view.AttrViewEvent;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneConstants;
import javax.swing.table.TableColumn;

public class BasicTupleEditor
extends AbstractEditor
implements AttrTupleEditor,
AttrViewObserver,
TupleTableModelConstants,
ScrollPaneConstants {
    protected AttrTuple tuple;
    protected AttrViewSetting viewSetting;
    protected TupleTableModel tableModel;
    protected HandlerSelectionEditor handlerSelectionEditor;
    protected JTable tableView;
    protected JScrollPane tableScrollPane;

    public BasicTupleEditor(AttrManager m, AttrEditorManager em) {
        super(m, em);
        this.setViewSetting(m.getDefaultOpenView());
    }

    protected TupleTableModel createTableModel() {
        int[] columns = new int[]{3, 4};
        TupleTableModel tm = new TupleTableModel(this);
        tm.setColumnArray(columns);
        tm.setExtensible(false);
        return tm;
    }

    @Override
    protected void arrangeMainPanel() {
    }

    @Override
    protected void genericCreateAllViews() {
        this.createTableView();
    }

    @Override
    protected void genericCustomizeMainLayout() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.tableScrollPane, "Center");
    }

    protected void createTableView() {
        this.tableModel = this.createTableModel();
        this.tableView = new JTable(this.tableModel);
        this.tableView.setRowHeight(this.tableView.getRowHeight() + 2);
        String[] names = new String[this.tableModel.getColumnCount()];
        int i = 0;
        while (i < this.tableModel.getColumnCount()) {
            names[i] = this.tableModel.getColumnName(i);
            ++i;
        }
        Enumeration<TableColumn> columns = this.tableView.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tc = columns.nextElement();
            String name = this.tableModel.getColumnName(tc.getModelIndex());
            if (name == "OK" || name == "In" || name == "Out") {
                tc.setMinWidth(30);
                tc.setMaxWidth(70);
                continue;
            }
            if (name == "Shown") {
                tc.setMinWidth(30);
                tc.setMaxWidth(60);
                tc.setPreferredWidth(60);
                continue;
            }
            if (name == "Handler") {
                tc.setMinWidth(50);
                tc.setMaxWidth(100);
                tc.setPreferredWidth(80);
                continue;
            }
            if (name == "Type" || name == "Name") {
                tc.setMinWidth(40);
                tc.setPreferredWidth(70);
                continue;
            }
            if (name == "Expression") {
                tc.setMinWidth(60);
                tc.setPreferredWidth(300);
                continue;
            }
            if (name == "Yields") {
                tc.setMinWidth(80);
                tc.setPreferredWidth(100);
                continue;
            }
            tc.setPreferredWidth(100);
        }
        new MemberEditorDispatcher(this);
        this.tableScrollPane = new JScrollPane(this.tableView);
        this.tableScrollPane.setMinimumSize(new Dimension(100, 50));
    }

    protected void registerAsObserver() {
        if (this.tuple != null) {
            this.viewSetting.addObserver(this, this.tuple);
        }
    }

    protected void deregisterAsObserver() {
        if (this.tuple != null) {
            this.viewSetting.removeObserver(this, this.tuple);
        }
    }

    public AttrInstanceMember getSelectedMember() {
        if (this.tuple == null || !(this.tuple instanceof AttrInstance)) {
            return null;
        }
        int selectedRow = this.tableView.getSelectedRow();
        if (selectedRow >= this.tuple.getNumberOfEntries(this.viewSetting)) {
            return null;
        }
        AttrInstanceMember member = (AttrInstanceMember)this.tableModel.getMember(this.tuple, selectedRow);
        return member;
    }

    public JTable getTableView() {
        return this.tableView;
    }

    public TupleTableModel getTableModel() {
        return this.tableModel;
    }

    public HandlerSelectionEditor getHandlerSelectionEditor() {
        return this.handlerSelectionEditor;
    }

    @Override
    public void setTuple(AttrTuple anAttrTuple) {
        this.deregisterAsObserver();
        this.tuple = anAttrTuple;
        this.registerAsObserver();
        this.handlerSelectionEditor = HandlerSelectionEditor.getHandlerSelectionEditor(this.getAttrManager());
        this.attributeChanged(null);
    }

    @Override
    public AttrTuple getTuple() {
        return this.tuple;
    }

    @Override
    public void setViewSetting(AttrViewSetting anAttrViewSetting) {
        if (anAttrViewSetting == null) {
            AttrSession.warn((Object)this, "Tried to set a null view setting!", true);
            return;
        }
        this.deregisterAsObserver();
        this.viewSetting = anAttrViewSetting;
        this.registerAsObserver();
        this.attributeChanged(null);
    }

    @Override
    public AttrViewSetting getViewSetting() {
        return this.viewSetting;
    }

    @Override
    public void attributeChanged(AttrViewEvent event) {
        if (this.tableModel != null && event != null) {
            this.tableModel.attributeChanged(event);
            this.firePropertyChange();
        }
    }

    public boolean isPersistentFor(AttrTuple at) {
        return false;
    }

    @Override
    public Component getCustomEditor() {
        return this.getComponent();
    }

    @Override
    public void setValue(Object val) {
        this.setTuple((AttrTuple)val);
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        this.getComponent().paintAll(gfx);
    }
}

