/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrMapping;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrMsgCode;
import agg.attribute.impl.AttrObject;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueTuple;
import java.util.Vector;

public class TupleMapping
extends AttrObject
implements AttrMapping,
AttrMsgCode {
    static final long serialVersionUID = 5592548875776404533L;
    protected ValueTuple source;
    protected ValueTuple target;
    protected ContextView context;
    protected String[] assignedVariables;

    public TupleMapping(ContextView mappingContext, ValueTuple src, ValueTuple tar) {
        boolean child2parentMapping = false;
        if (mappingContext.getAllowedMapping() == 0) {
            if (!src.getType().compareTo(tar.getType()) && !((DeclTuple)src.getType()).weakcompareTo(tar.getType())) {
                throw new AttrImplException(9, "Types must be equal.");
            }
        } else if (!(mappingContext.getAllowedMapping() != 1 || src.getType().compareTo(tar.getType()) || ((DeclTuple)src.getType()).weakcompareTo(tar.getType()) || tar.getTupleType().isSubclassOf(src.getTupleType()))) {
            if (src.getTupleType().isSubclassOf(tar.getTupleType())) {
                child2parentMapping = true;
            } else {
                System.out.println("Target type must be subtype of source or equal.");
                throw new AttrImplException("Target type must be subtype of source or equal.");
            }
        }
        String[] variables = null;
        this.context = mappingContext;
        if (this.context == null) {
            this.context = src.getContextView();
        }
        try {
            if (this.context.getAllowedMapping() == 1) {
                variables = child2parentMapping ? src.matchChild2Parent(tar, this.context) : src.matchTo(tar, this.context);
            }
        }
        catch (AttrImplException ex1) {
            throw new AttrImplException("TupleMapping: attribute exception\n" + ex1.getMessage());
        }
        this.source = src;
        this.target = tar;
        this.assignedVariables = variables;
        this.context.addMapping(this);
    }

    public void adoptEntriesWhereEmpty(ValueTuple src, ValueTuple tar) {
        try {
            if (this.context.getAllowedMapping() == 0) {
                tar.adoptEntriesWhereEmpty(src);
            }
        }
        catch (AttrImplException ex1) {
            throw new AttrImplException("TupleMapping: attribute exception\n" + ex1.getMessage());
        }
    }

    public Vector<String> getAssignedVariables() {
        int nn = this.assignedVariables == null ? -1 : this.assignedVariables.length;
        Vector<String> v = new Vector<String>(1);
        int i = 0;
        while (i < nn) {
            v.add(this.assignedVariables[i]);
            ++i;
        }
        return v;
    }

    @Override
    public boolean next() {
        return false;
    }

    @Override
    public void remove() {
        this.context.removeMapping(this);
    }

    @Override
    public void removeNow() {
        if (this.assignedVariables != null) {
            int i = 0;
            while (i < this.assignedVariables.length) {
                this.context.removeValue(this.assignedVariables[i]);
                ++i;
            }
        }
    }

    public ValueTuple getSource() {
        return this.source;
    }

    public ValueTuple getTarget() {
        return this.target;
    }

    protected String getAllowedMappingAsString(ContextView contextview) {
        if (contextview == null) {
            return "";
        }
        return contextview.getAllowedMapping() == 1 ? " (match)" : " (plain)";
    }
}

