/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.impl.CondTuple;
import agg.cons.AtomConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.EditUndoManager;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.agt.MultiRule;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class EdAtomic
extends EdRule {
    protected OrdinaryMorphism morph;
    private Vector<EdAtomic> conclusions;
    protected boolean isParent;
    protected EdAtomic parent;

    public EdAtomic(AtomConstraint a, EdTypeSet typeset, String name) {
        super(true);
        this.itsACs = null;
        this.itsNACs = null;
        this.itsPACs = null;
        this.typeSet = typeset;
        this.conclusions = new Vector();
        if (a == a.getParent()) {
            this.parent = this;
            this.isParent = true;
            this.eRight = this.eLeft = new EdGraph(a.getOriginal(), this.typeSet);
            if (!name.equals("")) {
                this.eLeft.getBasisGraph().setName("Premise of " + name);
                a.setAtomicName(name);
            }
            this.morph = a;
            Enumeration<AtomConstraint> e = a.getConclusions();
            while (e.hasMoreElements()) {
                AtomConstraint c = e.nextElement();
                this.createNextConclusion(c);
            }
        }
    }

    private EdAtomic(AtomConstraint a, EdTypeSet typeset, String name, EdAtomic parent) {
        super(true);
        this.itsACs = null;
        this.itsNACs = null;
        this.itsPACs = null;
        this.typeSet = typeset;
        this.conclusions = new Vector(0);
        this.parent = parent;
        this.isParent = false;
        this.eLeft = new EdGraph(a.getOriginal(), this.typeSet);
        this.eRight = new EdGraph(a.getImage(), this.typeSet);
        if (!name.equals("")) {
            this.eLeft.getBasisGraph().setName("Premise of " + name);
            this.eRight.getBasisGraph().setName("Conclusion of " + name);
            a.setAtomicName(name);
        }
        this.morph = a;
        this.morph.addObserver(this.eLeft);
        this.morph.addObserver(this.eRight);
    }

    private EdAtomic(EdGraph orig, EdGraph img, AtomConstraint a, EdTypeSet typeset, EdAtomic parent) {
        super(true);
        this.itsACs = null;
        this.itsNACs = null;
        this.itsPACs = null;
        this.typeSet = typeset;
        this.eLeft = orig;
        this.eRight = img;
        this.morph = a;
        this.morph.addObserver(this.eLeft);
        this.morph.addObserver(this.eRight);
        this.conclusions = new Vector(0);
        this.parent = parent;
        this.isParent = false;
    }

    @Override
    public void dispose() {
        if (this == this.parent) {
            while (this.conclusions.size() > 0) {
                EdAtomic conclusion = this.conclusions.remove(this.conclusions.size() - 1);
                if (conclusion.getMorphism() != null) {
                    conclusion.getMorphism().deleteObserver(this.eLeft);
                    conclusion.getMorphism().deleteObserver(this.eRight);
                }
                conclusion.getRight().dispose();
            }
            if (this.morph != null) {
                this.morph.deleteObserver(this.eLeft);
                this.morph.deleteObserver(this.eRight);
            }
            this.eLeft.dispose();
            this.eRight.dispose();
            this.eLeft = null;
            this.eRight = null;
            this.morph = null;
        }
    }

    @Override
    public void finalize() {
    }

    @Override
    public void trimToSize() {
        this.conclusions.trimToSize();
    }

    @Override
    public void setEditable(boolean b) {
        this.editable = b;
        if (!this.isParent) {
            this.eLeft.setEditable(b);
            this.eRight.setEditable(b);
        } else {
            int i = 0;
            while (i < this.conclusions.size()) {
                this.conclusions.get(i).setEditable(b);
                ++i;
            }
        }
    }

    @Override
    public void setGraGra(EdGraGra egra) {
        this.eGra = egra;
        if (egra != null) {
            if (!this.isParent) {
                this.eLeft.setGraGra(egra);
                this.eRight.setGraGra(egra);
                this.typeSet = egra.getTypeSet();
            } else {
                int i = 0;
                while (i < this.conclusions.size()) {
                    this.conclusions.get(i).setGraGra(this.eGra);
                    ++i;
                }
            }
        }
    }

    @Override
    public void setUndoManager(EditUndoManager anUndoManager) {
        if (!this.isParent) {
            this.undoManager = anUndoManager;
            this.eLeft.setUndoManager(anUndoManager);
            this.eRight.setUndoManager(anUndoManager);
        } else {
            int i = 0;
            while (i < this.conclusions.size()) {
                this.conclusions.get(i).setUndoManager(anUndoManager);
                ++i;
            }
        }
    }

    @Override
    public void setTypeSet(EdTypeSet types) {
        this.typeSet = types;
        if (types != null) {
            this.eLeft.setTypeSet(types);
            this.eRight.setTypeSet(types);
            this.typeSet = types;
        }
    }

    @Override
    public void clear() {
        this.eLeft.clear();
        this.eRight.clear();
    }

    @Override
    public OrdinaryMorphism getMorphism() {
        return this.morph;
    }

    @Override
    public Rule getBasisRule() {
        return null;
    }

    @Override
    public String getName() {
        if (this.morph != null) {
            return ((AtomConstraint)this.morph).getName();
        }
        return "";
    }

    public AtomConstraint getBasisAtomic() {
        return (AtomConstraint)this.morph;
    }

    public EdAtomic createNextConclusion(String name) {
        if (this == this.parent) {
            Graph g = BaseFactory.theFactory().createGraph(this.eLeft.getBasisGraph().getTypeSet());
            EdGraph img = new EdGraph(g, this.eLeft.getTypeSet());
            AtomConstraint a = this.parent.getBasisAtomic().createNextConclusion(img.getBasisGraph());
            EdAtomic conclusion = new EdAtomic(this.eLeft, img, a, this.eLeft.getTypeSet(), this.parent);
            this.conclusions.addElement(conclusion);
            conclusion.getMorphism().setName(name);
            this.enrichConclusion(conclusion);
            return conclusion;
        }
        return null;
    }

    public EdAtomic createNextConclusion(AtomConstraint a) {
        if (this == this.parent) {
            EdGraph img = new EdGraph(a.getTarget(), this.eLeft.getTypeSet());
            EdAtomic conclusion = new EdAtomic(this.eLeft, img, a, this.eLeft.getTypeSet(), this);
            this.conclusions.add(conclusion);
            this.enrichConclusion(conclusion);
            return conclusion;
        }
        return null;
    }

    public EdAtomic createNextConclusion(EdGraph img) {
        if (this == this.parent) {
            AtomConstraint a = this.parent.getBasisAtomic().createNextConclusion(img.getBasisGraph());
            EdAtomic conclusion = new EdAtomic(a, this.eLeft.getTypeSet(), "", this.parent);
            this.conclusions.addElement(conclusion);
            this.enrichConclusion(conclusion);
            return conclusion;
        }
        return null;
    }

    private void enrichConclusion(EdAtomic conclusion) {
        conclusion.setUndoManager(this.undoManager);
        conclusion.setGraGra(this.getGraGra());
        if (this.getGraGra() != null) {
            this.getGraGra().setChanged(true);
        }
    }

    public EdAtomic addConclusion(EdAtomic conclusion) {
        if (this == this.parent) {
            conclusion.isParent = false;
            conclusion.parent = this.parent;
            this.conclusions.addElement(conclusion);
            this.enrichConclusion(conclusion);
        }
        return conclusion;
    }

    public boolean destroyConclusion(EdAtomic conclusion) {
        if (this.conclusions.size() <= 1) {
            return false;
        }
        if (this.conclusions.contains(conclusion)) {
            this.conclusions.remove(conclusion);
            this.getBasisAtomic().destroyConclusion(conclusion.getBasisAtomic());
            if (this.getGraGra() != null) {
                this.getGraGra().setChanged(true);
            }
            return true;
        }
        return false;
    }

    public boolean removeConclusion(EdAtomic conclusion) {
        if (this.conclusions.size() <= 1) {
            return false;
        }
        if (this.conclusions.contains(conclusion)) {
            this.conclusions.remove(conclusion);
            this.getBasisAtomic().removeConclusion(conclusion.getBasisAtomic());
            if (this.getGraGra() != null) {
                this.getGraGra().setChanged(true);
            }
            return true;
        }
        return false;
    }

    public void removeConclusions() {
        while (this.conclusions.size() > 1) {
            this.conclusions.remove(this.conclusions.size() - 1);
        }
    }

    public Vector<EdAtomic> getConclusions() {
        return this.conclusions;
    }

    public EdAtomic getConclusion(int indx) {
        if (indx >= 0 && indx < this.conclusions.size()) {
            return this.conclusions.elementAt(indx);
        }
        return null;
    }

    @Override
    public Vector<String> getAttrConditions() {
        Vector<String> conds = new Vector<String>(1);
        if (this.morph == null) {
            return conds;
        }
        CondTuple ct = (CondTuple)this.morph.getAttrContext().getConditions();
        int i = 0;
        while (i < ct.getSize()) {
            conds.add(ct.getCondMemberAt(i).getExprAsText());
            ++i;
        }
        return conds;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public EdAtomic getParent() {
        return this.parent;
    }

    @Override
    public EdGraphObject getImage(EdGraphObject orig) {
        GraphObject im = this.morph.getImage(orig.getBasisObject());
        return this.eRight.findGraphObject(im);
    }

    @Override
    public Vector<EdGraphObject> getOriginal(EdGraphObject image) {
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(2);
        Enumeration<GraphObject> en = this.morph.getInverseImage(image.getBasisObject());
        while (en.hasMoreElements()) {
            GraphObject or = en.nextElement();
            EdGraphObject go = this.eLeft.findGraphObject(or);
            if (go == null) continue;
            vec.add(go);
        }
        return vec;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.addObject("", this.eLeft, true);
        if (this.conclusions.size() > 0) {
            int i = 0;
            while (i < this.conclusions.size()) {
                EdAtomic concl = this.conclusions.elementAt(i);
                EdGraph g = concl.getRight();
                h.addObject("", g, true);
                ++i;
            }
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        h.enrichObject(this.eLeft);
        int i = 0;
        while (i < this.conclusions.size()) {
            EdAtomic concl = this.conclusions.elementAt(i);
            h.enrichObject(concl.getRight());
            ++i;
        }
        this.updateRule();
    }

    @Override
    public boolean deleteGraphObjectsOfType(EdGraphObject tgo, boolean addToUndo) {
        List<EdGraphObject> list = this.eLeft.getGraphObjectsOfType(tgo);
        if (addToUndo) {
            int i = 0;
            while (i < list.size()) {
                EdGraphObject go = list.get(i);
                EdGraphObject rgo = this.eRight.findGraphObject(this.getBasisRule().getImage(go.getBasisObject()));
                if (rgo != null) {
                    this.addDeletedMappingToUndo(go, rgo);
                    this.undoManagerEndEdit();
                }
                ++i;
            }
        }
        boolean allDone = true;
        if (!this.eLeft.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
            allDone = false;
        }
        if (!this.eRight.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo)) {
            allDone = false;
        }
        return allDone;
    }

    @Override
    public boolean deleteGraphObjectsOfType(EdType t, boolean addToUndo) {
        List<EdGraphObject> list = this.eLeft.getGraphObjectsOfType(t);
        if (addToUndo) {
            int i = 0;
            while (i < list.size()) {
                EdGraphObject rgo;
                EdGraphObject go = list.get(i);
                if (!(this.getBasisRule().getRuleScheme() != null && this.getBasisRule().getRuleScheme().getKernelRule() != this.bRule && ((MultiRule)this.bRule).isTargetOfEmbeddingLeft(go.getBasisObject()) || (rgo = this.eRight.findGraphObject(this.getBasisRule().getImage(go.getBasisObject()))) == null)) {
                    this.addDeletedMappingToUndo(go, rgo);
                    this.undoManagerEndEdit();
                }
                ++i;
            }
        }
        boolean allDone = true;
        if (!this.eLeft.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            allDone = false;
        }
        if (!this.eRight.deleteGraphObjectsOfTypeFromGraph(t, addToUndo)) {
            allDone = false;
        }
        return allDone;
    }

    @Override
    public void setLayoutByIndexFrom(EdRule er, boolean inverse) {
        if (inverse) {
            this.eLeft.setLayoutByIndex(er.getRight(), true);
            this.eRight.setLayoutByIndex(er.getLeft(), true);
        } else {
            this.eLeft.setLayoutByIndex(er.getLeft(), true);
            this.eRight.setLayoutByIndex(er.getRight(), true);
        }
    }

    @Override
    public boolean addNAC(EdNAC nac) {
        return false;
    }

    @Override
    public EdNAC createNAC(OrdinaryMorphism nac) {
        return null;
    }

    @Override
    public EdNAC createNAC(String nameStr, boolean isIdentic) {
        return null;
    }

    @Override
    public void destroyNAC(EdNAC enac) {
    }

    @Override
    protected EdGraphObject findGraphObjectOfNAC(String goHashCode) {
        return null;
    }

    @Override
    protected EdGraphObject findRestoredObjectOfNAC(EdGraphObject go) {
        return null;
    }

    @Override
    public Object getApplCondByImageGraph(Graph g) {
        return null;
    }

    @Override
    public EdNAC getNAC(int index) {
        return null;
    }

    @Override
    public EdNAC getNAC(OrdinaryMorphism morphism) {
        return null;
    }

    @Override
    public EdNAC getNAC(String nacname) {
        return null;
    }

    @Override
    public Vector<EdNAC> getNACs() {
        return null;
    }

    @Override
    public boolean hasNACs() {
        return false;
    }

    @Override
    public boolean removeNAC(EdNAC nac) {
        return false;
    }

    @Override
    public void removeNACMapping(EdGraphObject leftObj) {
    }

    @Override
    public void updateNACs() {
    }

    @Override
    public boolean addPAC(EdPAC pac) {
        return false;
    }

    @Override
    public EdPAC createPAC(OrdinaryMorphism pac) {
        return null;
    }

    @Override
    public EdPAC createPAC(String nameStr, boolean isIdentic) {
        return null;
    }

    @Override
    public void destroyPAC(EdPAC epac) {
    }

    @Override
    protected EdGraphObject findGraphObjectOfPAC(String goHashCode) {
        return null;
    }

    @Override
    protected EdGraphObject findRestoredObjectOfPAC(EdGraphObject go) {
        return null;
    }

    @Override
    public EdPAC getPAC(int index) {
        return null;
    }

    @Override
    public EdPAC getPAC(OrdinaryMorphism morphism) {
        return null;
    }

    @Override
    public EdPAC getPAC(String pacname) {
        return null;
    }

    @Override
    public Vector<EdPAC> getPACs() {
        return null;
    }

    @Override
    public boolean hasPACs() {
        return false;
    }

    @Override
    public boolean removePAC(EdPAC pac) {
        return false;
    }

    @Override
    public void removePACMapping(EdGraphObject leftObj) {
    }

    @Override
    public void updatePACs() {
    }

    @Override
    public boolean addNestedAC(EdNestedApplCond ac) {
        return false;
    }

    @Override
    public EdNestedApplCond createNestedAC(OrdinaryMorphism ac) {
        return null;
    }

    @Override
    public EdNestedApplCond createNestedAC(String nameStr, boolean isIdentic) {
        return null;
    }

    @Override
    public void destroyNestedAC(EdNestedApplCond ac) {
    }

    @Override
    protected EdGraphObject findGraphObjectOfAC(String goHashCode) {
        return null;
    }

    @Override
    protected EdGraphObject findRestoredObjectOfAC(EdGraphObject go) {
        return null;
    }

    @Override
    public List<EdNestedApplCond> getEnabledACs() {
        return null;
    }

    @Override
    public List<EdNestedApplCond> getEnabledNestedACs() {
        return null;
    }

    @Override
    public EdPAC getNestedAC(int index) {
        return null;
    }

    @Override
    public EdPAC getNestedAC(OrdinaryMorphism morphism) {
        return null;
    }

    @Override
    public EdPAC getNestedAC(String acname) {
        return null;
    }

    @Override
    public Vector<EdPAC> getNestedACs() {
        return null;
    }

    @Override
    public boolean hasNestedACs() {
        return false;
    }

    @Override
    public boolean removeNestedAC(EdPAC ac) {
        return false;
    }

    @Override
    public void removeNestedACMapping(EdGraphObject leftObj) {
    }
}

