/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.xt_basis.Type;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

public class TypeReprData {
    String name;
    String shape;
    String imageFileName;
    String red;
    String green;
    String blue;
    boolean filled;
    Vector<Vector<String>> attributes;
    Vector<String> parents = new Vector(5, 5);
    Vector<String> children = new Vector(5, 5);
    int srcMinMultiplicity;
    int srcMaxMultiplicity;
    int tarMinMultiplicity;
    int tarMaxMultiplicity;
    int typeHC;
    boolean isAbstract;
    String contextUsage;
    String textualComment;

    public TypeReprData(EdType t) {
        int i;
        this.name = t.getName();
        this.shape = String.valueOf(t.getShape());
        this.filled = t.hasFilledShape();
        this.imageFileName = t.getImageFileName();
        this.red = Integer.valueOf(t.getColor().getRed()).toString();
        this.green = Integer.valueOf(t.getColor().getGreen()).toString();
        this.blue = Integer.valueOf(t.getColor().getBlue()).toString();
        this.attributes = new Vector();
        DeclTuple dt = (DeclTuple)t.getBasisType().getAttrType();
        if (dt != null) {
            i = 0;
            while (i < dt.getNumberOfEntries()) {
                DeclMember dm = (DeclMember)dt.getMemberAt(i);
                if (dm.getHoldingTuple() == dt) {
                    Vector<String> v = new Vector<String>(3);
                    v.add(dm.getName());
                    v.add(dm.getTypeName());
                    v.add(String.valueOf(dm.hashCode()));
                    this.attributes.add(v);
                }
                ++i;
            }
        }
        i = 0;
        while (i < t.getBasisType().getParents().size()) {
            this.parents.add(t.getBasisType().getParents().get(i).getName());
            ++i;
        }
        i = 0;
        while (i < t.getBasisType().getChildren().size()) {
            this.children.add(t.getBasisType().getChildren().get(i).getName());
            ++i;
        }
        this.typeHC = t.hashCode();
        this.contextUsage = ":" + String.valueOf(t.hashCode()) + ":" + t.getContextUsage() + ":";
        this.contextUsage = this.contextUsage.replaceAll("::", ":");
        this.isAbstract = t.getBasisType().isAbstract();
        this.textualComment = t.getBasisType().getTextualComment();
    }

    public TypeReprData(EdNode typeNode) {
        this(typeNode.getType());
        this.srcMinMultiplicity = typeNode.getType().getBasisType().getSourceMin();
        this.srcMaxMultiplicity = typeNode.getType().getBasisType().getSourceMax();
        this.tarMinMultiplicity = this.srcMinMultiplicity;
        this.tarMaxMultiplicity = this.srcMaxMultiplicity;
    }

    public TypeReprData(EdArc edgetype) {
        this(edgetype.getType());
        Type t = edgetype.getBasisArc().getType();
        Type srct = edgetype.getBasisArc().getSource().getType();
        Type tart = edgetype.getBasisArc().getTarget().getType();
        this.srcMinMultiplicity = t.getSourceMin(srct, tart);
        this.srcMaxMultiplicity = t.getSourceMax(srct, tart);
        this.tarMinMultiplicity = t.getTargetMin(srct, tart);
        this.tarMaxMultiplicity = t.getTargetMax(srct, tart);
    }

    public void restoreTypeFromTypeRepr(EdType t) {
        t.setName(this.name);
        t.setColor(this.getColor());
        t.setShape(Integer.valueOf(this.shape));
        t.setFilledShape(this.filled);
        t.setImageFileName(this.imageFileName);
        Type btype = t.getBasisType();
        this.restoreAttributes(btype);
        t.setContextUsage(this.contextUsage);
        t.getBasisType().setAbstract(this.isAbstract);
        t.getBasisType().setTextualComment(this.textualComment);
    }

    public EdType createTypeFromTypeRepr() {
        EdType t = new EdType(this.name, (int)Integer.valueOf(this.shape), this.getColor(), this.filled, this.imageFileName);
        t.setContextUsage(this.contextUsage);
        return t;
    }

    public EdType createTypeFromTypeRepr(Type basis) {
        EdType t = new EdType(this.name, Integer.valueOf(this.shape), this.getColor(), this.filled, this.imageFileName, basis);
        this.restoreAttributes(basis);
        t.setContextUsage(this.contextUsage);
        t.getBasisType().setAbstract(this.isAbstract);
        t.getBasisType().setTextualComment(this.textualComment);
        return t;
    }

    public String getName() {
        return this.name;
    }

    public int getShape() {
        return Integer.valueOf(this.shape);
    }

    public Color getColor() {
        Color color = new Color(Integer.valueOf(this.red), Integer.valueOf(this.green), Integer.valueOf(this.blue));
        return color;
    }

    public boolean hasFilledShape() {
        return this.filled;
    }

    public String getTypeContextUsage() {
        return this.contextUsage;
    }

    public int getTypeHashCode() {
        return this.typeHC;
    }

    public void restoreAttributes(Type btype) {
        block22: {
            DeclTuple dt;
            Vector<Vector<String>> attrs;
            block23: {
                if (btype == null) break block22;
                attrs = new Vector<Vector<String>>();
                attrs.addAll(this.attributes);
                if (!attrs.isEmpty()) break block23;
                if (btype.getAttrType() == null) break block22;
                DeclTuple dt2 = (DeclTuple)btype.getAttrType();
                int i = 0;
                while (i < dt2.getNumberOfEntries()) {
                    DeclMember dm = (DeclMember)dt2.getMemberAt(i);
                    if (dm.getHoldingTuple() == dt2) {
                        dt2.deleteMemberAt(dm.getName());
                    }
                    ++i;
                }
                break block22;
            }
            if (btype.getAttrType() == null) {
                btype.createAttributeType();
            }
            if ((dt = (DeclTuple)btype.getAttrType()).getNumberOfEntries() == 0) {
                int i = 0;
                while (i < attrs.size()) {
                    Vector v = (Vector)attrs.get(i);
                    String n = (String)v.get(0);
                    String tn = (String)v.get(1);
                    dt.addMember(DefaultInformationFacade.self().getJavaHandler(), tn, n);
                    ++i;
                }
            } else {
                Vector v;
                Hashtable<String, Vector> hc2dmvec = new Hashtable<String, Vector>();
                int j = 0;
                while (j < attrs.size()) {
                    v = (Vector)attrs.get(j);
                    String hashCode = (String)v.get(2);
                    hc2dmvec.put(hashCode, v);
                    ++j;
                }
                int i = 0;
                while (i < dt.getNumberOfEntries()) {
                    DeclMember dm = (DeclMember)dt.getMemberAt(i);
                    if (dm.getHoldingTuple() == dt) {
                        boolean found = false;
                        String hcStr = String.valueOf(dm.hashCode());
                        Vector v2 = (Vector)hc2dmvec.get(hcStr);
                        if (v2 != null) {
                            String n = (String)v2.get(0);
                            String tn = (String)v2.get(1);
                            if (!dm.getName().equals(n)) {
                                dm.setName(n);
                            }
                            if (!dm.getTypeName().equals(tn)) {
                                dm.setType(tn);
                            }
                            found = true;
                            attrs.remove(v2);
                        }
                        if (!found) {
                            int j2 = 0;
                            while (j2 < attrs.size()) {
                                v2 = (Vector)attrs.get(j2);
                                String n = (String)v2.get(0);
                                String tn = (String)v2.get(1);
                                if (n.equals(dm.getName())) {
                                    if (!dm.getTypeName().equals(tn)) {
                                        dm.setType(tn);
                                    }
                                    attrs.remove(v2);
                                    found = true;
                                    break;
                                }
                                ++j2;
                            }
                            if (!found) {
                                dt.deleteMemberAt(i);
                            }
                        }
                    }
                    ++i;
                }
                if (!attrs.isEmpty()) {
                    j = 0;
                    while (j < attrs.size()) {
                        v = (Vector)attrs.get(j);
                        String n = (String)v.get(0);
                        String tn = (String)v.get(1);
                        int pos = this.attributes.indexOf(v);
                        if (dt.getMemberAt(n) == null) {
                            if (pos < dt.getNumberOfEntries()) {
                                dt.addMember(pos, DefaultInformationFacade.self().getJavaHandler(), tn, n);
                            } else {
                                dt.addMember(DefaultInformationFacade.self().getJavaHandler(), tn, n);
                            }
                        }
                        ++j;
                    }
                }
            }
        }
    }
}

