/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.gui.editor.GraGraEditor;
import agg.gui.event.EditEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class GraGraEditorKeyAdapter
extends KeyAdapter {
    private GraGraEditor editor;

    public GraGraEditorKeyAdapter(GraGraEditor graGraEditor) {
        this.editor = graGraEditor;
        this.editor.addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.performShortKeyEvent(e, true)) {
            this.propagateShortKeyToTreeView(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performShortKeyEvent(KeyEvent e, boolean editorowner) {
        int keyCode = e.getKeyCode();
        if (this.editor.isTransformationRunning()) {
            if (e.isShiftDown() && e.isControlDown()) {
                String typedKey = KeyEvent.getKeyText(keyCode);
                if (!typedKey.equals("Q")) return true;
                this.editor.getStopButton().doClick();
                return true;
            } else {
                this.editor.refreshAfterWaitBeforeApplyRule();
                this.editor.setSleep(false);
            }
            return true;
        }
        if (e.isControlDown()) {
            String typedKey = KeyEvent.getKeyText(keyCode);
            if (e.isAltDown()) {
                if (typedKey.equals("N")) {
                    this.editor.selectNodeTypeProc();
                    return true;
                } else if (typedKey.equals("E")) {
                    this.editor.selectArcTypeProc();
                    return true;
                } else if (typedKey.equals("S")) {
                    this.editor.selectAllProc();
                    return true;
                } else {
                    if (!typedKey.equals("U")) return false;
                    this.editor.deselectAllProc();
                }
                return true;
            } else if (e.isShiftDown()) {
                if (typedKey.equals("M")) {
                    this.editor.getMatchButton().doClick();
                    return true;
                } else if (typedKey.equals("C")) {
                    this.editor.getMatchCompletionButton().doClick();
                    return true;
                } else if (typedKey.equals("S")) {
                    this.editor.getStepButton().doClick();
                    return true;
                } else if (typedKey.equals("T")) {
                    this.editor.getStartButton().doClick();
                    return true;
                } else if (typedKey.equals("U")) {
                    this.editor.getUndoStepButton().doClick();
                    return true;
                } else if (typedKey.equals("R")) {
                    this.editor.doIdenticRule();
                    return true;
                } else if (typedKey.equals("N")) {
                    this.editor.doIdenticNAC();
                    return true;
                } else if (typedKey.equals("P")) {
                    this.editor.doIdenticPAC();
                    return true;
                } else {
                    if (!typedKey.equals("A")) return false;
                    this.editor.doIdenticGAC();
                }
                return true;
            } else if (typedKey.equals("Z")) {
                this.editor.getUndoButton().doClick();
                return true;
            } else if (typedKey.equals("Y")) {
                this.editor.getRedoButton().doClick();
                return true;
            } else if (typedKey.equals("A")) {
                this.editor.attrsProc();
                return true;
            } else if (typedKey.equals("D")) {
                this.editor.deleteProc();
                return true;
            } else if (typedKey.equals("C")) {
                this.editor.copyProc();
                return true;
            } else if (typedKey.equals("V")) {
                this.editor.pasteProc();
                return true;
            } else if (typedKey.equals("E")) {
                this.editor.doStraightenArcsProc();
                return true;
            } else if (typedKey.equals("M")) {
                this.editor.forwardModeCommand("Map");
                this.editor.setEditMode(115);
                return true;
            } else {
                if (!typedKey.equals("U")) return false;
                this.editor.forwardModeCommand("Unmap");
                this.editor.setEditMode(116);
            }
            return true;
        } else if (e.isShiftDown()) {
            if (e.isAltDown()) {
                String typedKey = KeyEvent.getKeyText(keyCode);
                if (!typedKey.equals("P")) return false;
                this.editor.fireEditEvent(new EditEvent((Object)this, -10, "Parser Open"));
                return true;
            } else {
                String typedKey = KeyEvent.getKeyText(keyCode);
                if (typedKey.equals("D")) {
                    this.editor.forwardModeCommand("Draw");
                    this.editor.setEditMode(11);
                    return true;
                } else if (typedKey.equals("S")) {
                    this.editor.forwardModeCommand("Select");
                    this.editor.setEditMode(12);
                    return true;
                } else if (typedKey.equals("M")) {
                    this.editor.forwardModeCommand("Move");
                    this.editor.setEditMode(13);
                    return true;
                } else {
                    if (!typedKey.equals("A")) return false;
                    this.editor.forwardModeCommand("Attributes");
                    this.editor.setEditMode(114);
                }
            }
            return true;
        } else {
            if (e.isAltDown()) {
                return false;
            }
            String typedKey = String.valueOf(e.getKeyChar()).toUpperCase();
            if (typedKey.equals("F")) {
                this.editor.fireEditEvent(new EditEvent((Object)this, -10, "File"));
                return true;
            } else if (typedKey.equals("E")) {
                this.editor.getEditMenu().doClick();
                return true;
            } else if (typedKey.equals("M")) {
                this.editor.getModeMenu().doClick();
                return true;
            } else if (typedKey.equals("T")) {
                this.editor.getTransformMenu().doClick();
                return true;
            } else if (typedKey.equals("A")) {
                this.editor.fireEditEvent(new EditEvent((Object)this, -10, "Analyzer"));
                return true;
            } else if (typedKey.equals("P")) {
                this.editor.fireEditEvent(new EditEvent((Object)this, -10, "Preferences"));
                return true;
            } else if (typedKey.equals("H")) {
                this.editor.fireEditEvent(new EditEvent((Object)this, -10, "Help"));
                return true;
            } else {
                if (!KeyEvent.getKeyText(keyCode).equals("Delete") && !KeyEvent.getKeyText(keyCode).equals("Entf")) return false;
                if (this.editor.deleteProc() || !editorowner) return true;
                return false;
            }
        }
    }

    void propagateShortKeyToTreeView(KeyEvent e) {
        this.editor.fireEditEvent(new EditEvent((Object)this, -11, e));
    }
}

