/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.gui.AGGAppl;
import agg.gui.editor.GraGraEditor;
import agg.gui.editor.GraphEditor;
import agg.gui.editor.GraphPanel;
import agg.gui.editor.RuleEditor;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class EditSelPopupMenu
extends JPopupMenu {
    JFrame applFrame;
    JMenuItem mi;
    JMenuItem miDelete;
    JMenuItem miMap;
    JMenuItem miUnmap;
    JMenuItem miStraighten;
    JMenuItem miAddIdenticToRule;
    JMenuItem miAddIdenticToNAC;
    JMenuItem miAddIdenticToPAC;
    JMenuItem miAddIdenticToGAC;
    JMenuItem miSetParent;
    JMenuItem miUnsetParent;
    JMenu deleteMenu;
    JMenu addIdentic;
    boolean mapping = false;
    GraGraEditor editor;
    RuleEditor ruleEditor;
    GraphEditor graphEditor;
    GraphPanel gp;
    EdGraphObject ego;
    boolean useDeleteMenu = false;
    Vector<Type> selectedTypes;

    public EditSelPopupMenu() {
        super("Operations");
        this.setLabel("Operations");
        this.setBorderPainted(true);
        this.deleteMenu = this.createDeleteMenu();
        this.useDeleteMenu = false;
        this.mi = this.add(new JMenuItem("      Operations"));
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Attributes ..."));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9 || EditSelPopupMenu.this.gp.getGraph() == null || EditSelPopupMenu.this.ego == null) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.ruleEditor == null) {
                    EditSelPopupMenu.this.editor.setAttrEditorOnTopForGraphObject(EditSelPopupMenu.this.ego);
                } else {
                    EditSelPopupMenu.this.editor.setAttrEditorOnBottomForGraphObject(EditSelPopupMenu.this.ego);
                }
                EditSelPopupMenu.this.gp.updateGraphics();
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Copy Selected"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9 || EditSelPopupMenu.this.gp.getGraph() == null) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection()) {
                    AGGAppl.getInstance().getGraGraEditor().copyProc();
                    AGGAppl.getInstance().setCursor(new Cursor(1));
                }
            }
        });
        this.mi = this.add(new JMenuItem("Deselect"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp != null && EditSelPopupMenu.this.gp.getGraph() != null && EditSelPopupMenu.this.ego != null) {
                    EditSelPopupMenu.this.gp.deselect(EditSelPopupMenu.this.ego);
                }
            }
        });
        this.mi = this.add(new JMenuItem("Deselect All"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp != null && EditSelPopupMenu.this.gp.getGraph() != null) {
                    EditSelPopupMenu.this.gp.deselectAll();
                }
            }
        });
        this.addSeparator();
        this.miDelete = this.createDeleteItem();
        this.deleteMenu = this.createDeleteMenu();
        this.add(this.miDelete);
        if (this.useDeleteMenu) {
            this.add(this.deleteMenu);
        }
        this.addSeparator();
        this.miStraighten = this.mi = this.add(new JMenuItem("Straighten Selected"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9 || EditSelPopupMenu.this.gp.getGraph() == null) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                EditSelPopupMenu.this.gp.straightenSelectedArcs();
            }
        });
        this.addSeparator();
        this.addIdentic = new JMenu("Add Identic To");
        this.add(this.addIdentic);
        this.miAddIdenticToRule = this.mi = this.addIdentic.add(new JMenuItem("Rule RHS"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ruleEditor != null && EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getLeftPanel()) {
                    EditSelPopupMenu.this.ruleEditor.getRule().addIdenticToRule(EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs());
                    EditSelPopupMenu.this.ruleEditor.getRule().updateRule();
                    EditSelPopupMenu.this.ruleEditor.updateGraphics();
                }
            }
        });
        this.miAddIdenticToNAC = this.mi = this.addIdentic.add(new JMenuItem("NAC"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ruleEditor != null && EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditSelPopupMenu.this.ruleEditor.getNAC() == null) {
                        JOptionPane.showMessageDialog(null, "Cannot create an identic object!" + System.getProperty("line.separator") + "Please create and open an empty NAC graph first.", "Identic Node/Edge", 2);
                        return;
                    }
                    EditSelPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs(), EditSelPopupMenu.this.ruleEditor.getNAC());
                    EditSelPopupMenu.this.ruleEditor.getRule().updateNAC(EditSelPopupMenu.this.ruleEditor.getNAC());
                    EditSelPopupMenu.this.ruleEditor.updateGraphics();
                }
            }
        });
        this.miAddIdenticToPAC = this.mi = this.addIdentic.add(new JMenuItem("PAC"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ruleEditor != null && EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditSelPopupMenu.this.ruleEditor.getPAC() == null) {
                        JOptionPane.showMessageDialog(null, "Cannot create an identic object!" + System.getProperty("line.separator") + "Please create and open an empty PAC graph first.", "Identic Node/Edge", 2);
                        return;
                    }
                    EditSelPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs(), EditSelPopupMenu.this.ruleEditor.getPAC());
                    EditSelPopupMenu.this.ruleEditor.getRule().updatePAC(EditSelPopupMenu.this.ruleEditor.getPAC());
                    EditSelPopupMenu.this.ruleEditor.updateGraphics();
                }
            }
        });
        this.miAddIdenticToGAC = this.mi = this.addIdentic.add(new JMenuItem("General AC"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.ruleEditor != null && EditSelPopupMenu.this.gp == EditSelPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditSelPopupMenu.this.ruleEditor.getNestedAC() == null) {
                        JOptionPane.showMessageDialog(null, "Cannot create an identic object!" + System.getProperty("line.separator") + "Please create and open an empty General AC graph first.", "Identic Node/Edge", 2);
                        return;
                    }
                    EditSelPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(EditSelPopupMenu.this.ruleEditor.getRule().getLeft().getSelectedObjs(), (EdPAC)EditSelPopupMenu.this.ruleEditor.getNestedAC());
                    EditSelPopupMenu.this.ruleEditor.getRule().updateNestedAC(EditSelPopupMenu.this.ruleEditor.getNestedAC());
                    EditSelPopupMenu.this.ruleEditor.updateGraphics();
                }
            }
        });
        this.miMap = this.mi = this.add(new JMenuItem("Map Selected"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditSelPopupMenu.this.mapping = true;
                EditSelPopupMenu.this.setLastEditModeBeforMapping(EditSelPopupMenu.this.gp);
                if (EditSelPopupMenu.this.editor != null) {
                    EditSelPopupMenu.this.editor.getGraphEditor().setEditMode(117);
                    EditSelPopupMenu.this.editor.getRuleEditor().setEditMode(117);
                    EditSelPopupMenu.this.editor.getRuleEditor().setObjMapping(true);
                    EditSelPopupMenu.this.editor.setMsg("Click on a target object you want to map or click on the background you want to break the mapping.");
                } else if (EditSelPopupMenu.this.ruleEditor != null) {
                    EditSelPopupMenu.this.ruleEditor.setEditMode(117);
                    EditSelPopupMenu.this.ruleEditor.setObjMapping(true);
                    EditSelPopupMenu.this.ruleEditor.setMsg("Click on on a target object you want to map or click on the background you want to break the mapping.");
                }
            }
        });
        this.miUnmap = this.mi = this.add(new JMenuItem("Unmap Selected"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                EditSelPopupMenu.this.unmapSelectedGraphObjects(false);
            }
        });
        this.addSeparator();
        this.miSetParent = this.mi = this.add(new JMenuItem("Set Parent"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditSelPopupMenu.this.editor != null) {
                    EditSelPopupMenu.this.editor.getGraphEditor().setEditMode(1201);
                    EditSelPopupMenu.this.editor.setMsg("Click on a node to add inheritance relation.");
                }
            }
        });
        this.miUnsetParent = this.mi = this.add(new JMenuItem("Unset Parent"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node bNode;
                Graph bGraph;
                if (EditSelPopupMenu.this.gp == null || EditSelPopupMenu.this.gp.getEditMode() == 9 || !EditSelPopupMenu.this.gp.getGraph().isEditable()) {
                    return;
                }
                if (EditSelPopupMenu.this.ego instanceof EdNode && (bGraph = (bNode = EditSelPopupMenu.this.ego.getNode().getBasisNode()).getContext()).isTypeGraph() && EditSelPopupMenu.this.editor != null) {
                    if (EditSelPopupMenu.this.graphEditor.getGraph().getBasisGraph().getTypeSet().getLevelOfTypeGraphCheck() != 0 && EditSelPopupMenu.this.graphEditor.getGraph().getTypeSet().isTypeUsed(EditSelPopupMenu.this.ego.getType())) {
                        JOptionPane.showMessageDialog(EditSelPopupMenu.this.applFrame, "Cannot unset inheritance relation.\nPlease disable the type graph first.", "Unset Parent", 0);
                        return;
                    }
                    if (bNode.getType().getParents().size() == 1) {
                        EditSelPopupMenu.this.graphEditor.getGraph().addChangedParentToUndo(EditSelPopupMenu.this.ego);
                        EditSelPopupMenu.this.gp.getCanvas().updateUndoButton();
                        EditSelPopupMenu.this.gp.getCanvas().performDeleteInheritanceRel((EdNode)EditSelPopupMenu.this.ego);
                        EditSelPopupMenu.this.graphEditor.getGraph().undoManagerEndEdit();
                        EditSelPopupMenu.this.graphEditor.getGraph().updateGraph();
                        EditSelPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                    } else {
                        EditSelPopupMenu.this.editor.getGraphEditor().setEditMode(1202);
                        EditSelPopupMenu.this.editor.setMsg("Click on a parent node to remove inheritance relation.");
                    }
                }
            }
        });
        this.pack();
        this.setBorderPainted(true);
    }

    public void showMe(Component comp, int x, int y) {
        if (this.editor != null) {
            if (this.editor.getRuleEditor().getRule() == null) {
                this.setUnmapEnabled(false);
            }
            if (this.gp.getGraph() != null && this.gp.getGraph().isTypeGraph()) {
                this.setUnmapEnabled(false);
            }
        }
        if (this.useDeleteMenu) {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx == -1 && (indx = this.getComponentIndex(this.miDelete)) != -1) {
                this.add((Component)this.deleteMenu, indx + 1);
            }
        } else {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx != -1) {
                this.remove(indx);
            }
        }
        this.show(comp, x, y);
    }

    boolean canDo() {
        return this.gp != null && this.gp.getEditMode() != 9 && this.gp.getGraph() != null;
    }

    void doUpdateAfterDelete() {
        if (this.gp.isMappedObjDeleted()) {
            this.gp.setMappedObjDeleted(false);
            if (this.editor != null) {
                this.editor.getRuleEditor().getRule().update();
                this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                this.editor.getRuleEditor().getRightPanel().updateGraphics();
                this.editor.getRuleEditor().getNACPanel().updateGraphics();
                this.editor.getGraphEditor().getGraph().update();
                this.editor.getGraphEditor().getGraphPanel().updateGraphics();
            } else if (this.ruleEditor != null) {
                this.ruleEditor.getRule().update();
                this.ruleEditor.getLeftPanel().updateGraphics();
                this.ruleEditor.getRightPanel().updateGraphics();
                this.ruleEditor.getNACPanel().updateGraphics();
                if (this.graphEditor != null) {
                    this.graphEditor.getGraph().update();
                    this.graphEditor.getGraphPanel().updateGraphics();
                }
            } else if (this.graphEditor != null) {
                this.graphEditor.getGraph().update();
                this.graphEditor.getGraphPanel().updateGraphics();
            }
        } else {
            this.gp.getGraph().update();
            this.gp.updateGraphicsAfterDelete();
        }
    }

    void showMessageDialog(List<String> failed, String typename, boolean nodetype) {
        String nt = nodetype ? "node" : "arc";
        String str = "Cannot delete objects of the " + nt + " type  \"" + typename + "\"  from \n";
        int i = 0;
        while (i < failed.size()) {
            String s = "\t" + failed.get(i) + "\n";
            str = String.valueOf(str) + s;
            ++i;
        }
        if (!failed.isEmpty()) {
            JOptionPane.showMessageDialog(this.applFrame, str);
        }
    }

    private JMenuItem createDeleteItem() {
        JMenuItem m = this.add(new JMenuItem("Delete Selected"));
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer;
                if (!EditSelPopupMenu.this.canDo()) {
                    return;
                }
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection() && (answer = EditSelPopupMenu.this.removeWarning()) == 0) {
                    int i = 0;
                    while (i < EditSelPopupMenu.this.gp.getGraph().getSelectedObjs().size()) {
                        EdGraphObject go = EditSelPopupMenu.this.gp.getGraph().getSelectedObjs().elementAt(i);
                        if (!go.getMorphismMark().equals("")) {
                            EditSelPopupMenu.this.gp.setMappedObjDeleted(true);
                        }
                        ++i;
                    }
                    EditSelPopupMenu.this.unmapSelectedGraphObjects(true);
                    EditSelPopupMenu.this.gp.deleteSelected();
                    EditSelPopupMenu.this.doUpdateAfterDelete();
                    EditSelPopupMenu.this.ego = null;
                }
            }
        });
        return m;
    }

    Vector<EdType> getSelectedTypes(Vector<EdGraphObject> selectedGraphObjects) {
        Vector<EdType> v = new Vector<EdType>(5);
        int i = 0;
        while (i < selectedGraphObjects.size()) {
            EdGraphObject go = selectedGraphObjects.get(i);
            EdType t = go.getType();
            if (!v.contains(t)) {
                v.add(t);
            }
            ++i;
        }
        return v;
    }

    private JMenu createDeleteMenu() {
        JMenu m = new JMenu("Delete Objects of Selected Types");
        JMenuItem jmi = m.add(new JMenuItem("Delete All Objects"));
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditSelPopupMenu.this.canDo()) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection()) {
                    Vector<EdGraphObject> selTypes = EditSelPopupMenu.this.gp.getGraph().getSelectedObjs();
                    int i = 0;
                    while (i < selTypes.size()) {
                        EdGraphObject tgo = (EdGraphObject)selTypes.get(i);
                        boolean ok = false;
                        boolean addToUndo = true;
                        if (!ok) {
                            List<String> failed = EditSelPopupMenu.this.gp.getGraph().getGraGra().deleteGraphObjectsOfType(tgo, false, addToUndo);
                            EditSelPopupMenu.this.showMessageDialog(failed, tgo.getType().getName(), tgo.isNode());
                        }
                        ++i;
                    }
                }
                EditSelPopupMenu.this.doUpdateAfterDelete();
                EditSelPopupMenu.this.gp.getCanvas().updateUndoButton();
                EditSelPopupMenu.this.gp.getGraph().getGraGra().update();
                if (EditSelPopupMenu.this.editor != null) {
                    EditSelPopupMenu.this.editor.getRuleEditor().updateGraphics();
                }
            }
        });
        jmi = m.add(new JMenuItem("Delete Objects of Host Graph"));
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditSelPopupMenu.this.canDo()) {
                    return;
                }
                EditSelPopupMenu.this.mapping = false;
                if (EditSelPopupMenu.this.gp.getGraph().hasSelection()) {
                    Vector<EdGraphObject> selTypes = EditSelPopupMenu.this.gp.getGraph().getSelectedObjs();
                    Vector<String> failed = new Vector<String>();
                    int i = 0;
                    while (i < selTypes.size()) {
                        EdGraphObject tgo = (EdGraphObject)selTypes.get(i);
                        if (!EditSelPopupMenu.this.gp.getGraph().getGraGra().deleteGraphObjectsOfTypeFromHostGraph(tgo, true)) {
                            failed.add(EditSelPopupMenu.this.gp.getGraph().getGraGra().getGraph().getName());
                        }
                        EditSelPopupMenu.this.showMessageDialog(failed, tgo.getType().getName(), tgo.isNode());
                        failed.clear();
                        ++i;
                    }
                }
                EditSelPopupMenu.this.doUpdateAfterDelete();
                EditSelPopupMenu.this.gp.getCanvas().updateUndoButton();
                EditSelPopupMenu.this.gp.getGraph().getGraGra().getGraph().update();
            }
        });
        return m;
    }

    public void setEditor(GraGraEditor ed) {
        this.editor = ed;
        this.ruleEditor = this.editor.getRuleEditor();
        this.graphEditor = this.editor.getGraphEditor();
    }

    public void setEditor(RuleEditor re) {
        this.ruleEditor = re;
        this.graphEditor = null;
    }

    public void setEditor(GraphEditor ge) {
        this.graphEditor = ge;
        this.ruleEditor = null;
    }

    public EdGraphObject getPickedObj() {
        return this.ego;
    }

    public boolean isMapping() {
        return this.mapping;
    }

    public void setParentFrame(JFrame pf) {
        this.applFrame = pf;
    }

    public void setMapEnabled(boolean b) {
        this.miMap.setEnabled(b);
    }

    public void setUnmapEnabled(boolean b) {
        this.miUnmap.setEnabled(b);
    }

    public boolean invoked(GraphPanel p, int x, int y) {
        this.gp = p;
        if (this.gp.getGraph() != null && !this.gp.getCanvas().isLeftPressed()) {
            this.ego = this.gp.getGraph().getPicked(x, y);
            if (this.ego == null) {
                this.ego = this.gp.getGraph().getPickedTextOfArc(x, y, this.gp.getCanvas().getGraphics().getFontMetrics());
            }
            if (this.ego != null && this.ego.isVisible() && this.ego.isSelected()) {
                if (this.ruleEditor != null) {
                    if (this.ruleEditor.getRule().getLeft() == this.gp.getGraph()) {
                        this.miAddIdenticToRule.setEnabled(true);
                    } else {
                        this.miAddIdenticToRule.setEnabled(false);
                    }
                    if (this.ruleEditor.getNAC() != null) {
                        this.miAddIdenticToNAC.setEnabled(true);
                        this.miAddIdenticToPAC.setEnabled(false);
                        this.miAddIdenticToGAC.setEnabled(false);
                    } else if (this.ruleEditor.getPAC() != null) {
                        this.miAddIdenticToNAC.setEnabled(false);
                        this.miAddIdenticToPAC.setEnabled(true);
                        this.miAddIdenticToGAC.setEnabled(false);
                    } else if (this.ruleEditor.getNestedAC() != null) {
                        this.miAddIdenticToNAC.setEnabled(false);
                        this.miAddIdenticToPAC.setEnabled(false);
                        this.miAddIdenticToGAC.setEnabled(true);
                    } else {
                        this.miAddIdenticToNAC.setEnabled(false);
                        this.miAddIdenticToPAC.setEnabled(false);
                        this.miAddIdenticToGAC.setEnabled(false);
                    }
                }
                if (this.ego.isNode()) {
                    this.miStraighten.setEnabled(false);
                    if (this.ego.isElementOfTypeGraph()) {
                        this.useDeleteMenu = true;
                        this.addIdentic.setEnabled(false);
                        this.miSetParent.setEnabled(true);
                        if (!this.ego.getNode().getBasisNode().getType().getParents().isEmpty()) {
                            this.miUnsetParent.setEnabled(true);
                        } else {
                            this.miUnsetParent.setEnabled(false);
                        }
                    } else {
                        this.useDeleteMenu = false;
                        this.addIdentic.setEnabled(false);
                        this.miSetParent.setEnabled(false);
                        this.miUnsetParent.setEnabled(false);
                    }
                    if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                        this.addIdentic.setEnabled(true);
                    }
                } else {
                    this.miStraighten.setEnabled(true);
                    this.miSetParent.setEnabled(false);
                    this.miUnsetParent.setEnabled(false);
                    if (this.ego.isElementOfTypeGraph()) {
                        this.useDeleteMenu = true;
                        this.addIdentic.setEnabled(false);
                    } else {
                        this.useDeleteMenu = false;
                        this.addIdentic.setEnabled(false);
                    }
                    if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                        this.addIdentic.setEnabled(true);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    void setLastEditModeBeforMapping(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 115 || gp.getEditMode() == 116 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 801 || gp.getEditMode() == 8010 || gp.getEditMode() == 42) {
            gp.setLastEditMode(gp.getEditMode());
            gp.setLastEditCursor(gp.getEditCursor());
        }
    }

    protected void unmapSelectedGraphObjects(boolean wantDeleteGraphObject) {
        if (this.editor != null && this.editor.getRuleEditor().getRule() != null) {
            EdRule rule = this.editor.getRuleEditor().getRule();
            boolean unmapdone = false;
            if (this.editor.getActivePanel() == this.editor.getRuleEditor().getLeftPanel()) {
                EdGraphObject lgo = null;
                int i = 0;
                while (i < rule.getLeft().getSelectedObjs().size()) {
                    lgo = rule.getLeft().getSelectedObjs().get(i);
                    if (wantDeleteGraphObject) {
                        if (this.editor.getRuleEditor().removeNacMapping(lgo) || this.editor.getRuleEditor().removePacMapping(lgo) || this.editor.getRuleEditor().removeNestedACMapping(lgo)) {
                            unmapdone = true;
                        }
                    } else if (this.editor.getRuleEditor().removeNacMapping(lgo, true) || this.editor.getRuleEditor().removePacMapping(lgo, true) || this.editor.getRuleEditor().removeNestedACMapping(lgo, true)) {
                        unmapdone = true;
                    }
                    if (rule.getMatch() != null) {
                        if (this.editor.getRuleEditor().removeMatchMapping(lgo, true)) {
                            unmapdone = true;
                        }
                        if (wantDeleteGraphObject) {
                            rule.getMatch().getCompletionStrategy().removeFromObjectVarMap(lgo.getBasisObject());
                        }
                    }
                    if (this.editor.getRuleEditor().removeRuleMapping(lgo, true)) {
                        unmapdone = true;
                    }
                    ++i;
                }
                if (unmapdone) {
                    rule.update();
                    this.editor.updateGraphics();
                }
            } else if (this.editor.getActivePanel() == this.editor.getRuleEditor().getRightPanel()) {
                int i = 0;
                while (i < rule.getRight().getSelectedObjs().size()) {
                    EdGraphObject rgo = rule.getRight().getSelectedObjs().get(i);
                    if (this.editor.getRuleEditor().removeRuleMapping(rgo, false)) {
                        unmapdone = true;
                    }
                    ++i;
                }
                if (unmapdone) {
                    this.editor.getRuleEditor().updateGraphics();
                }
            } else if (this.editor.getActivePanel() == this.editor.getRuleEditor().getLeftCondPanel()) {
                Vector<EdGraphObject> l = null;
                if (this.editor.getRuleEditor().getNAC() != null) {
                    l = this.editor.getRuleEditor().getNAC().getSelectedObjs();
                    EdGraphObject go = null;
                    int i = 0;
                    while (i < l.size()) {
                        go = (EdGraphObject)l.get(i);
                        if (this.editor.getRuleEditor().removeNacMapping(go, false)) {
                            unmapdone = true;
                        }
                        ++i;
                    }
                } else if (this.editor.getRuleEditor().getPAC() != null) {
                    l = this.editor.getRuleEditor().getPAC().getSelectedObjs();
                    EdGraphObject go = null;
                    int i = 0;
                    while (i < l.size()) {
                        go = (EdGraphObject)l.get(i);
                        if (this.editor.getRuleEditor().removePacMapping(go, false)) {
                            unmapdone = true;
                        }
                        ++i;
                    }
                } else if (this.editor.getRuleEditor().getNestedAC() != null) {
                    l = this.editor.getRuleEditor().getNestedAC().getSelectedObjs();
                    EdGraphObject go = null;
                    int i = 0;
                    while (i < l.size()) {
                        go = (EdGraphObject)l.get(i);
                        if (this.editor.getRuleEditor().removeNestedACMapping(go, false)) {
                            unmapdone = true;
                        }
                        ++i;
                    }
                    this.editor.getRuleEditor().updateNestedAC(this.editor.getRuleEditor().getNestedAC());
                }
                if (unmapdone) {
                    this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                    this.editor.getRuleEditor().getLeftCondPanel().updateGraphics();
                }
            } else if (this.editor.getActivePanel() == this.editor.getGraphEditor().getGraphPanel() && rule.getMatch() != null) {
                EdGraphObject ggo = null;
                int i = 0;
                while (i < this.editor.getGraphEditor().getGraph().getSelectedObjs().size()) {
                    ggo = this.editor.getGraphEditor().getGraph().getSelectedObjs().get(i);
                    if (this.editor.getRuleEditor().removeMatchMapping(ggo, false)) {
                        unmapdone = true;
                    }
                    ++i;
                }
                if (unmapdone) {
                    this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                    this.editor.getGraphEditor().getGraphPanel().updateGraphics();
                }
            }
        } else if (this.ruleEditor != null && this.ruleEditor.getRule() != null) {
            if (this.gp == this.ruleEditor.getLeftPanel() && this.ruleEditor.getRule().getLeft() == this.gp.getGraph()) {
                EdGraphObject lObj = null;
                int i = 0;
                while (i < this.ruleEditor.getRule().getLeft().getSelectedObjs().size()) {
                    lObj = this.ruleEditor.getRule().getLeft().getSelectedObjs().get(i);
                    this.ruleEditor.getRule().removeRuleMapping(lObj);
                    if (this.ruleEditor.getNAC() != null) {
                        this.ruleEditor.getRule().removeNACMapping(lObj, this.ruleEditor.getNAC().getMorphism());
                    }
                    if (this.ruleEditor.getPAC() != null) {
                        this.ruleEditor.getRule().removePACMapping(lObj, this.ruleEditor.getPAC().getMorphism());
                    }
                    this.ruleEditor.getRule().removeMatchMapping(lObj);
                    ++i;
                }
                this.ruleEditor.getRule().update();
                this.ruleEditor.updateGraphics();
                if (this.graphEditor != null) {
                    this.graphEditor.getGraphPanel().updateGraphics();
                }
            } else if (this.gp == this.ruleEditor.getRightPanel()) {
                int i = 0;
                while (i < this.ruleEditor.getRule().getRight().getSelectedObjs().size()) {
                    EdGraphObject imageObj = this.ruleEditor.getRule().getRight().getSelectedObjs().elementAt(i);
                    this.ruleEditor.getRule().removeMapping(imageObj, this.ruleEditor.getRule().getBasisRule());
                    ++i;
                }
                this.ruleEditor.updateGraphics();
            } else if (this.gp == this.ruleEditor.getLeftCondPanel()) {
                EdGraphObject imageObj;
                int i;
                if (this.ruleEditor.getNAC() != null) {
                    i = 0;
                    while (i < this.ruleEditor.getNAC().getSelectedObjs().size()) {
                        imageObj = this.ruleEditor.getNAC().getSelectedObjs().elementAt(i);
                        this.ruleEditor.getRule().removeMapping(imageObj, this.ruleEditor.getNAC().getMorphism());
                        ++i;
                    }
                }
                if (this.ruleEditor.getPAC() != null) {
                    i = 0;
                    while (i < this.ruleEditor.getPAC().getSelectedObjs().size()) {
                        imageObj = this.ruleEditor.getPAC().getSelectedObjs().elementAt(i);
                        this.ruleEditor.getRule().removeMapping(imageObj, this.ruleEditor.getPAC().getMorphism());
                        ++i;
                    }
                }
                this.ruleEditor.getLeftPanel().updateGraphics();
                this.ruleEditor.getNACPanel().updateGraphics();
            }
        } else if (this.graphEditor != null && this.gp == this.graphEditor.getGraphPanel()) {
            int i = 0;
            while (i < this.graphEditor.getGraph().getSelectedObjs().size()) {
                EdGraphObject imageObj = this.graphEditor.getGraph().getSelectedObjs().elementAt(i);
                if (this.ruleEditor != null) {
                    this.ruleEditor.getRule().removeMapping(imageObj, this.ruleEditor.getRule().getMatch());
                }
                ++i;
            }
            if (this.ruleEditor != null) {
                this.ruleEditor.getLeftPanel().updateGraphics();
            }
            this.graphEditor.getGraphPanel().updateGraphics();
        }
    }

    int removeWarning() {
        String msgStr = "Do you really want to delete all \nselected objects of this graph?";
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(null, msgStr, "Warning", -1, 2, null, options, options[1]);
        return answer;
    }
}

