/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdRule;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import agg.util.Pair;
import agg.xt_basis.NestedApplCond;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;

public class ApplFormulaTreeNodeData
extends GraGraTreeNodeDataAdapter {
    JLabel treeCell;
    private Object data;
    private Formula f;
    private List<String> names;
    private List<Evaluable> acs;
    private boolean enabled = true;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public ApplFormulaTreeNodeData(String formula, boolean enabled, EdRule rule) {
        this.setRuleData(formula, enabled, rule);
        this.setFormula(formula);
    }

    public ApplFormulaTreeNodeData(String formula, boolean enabled, EdNestedApplCond nestedAC) {
        this.setApplCondData(formula, enabled, nestedAC);
        this.setFormula(formula);
    }

    private void setRuleData(String formula, boolean enabled, EdRule rule) {
        this.data = new Pair<String, EdRule>(formula, rule);
        this.f = rule.getBasisRule().getFormula();
        this.names = rule.getBasisRule().getNameOfEnabledACs();
        this.acs = new Vector<NestedApplCond>(rule.getBasisRule().getEnabledACs());
        this.enabled = enabled;
    }

    private void setApplCondData(String formula, boolean enabled, EdNestedApplCond nestedAC) {
        this.data = new Pair<String, EdNestedApplCond>(formula, nestedAC);
        this.f = nestedAC.getNestedMorphism().getFormula();
        this.names = nestedAC.getNestedMorphism().getNameOfEnabledACs();
        this.acs = new Vector<NestedApplCond>(nestedAC.getNestedMorphism().getEnabledACs());
        this.enabled = enabled;
    }

    private void setFormula(String formula) {
        this.string = !this.enabled ? "[D]" + formula : formula;
        this.replace();
    }

    public ApplFormulaTreeNodeData(String s) {
        this.data = s;
        this.setFormula(s);
    }

    public ApplFormulaTreeNodeData(Object obj) {
        this.data = obj;
        if (obj instanceof String) {
            this.setFormula((String)obj);
        }
    }

    @Override
    public void dispose() {
        this.data = null;
        this.string = null;
        this.treeNode = null;
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
            this.replace();
        } else {
            this.data = null;
            this.string = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
    }

    @Override
    public void setString(String tag, String newString) {
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public void update() {
        if (this.data instanceof Pair) {
            String fstr = (String)((Pair)this.data).first;
            if (((Pair)this.data).second instanceof EdRule) {
                EdRule r = (EdRule)((Pair)this.data).second;
                this.names = r.getBasisRule().getNameOfEnabledACs();
                this.acs = new Vector<NestedApplCond>(r.getBasisRule().getEnabledACs());
                if (((EdRule)((Pair)this.data).second).getBasisRule().refreshFormula(this.acs)) {
                    fstr = ((EdRule)((Pair)this.data).second).getBasisRule().getFormulaStr();
                    this.data = new Pair<String, EdRule>(fstr, r);
                    this.enabled = r.getBasisRule().isEnabled();
                }
            } else if (((Pair)this.data).second instanceof EdNestedApplCond) {
                EdNestedApplCond ac = (EdNestedApplCond)((Pair)this.data).second;
                this.names = ac.getNestedMorphism().getNameOfEnabledACs();
                this.acs = new Vector<NestedApplCond>(ac.getNestedMorphism().getEnabledACs());
                if (((NestedApplCond)((EdNestedApplCond)((Pair)this.data).second).getMorphism()).refreshFormula(this.acs)) {
                    fstr = ((NestedApplCond)((EdNestedApplCond)((Pair)this.data).second).getMorphism()).getFormulaText();
                    this.data = new Pair<String, EdNestedApplCond>(fstr, ac);
                    this.enabled = ac.getNestedMorphism().isEnabled();
                }
            }
        }
        this.string = !this.enabled ? "[D]" + (String)((Pair)this.data).first : (String)((Pair)this.data).first;
        this.replace();
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    public EdRule getRule() {
        if (((Pair)this.data).second instanceof EdRule) {
            return (EdRule)((Pair)this.data).second;
        }
        return null;
    }

    @Override
    public EdNestedApplCond getNestedAC() {
        if (((Pair)this.data).second instanceof EdNestedApplCond) {
            return (EdNestedApplCond)((Pair)this.data).second;
        }
        return null;
    }

    @Override
    public Formula getFormula() {
        return this.f;
    }

    @Override
    public boolean isApplFormula() {
        return true;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    private void replace() {
        if (this.string != null) {
            String outStr;
            this.string = outStr = this.f.getAsString(this.acs, this.names);
        }
    }

    @Override
    public String getToolTipText() {
        return " Formula above General Application Conditions ";
    }

    @Override
    public boolean isTreeTextEditable() {
        return false;
    }
}

