/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.editor.impl.EdPAC;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import javax.swing.tree.DefaultMutableTreeNode;

public class PACTreeNodeData
extends GraGraTreeNodeDataAdapter {
    private Object data;
    private EdPAC ePAC;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public PACTreeNodeData(EdPAC pac) {
        this.setPAC(pac);
    }

    private void setPAC(EdPAC pac) {
        this.data = pac;
        this.string = !pac.getMorphism().isEnabled() ? "[D]" + pac.getName() : pac.getName();
        this.ePAC = pac;
    }

    public PACTreeNodeData(String s) {
        this.data = s;
        this.string = s;
    }

    public PACTreeNodeData(Object obj) {
        if (obj instanceof EdPAC) {
            this.setPAC((EdPAC)obj);
        } else if (obj instanceof String) {
            new PACTreeNodeData((String)obj);
        }
    }

    @Override
    public void dispose() {
        this.data = null;
        this.ePAC = null;
        this.string = null;
        this.treeNode = null;
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof EdPAC) {
            this.setPAC((EdPAC)obj);
        } else if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
            this.ePAC = null;
        } else {
            this.data = null;
            this.ePAC = null;
            this.string = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        this.string = newString = str.replaceAll(" ", "");
        String newPacName = "";
        String sD = "";
        if (!this.ePAC.getMorphism().isEnabled()) {
            sD = "[D]";
        }
        if (newString.indexOf("[D]") != -1) {
            newString = newString.substring(3, newString.length());
        }
        newPacName = newString;
        if (!this.ePAC.getName().equals(newPacName)) {
            this.ePAC.setName(newPacName);
            this.ePAC.getGraGra().setChanged(true);
        }
        this.string = String.valueOf(sD) + this.ePAC.getBasisGraph().getName();
    }

    @Override
    public void setString(String tag, String newString) {
        if (tag.equals("[]")) {
            tag = "";
        }
        this.string = String.valueOf(tag) + newString;
        if (!this.ePAC.getName().equals(newString)) {
            this.ePAC.setName(newString);
            this.ePAC.getGraGra().setChanged(true);
        }
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string();
    }

    @Override
    public EdPAC getPAC() {
        return this.ePAC;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public boolean isPAC() {
        return true;
    }

    @Override
    public String getToolTipText() {
        String toolTipText = " Positive application condition ";
        if (!this.ePAC.getMorphism().getTextualComment().equals("")) {
            toolTipText = " " + this.ePAC.getMorphism().getTextualComment();
        }
        return toolTipText;
    }
}

