/*
 * Decompiled with CFR 0.152.
 */
package agg.util.colim;

import agg.util.colim.BidirectionalIterator;
import agg.util.colim.Container;
import agg.util.colim.ForwardIterator;
import agg.util.colim.InputIterator;
import agg.util.colim.IntArray;
import agg.util.colim.IntBuffer;
import java.util.NoSuchElementException;

public final class IntIterator
implements BidirectionalIterator {
    int[] buffer;
    Container original;
    int index;

    public static IntIterator begin(int[] array) {
        return new IntIterator(array, 0);
    }

    public static IntIterator end(int[] array) {
        return new IntIterator(array, array.length);
    }

    public IntIterator() {
        this(new IntArray(), 0);
    }

    public IntIterator(IntIterator iterator) {
        this.buffer = iterator.buffer;
        this.original = iterator.original;
        this.index = iterator.index;
    }

    public IntIterator(int[] vector, int index) {
        this(new IntArray(vector), index);
    }

    public IntIterator(IntArray vector, int index) {
        this.buffer = vector.array;
        this.original = vector;
        this.index = index;
    }

    public IntIterator(IntBuffer vector, int index) {
        this.buffer = vector.storage;
        this.original = vector;
        this.index = index;
    }

    @Override
    public Object clone() {
        return new IntIterator(this);
    }

    public boolean equals(Object object) {
        return object instanceof IntIterator && this.equals((IntIterator)object);
    }

    public boolean equals(IntIterator iterator) {
        return iterator.index == this.index && iterator.buffer == this.buffer;
    }

    @Override
    public boolean atBegin() {
        return this.index == 0;
    }

    @Override
    public boolean atEnd() {
        return this.index == this.original.size();
    }

    @Override
    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    @Override
    public void advance() {
        ++this.index;
    }

    @Override
    public void advance(int n) {
        this.index += n;
    }

    @Override
    public void retreat() {
        --this.index;
    }

    @Override
    public void retreat(int n) {
        this.index -= n;
    }

    public Object nextElement() {
        try {
            Object obj = this.get();
            this.advance();
            return obj;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new NoSuchElementException("IntIterator");
        }
    }

    @Override
    public Object get() {
        return this.get(0);
    }

    public int getInt() {
        return this.getInt(0);
    }

    @Override
    public Object get(int offset) {
        return new Integer(this.buffer[this.index + offset]);
    }

    public int getInt(int offset) {
        return this.buffer[this.index + offset];
    }

    @Override
    public void put(Object object) {
        this.put(0, object);
    }

    public void put(int object) {
        this.put(0, object);
    }

    @Override
    public void put(int offset, Object object) {
        this.put(offset, IntBuffer.asInt(object));
    }

    public void put(int offset, int object) {
        this.buffer[this.index + offset] = object;
    }

    @Override
    public int distance(ForwardIterator iterator) {
        if (!this.isCompatibleWith(iterator)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((IntIterator)iterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    @Override
    public Container getContainer() {
        return this.original;
    }

    @Override
    public boolean isCompatibleWith(InputIterator iterator) {
        return iterator instanceof IntIterator && this.buffer == ((IntIterator)iterator).buffer;
    }
}

