/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrObserver;
import agg.attribute.AttrType;
import agg.attribute.facade.InformationFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.cons.AtomConstraint;
import agg.cons.ConstraintLayer;
import agg.cons.ConstraintPriority;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.ruleappl.ObjectFlow;
import agg.ruleappl.RuleSequence;
import agg.util.Disposable;
import agg.util.ExtObservable;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Completion_NAC;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.RulePriority;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.agt.RuleScheme;
import agg.xt_basis.csp.CompletionPropertyBits;
import agg.xt_basis.csp.Completion_CSP_NoBJ;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;

public class GraGra
implements Disposable,
XMLObject {
    protected final Vector<Graph> itsGraphs = new Vector();
    protected final Vector<Rule> itsRules = new Vector();
    Hashtable<Integer, List<Rule>> ruleSets;
    protected final Vector<AtomConstraint> itsAtomics = new Vector(5);
    protected final Vector<Formula> itsConstraints = new Vector(5);
    protected final Vector<String> gratraOptions = new Vector();
    protected final Vector<Match> itsMatches = new Vector();
    protected RuleSequence itsRuleSequence;
    protected final List<RuleSequence> itsRuleSequences = new Vector<RuleSequence>(1);
    protected final Vector<Pair<String, List<String>>> itsPackages = new Vector(5);
    protected TypeSet typeSet;
    protected Graph itsGraph;
    protected Graph itsStartGraph;
    protected String itsName = "unnamed.gragra";
    protected String comment = "";
    protected MorphCompletionStrategy strategy;
    protected boolean hasRuleApplCond;
    private String consistErrMsg;
    private int multiplErrKind;
    private boolean ruleChangedLayer;
    private boolean ruleChangedPriority;
    private boolean ruleChangedEvailability;
    protected String dirName = "";
    protected String fileName = "";

    protected GraGra() {
        this.typeSet = new TypeSet();
        this.itsGraph = BaseFactory.theFactory().createGraph(this.typeSet);
        this.itsGraph.setKind("HOST");
        this.itsGraph.setCompleteGraph(true);
        this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
        this.itsGraphs.add(this.itsGraph);
        this.initMorphismCompletionStrategy();
    }

    public GraGra(boolean withGraph) {
        this.typeSet = new TypeSet();
        if (withGraph) {
            this.itsGraph = BaseFactory.theFactory().createGraph(this.typeSet);
            this.itsGraph.setKind("HOST");
            this.itsGraph.setCompleteGraph(true);
            this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
            this.itsGraphs.add(this.itsGraph);
        }
        this.initMorphismCompletionStrategy();
    }

    public GraGra(TypeSet newTypeSet) {
        this.typeSet = newTypeSet;
        this.itsGraph = BaseFactory.theFactory().createGraph(this.typeSet, true);
        this.itsGraph.setKind("HOST");
        this.itsGraph.setCompleteGraph(true);
        this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
        this.itsGraphs.add(this.itsGraph);
        this.initMorphismCompletionStrategy();
    }

    public GraGra(TypeSet newTypeSet, boolean withGraph) {
        this.typeSet = newTypeSet;
        if (withGraph) {
            this.itsGraph = BaseFactory.theFactory().createGraph(this.typeSet);
            this.itsGraph.setKind("HOST");
            this.itsGraph.setCompleteGraph(true);
            this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
            this.itsGraphs.add(this.itsGraph);
        }
        this.initMorphismCompletionStrategy();
    }

    public GraGra(Graph g) {
        this.itsGraph = g;
        this.itsGraph.setKind("HOST");
        this.itsGraph.setCompleteGraph(true);
        this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
        this.itsGraphs.add(this.itsGraph);
        this.typeSet = g.getTypeSet();
        this.initMorphismCompletionStrategy();
    }

    public void trimToSize() {
        this.typeSet.trimToSize();
        this.itsGraphs.trimToSize();
        int i = 0;
        while (i < this.itsGraphs.size()) {
            this.itsGraphs.get(i).trimToSize();
            ++i;
        }
        this.itsRules.trimToSize();
        i = 0;
        while (i < this.itsRules.size()) {
            this.itsRules.get(i).trimToSize();
            ++i;
        }
        this.itsMatches.trimToSize();
        i = 0;
        while (i < this.itsMatches.size()) {
            this.itsMatches.get(i).trimToSize();
            ++i;
        }
        this.itsAtomics.trimToSize();
        i = 0;
        while (i < this.itsAtomics.size()) {
            this.itsAtomics.get(i).trimToSize();
            ++i;
        }
        this.itsConstraints.trimToSize();
        i = 0;
        while (i < this.itsConstraints.size()) {
            this.itsConstraints.get(i).trimToSize();
            ++i;
        }
        ((Vector)this.itsRuleSequences).trimToSize();
        i = 0;
        while (i < this.itsRuleSequences.size()) {
            this.itsRuleSequences.get(i).trimToSize();
            ++i;
        }
        this.itsPackages.trimToSize();
        this.gratraOptions.trimToSize();
        if (this.itsStartGraph != null) {
            this.itsStartGraph.trimToSize();
        }
    }

    public Vector<Pair<String, List<String>>> getPackages() {
        return this.itsPackages;
    }

    public void setPackages(Vector<Pair<String, List<String>>> n) {
        this.itsPackages.clear();
        this.itsPackages.addAll(n);
    }

    public void addPackage(Pair<String, List<String>> p) {
        if (!this.itsPackages.contains(p)) {
            this.itsPackages.add(p);
        }
    }

    public void removePackage(Pair<String, Vector<String>> p) {
        this.itsPackages.remove(p);
    }

    private Graph createGraph() {
        Graph g = BaseFactory.theFactory().createGraph(this.typeSet, true);
        g.setKind("HOST");
        g.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
        g.xyAttr = this.gratraOptions.contains("xyPosAttribute");
        g.setCompleteGraph(true);
        this.itsGraphs.add(g);
        return g;
    }

    public boolean addGraph(Graph g) {
        boolean result;
        if (this.itsGraphs.contains(g)) {
            result = false;
        } else {
            g.setKind("HOST");
            g.xyAttr = this.gratraOptions.contains("xyPosAttribute");
            g.setCompleteGraph(true);
            this.itsGraphs.add(g);
            result = true;
        }
        return result;
    }

    public void destroyGraph(Graph g) {
        if (this.itsGraphs.remove(g)) {
            g.dispose();
        }
    }

    public void destroyAllGraphs() {
        while (!this.itsGraphs.isEmpty()) {
            Graph g = this.itsGraphs.get(0);
            this.itsGraphs.remove(0);
            g.dispose();
        }
    }

    public boolean removeGraph(Graph g) {
        if (this.itsGraphs.contains(g)) {
            this.itsGraphs.remove(g);
            if (this.itsGraph == g && this.itsGraphs.size() == 0) {
                this.itsGraph = null;
            }
            return true;
        }
        return false;
    }

    public boolean isElement(Rule r) {
        boolean found = false;
        int i = 0;
        while (i < this.itsRules.size()) {
            if (this.itsRules.get(i).equals(r)) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    public boolean isElement(Graph g) {
        return this.itsGraphs.contains(g);
    }

    public boolean trafoByPriority() {
        return this.gratraOptions.contains("priority");
    }

    public boolean trafoByLayer() {
        return this.gratraOptions.contains("layered");
    }

    public boolean isLayered() {
        return this.gratraOptions.contains("layered");
    }

    public boolean trafoByRuleSequence() {
        return this.gratraOptions.contains("ruleSequence");
    }

    public Vector<String> getLayers() {
        RuleLayer layers = new RuleLayer(this.itsRules);
        Hashtable<Integer, HashSet<Rule>> invRuleLayers = layers.invertLayer();
        Integer currentLayer = layers.getStartLayer();
        OrderedSet<Integer> ruleLayers = new OrderedSet<Integer>(new IntComparator());
        Iterator en = invRuleLayers.keySet().iterator();
        while (en.hasNext()) {
            ruleLayers.add((Integer)en.next());
        }
        int i = 0;
        Vector<String> v = new Vector<String>();
        while (currentLayer != null) {
            v.add(currentLayer.toString());
            currentLayer = ++i < ruleLayers.size() ? (Integer)ruleLayers.get(i) : null;
        }
        return v;
    }

    public Vector<String> getEnabledLayers() {
        RuleLayer layers = new RuleLayer(this.getEnabledRules());
        Hashtable<Integer, HashSet<Rule>> invRuleLayers = layers.invertLayer();
        Integer currentLayer = layers.getStartLayer();
        OrderedSet<Integer> ruleLayers = new OrderedSet<Integer>(new IntComparator());
        Iterator en = invRuleLayers.keySet().iterator();
        while (en.hasNext()) {
            ruleLayers.add((Integer)en.next());
        }
        int i = 0;
        Vector<String> v = new Vector<String>();
        while (currentLayer != null) {
            v.add(currentLayer.toString());
            currentLayer = ++i < ruleLayers.size() ? (Integer)ruleLayers.get(i) : null;
        }
        return v;
    }

    public Vector<String> getPriorities() {
        RulePriority priors = new RulePriority(this.itsRules);
        Hashtable<Integer, HashSet<Rule>> invRulePriors = priors.invertPriority();
        Integer currentPrior = priors.getStartPriority();
        OrderedSet<Integer> rulePriors = new OrderedSet<Integer>(new IntComparator());
        Iterator en = invRulePriors.keySet().iterator();
        while (en.hasNext()) {
            rulePriors.add((Integer)en.next());
        }
        int i = 0;
        Vector<String> v = new Vector<String>(5);
        while (currentPrior != null) {
            v.add(currentPrior.toString());
            currentPrior = ++i < rulePriors.size() ? (Integer)rulePriors.get(i) : null;
        }
        return v;
    }

    public Vector<String> getEnabledPriorities() {
        RulePriority priors = new RulePriority(this.getEnabledRules());
        Hashtable<Integer, HashSet<Rule>> invRulePriors = priors.invertPriority();
        Integer currentPrior = priors.getStartPriority();
        OrderedSet<Integer> rulePriors = new OrderedSet<Integer>(new IntComparator());
        Iterator en = invRulePriors.keySet().iterator();
        while (en.hasNext()) {
            rulePriors.add((Integer)en.next());
        }
        int i = 0;
        Vector<String> v = new Vector<String>(1);
        while (currentPrior != null) {
            v.add(currentPrior.toString());
            currentPrior = ++i < rulePriors.size() ? (Integer)rulePriors.get(i) : null;
        }
        return v;
    }

    public boolean resetGraph(Graph g) {
        if (this.typeSet == null || g.getTypeSet() == null) {
            return false;
        }
        if (this.typeSet.compareTo(g.getTypeSet())) {
            int indx = this.itsGraphs.indexOf(this.itsGraph);
            if (!this.itsGraphs.contains(g)) {
                this.itsGraphs.remove(this.itsGraph);
                if (indx == -1) {
                    this.itsGraphs.add(g);
                } else {
                    this.itsGraphs.add(indx, g);
                }
                g.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
            }
            this.itsGraph = g;
            this.itsGraph.graphDidChange();
            return true;
        }
        return false;
    }

    public boolean resetGraph(int atIndex, Graph g) {
        int indx;
        if (this.typeSet == null || g.getTypeSet() == null || atIndex < 0 || atIndex >= this.itsGraphs.size()) {
            return false;
        }
        if (this.typeSet.compareTo(g.getTypeSet()) && (indx = this.itsGraphs.indexOf(this.itsGraph)) == atIndex && !this.itsGraphs.contains(g)) {
            this.itsGraphs.remove(atIndex);
            this.itsGraphs.add(atIndex, g);
            g.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
            g.graphDidChange();
            this.itsGraph = g;
            return true;
        }
        return false;
    }

    public boolean resetGraph() {
        boolean result = false;
        if (this.itsGraph == null || this.typeSet == null || this.itsStartGraph == null || !this.typeSet.equals(this.itsStartGraph.getTypeSet())) {
            result = false;
        } else {
            int indx = this.itsGraphs.indexOf(this.itsGraph);
            this.itsGraphs.remove(this.itsGraph);
            this.itsGraph.dispose();
            this.itsGraph = this.itsStartGraph.copy();
            if (indx == -1) {
                this.itsGraphs.add(this.itsGraph);
            } else {
                this.itsGraphs.add(indx, this.itsGraph);
            }
            this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
            this.itsGraph.graphDidChange();
            result = true;
        }
        return result;
    }

    public boolean resetGraphWithoutGuarantee(Graph g) {
        boolean result = true;
        int indx = this.itsGraphs.indexOf(this.itsGraph);
        if (indx >= 0) {
            this.itsGraphs.remove(this.itsGraph);
        }
        this.itsGraph = g.copy(this.typeSet);
        if (this.itsGraph == null) {
            result = false;
        } else {
            if (indx == -1) {
                this.itsGraphs.add(this.itsGraph);
            } else {
                this.itsGraphs.add(indx, this.itsGraph);
            }
            this.itsGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
            this.itsGraph.graphDidChange();
        }
        return result;
    }

    public boolean importTypeGraph(Graph g, boolean rewrite) {
        boolean result = false;
        if (g.isTypeGraph()) {
            if (this.typeSet.getTypeGraph() == null) {
                this.typeSet.createTypeGraph();
            }
            if (rewrite) {
                this.typeSet.adaptTypes(g.getTypeSet(), false);
            }
            Map<ValueTuple, ValueTuple> valueTable = this.storeAttrValueOfAttrTypeObserver();
            if (this.typeSet.importTypeGraph(g, rewrite)) {
                this.typeSet.refreshInheritanceArcs();
                this.restoreAttrValueOfObserver(valueTable);
                this.typeSet.getTypeGraph().graphDidChange();
                result = true;
            } else {
                result = false;
            }
        }
        return result;
    }

    private Map<ValueTuple, ValueTuple> storeAttrValueOfAttrTypeObserver() {
        Hashtable<ValueTuple, ValueTuple> attrStore = new Hashtable<ValueTuple, ValueTuple>();
        Enumeration<Type> types = this.typeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            if (t.getAttrType() == null) continue;
            DeclTuple dt = (DeclTuple)t.getAttrType();
            Enumeration<AttrObserver> observers = ((DeclTuple)t.getAttrType()).getObservers();
            while (observers.hasMoreElements()) {
                ValueTuple valTuple;
                AttrObserver obs = observers.nextElement();
                if (!(obs instanceof ValueTuple) || (valTuple = (ValueTuple)obs).isEmpty()) continue;
                ValueTuple vt = new ValueTuple((AttrTupleManager)AttrTupleManager.getDefaultManager(), dt, (ContextView)valTuple.getContext());
                int i = 0;
                while (i < valTuple.getSize()) {
                    ValueMember mem = valTuple.getValueMemberAt(i);
                    ValueMember vm = vt.getValueMemberAt(mem.getName());
                    if (vm != null && mem.isSet()) {
                        vm.setExprAsText(mem.getExprAsText());
                    }
                    ++i;
                }
                attrStore.put((ValueTuple)obs, vt);
            }
        }
        return attrStore;
    }

    private void restoreAttrValueOfObserver(Map<ValueTuple, ValueTuple> attrStore) {
        Enumeration<Type> types = this.typeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            if (t.getAttrType() == null) continue;
            Enumeration<AttrObserver> observers = ((DeclTuple)t.getAttrType()).getObservers();
            while (observers.hasMoreElements()) {
                ValueTuple vt;
                AttrObserver obs = observers.nextElement();
                if (!(obs instanceof ValueTuple) || (vt = attrStore.get(obs)) == null) continue;
                ValueTuple valTuple = (ValueTuple)obs;
                int i = 0;
                while (i < valTuple.getSize()) {
                    ValueMember mem = valTuple.getValueMemberAt(i);
                    ValueMember vm = vt.getValueMemberAt(mem.getName());
                    if (vm != null && vm.isSet()) {
                        mem.setExprAsText(vm.getExprAsText());
                    }
                    ++i;
                }
            }
        }
    }

    public boolean importGraph(Graph g) {
        boolean importTried = false;
        boolean result = false;
        if (g.getTypeSet().getTypeGraph() != null && (this.typeSet.getTypeGraph() == null || this.typeSet.getTypeGraph().isEmpty() && this.getLevelOfTypeGraphCheck() == 0)) {
            importTried = true;
            result = this.importTypeGraph(g.getTypeSet().getTypeGraph(), true) ? this.importGraph(g, false) : false;
        }
        if (!importTried) {
            result = this.importGraph(g, false);
        }
        return result;
    }

    public boolean importGraph(Graph g, boolean adapt) {
        boolean result;
        Graph impGraph = this.doImportGraph(g, adapt);
        if (impGraph == null) {
            result = false;
        } else {
            int indx = this.itsGraphs.indexOf(this.itsGraph);
            if (indx == -1) {
                this.itsGraphs.add(impGraph);
            } else {
                this.itsGraphs.remove(this.itsGraph);
                this.itsGraphs.add(indx, impGraph);
            }
            this.itsGraph = impGraph;
            this.itsGraph.graphDidChange();
            result = true;
        }
        return result;
    }

    public boolean addImportGraph(Graph g) {
        return this.addImportGraph(g, false);
    }

    public boolean addImportGraph(Graph g, boolean adapt) {
        boolean result;
        Graph impGraph = this.doImportGraph(g, adapt);
        if (impGraph == null) {
            result = false;
        } else {
            this.itsGraphs.add(impGraph);
            result = true;
        }
        return result;
    }

    private Graph doImportGraph(Graph g, boolean adapt) {
        Graph impGraph = null;
        if (this.typeSet != null && g.getTypeSet() != null) {
            String extStr = "_import";
            if (this.typeSet.isEmpty() && this.adoptTypes(g.getTypeSet().getTypes())) {
                impGraph = g.copy(this.typeSet);
            } else if (this.typeSet.contains(g.getTypeSet())) {
                impGraph = g.copy(this.typeSet);
            } else if (this.typeSet.getTypeGraph() == null || this.typeSet.getLevelOfTypeGraphCheck() == 0) {
                Vector<Type> typesToAdopt = new Vector<Type>(1);
                Enumeration<Type> other = g.getTypeSet().getTypes();
                while (other.hasMoreElements()) {
                    Type tOther = other.nextElement();
                    if (this.typeSet.containsType(tOther) || !g.getElementsOfType(tOther).hasMoreElements()) continue;
                    typesToAdopt.add(tOther);
                }
                if (adapt) {
                    this.typeSet.adaptTypes(g.getTypeSet().getTypes(), false);
                    impGraph = g.copyLight(this.typeSet);
                } else if (this.adoptTypes(typesToAdopt.elements())) {
                    impGraph = g.copy(this.typeSet);
                }
            }
            if (impGraph != null) {
                impGraph.setName(String.valueOf(g.getName()) + "_import");
                impGraph.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(this.aGraphContext()));
                this.typeSet.extendTypeGraph(g.getNodesSet().iterator(), g.getArcsSet().iterator());
            }
        }
        return impGraph;
    }

    public boolean addImportRule(Rule r) {
        return this.addImportRule(r, false);
    }

    public boolean addImportRule(Rule r, boolean adapt) {
        boolean result = false;
        if (!this.itsRules.contains(r)) {
            Rule impR;
            if (adapt) {
                this.typeSet.adaptTypes(r.getTypeSet(), true);
            }
            if ((impR = BaseFactory.theFactory().cloneRule(r, this.typeSet, true)) != null) {
                OrdinaryMorphism m;
                this.itsRules.add(impR);
                result = true;
                Vector<Node> nodelist = new Vector<Node>(r.getLeft().getNodesSet());
                nodelist.addAll(r.getRight().getNodesSet());
                Vector<Arc> edgelist = new Vector<Arc>(r.getLeft().getArcsSet());
                edgelist.addAll(r.getRight().getArcsSet());
                int i = 0;
                while (i < r.getNACsList().size()) {
                    m = r.getNACsList().get(i);
                    nodelist.addAll(m.getTarget().getNodesSet());
                    edgelist.addAll(m.getTarget().getArcsSet());
                    ++i;
                }
                i = 0;
                while (i < r.getPACsList().size()) {
                    m = r.getPACsList().get(i);
                    nodelist.addAll(m.getTarget().getNodesSet());
                    edgelist.addAll(m.getTarget().getArcsSet());
                    ++i;
                }
                this.typeSet.extendTypeGraph(nodelist.iterator(), edgelist.iterator());
            }
        }
        return result;
    }

    public boolean adoptTypes(Enumeration<Type> types) {
        boolean result = true;
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            if (this.typeSet.adoptType(t) != null) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void dispose() {
        this.typeSet.setLevelOfTypeGraph(0);
        if (this.itsRuleSequences != null) {
            this.itsRuleSequences.clear();
        }
        this.destroyAllMatches();
        this.destroyAllRules();
        this.destroyAllConstraints();
        this.destroyAllAtomics();
        this.destroyAllGraphs();
        if (this.itsStartGraph != null) {
            this.itsStartGraph.dispose();
        }
        this.typeSet.destroyTypeGraph();
        this.typeSet.dispose();
        this.typeSet = null;
        this.itsGraph = null;
    }

    public void finalize() {
    }

    private AttrContext aGraphContext() {
        AttrContext aGraphCntxt = AttrTupleManager.getDefaultManager().newContext(2);
        return aGraphCntxt;
    }

    private void clear() {
        this.setLevelOfTypeGraphCheck(0);
        if (this.itsRuleSequences != null) {
            this.itsRuleSequences.clear();
            this.itsRuleSequence = null;
        }
        this.destroyAllMatches();
        this.destroyAllRules();
        this.destroyAllConstraints();
        this.destroyAllAtomics();
        this.destroyAllGraphs();
        if (this.itsStartGraph != null) {
            this.itsStartGraph.dispose();
        }
        this.typeSet.dispose();
    }

    public boolean addRule(Rule r) {
        boolean result = true;
        if (this.itsRules.contains(r)) {
            result = false;
        } else {
            if (this.gratraOptions.contains("xyPosAttribute")) {
                r.getLeft().xyAttr = true;
                r.getRight().xyAttr = true;
            }
            this.itsRules.add(r);
            this.addMatch(r.getMatch());
        }
        return result;
    }

    public boolean addRuleAt(int indx, Rule r) {
        boolean result = true;
        if (this.itsRules.contains(r)) {
            result = false;
        } else {
            if (this.gratraOptions.contains("xyPosAttribute")) {
                r.getLeft().xyAttr = true;
                r.getRight().xyAttr = true;
            }
            this.itsRules.add(indx, r);
            this.addMatch(r.getMatch());
        }
        return result;
    }

    public boolean removeRule(Rule r) {
        if (this.itsRules.remove(r)) {
            this.refreshRuleSequences();
            return true;
        }
        return false;
    }

    public boolean hasRuleWithApplCond() {
        this.hasRuleApplCond = false;
        int i = 0;
        while (i < this.itsRules.size()) {
            if (this.itsRules.get(i).getNACsList().size() > 0 || this.itsRules.get(i).getPACsList().size() > 0 || this.itsRules.get(i).getNestedACsList().size() > 0) {
                this.hasRuleApplCond = true;
                break;
            }
            ++i;
        }
        return this.hasRuleApplCond;
    }

    public void removeTypeGraph() {
        this.typeSet.removeTypeGraph();
    }

    public final void setName(String n) {
        this.itsName = n;
    }

    public final String getName() {
        return this.itsName;
    }

    public void setTextualComment(String text) {
        this.comment = text;
    }

    public String getTextualComment() {
        return this.comment;
    }

    public void setDirName(String str) {
        this.dirName = str;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setFileName(String str) {
        this.fileName = str;
    }

    public String getFileName() {
        return this.fileName;
    }

    public final Graph getGraph() {
        return this.itsGraph;
    }

    public int getIndexOfGraph() {
        return this.itsGraphs.indexOf(this.itsGraph);
    }

    public final Graph getGraph(String name) {
        Graph g = null;
        int i = 0;
        while (i < this.itsGraphs.size()) {
            if (this.itsGraphs.get(i).getName().equals(name)) {
                g = this.itsGraphs.get(i);
                break;
            }
            ++i;
        }
        return g;
    }

    public final Graph getGraph(int indx) {
        Graph g = null;
        if (indx >= 0 && indx < this.itsGraphs.size()) {
            g = this.itsGraphs.get(indx);
        }
        return g;
    }

    public final Enumeration<Graph> getGraphs() {
        return this.itsGraphs.elements();
    }

    public final int getCountOfGraphs() {
        return this.itsGraphs.size();
    }

    public final List<Graph> getListOfGraphs() {
        return this.itsGraphs;
    }

    public final Vector<Graph> getGraphsVec() {
        return this.itsGraphs;
    }

    public final Graph getStartGraph() {
        return this.itsStartGraph;
    }

    public void setStartGraph(Graph g) {
        if (g == null) {
            this.destroyStartGraph();
        } else if (g.getTypeSet().equals(this.typeSet)) {
            if (this.itsStartGraph != null) {
                this.itsStartGraph.dispose();
            }
            this.itsStartGraph = g;
        }
    }

    public void destroyStartGraph() {
        this.itsStartGraph.dispose();
    }

    public final List<Rule> getListOfRules() {
        return this.itsRules;
    }

    public List<Rule> getListOfEnabledRules() {
        Vector<Rule> list = new Vector<Rule>();
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.isEnabled()) {
                list.add(r);
            }
            ++i;
        }
        return list;
    }

    public void oneRuleHasChangedLayer() {
        this.ruleChangedLayer = true;
    }

    public boolean hasRuleChangedLayer() {
        return this.ruleChangedLayer;
    }

    public void oneRuleHasChangedPriority() {
        this.ruleChangedPriority = true;
    }

    public boolean hasRuleChangedPriority() {
        return this.ruleChangedPriority;
    }

    public void oneRuleHasChangedEvailability() {
        this.ruleChangedEvailability = true;
    }

    public boolean hasRuleChangedEvailability() {
        return this.ruleChangedEvailability;
    }

    public final Enumeration<Rule> getRules() {
        return this.itsRules.elements();
    }

    public final Iterator<Rule> getRuleIterator() {
        return this.itsRules.iterator();
    }

    public final Vector<Rule> getRulesVec() {
        return this.itsRules;
    }

    public Vector<Rule> getRulesForLayer(int l) {
        Vector<Rule> v = new Vector<Rule>(5);
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.getLayer() == l) {
                v.add(r);
            }
            ++i;
        }
        return v;
    }

    public void enableRuleLayer(int l, boolean enabled) {
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.getLayer() == l) {
                r.setEnabled(enabled);
            }
            ++i;
        }
    }

    public boolean isRuleLayerEnabled(int l) {
        boolean result = false;
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.getLayer() == l && r.isEnabled()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public final Rule getRule(int ruleIndx) {
        Rule r = null;
        if (ruleIndx < this.itsRules.size()) {
            r = this.itsRules.get(ruleIndx);
        }
        return r;
    }

    public final Rule getRule(String name) {
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.getRuleScheme() == null ? r.getName().equals(name) : (r = r.getRuleScheme().getRule(name)) != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public final Rule getRuleByQualifiedName(String name) {
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.getRuleScheme() == null ? r.getQualifiedName().equals(name) : (r = r.getRuleScheme().getRuleByQualifiedName(name)) != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public MorphCompletionStrategy getMorphismCompletionStrategy() {
        return this.strategy;
    }

    public final List<Evaluable> getListOfAtomicObjects() {
        return this.getAtomicObjects();
    }

    public final Enumeration<AtomConstraint> getAtomics() {
        return this.itsAtomics.elements();
    }

    public final AtomConstraint getAtomic(String name) {
        int i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint ac = this.itsAtomics.get(i);
            if (ac.getAtomicName().equals(name)) {
                return ac;
            }
            ++i;
        }
        return null;
    }

    public final List<AtomConstraint> getListOfAtomics() {
        return this.itsAtomics;
    }

    private final List<String> getAtomicNames() {
        Vector<String> names = new Vector<String>(this.itsAtomics.size());
        int i = 0;
        while (i < this.itsAtomics.size()) {
            names.add(this.itsAtomics.get(i).getAtomicName());
            ++i;
        }
        return names;
    }

    private final List<Evaluable> getAtomicObjects() {
        Vector<Evaluable> res = new Vector<Evaluable>(this.itsAtomics.size());
        int i = 0;
        while (i < this.itsAtomics.size()) {
            res.add(this.itsAtomics.get(i));
            ++i;
        }
        return res;
    }

    public final List<Formula> getListOfConstraints() {
        return this.itsConstraints;
    }

    public final Enumeration<Formula> getConstraints() {
        return this.itsConstraints.elements();
    }

    public final Vector<Formula> getConstraintsVec() {
        return this.itsConstraints;
    }

    public List<Formula> getGlobalConstraints() {
        return this.getConstraintsForLayer(-1);
    }

    public List<Formula> getConstraintsForLayer(int l) {
        Vector<Formula> v = new Vector<Formula>(5);
        int i = 0;
        while (i < this.itsConstraints.size()) {
            Formula c = this.itsConstraints.get(i);
            Vector<Integer> layer = c.getLayer();
            if (l == -1 && layer.isEmpty()) {
                v.add(c);
            } else if (l > -1 && !layer.isEmpty()) {
                int j = 0;
                while (j < layer.size()) {
                    Integer I = layer.get(j);
                    if (I == l) {
                        v.add(c);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return v;
    }

    public Vector<Formula> getConstraintsForPriority(int p) {
        Vector<Formula> v = new Vector<Formula>(5);
        int i = 0;
        while (i < this.itsConstraints.size()) {
            Formula c = this.itsConstraints.get(i);
            Vector<Integer> prior = c.getPriority();
            if (p == -1 && prior.isEmpty()) {
                v.add(c);
            } else if (p > -1 && !prior.isEmpty()) {
                int j = 0;
                while (j < prior.size()) {
                    Integer I = prior.get(j);
                    if (I == p) {
                        v.add(c);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return v;
    }

    private void refreshConstraints() {
        int i = 0;
        while (i < this.itsConstraints.size()) {
            Formula c = this.itsConstraints.get(i);
            c.getAsString(this.getAtomicObjects(), this.getAtomicNames());
            ++i;
        }
    }

    public void refreshConstraintsForLayer() {
        Vector<String> itsLayers = this.getLayers();
        int i = 0;
        while (i < this.itsConstraints.size()) {
            Formula c = this.itsConstraints.get(i);
            Vector<Integer> layer = c.getLayer();
            Enumeration<Integer> e = layer.elements();
            while (e.hasMoreElements()) {
                Integer l = e.nextElement();
                boolean found = false;
                int j = 0;
                while (j < itsLayers.size()) {
                    try {
                        Integer I = Integer.valueOf(itsLayers.get(j));
                        if (I.intValue() == l.intValue()) {
                            found = true;
                            break;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++j;
                }
                if (found) continue;
                layer.remove(l);
                e = layer.elements();
            }
            ++i;
        }
    }

    public void refreshConstraintsForPriority() {
        Vector<String> itsPriors = this.getPriorities();
        int i = 0;
        while (i < this.itsConstraints.size()) {
            Formula c = this.itsConstraints.get(i);
            Vector<Integer> prior = c.getPriority();
            Enumeration<Integer> e = c.getPriority().elements();
            while (e.hasMoreElements()) {
                Integer p = e.nextElement();
                boolean found = false;
                int j = 0;
                while (j < itsPriors.size()) {
                    try {
                        Integer I = Integer.valueOf(itsPriors.get(j));
                        if (I.intValue() == p.intValue()) {
                            found = true;
                            break;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++j;
                }
                if (found) continue;
                prior.remove(p);
                e = prior.elements();
            }
            ++i;
        }
    }

    public Rule createRule() {
        Rule r = new Rule(this.typeSet);
        if (this.gratraOptions.contains("xyPosAttribute")) {
            r.getLeft().xyAttr = true;
            r.getRight().xyAttr = true;
        }
        this.itsRules.add(r);
        return r;
    }

    public RuleScheme createRuleScheme() {
        RuleScheme rs = new RuleScheme("RuleScheme" + String.valueOf(this.itsRules.size()), this.typeSet);
        if (this.gratraOptions.contains("xyPosAttribute")) {
            rs.getKernelRule().getLeft().xyAttr = true;
            rs.getKernelRule().getRight().xyAttr = true;
        }
        this.itsRules.add(rs);
        return rs;
    }

    public RuleScheme createRuleScheme(Rule r) {
        RuleScheme rs = BaseFactory.theBaseFactory.makeRuleScheme(r);
        if (rs != null) {
            int indx = this.itsRules.indexOf(r);
            if (indx >= 0) {
                this.itsRules.add(indx + 1, rs);
            } else {
                this.itsRules.add(rs);
            }
        }
        return rs;
    }

    public boolean addRuleScheme(RuleScheme rs) {
        boolean result = true;
        if (this.itsRules.contains(rs)) {
            result = false;
        } else {
            if (this.gratraOptions.contains("xyPosAttribute")) {
                rs.getKernelRule().getLeft().xyAttr = true;
                rs.getKernelRule().getRight().xyAttr = true;
                for (Rule mr : rs.getMultiRules()) {
                    mr.getLeft().xyAttr = true;
                    mr.getRight().xyAttr = true;
                }
            }
            this.itsRules.add(rs);
        }
        return result;
    }

    public void sortRulesByPriority() {
        RulePriority priority = new RulePriority(this.itsRules);
        Integer startPriority = priority.getStartPriority();
        Hashtable<Integer, HashSet<Rule>> invertedRulePriority = priority.invertPriority();
        OrderedSet<Integer> rulePrioritySet = new OrderedSet<Integer>(new IntComparator());
        Enumeration<Integer> en = invertedRulePriority.keys();
        while (en.hasMoreElements()) {
            rulePrioritySet.add(en.nextElement());
        }
        int i = 0;
        this.itsRules.clear();
        Integer currentPriority = startPriority;
        boolean nextPriorityExists = true;
        while (nextPriorityExists && currentPriority != null) {
            HashSet<Rule> rulesForPriority = invertedRulePriority.get(currentPriority);
            for (Rule r : rulesForPriority) {
                this.itsRules.add(r);
            }
            if (++i < rulePrioritySet.size()) {
                currentPriority = (Integer)rulePrioritySet.get(i);
                continue;
            }
            nextPriorityExists = false;
        }
    }

    public void sortRulesByLayer() {
        RuleLayer layer = new RuleLayer(this.itsRules);
        Integer startLayer = layer.getStartLayer();
        Hashtable<Integer, HashSet<Rule>> invertedRuleLayer = layer.invertLayer();
        OrderedSet<Integer> ruleLayer = new OrderedSet<Integer>(new IntComparator());
        Iterator en = invertedRuleLayer.keySet().iterator();
        while (en.hasNext()) {
            ruleLayer.add((Integer)en.next());
        }
        int i = 0;
        this.itsRules.clear();
        Integer currentLayer = startLayer;
        boolean nextLayerExists = true;
        while (nextLayerExists && currentLayer != null) {
            HashSet rulesForLayer = (HashSet)invertedRuleLayer.get(currentLayer);
            for (Rule r : rulesForLayer) {
                this.itsRules.add(r);
            }
            if (++i < ruleLayer.size()) {
                currentLayer = (Integer)ruleLayer.get(i);
                continue;
            }
            nextLayerExists = false;
        }
    }

    public void sortConstraintsByLayer() {
        ConstraintLayer layer = new ConstraintLayer(this.itsConstraints);
        Integer startLayer = layer.getStartLayer();
        Hashtable<Integer, HashSet<Object>> invLayer = layer.invertLayer();
        OrderedSet<Integer> formulaLayer = new OrderedSet<Integer>(new IntComparator());
        Iterator en = invLayer.keySet().iterator();
        while (en.hasNext()) {
            formulaLayer.add((Integer)en.next());
        }
        int i = 0;
        this.itsConstraints.clear();
        Integer currentLayer = startLayer;
        boolean nextLayerExists = true;
        while (nextLayerExists && currentLayer != null) {
            HashSet constraintsForLayer = (HashSet)invLayer.get(currentLayer);
            for (Formula f : constraintsForLayer) {
                this.itsConstraints.add(f);
            }
            if (++i < formulaLayer.size()) {
                currentLayer = (Integer)formulaLayer.get(i);
                continue;
            }
            nextLayerExists = false;
        }
    }

    public void sortConstraintsByPriority() {
        ConstraintPriority cons = new ConstraintPriority(this.itsConstraints);
        Integer start = cons.getStartPriority();
        Hashtable<Integer, HashSet<Object>> inverted = cons.invertPriority();
        OrderedSet<Integer> set = new OrderedSet<Integer>(new IntComparator());
        Iterator en = inverted.keySet().iterator();
        while (en.hasNext()) {
            set.add((Integer)en.next());
        }
        int i = 0;
        this.itsConstraints.clear();
        Integer current = start;
        boolean nextExists = true;
        while (nextExists && current != null) {
            HashSet constraintsForLayer = (HashSet)inverted.get(current);
            for (Formula f : constraintsForLayer) {
                this.itsConstraints.add(f);
            }
            if (++i < set.size()) {
                current = (Integer)set.get(i);
                continue;
            }
            nextExists = false;
        }
    }

    public Graph cloneGraph() {
        return this.itsGraph.graphcopy();
    }

    public Rule cloneRule(Rule r) {
        Rule aNewRule = BaseFactory.theFactory().cloneRule(r, this.typeSet, true);
        this.itsRules.add(aNewRule);
        return aNewRule;
    }

    public Rule reverseRule(Rule r) {
        Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> inverseRulePair = BaseFactory.theFactory().reverseRule(r);
        if (inverseRulePair != null) {
            Rule invRule = (Rule)((Pair)inverseRulePair.first).first;
            r.disposeInverseConstruct();
            return invRule;
        }
        return null;
    }

    public RuleScheme reverseRuleScheme(RuleScheme rs) {
        RuleScheme invRS = BaseFactory.theFactory().reverseRuleScheme(rs);
        return invRS;
    }

    public AtomConstraint createAtomic(String name) {
        AtomConstraint ac = BaseFactory.theFactory().createAtomic(this.typeSet, name);
        ac.setMorphismCompletionStrategy(this.strategy);
        if (this.gratraOptions.contains("xyPosAttribute")) {
            ac.getSource().xyAttr = true;
            ac.getTarget().xyAttr = true;
        }
        this.itsAtomics.add(ac);
        return ac;
    }

    public boolean addAtomic(AtomConstraint ac) {
        boolean result = true;
        if (this.itsAtomics.contains(ac)) {
            result = false;
        } else {
            if (this.gratraOptions.contains("xyPosAttribute")) {
                ac.getSource().xyAttr = true;
                ac.getTarget().xyAttr = true;
            }
            ac.setMorphismCompletionStrategy(this.strategy);
            this.itsAtomics.add(ac);
        }
        return result;
    }

    public boolean removeAtomic(AtomConstraint ac) {
        int i = 0;
        while (i < this.itsConstraints.size()) {
            this.itsConstraints.get(i).patchOutEvaluable(ac, true);
            ++i;
        }
        return this.itsAtomics.remove(ac);
    }

    public Formula createConstraint(String name) {
        Formula f = new Formula(true);
        f.setName(name);
        this.itsConstraints.add(f);
        return f;
    }

    public boolean addConstraint(Formula f) {
        boolean result = true;
        if (this.itsConstraints.contains(f)) {
            result = false;
        } else {
            this.itsConstraints.add(f);
        }
        return result;
    }

    public void destroyTypeGraph() {
        this.typeSet.removeTypeGraph();
    }

    public void destroyRule(Rule rule) {
        if (this.itsRules.remove(rule)) {
            rule.dispose();
        }
    }

    public void destroyAllRules() {
        while (!this.itsRules.isEmpty()) {
            Rule rule = this.itsRules.get(0);
            this.itsRules.remove(0);
            rule.dispose();
        }
    }

    public void destroyAtomic(AtomConstraint a) {
        if (this.itsAtomics.remove(a)) {
            this.clearRuleConstraints(a);
            int i = 0;
            while (i < this.itsConstraints.size()) {
                this.itsConstraints.get(i).patchOutEvaluable(a, true);
                ++i;
            }
            a.dispose(true, true);
        }
    }

    public void destroyAllAtomics() {
        int n = this.itsAtomics.size() - 1;
        while (!this.itsAtomics.isEmpty()) {
            AtomConstraint a = this.itsAtomics.remove(n);
            this.clearRuleConstraints(a);
            int i = 0;
            while (i < this.itsConstraints.size()) {
                this.itsConstraints.get(i).patchOutEvaluable(a, true);
                ++i;
            }
            a.dispose();
            n = this.itsAtomics.size() - 1;
        }
    }

    public void destroyConstraint(Formula f) {
        if (this.itsConstraints.remove(f)) {
            this.clearRuleConstraints(f);
        }
    }

    public void destroyAllConstraints() {
        while (!this.itsConstraints.isEmpty()) {
            Formula f = this.itsConstraints.get(0);
            this.itsConstraints.remove(0);
            this.clearRuleConstraints(f);
        }
    }

    public Vector<String> destroyGraphObjectsOfType(Type t, boolean fromTypeGraph) {
        Vector<String> failed = new Vector<String>(5);
        int i = 0;
        while (i < this.itsGraphs.size()) {
            Graph g = this.itsGraphs.get(i);
            if (!g.destroyObjectsOfType(t)) {
                failed.add(g.getName());
            }
            ++i;
        }
        for (Rule r : this.itsRules) {
            if (r.destroyObjectsOfType(t)) continue;
            failed.add(r.getName());
        }
        Enumeration<AtomConstraint> atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = atomics.nextElement();
            a.getSource().destroyObjectsOfType(t);
            Enumeration<AtomConstraint> conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = conclusions.nextElement();
                if (c.getTarget().destroyObjectsOfType(t)) continue;
                failed.add(c.getName());
            }
        }
        if (this.typeSet.getTypeGraph() != null && fromTypeGraph && !this.typeSet.getTypeGraph().destroyObjectsOfType(t)) {
            failed.add(this.typeSet.getTypeGraph().getName());
        }
        return failed;
    }

    public Vector<String> destroyGraphObjectsOfTypes(Vector<Type> ts, boolean fromTypeGraph) {
        Vector<String> failed = null;
        if (this.itsStartGraph != null) {
            this.itsStartGraph.destroyObjectsOfTypes(ts);
        }
        Vector<String> v = null;
        int i = 0;
        while (i < this.itsGraphs.size()) {
            Graph g = this.itsGraphs.get(i);
            v = g.destroyObjectsOfTypes(ts);
            if (v != null) {
                if (failed == null) {
                    failed = new Vector<String>(5);
                }
                failed.addAll(v);
            }
            ++i;
        }
        for (Rule r : this.itsRules) {
            v = r.destroyObjectsOfTypes(ts);
            if (v.isEmpty()) continue;
            if (failed == null) {
                failed = new Vector(5);
            }
            failed.addAll(v);
        }
        Enumeration<AtomConstraint> atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = atomics.nextElement();
            v = a.getSource().destroyObjectsOfTypes(ts);
            if (v != null) {
                if (failed == null) {
                    failed = new Vector(5);
                }
                failed.addAll(v);
            }
            Enumeration<AtomConstraint> conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = conclusions.nextElement();
                v = c.getTarget().destroyObjectsOfTypes(ts);
                if (v == null) continue;
                if (failed == null) {
                    failed = new Vector(5);
                }
                failed.addAll(v);
            }
        }
        if (this.typeSet.getTypeGraph() != null && fromTypeGraph && (v = this.typeSet.getTypeGraph().destroyObjectsOfTypes(ts)) != null) {
            if (failed == null) {
                failed = new Vector(5);
            }
            failed.addAll(v);
        }
        return failed;
    }

    public boolean destroyGraphObjectsOfTypeFromHostGraph(Type t) {
        return this.itsGraph.destroyObjectsOfType(t);
    }

    public Vector<String> destroyGraphObjectsOfTypesFromHostGraph(Vector<Type> ts) {
        return this.itsGraph.destroyObjectsOfTypes(ts);
    }

    public Vector<String> destroyGraphObjectsOfTypeFromRules(Type t) {
        Vector<String> failed = new Vector<String>(5);
        for (Rule r : this.itsRules) {
            if (r.destroyObjectsOfType(t)) continue;
            failed.add(r.getName());
        }
        return failed;
    }

    public Vector<String> destroyGraphObjectsOfTypesFromRules(Vector<Type> ts) {
        Vector<String> failed = new Vector<String>(5);
        for (Rule r : this.itsRules) {
            Vector<String> v = r.destroyObjectsOfTypes(ts);
            if (v.isEmpty()) continue;
            failed.addAll(v);
        }
        return failed;
    }

    public Vector<String> destroyGraphObjectsOfTypeFromGraphConstraints(Type t) {
        Vector<String> failed = new Vector<String>(5);
        Enumeration<AtomConstraint> atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = atomics.nextElement();
            a.getSource().destroyObjectsOfType(t);
            Enumeration<AtomConstraint> conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = conclusions.nextElement();
                if (c.getTarget().destroyObjectsOfType(t)) continue;
                failed.add(c.getName());
            }
        }
        return failed;
    }

    public Vector<String> destroyGraphObjectsOfTypesFromGraphConstraints(Vector<Type> ts) {
        Vector<String> failed = null;
        Enumeration<AtomConstraint> atomics = this.getAtomics();
        while (atomics.hasMoreElements()) {
            AtomConstraint a = atomics.nextElement();
            Vector<String> v = a.getSource().destroyObjectsOfTypes(ts);
            if (v != null) {
                if (failed == null) {
                    failed = new Vector<String>(5);
                }
                failed.addAll(v);
            }
            Enumeration<AtomConstraint> conclusions = a.getConclusions();
            while (conclusions.hasMoreElements()) {
                AtomConstraint c = conclusions.nextElement();
                v = c.getTarget().destroyObjectsOfTypes(ts);
                if (v == null) continue;
                if (failed == null) {
                    failed = new Vector(5);
                }
                failed.addAll(v);
            }
        }
        return failed;
    }

    public final Enumeration<Match> getMatches(Rule rule) {
        Vector<Match> mtchs = new Vector<Match>();
        int i = 0;
        while (i < this.itsMatches.size()) {
            Match m = this.itsMatches.get(i);
            if (m.getRule().equals(rule)) {
                mtchs.add(m);
            }
            ++i;
        }
        return mtchs.elements();
    }

    public final Match getMatch(Rule rule, Graph g) {
        Match m = null;
        int i = 0;
        while (i < this.itsMatches.size()) {
            if (this.itsMatches.get(i).getRule() == rule && this.itsMatches.get(i).getTarget() == g) {
                m = this.itsMatches.get(i);
            }
            ++i;
        }
        return m;
    }

    public Match createMatch(Rule rule) {
        Match m = new Match(rule, this.itsGraph);
        rule.setMatch(m);
        this.itsMatches.add(m);
        return m;
    }

    public Match createMatch(Rule rule, Graph g) {
        if (this.resetGraph(g)) {
            Match m = new Match(rule, g);
            rule.setMatch(m);
            this.itsMatches.add(m);
            return m;
        }
        return null;
    }

    public void addMatch(Match m) {
        if (m != null) {
            this.itsMatches.add(m);
        }
    }

    public void destroyMatch(Match match) {
        if (match != null) {
            if (match.getRule() != null) {
                match.getRule().setMatch(null);
            }
            this.itsMatches.remove(match);
            match.dispose();
        }
    }

    public void destroyMatches(Graph g) {
        int i = 0;
        while (i < this.itsMatches.size()) {
            Match match = this.itsMatches.get(i);
            if (match.getTarget() == g) {
                this.itsMatches.remove(match);
                --i;
                if (match.getRule() != null) {
                    match.getRule().setMatch(null);
                }
                match.dispose();
            }
            ++i;
        }
    }

    public void destroyAllMatches() {
        while (!this.itsMatches.isEmpty()) {
            Match match = this.itsMatches.remove(0);
            if (match == null) continue;
            if (match.getRule() != null) {
                match.getRule().setMatch(null);
            }
            match.dispose();
        }
    }

    public Graph createTypeGraph() {
        Graph tg = this.typeSet.createTypeGraph();
        tg.xyAttr = this.gratraOptions.contains("xyPosAttribute");
        return tg;
    }

    public Graph getTypeGraph() {
        return this.typeSet.getTypeGraph();
    }

    public Type createType() {
        return this.typeSet.createType();
    }

    public Type createType(boolean withAttributes) {
        return this.typeSet.createType(withAttributes);
    }

    public Type createNodeType(boolean withAttributes) {
        return this.typeSet.createNodeType(withAttributes);
    }

    public Type createArcType(boolean withAttributes) {
        return this.typeSet.createArcType(withAttributes);
    }

    public boolean isUsingType(GraphObject t) {
        boolean result = this.graphIsUsingType(t) || this.ruleIsUsingType(t) || this.constraintIsUsingType(t);
        return result;
    }

    private boolean graphIsUsingType(GraphObject t) {
        boolean result = false;
        int i = 0;
        while (i < this.itsGraphs.size()) {
            if (this.itsGraphs.get(i).isUsingType(t)) {
                result = true;
            }
            ++i;
        }
        if (this.itsStartGraph != null) {
            result = result || this.itsStartGraph.isUsingType(t);
        }
        return result;
    }

    private boolean ruleIsUsingType(GraphObject t) {
        boolean result = false;
        int i = 0;
        while (i < this.itsRules.size()) {
            if (this.itsRules.get(i).isUsingType(t)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private boolean constraintIsUsingType(GraphObject t) {
        boolean result = false;
        Iterator<AtomConstraint> e = this.itsAtomics.iterator();
        while (!result && e.hasNext()) {
            AtomConstraint atom = e.next();
            if (!atom.getSource().isUsingType(t) && !atom.getTarget().isUsingType(t)) continue;
            result = true;
        }
        return result;
    }

    public void refreshAttributed() {
        int i = 0;
        while (i < this.itsGraphs.size()) {
            this.itsGraphs.get(i).refreshAttributed();
            ++i;
        }
        if (this.itsStartGraph != null) {
            this.itsStartGraph.refreshAttributed();
        }
        i = 0;
        while (i < this.itsRules.size()) {
            this.itsRules.get(i).refreshAttributed();
            ++i;
        }
        i = 0;
        while (i < this.itsAtomics.size()) {
            this.itsAtomics.get(i).refreshAttributed();
            ++i;
        }
    }

    public TypeSet getTypeSet() {
        return this.typeSet;
    }

    public Enumeration<Type> getTypes() {
        return this.typeSet.getTypes();
    }

    public void destroyType(Type type) throws TypeException {
        this.typeSet.destroyType(type);
    }

    public Collection<TypeError> setLevelOfTypeGraphCheck(int level) {
        this.multiplErrKind = -1;
        int oldLevel = this.typeSet.getLevelOfTypeGraphCheck();
        Collection<TypeError> checkResult = this.typeSet.setLevelOfTypeGraphCheck(level);
        if (checkResult.isEmpty()) {
            Vector<TypeError> errors = new Vector<TypeError>();
            for (Graph g : this.itsGraphs) {
                if (g.isEmpty() && level != 30) continue;
                errors.addAll(this.typeSet.checkType(g));
            }
            if (level != 0) {
                for (Rule r : this.itsRules) {
                    if (r.getRuleScheme() == null) {
                        errors.addAll(this.typeSet.checkType(r));
                        continue;
                    }
                    errors.addAll(this.typeSet.checkType(r.getRuleScheme().getKernelRule()));
                    int i = 0;
                    while (i < r.getRuleScheme().getMultiRules().size()) {
                        errors.addAll(this.typeSet.checkType(r.getRuleScheme().getMultiRules().get(i)));
                        ++i;
                    }
                }
                Iterator<AtomConstraint> en = this.itsAtomics.iterator();
                while (en.hasNext()) {
                    errors.addAll(this.typeSet.checkType(en.next()));
                }
            }
            if (!errors.isEmpty()) {
                if (oldLevel == level) {
                    oldLevel = 10;
                }
                this.typeSet.setLevelOfTypeGraphCheck(oldLevel);
            }
            return errors;
        }
        if (oldLevel == level) {
            oldLevel = 0;
        }
        return checkResult;
    }

    public int getLevelOfTypeGraphCheck() {
        return this.typeSet.getLevelOfTypeGraphCheck();
    }

    public void setMorphismCompletionStrategyOfGraphConstraints() {
        int i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i);
            a.setMorphismCompletionStrategy(this.strategy);
            ++i;
        }
    }

    private int getMultiplicityErrorKind(int currentKind, TypeError error) {
        if (currentKind != 25 && error.getErrorNumber() == 25) {
            return error.getErrorNumber();
        }
        if (currentKind == -1) {
            return error.getErrorNumber();
        }
        return currentKind;
    }

    public String checkNodeTypeMultiplicity(Node typeNode) {
        TypeError error;
        int errorkind = -1;
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.itsGraphs.size()) {
            Graph graph = this.itsGraphs.get(i);
            error = this.typeSet.checkNodeTypeMultiplicity(typeNode.getType(), graph, this.getLevelOfTypeGraphCheck());
            if (error != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error);
                result.add(graph.getName());
            }
            ++i;
        }
        i = 0;
        while (i < this.itsRules.size()) {
            Rule rule = this.itsRules.get(i);
            error = this.typeSet.checkNodeTypeMultiplicity(typeNode.getType(), rule.getLeft(), 20);
            if (error != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error);
                result.add(rule.getLeft().getName());
            }
            if ((error = this.typeSet.checkNodeTypeMultiplicity(typeNode.getType(), rule.getRight(), 20)) != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error);
                result.add(rule.getRight().getName());
            }
            List<OrdinaryMorphism> nacs = rule.getNACsList();
            int l = 0;
            while (l < nacs.size()) {
                Graph nacgraph = nacs.get(l).getTarget();
                error = this.typeSet.checkNodeTypeMultiplicity(typeNode.getType(), nacgraph, 20);
                if (error != null) {
                    errorkind = this.getMultiplicityErrorKind(errorkind, error);
                    result.add(nacgraph.getName());
                }
                ++l;
            }
            List<OrdinaryMorphism> pacs = rule.getPACsList();
            int l2 = 0;
            while (l2 < pacs.size()) {
                Graph pacgraph = pacs.get(l2).getTarget();
                error = this.typeSet.checkNodeTypeMultiplicity(typeNode.getType(), pacgraph, 20);
                if (error != null) {
                    errorkind = this.getMultiplicityErrorKind(errorkind, error);
                    result.add(pacgraph.getName());
                }
                ++l2;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i);
            Graph pgraph = a.getConclusion(0).getSource();
            TypeError error2 = this.typeSet.checkNodeTypeMultiplicity(typeNode.getType(), pgraph, 20);
            if (error2 != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error2);
                result.add(pgraph.getName());
            }
            Enumeration<AtomConstraint> concls = a.getConclusions();
            while (concls.hasMoreElements()) {
                Graph cgraph = concls.nextElement().getTarget();
                error2 = this.typeSet.checkNodeTypeMultiplicity(typeNode.getType(), cgraph, 20);
                if (error2 == null) continue;
                errorkind = this.getMultiplicityErrorKind(errorkind, error2);
                result.add(cgraph.getName());
            }
            ++i;
        }
        if (!result.isEmpty()) {
            this.multiplErrKind = errorkind;
        }
        return result.isEmpty() ? null : ((Object)result).toString();
    }

    public String checkEdgeTypeMultiplicity(Arc typeArc) {
        TypeError error;
        int errorkind = -1;
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.itsGraphs.size()) {
            Graph graph = this.itsGraphs.get(i);
            error = this.typeSet.checkEdgeTypeMultiplicity(typeArc, graph, this.getLevelOfTypeGraphCheck());
            if (error != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error);
                result.add(graph.getName());
            }
            ++i;
        }
        i = 0;
        while (i < this.itsRules.size()) {
            Rule rule = this.itsRules.get(i);
            error = this.typeSet.checkEdgeTypeMultiplicity(typeArc, rule.getLeft(), 20);
            if (error != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error);
                result.add(rule.getLeft().getName());
            }
            if ((error = this.typeSet.checkEdgeTypeMultiplicity(typeArc, rule.getRight(), 20)) != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error);
                result.add(rule.getRight().getName());
            }
            List<OrdinaryMorphism> nacs = rule.getNACsList();
            int l = 0;
            while (l < nacs.size()) {
                Graph nacgraph = nacs.get(l).getTarget();
                error = this.typeSet.checkEdgeTypeMultiplicity(typeArc, nacgraph, 20);
                if (error != null) {
                    errorkind = this.getMultiplicityErrorKind(errorkind, error);
                    result.add(nacgraph.getName());
                }
                ++l;
            }
            List<OrdinaryMorphism> pacs = rule.getPACsList();
            int l2 = 0;
            while (l2 < pacs.size()) {
                Graph pacgraph = pacs.get(l2).getTarget();
                error = this.typeSet.checkEdgeTypeMultiplicity(typeArc, pacgraph, 20);
                if (error != null) {
                    errorkind = this.getMultiplicityErrorKind(errorkind, error);
                    result.add(pacgraph.getName());
                }
                ++l2;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i);
            Graph pgraph = a.getConclusion(0).getSource();
            TypeError error2 = this.typeSet.checkEdgeTypeMultiplicity(typeArc, pgraph, 20);
            if (error2 != null) {
                errorkind = this.getMultiplicityErrorKind(errorkind, error2);
                result.add(pgraph.getName());
            }
            Enumeration<AtomConstraint> concls = a.getConclusions();
            while (concls.hasMoreElements()) {
                Graph cgraph = concls.nextElement().getTarget();
                error2 = this.typeSet.checkEdgeTypeMultiplicity(typeArc, cgraph, 20);
                if (error2 == null) continue;
                errorkind = this.getMultiplicityErrorKind(errorkind, error2);
                result.add(cgraph.getName());
            }
            ++i;
        }
        if (!result.isEmpty()) {
            this.multiplErrKind = errorkind;
        }
        return result.isEmpty() ? null : ((Object)result).toString();
    }

    public int getMultiplicityErrorKind() {
        return this.multiplErrKind;
    }

    public boolean checkGraphConstraints(boolean validity) {
        boolean all_valid = true;
        int i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i);
            a.setMorphismCompletionStrategy(this.strategy);
            if (!a.isValid()) {
                this.consistErrMsg = String.valueOf(this.consistErrMsg) + "   " + a.getAtomicName() + "   ";
                all_valid = false;
            }
            ++i;
        }
        if (!all_valid) {
            return false;
        }
        boolean all_good = true;
        this.consistErrMsg = "";
        Vector<Evaluable> atomics = new Vector<Evaluable>();
        atomics.addAll(this.itsAtomics);
        int i2 = 0;
        while (i2 < this.itsConstraints.size()) {
            Formula f = this.itsConstraints.get(i2);
            if (f.isEnabled()) {
                String fn;
                if (!f.isValid()) {
                    fn = f.getAsString(atomics, this.getAtomicNames());
                    this.consistErrMsg = fn.indexOf(91) == -1 ? String.valueOf(this.consistErrMsg) + "   " + f.getName() + " : " + fn.substring(1, fn.length() - 1) + "   " : String.valueOf(this.consistErrMsg) + "   " + f.getName() + " : " + fn.substring(1, fn.length() - 1) + "   ";
                    all_good = false;
                }
                if (!validity && !f.eval(this.itsGraph)) {
                    fn = f.getAsString(atomics, this.getAtomicNames());
                    this.consistErrMsg = fn.indexOf(91) == -1 ? String.valueOf(this.consistErrMsg) + "   " + f.getName() + " : " + fn.substring(0, fn.length()) + "   " : String.valueOf(this.consistErrMsg) + "   " + f.getName() + " : " + fn.substring(1, fn.length() - 1) + "   ";
                    all_good = false;
                }
            }
            ++i2;
        }
        return all_good;
    }

    public boolean checkGraphConsistency(Graph g) {
        return this.checkGraphConsistency(g, this.itsConstraints);
    }

    public boolean checkGraphConsistency(Graph g, List<Formula> constraints) {
        this.consistErrMsg = "";
        boolean all_valid = true;
        int i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i);
            a.setMorphismCompletionStrategy(this.strategy);
            if (!a.isValid()) {
                this.consistErrMsg = String.valueOf(this.consistErrMsg) + "   " + a.getAtomicName() + "   ";
                all_valid = false;
            }
            ++i;
        }
        if (!all_valid) {
            return false;
        }
        Vector<Evaluable> atomics = new Vector<Evaluable>();
        atomics.addAll(this.itsAtomics);
        int i2 = 0;
        while (i2 < constraints.size()) {
            Formula f = constraints.get(i2);
            String fn = f.getAsString(atomics, this.getAtomicNames());
            if (f.isEnabled()) {
                if (!f.isValid()) {
                    this.consistErrMsg = String.valueOf(this.consistErrMsg) + "   " + f.getName() + "   ";
                    return false;
                }
                if (!f.isEvaluable()) {
                    this.consistErrMsg = String.valueOf(this.consistErrMsg) + "   " + f.getName() + "   ";
                    return true;
                }
                if (!f.eval(g)) {
                    this.consistErrMsg = String.valueOf(this.consistErrMsg) + "   " + f.getName() + "   ";
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    public boolean checkAtomics(boolean checkAtomicValidityOnly) {
        this.consistErrMsg = "";
        boolean all_valid = true;
        boolean all_satisfied = true;
        int i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i);
            a.setMorphismCompletionStrategy(this.strategy);
            if (!a.isValid()) {
                this.consistErrMsg = String.valueOf(this.consistErrMsg) + "   " + a.getAtomicName() + "   ";
                all_valid = false;
            }
            if (all_valid && !checkAtomicValidityOnly && !a.eval((Object)this.itsGraph)) {
                this.consistErrMsg = String.valueOf(this.consistErrMsg) + "   " + a.getAtomicName() + "   ";
                all_satisfied = false;
            }
            ++i;
        }
        if (checkAtomicValidityOnly) {
            return all_valid;
        }
        return all_satisfied;
    }

    public String getConsistencyErrorMsg() {
        return this.consistErrMsg;
    }

    public String convertConstraints() {
        String msg = "";
        if (this.itsAtomics.size() <= 0 || this.itsConstraints.size() <= 0) {
            msg = "Atomics or constraints do not exist.";
            return msg;
        }
        Vector<Rule> rs = new Vector<Rule>();
        rs.addAll(this.itsRules);
        int i = 0;
        while (i < rs.size()) {
            int j = 0;
            while (j < this.itsAtomics.size()) {
                AtomConstraint a = this.itsAtomics.get(j);
                if (!a.isValid()) {
                    msg = "Atomic  \"" + a.getAtomicName() + "\"  is not valid";
                    return msg;
                }
                ++j;
            }
            Rule r = (Rule)rs.get(i);
            r.clearConstraints();
            r.setUsedFormulas(this.itsConstraints);
            String msg0 = r.convertUsedFormulas();
            if (!"".equals(msg0)) {
                msg = "Rule  \"" + r.getName() + "\" : \n" + msg0 + "\nConverting constraints to post application conditions failed.";
                return msg;
            }
            ++i;
        }
        return msg;
    }

    public void clearRuleConstraints(AtomConstraint ac) {
        Iterator<Rule> en = this.itsRules.iterator();
        while (en.hasNext()) {
            en.next().clearConstraints(ac);
        }
    }

    public void clearRuleConstraints(Formula f) {
        Iterator<Rule> en = this.itsRules.iterator();
        while (en.hasNext()) {
            en.next().clearConstraints(f);
        }
    }

    public void clearRuleConstraints() {
        Iterator<Rule> en = this.itsRules.iterator();
        while (en.hasNext()) {
            en.next().clearConstraints();
        }
    }

    public void setRuleLayer(RuleLayer rl) {
        for (Rule key : this.getListOfRules()) {
            Integer layer = rl.getRuleLayer().get(key);
            if (layer == null) continue;
            key.setLayer(layer);
        }
    }

    public void unsetLayerTriggerRule() {
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            r.setTriggerForLayer(false);
            ++i;
        }
    }

    public Vector<String> getGraTraOptions() {
        return this.gratraOptions;
    }

    public void setGraTraOptions(Vector<String> opts) {
        this.gratraOptions.clear();
        this.gratraOptions.addAll(opts);
    }

    private void initMorphismCompletionStrategy() {
        this.strategy = CompletionStrategySelector.getDefault();
        this.strategy.setRandomisedDomain(true);
        this.gratraOptions.add("CSP");
        this.gratraOptions.add("injective");
        this.gratraOptions.add("dangling");
        this.gratraOptions.add("identification");
        this.gratraOptions.add("NACs");
        this.gratraOptions.add("PACs");
        this.gratraOptions.add("GACs");
    }

    private void setMorphismCompletionStrategy() {
        if (this.gratraOptions.contains("CSP")) {
            this.strategy = new Completion_NAC(new Completion_InjCSP());
        } else if (this.gratraOptions.contains("CSP w/o BJ")) {
            this.strategy = new Completion_NAC(new Completion_CSP_NoBJ());
        }
        if (this.strategy == null) {
            this.initMorphismCompletionStrategy();
        } else {
            if (!this.gratraOptions.contains("injective")) {
                this.strategy.getProperties().clear(0);
            }
            if (!this.gratraOptions.contains("dangling")) {
                this.strategy.getProperties().clear(1);
            }
            if (!this.gratraOptions.contains("identification")) {
                this.strategy.getProperties().clear(2);
            }
            if (!this.gratraOptions.contains("NACs")) {
                this.strategy.getProperties().clear(3);
            }
            if (!this.gratraOptions.contains("PACs")) {
                this.strategy.getProperties().clear(4);
            }
            if (!this.gratraOptions.contains("GACs")) {
                this.strategy.getProperties().clear(5);
            }
            if (this.gratraOptions.contains("determinedCSPDomain")) {
                this.strategy.setRandomisedDomain(false);
            } else if (this.gratraOptions.contains("randomCSPDomain")) {
                this.strategy.setRandomisedDomain(true);
            }
        }
        this.setMorphismCompletionStrategyOfGraphConstraints();
    }

    public void addGraTraOption(String opt) {
        if (!this.gratraOptions.contains(opt)) {
            this.gratraOptions.add(opt);
            if (opt.equals("determinedCSPDomain")) {
                this.strategy.setRandomisedDomain(false);
            } else if (opt.equals("randomCSPDomain")) {
                this.strategy.setRandomisedDomain(true);
            } else {
                this.strategy.setProperty(opt);
            }
        }
    }

    public void removeGraTraOption(String opt) {
        if (this.gratraOptions.contains(opt)) {
            this.gratraOptions.remove(opt);
            if (opt.equals("determinedCSPDomain")) {
                this.strategy.setRandomisedDomain(true);
            } else {
                this.strategy.removeProperty(opt);
            }
        }
    }

    public void setMorphismCompletionStrategy(MorphCompletionStrategy strat) {
        this.setGraTraOptions(strat);
    }

    public void setGraTraOptions(MorphCompletionStrategy strat) {
        if (strat == null) {
            return;
        }
        this.gratraOptions.clear();
        this.strategy = strat;
        String stratName = CompletionStrategySelector.getName(this.strategy);
        this.gratraOptions.add(stratName);
        BitSet activebits = this.strategy.getProperties();
        int j = 0;
        while (j < CompletionPropertyBits.BITNAME.length) {
            String bitName = CompletionPropertyBits.BITNAME[j];
            if (activebits.get(j)) {
                this.gratraOptions.add(bitName);
            }
            ++j;
        }
        if (!this.strategy.isRandomisedDomain()) {
            this.gratraOptions.add("determinedCSPDomain");
        }
        this.setMorphismCompletionStrategyOfGraphConstraints();
    }

    public boolean compareTo(GraGra gragra, boolean transOption) {
        if (gragra == null) {
            return false;
        }
        boolean checkLayer = false;
        if (transOption) {
            int i = 0;
            while (i < this.gratraOptions.size()) {
                String op = this.gratraOptions.get(i);
                if (!gragra.getGraTraOptions().contains(op)) {
                    return false;
                }
                ++i;
            }
        }
        return this.compareRulesTo(gragra, checkLayer) && this.compareConstraintsTo(gragra);
    }

    public boolean compareTo(GraGra gragra) {
        int j;
        if (!this.getName().equals(gragra.getName())) {
            return false;
        }
        if (!this.getTypeSet().compareTo(gragra.getTypeSet())) {
            return false;
        }
        if (!this.itsGraph.compareTo(gragra.getGraph())) {
            return false;
        }
        Vector<Object> another = new Vector<Object>();
        another.add(gragra.getListOfRules());
        if (this.itsRules.size() != another.size()) {
            return false;
        }
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            Rule r1 = gragra.getRule(r.getName());
            if (r1 != null && r.compareTo(r1)) {
                another.remove(r1);
            }
            ++i;
        }
        if (!another.isEmpty()) {
            return false;
        }
        Enumeration<XMLObject> e = gragra.getAtomics();
        another = new Vector();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.itsAtomics.size() != another.size()) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i2);
            j = another.size() - 1;
            while (j >= 0) {
                AtomConstraint a1 = (AtomConstraint)another.get(j);
                if (a.compareTo(a1)) {
                    another.remove(a1);
                    break;
                }
                --j;
            }
            ++i2;
        }
        if (!another.isEmpty()) {
            return false;
        }
        e = gragra.getConstraints();
        another = new Vector();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.itsConstraints.size() != another.size()) {
            return false;
        }
        i2 = 0;
        while (i2 < this.itsConstraints.size()) {
            Formula f = this.itsConstraints.get(i2);
            j = another.size() - 1;
            while (j >= 0) {
                Formula f1 = (Formula)another.get(j);
                if (f.compareTo(f1)) {
                    another.remove(f1);
                    break;
                }
                --j;
            }
            ++i2;
        }
        return another.isEmpty();
    }

    public boolean compareRulesTo(GraGra gragra, boolean checkLayer) {
        Vector<Rule> another = new Vector<Rule>();
        another.addAll(gragra.getListOfRules());
        if (this.itsRules.size() != another.size()) {
            return false;
        }
        Rule r = null;
        int i = 0;
        while (i < this.itsRules.size()) {
            r = this.itsRules.get(i);
            Rule r1 = gragra.getRule(r.getName());
            if (r1 != null) {
                if (r.compareTo(r1)) {
                    another.remove(r1);
                }
                if (checkLayer && r.getLayer() != r1.getLayer()) {
                    return false;
                }
            }
            ++i;
        }
        return another.isEmpty() || r == null;
    }

    public boolean compareConstraintsTo(GraGra gragra) {
        Vector<AtomConstraint> another = new Vector<AtomConstraint>();
        Enumeration<AtomConstraint> e = gragra.getAtomics();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.itsAtomics.size() != another.size()) {
            return false;
        }
        AtomConstraint a = null;
        int i = 0;
        while (i < this.itsAtomics.size()) {
            a = this.itsAtomics.get(i);
            int j = another.size() - 1;
            while (j >= 0) {
                AtomConstraint a1 = (AtomConstraint)another.get(j);
                if (a.compareTo(a1)) {
                    another.remove(a1);
                    break;
                }
                --j;
            }
            ++i;
        }
        if (!another.isEmpty() && a != null) {
            return false;
        }
        Enumeration<Formula> eF = gragra.getConstraints();
        Vector<Formula> anotherF = new Vector<Formula>();
        while (eF.hasMoreElements()) {
            anotherF.add(eF.nextElement());
        }
        if (this.itsConstraints.size() != anotherF.size()) {
            return false;
        }
        Formula f = null;
        int i2 = 0;
        while (i2 < this.itsConstraints.size()) {
            f = this.itsConstraints.get(i2);
            int j = anotherF.size() - 1;
            while (j >= 0) {
                Formula f1 = (Formula)anotherF.get(j);
                if (f.compareTo(f1)) {
                    anotherF.remove(f1);
                    break;
                }
                --j;
            }
            ++i2;
        }
        return anotherF.isEmpty() || f == null;
    }

    public Vector<Rule> getNonInjectiveRules() {
        Vector<Rule> result = new Vector<Rule>(1);
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.isEnabled() && !r.isInjective()) {
                result.add(r);
            }
            ++i;
        }
        return result;
    }

    public boolean isGraphReadyForTransform() {
        return this.itsGraph.isReadyForTransform();
    }

    public void prepareRuleInfo() {
        int i = 0;
        while (i < this.itsRules.size()) {
            this.itsRules.get(i).prepareRuleInfo();
            ++i;
        }
    }

    public Pair<Object, String> isReadyToTransform(boolean prepareRuleInfo) {
        Pair<Object, String> result = this.isReadyToTransform();
        if (result == null) {
            this.prepareRuleInfo();
        }
        return result;
    }

    public Pair<Object, String> isReadyToTransform() {
        String msg = "";
        Enumeration<Type> e = this.typeSet.getTypes();
        while (e.hasMoreElements()) {
            Type t = e.nextElement();
            if (this.doesAttrTypeExist(t)) continue;
            msg = "Not all attribute members of the type :  \"" + t.getName() + "\"  are declared correctly.";
            return new Pair<Object, String>(t, msg);
        }
        Pair<Object, String> p = this.checkInheritedAttributesValid();
        if (p != null) {
            return p;
        }
        int i = 0;
        while (i < this.itsGraphs.size()) {
            Graph g = this.itsGraphs.get(i);
            if (!g.isReadyForTransform()) {
                msg = "Graph  \"" + g.getName() + "\" : " + "not all attribute set";
                return new Pair<Object, String>(g, msg);
            }
            ++i;
        }
        i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (!r.isReadyToTransform()) {
                msg = "Rule  \"" + r.getName() + "\" : " + r.getErrorMsg();
                return new Pair<Object, String>(r, msg);
            }
            ++i;
        }
        return this.isGraphConstraintReadyForTransform();
    }

    public Pair<Object, String> isGraphConstraintReadyForTransform() {
        int i = 0;
        while (i < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(i);
            if (!a.isValid()) {
                String msg = "Atomic graph constraint  \"" + a.getAtomicName() + "\" is not valid. " + "\nPlease check: " + "\n  - graph morphism ( injective and total )  " + "\n  - attribute context ( variable and condition declarations ).";
                return new Pair<Object, String>(a, msg);
            }
            ++i;
        }
        return null;
    }

    public Type doAttrTypesExist() {
        Enumeration<Type> e = this.typeSet.getTypes();
        while (e.hasMoreElements()) {
            Type t = e.nextElement();
            if (this.doesAttrTypeExist(t)) continue;
            return t;
        }
        return null;
    }

    private boolean doesAttrTypeExist(Type type) {
        if (type.getAttrType() == null) {
            return true;
        }
        boolean isClass = false;
        DeclTuple declTupl = (DeclTuple)type.getAttrType();
        int i = 0;
        while (i < declTupl.getSize()) {
            DeclMember decl = (DeclMember)declTupl.getMemberAt(i);
            String t = decl.getTypeName();
            if (!this.isPrimitiveType(t)) {
                try {
                    Class.forName(t);
                    isClass = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (!isClass) {
                    AttrHandler[] attrHandlers = AttrTupleManager.getDefaultManager().getHandlers();
                    int h = 0;
                    while (h < attrHandlers.length) {
                        AttrHandler attrh = attrHandlers[h];
                        Vector<String> packs = ((JexHandler)attrh).getClassResolver().getPackages();
                        int pi = 0;
                        while (pi < packs.size()) {
                            String pack = packs.get(pi);
                            try {
                                Class.forName(String.valueOf(pack) + "." + t);
                                isClass = true;
                                break;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                ++pi;
                            }
                        }
                        if (isClass) break;
                        ++h;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isPrimitiveType(String t) {
        return "int".equals(t) || "long".equals(t) || "short".equals(t) || "double".equals(t) || "float".equals(t) || "boolean".equals(t) || "char".equals(t) || "byte".equals(t);
    }

    public Pair<Object, String> checkInheritedAttributesValid() {
        if (this.typeSet.getLevelOfTypeGraphCheck() <= 0 && this.typeSet.hasInheritance()) {
            Enumeration<Type> e = this.typeSet.getTypes();
            while (e.hasMoreElements()) {
                Type t = e.nextElement();
                int i = 0;
                while (i < t.getParents().size()) {
                    Type p = t.getParents().get(i);
                    AttrType attrType = p.getAttrType();
                    if (attrType != null && attrType.getNumberOfEntries() != 0) {
                        String msg = "Type  \"" + t.getName() + "\" - inheritance conflict: inherited attributes by disabled type graph.";
                        return new Pair<Object, String>(t, msg);
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public List<Rule> getRulesWithIntegratedMultiRulesOfRuleScheme() {
        Vector<Rule> list = new Vector<Rule>();
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.isEnabled()) {
                if (r.getRuleScheme() == null) {
                    list.add(r);
                } else {
                    RuleScheme rs = r.getRuleScheme();
                    rs.propagateApplCondsOfKernelToMultiRules();
                    int j = 0;
                    while (j < rs.getMultiRules().size()) {
                        Rule mRule = rs.getMultiRules().get(j);
                        list.add(mRule);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return list;
    }

    public List<Rule> getRulesWithIntegratedRulesOfRuleScheme() {
        Vector<Rule> list = new Vector<Rule>();
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.isEnabled()) {
                if (r.getRuleScheme() == null) {
                    list.add(r);
                } else {
                    RuleScheme rs = r.getRuleScheme();
                    rs.propagateApplCondsOfKernelToMultiRules();
                    list.add(rs.getKernelRule());
                    int j = 0;
                    while (j < rs.getMultiRules().size()) {
                        Rule mRule = rs.getMultiRules().get(j);
                        list.add(mRule);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return list;
    }

    public void removeShiftedApplConditionsFromMultiRules() {
        int k = 0;
        while (k < this.itsRules.size()) {
            Rule r = this.itsRules.get(k);
            if (r.getRuleScheme() != null) {
                RuleScheme rs = r.getRuleScheme();
                rs.removeShiftedApplConditionsFromMultiRules();
            }
            ++k;
        }
    }

    public List<Rule> getEnabledRules() {
        Vector<Rule> v = new Vector<Rule>();
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.isEnabled()) {
                v.add(r);
            }
            ++i;
        }
        return v;
    }

    public Vector<Rule> getApplicableRules(MorphCompletionStrategy aStrategy) {
        return this.getApplicableRules(this.itsGraph, aStrategy);
    }

    public Vector<Rule> getApplicableRules(Graph g, MorphCompletionStrategy aStrategy) {
        Vector<Rule> applicableRules = new Vector<Rule>();
        if (!this.itsGraphs.contains(g) && !g.isReadyForTransform()) {
            return applicableRules;
        }
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            if (r.isApplicable(g, aStrategy, false)) {
                r.setApplicable(true);
                applicableRules.add(r);
            } else {
                r.setApplicable(false);
            }
            ++i;
        }
        return applicableRules;
    }

    public void dismissRuleApplicability() {
        int i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            r.setApplicable(true);
            ++i;
        }
    }

    public void storeUsedClassPackages() {
        this.itsPackages.clear();
        InformationFacade info = DefaultInformationFacade.self();
        AttrHandler[] attrHandlers = info.getAttrManager().getHandlers();
        int i = 0;
        while (i < attrHandlers.length) {
            AttrHandler attrHandler = attrHandlers[i];
            Pair<String, List<String>> p = new Pair<String, List<String>>(attrHandler.getName(), ((JexHandler)attrHandler).getClassResolver().getPackages());
            this.addPackage(p);
            ++i;
        }
    }

    public void setUsedClassPackages() {
        InformationFacade info = DefaultInformationFacade.self();
        AttrHandler[] attrHandlers = info.getAttrManager().getHandlers();
        int i = 0;
        while (i < this.itsPackages.size()) {
            Pair<String, List<String>> p = this.itsPackages.get(i);
            String handler = (String)p.first;
            boolean found = false;
            AttrHandler attrHandler = null;
            Vector<Object> hPacks = new Vector(0);
            int h = 0;
            while (h < attrHandlers.length) {
                attrHandler = attrHandlers[h];
                String hName = attrHandler.getName();
                hPacks = ((JexHandler)attrHandler).getClassResolver().getPackages();
                if (hName.equals(handler)) {
                    found = true;
                }
                ++h;
            }
            if (found && attrHandler != null) {
                List packs = (List)p.second;
                int j = 0;
                while (j < packs.size()) {
                    String pack = (String)packs.get(j);
                    if (!hPacks.contains(pack)) {
                        ((JexHandler)attrHandler).appendPackage(pack);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setSubsequencesOfCurrentRuleSequence(List<Pair<List<Pair<String, String>>, String>> sequences) {
        this.itsRuleSequence.setSubsequenceList(sequences);
    }

    public void setCurrentRuleSequence(RuleSequence seq) {
        if (this.itsRuleSequences.contains(seq)) {
            this.itsRuleSequence = seq;
        }
    }

    public RuleSequence getCurrentRuleSequence() {
        return this.itsRuleSequence;
    }

    public int getIndexOfCurrentRuleSequence() {
        if (this.itsRuleSequence != null) {
            return this.itsRuleSequences.indexOf(this.itsRuleSequence);
        }
        return -1;
    }

    public void addRuleSequence(RuleSequence seq) {
        this.itsRuleSequences.add(seq);
        this.itsRuleSequence = seq;
    }

    public void removeRuleSequence(RuleSequence seq) {
        if (this.itsRuleSequence == seq) {
            this.itsRuleSequence = null;
        }
        this.itsRuleSequences.remove(seq);
    }

    public boolean trafoByApplicableRuleSequence() {
        return this.itsRuleSequence != null && this.itsRuleSequence.isTrafoByARS();
    }

    public void setTrafoByApplicableRuleSequence(boolean b) {
        if (this.itsRuleSequence != null) {
            this.itsRuleSequence.setTrafoByARS(b);
        }
    }

    public boolean trafoByRuleSequenceWithObjectFlow() {
        return this.itsRuleSequence != null && this.itsRuleSequence.isTrafoByObjFlow();
    }

    public void setTrafoByRuleSequenceWithObjectFlow(boolean b) {
        if (this.itsRuleSequence != null) {
            this.itsRuleSequence.setTrafoByObjFlow(b);
        }
    }

    public void clearRuleSequences() {
        this.itsRuleSequences.clear();
    }

    public List<RuleSequence> getRuleSequences() {
        return this.itsRuleSequences;
    }

    public List<Pair<List<Pair<String, String>>, String>> getRuleSequenceList() {
        if (this.itsRuleSequence != null) {
            return this.itsRuleSequence.getSubSequenceList();
        }
        return null;
    }

    private void refreshRuleSequences() {
        if (this.itsRuleSequences != null) {
            int i = 0;
            while (i < this.itsRuleSequences.size()) {
                RuleSequence ruleSeq = this.itsRuleSequences.get(i);
                boolean dorefresh = false;
                int j = 0;
                while (j < ruleSeq.getSubSequenceList().size()) {
                    Pair<List<Pair<String, String>>, String> grp = ruleSeq.getSubSequenceList().get(j);
                    List grpRules = (List)grp.first;
                    int k = 0;
                    while (k < grpRules.size()) {
                        Pair p = (Pair)grpRules.get(k);
                        String rulename = (String)p.first;
                        if (this.getRule(rulename) == null) {
                            grpRules.remove(k);
                            --k;
                            dorefresh = true;
                        }
                        ++k;
                    }
                    ++j;
                }
                if (dorefresh) {
                    ruleSeq.refresh();
                    ruleSeq.uncheck();
                }
                ++i;
            }
        }
    }

    private void updateTypeObjectsMapOfGraphs() {
        int i = 0;
        while (i < this.itsGraphs.size()) {
            Graph g = this.itsGraphs.get(i);
            g.updateTypeObjectsMap();
            ++i;
        }
    }

    public void createAttrInstanceWhereNeeded() {
        int i = 0;
        while (i < this.itsGraphs.size()) {
            this.itsGraphs.get(i).createAttrInstanceWhereNeeded();
            ++i;
        }
        i = 0;
        while (i < this.itsRules.size()) {
            this.itsRules.get(i).createAttrInstanceWhereNeeded();
            ++i;
        }
        i = 0;
        while (i < this.itsAtomics.size()) {
            this.itsAtomics.get(i).createAttrInstanceWhereNeeded();
            ++i;
        }
        this.itsStartGraph.createAttrInstanceWhereNeeded();
    }

    public void createAttrInstanceOfTypeWhereNeeded(Type t) {
        int i = 0;
        while (i < this.itsGraphs.size()) {
            this.itsGraphs.get(i).createAttrInstanceOfTypeWhereNeeded(t);
            ++i;
        }
        i = 0;
        while (i < this.itsRules.size()) {
            this.itsRules.get(i).createAttrInstanceOfTypeWhereNeeded(t);
            ++i;
        }
        i = 0;
        while (i < this.itsAtomics.size()) {
            this.itsAtomics.get(i).createAttrInstanceOfTypeWhereNeeded(t);
            ++i;
        }
        this.itsStartGraph.createAttrInstanceOfTypeWhereNeeded(t);
    }

    private void initRuleSubsets() {
        if (this.ruleSets != null) {
            this.ruleSets.clear();
        }
        this.ruleSets = new Hashtable();
        Vector<Rule> set = new Vector<Rule>(this.itsRules);
        this.ruleSets.put(1, set);
    }

    public void removeRuleSubsets() {
        if (this.ruleSets != null) {
            this.ruleSets.clear();
            this.ruleSets = null;
        }
    }

    public void addRuleSubset(List<Rule> set) {
        if (this.ruleSets == null) {
            this.initRuleSubsets();
        }
        this.ruleSets.put(this.ruleSets.size(), set);
    }

    public Hashtable<Integer, List<Rule>> getRuleSubsets() {
        return this.ruleSets;
    }

    public void save(String filename) {
        String ggx = ".ggx";
        this.storeUsedClassPackages();
        String outfileName = "";
        if ("".equals(filename)) {
            outfileName = String.valueOf(this.itsName) + "_out.ggx";
        } else {
            outfileName = filename;
            if (outfileName.indexOf(ggx) == -1) {
                outfileName = outfileName.concat(ggx);
            }
        }
        if (outfileName.endsWith(ggx)) {
            XMLHelper xmlh = new XMLHelper();
            xmlh.addTopObject(this);
            xmlh.save_to_xml(outfileName);
            File f = new File(outfileName);
            if (f.exists()) {
                this.fileName = f.getName();
                this.dirName = f.getParent() == null ? "." + File.separator : String.valueOf(f.getParent()) + File.separator;
            }
        }
    }

    public void save(String dirname, String filename) {
        String fullname = dirname.concat(File.separator).concat(filename);
        this.save(fullname);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) throw new Exception("File  \"" + filename + "\"  doesn't exist!");
        if (!filename.endsWith(".ggx")) throw new Exception("File  \"" + filename + "\"  is not a  \".ggx\"  file!");
        XMLHelper h = new XMLHelper();
        if (!h.read_from_xml(filename)) throw new Exception("File  \"" + filename + "\"  is not an  AGG  file!");
        h.getTopObject(this);
        this.fileName = f.getName();
        this.dirName = f.getParent() == null ? "." + File.separator : String.valueOf(f.getParent()) + File.separator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) throw new Exception("File  \"" + filename + "\"  does not exist!");
        if (!filename.endsWith(".ggx")) throw new Exception("File  \"" + filename + "\"  is not a  \".ggx\"  file!");
        XMLHelper h = new XMLHelper();
        if (!h.read_from_xml(filename)) {
            throw new Exception("File  \"" + filename + "\"  is not an AGG file!");
        }
        h.getTopObject(this);
        this.fileName = f.getName();
        this.dirName = f.getParent() != null ? String.valueOf(f.getParent()) + File.separator : "." + File.separator;
        this.setUsedClassPackages();
    }

    private void saveXML(XMLHelper h) {
        int i;
        this.storeUsedClassPackages();
        if (this.itsPackages != null && !this.itsPackages.isEmpty()) {
            i = 0;
            while (i < this.itsPackages.size()) {
                Pair<String, List<String>> p = this.itsPackages.get(i);
                String attrHand = (String)p.first;
                h.openSubTag("TaggedValue");
                h.addAttr("Tag", "AttrHandler");
                h.addAttr("TagValue", attrHand);
                List v = (List)p.second;
                int j = 0;
                while (j < v.size()) {
                    String n = (String)v.get(j);
                    h.openSubTag("TaggedValue");
                    h.addAttr("Tag", "Package");
                    h.addAttr("TagValue", n);
                    h.close();
                    ++j;
                }
                h.close();
                ++i;
            }
        }
        i = 0;
        while (i < this.gratraOptions.size()) {
            h.openSubTag("TaggedValue");
            h.addAttr("Tag", this.gratraOptions.get(i));
            h.addAttr("TagValue", "true");
            h.close();
            ++i;
        }
        h.openSubTag("TaggedValue");
        h.addAttr("Tag", "TypeGraphLevel");
        switch (this.typeSet.getLevelOfTypeGraphCheck()) {
            case 10: {
                h.addAttr("TagValue", "ENABLED");
                break;
            }
            case 20: {
                h.addAttr("TagValue", "ENABLED_MAX");
                break;
            }
            case 30: {
                h.addAttr("TagValue", "ENABLED_MAX_MIN");
                break;
            }
            default: {
                h.addAttr("TagValue", "DISABLED");
            }
        }
        h.close();
        h.openSubTag("Types");
        h.addEnumeration("", this.getTypes(), true);
        h.addObject("", this.typeSet.getTypeGraph(), true);
        h.close();
        i = 0;
        while (i < this.itsGraphs.size()) {
            this.itsGraphs.get(i).setKind("HOST");
            ++i;
        }
        h.addList("", this.itsGraphs, true);
        if (!this.itsAtomics.isEmpty()) {
            h.openSubTag("Constraints");
            h.addList("", this.getListOfAtomics(), true);
            if (!this.itsConstraints.isEmpty()) {
                for (Formula f : this.itsConstraints) {
                    Vector<Evaluable> atomics = new Vector<Evaluable>();
                    atomics.addAll(this.getListOfAtomicObjects());
                    String s = f.getAsString(atomics);
                    h.addObjectSub(f);
                    h.peekObject(f, null);
                    h.addAttr("f", s);
                    h.close();
                }
            }
            h.close();
        }
        i = 0;
        while (i < this.itsRules.size()) {
            Rule r = this.itsRules.get(i);
            r.getSource().setKind("LHS");
            r.getTarget().setKind("RHS");
            if (r instanceof RuleScheme) {
                ((RuleScheme)r).storeIndexOfRuleList(i);
            }
            ++i;
        }
        h.addList("", this.itsRules, true);
        if (!this.itsMatches.isEmpty()) {
            h.openSubTag("Matches");
            i = 0;
            while (i < this.itsMatches.size()) {
                Match m = this.itsMatches.get(i);
                if (m != null && m.getRule() != null && !m.isEmpty()) {
                    m.setName("MatchOf_" + m.getRule().getName());
                    h.openSubTag("MatchOf");
                    h.addObject("Rule", m.getRule(), false);
                    h.addObject("", m, true);
                    h.close();
                }
                ++i;
            }
            h.close();
        }
        if (this.itsRuleSequences != null && !this.itsRuleSequences.isEmpty()) {
            h.openSubTag("RuleSequences");
            i = 0;
            while (i < this.itsRuleSequences.size()) {
                RuleSequence seq = this.itsRuleSequences.get(i);
                h.openSubTag("Sequence");
                h.addAttr("name", seq.getName());
                if (seq.isTrafoByARS()) {
                    h.addAttr("trafoByARS", "true");
                }
                if (seq.isTrafoByObjFlow()) {
                    h.addAttr("trafoByOF", "true");
                }
                if (seq.getGraph() != null) {
                    h.openSubTag("Graph");
                    h.addObject("id", seq.getGraph(), false);
                    h.close();
                }
                List<Pair<List<Pair<String, String>>, String>> seqList = seq.getSubSequenceList();
                int j = 0;
                while (j < seqList.size()) {
                    Pair<List<Pair<String, String>>, String> pi = seqList.get(j);
                    h.openSubTag("Subsequence");
                    h.addAttr("iterations", (String)pi.second);
                    List v = (List)pi.first;
                    int k = 0;
                    while (k < v.size()) {
                        Pair pj = (Pair)v.get(k);
                        h.openSubTag("Item");
                        h.addAttr("rule", (String)pj.first);
                        h.addAttr("iterations", (String)pj.second);
                        h.close();
                        ++k;
                    }
                    h.close();
                    ++j;
                }
                if (seq.isObjFlowDefined()) {
                    Enumeration<String> keys = seq.getObjectFlow().keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        ObjectFlow objFlow = seq.getObjectFlow().get(key);
                        h.openSubTag("ObjectFlow");
                        h.addAttr("enabled", String.valueOf(seq.isObjFlowEnabled()));
                        h.addAttr("index", key);
                        if (objFlow.isGraphExtended() && objFlow.getIndexOfOutput() == 0) {
                            h.addAttr("output", ((Graph)objFlow.getSourceOfOutput()).getName());
                        } else if (((Rule)objFlow.getSourceOfOutput()).getRuleScheme() == null) {
                            h.addAttr("output", ((Rule)objFlow.getSourceOfOutput()).getName());
                        } else {
                            h.addAttr("output", String.valueOf(((Rule)objFlow.getSourceOfOutput()).getRuleScheme().getName()) + "." + ((Rule)objFlow.getSourceOfOutput()).getName());
                        }
                        if (((Rule)objFlow.getSourceOfInput()).getRuleScheme() == null) {
                            h.addAttr("input", ((Rule)objFlow.getSourceOfInput()).getName());
                        } else {
                            h.addAttr("input", String.valueOf(((Rule)objFlow.getSourceOfInput()).getRuleScheme().getName()) + "." + ((Rule)objFlow.getSourceOfInput()).getName());
                        }
                        Enumeration<Object> elems = objFlow.getMapping().keys();
                        while (elems.hasMoreElements()) {
                            GraphObject o = (GraphObject)elems.nextElement();
                            h.openSubTag("Mapping");
                            h.addObject("orig", o, false);
                            h.addObject("image", (GraphObject)objFlow.getMapping().get(o), false);
                            h.close();
                        }
                        h.close();
                    }
                }
                h.close();
                ++i;
            }
            h.close();
        }
        this.updateTypeObjectsMapOfGraphs();
        int tgl_check = this.typeSet.getLevelOfTypeGraphCheck();
        if (this.typeSet.getLevelOfTypeGraphCheck() == 30) {
            this.typeSet.setLevelOfTypeGraphCheck(20);
        }
        this.itsStartGraph = this.cloneGraph();
        this.typeSet.setLevelOfTypeGraphCheck(tgl_check);
    }

    private void loadXML(XMLHelper h) {
        String s;
        Formula f;
        AtomConstraint ac;
        int loadedLevel = 0;
        boolean tgl_ENABLED_MAX_MIN = false;
        this.gratraOptions.clear();
        String v = "";
        String v1 = "";
        String tag = "";
        boolean taggedvalue = true;
        while (taggedvalue) {
            if (tag.equals("AttrHandler")) {
                v = h.readAttr("TagValue");
                Vector<String> packs = new Vector<String>(0);
                boolean isPackage = true;
                while (isPackage && h.readSubTag("TaggedValue")) {
                    String tag1 = h.readAttr("Tag").trim();
                    if (tag1.equals("Package")) {
                        v1 = h.readAttr("TagValue");
                        if (!v1.isEmpty()) {
                            packs.add(v1.trim());
                        }
                        h.close();
                        continue;
                    }
                    isPackage = false;
                }
                packs.remove("genged.alphabet.datatypes");
                packs.remove("com.objectspace.jgl");
                Pair p = new Pair(v, packs);
                this.itsPackages.add(p);
                h.close();
                this.setUsedClassPackages();
            }
            if (h.readSubTag("TaggedValue")) {
                v = null;
                tag = h.readAttr("Tag").trim();
                v1 = h.readAttr("TagValue");
                if (!v1.isEmpty()) {
                    v = v1.trim();
                }
                if (tag.equals("AttrHandler")) continue;
                if (tag.equalsIgnoreCase("TypeGraphLevel")) {
                    if (v != null && !"".equals(v)) {
                        if (v.equalsIgnoreCase("ENABLED")) {
                            loadedLevel = 10;
                        } else if (v.equalsIgnoreCase("ENABLED_MAX")) {
                            loadedLevel = 20;
                        } else if (v.equalsIgnoreCase("ENABLED_MAX_MIN")) {
                            loadedLevel = 20;
                            tgl_ENABLED_MAX_MIN = true;
                        } else if (v.equalsIgnoreCase("DISABLED")) {
                            loadedLevel = 0;
                        }
                    } else {
                        loadedLevel = 0;
                    }
                } else if (v != null && !"".equals(v)) {
                    if (v.equalsIgnoreCase("true")) {
                        this.gratraOptions.add(tag);
                    }
                } else {
                    this.gratraOptions.add(tag);
                }
                h.close();
                continue;
            }
            taggedvalue = false;
        }
        boolean attributed = false;
        if (h.readSubTag("Types")) {
            Type t = null;
            Enumeration<Element> en = h.getEnumeration("", null, true, "Type");
            while (en.hasMoreElements()) {
                System.out.println(String.valueOf(this.itsName) + "   old format  Type  !");
                h.peekElement(en.nextElement());
                t = this.createType();
                h.loadObject(t);
                h.close();
                if (t.getAttrType() == null || t.getAttrType().getNumberOfEntries() == 0) continue;
                attributed = true;
            }
            en = h.getEnumeration("", null, true, "NodeType");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = this.createNodeType(false);
                h.loadObject(t);
                h.close();
                if (t.getAttrType() != null && t.getAttrType().getNumberOfEntries() != 0) {
                    attributed = true;
                }
                if (!t.getAdditionalRepr().equals("") && t.getAdditionalRepr().indexOf("Color") != -1) continue;
                t.setAdditionalRepr("NODE");
            }
            en = h.getEnumeration("", null, true, "EdgeType");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = this.createArcType(false);
                h.loadObject(t);
                h.close();
                if (t.getAttrType() != null && t.getAttrType().getNumberOfEntries() != 0) {
                    attributed = true;
                }
                if (!t.getAdditionalRepr().equals("") && t.getAdditionalRepr().indexOf("Color") != -1) continue;
                t.setAdditionalRepr("EDGE");
            }
            if (h.readSubTag("Graph")) {
                Graph tg = this.createTypeGraph();
                h.loadObject(tg);
                h.close();
                this.typeSet.setLevelOfTypeGraph(0);
                this.getTypeGraph().attributed = attributed;
                this.getTypeGraph().setKind("TG");
            }
            h.close();
            this.typeSet.refreshInheritanceArcs();
        }
        if (this.typeSet.getTypeGraph() == null) {
            this.typeSet.setLevelOfTypeGraph(0);
        } else if (loadedLevel != 0 && loadedLevel != -1) {
            this.typeSet.setLevelOfTypeGraph(10);
        }
        this.itsGraphs.clear();
        List<Element> graphList = h.getList("", null, true, "Graph");
        Iterator<Element> graphIter = graphList.iterator();
        while (graphIter.hasNext()) {
            h.peekElement(graphIter.next());
            Graph g = this.createGraph();
            h.loadObject(g);
            h.close();
            g.attributed = attributed;
        }
        if (this.itsGraphs.isEmpty()) {
            this.itsGraphs.add(BaseFactory.theFactory().createGraph(this.typeSet));
        }
        this.itsGraph = this.itsGraphs.get(0);
        boolean gcAtomicsLoaded = false;
        Enumeration<Element> en = h.getEnumeration("", null, true, "Graphconstraint_Atomic");
        if (en.hasMoreElements()) {
            gcAtomicsLoaded = true;
        }
        while (en.hasMoreElements()) {
            h.peekElement(en.nextElement());
            ac = this.createAtomic("");
            h.loadObject(ac);
            h.close();
            ac.getSource().setKind("PREMISE");
            ac.getTarget().setKind("CONCLUSION");
        }
        if (gcAtomicsLoaded) {
            if (h.readSubTag("Constraints")) {
                en = h.getEnumeration("", null, true, "Formula");
                while (en.hasMoreElements()) {
                    h.peekElement(en.nextElement());
                    f = (Formula)h.loadObject(this.createConstraint(""));
                    if (f != null) {
                        s = h.readAttr("f");
                        f.setFormula(this.getListOfAtomicObjects(), s);
                        s = h.readAttr("name");
                        f.setName(s);
                    }
                    h.close();
                }
                h.close();
            }
        } else if (h.readSubTag("Constraints")) {
            en = h.getEnumeration("", null, true, "Graphconstraint_Atomic");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                ac = this.createAtomic("");
                h.loadObject(ac);
                h.close();
            }
            this.itsAtomics.trimToSize();
            en = h.getEnumeration("", null, true, "Formula");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                f = (Formula)h.loadObject(this.createConstraint(""));
                if (f != null) {
                    s = h.readAttr("f");
                    f.setFormula(this.getListOfAtomicObjects(), s);
                }
                h.close();
            }
            h.close();
        }
        boolean hasGACs = false;
        Vector<Rule> rulesWithGC = new Vector<Rule>();
        this.itsRules.clear();
        Enumeration<Element> en1 = h.getEnumeration("", null, true, "Rule");
        while (en1.hasMoreElements()) {
            h.peekElement(en1.nextElement());
            Rule r = this.createRule();
            h.loadObject(r);
            boolean bl = hasGACs = hasGACs || r.hasNestedACs();
            if (!r.getUsedAtomics().isEmpty()) {
                rulesWithGC.add(r);
            }
            h.close();
        }
        Enumeration<Element> en2 = h.getEnumeration("", null, true, "RuleScheme");
        while (en2.hasMoreElements()) {
            h.peekElement(en2.nextElement());
            RuleScheme rs = this.createRuleScheme();
            h.loadObject(rs);
            hasGACs = hasGACs || rs.hasNestedACs();
            h.close();
            if (rs.getStoredIndexOfRuleList() < 0 || rs.getStoredIndexOfRuleList() >= this.itsRules.size() - 1) continue;
            this.itsRules.remove(rs);
            this.itsRules.add(rs.getStoredIndexOfRuleList(), rs);
        }
        this.itsRules.trimToSize();
        if (!hasGACs && !this.gratraOptions.contains("GACs")) {
            this.gratraOptions.add("GACs");
        }
        this.itsMatches.clear();
        if (h.readSubTag("Matches")) {
            boolean nextMatch = true;
            while (nextMatch) {
                if (h.readSubTag("MatchOf")) {
                    XMLObject obj = h.getObject("Rule", null, false);
                    if (obj instanceof Rule) {
                        Rule r = (Rule)obj;
                        Match m = this.createMatch(r);
                        h.getObject("Match", m, true);
                        if (m.getSize() > 0) {
                            m.setPartialMorphismCompletion(true);
                        }
                    }
                    h.close();
                    continue;
                }
                nextMatch = false;
            }
            h.close();
        }
        this.itsRuleSequences.clear();
        if (h.readSubTag("RuleSequences")) {
            boolean newformat = false;
            while (h.readSubTag("Sequence")) {
                String ruleIters;
                String ruleName2;
                this.itsRuleSequence = new RuleSequence(this, "RuleSequence");
                this.itsRuleSequences.add(this.itsRuleSequence);
                String strName = h.readAttr("name");
                if ("true".equals(h.readAttr("trafoByARS"))) {
                    this.itsRuleSequence.setTrafoByARS(true);
                }
                if ("true".equals(h.readAttr("trafoByOF"))) {
                    this.itsRuleSequence.setTrafoByObjFlow(true);
                }
                while (h.readSubTag("Subsequence")) {
                    newformat = true;
                    Vector<Pair<String, String>> vec = new Vector<Pair<String, String>>();
                    String iters = h.readAttr("iterations");
                    while (h.readSubTag("Item")) {
                        ruleName2 = h.readAttr("rule");
                        ruleIters = h.readAttr("iterations");
                        vec.add(new Pair<String, String>(ruleName2, ruleIters));
                        h.close();
                    }
                    try {
                        this.itsRuleSequence.getSubSequenceList().add(new Pair(vec, iters));
                    }
                    catch (NumberFormatException ruleName2) {
                        // empty catch block
                    }
                    h.close();
                }
                if (newformat) {
                    if (h.readSubTag("Graph")) {
                        Graph g = (Graph)h.getObject("id", null, false);
                        if (g != null) {
                            this.itsRuleSequence.setGraph(g);
                            this.itsRuleSequence.setCheckAtGraph(true);
                        }
                        h.close();
                    }
                    if (!strName.equals("")) {
                        this.itsRuleSequence.setName(strName);
                    }
                    while (h.readSubTag("ObjectFlow")) {
                        String sourceInputName;
                        Rule sourceInput;
                        String enabledStr = h.readAttr("enabled");
                        if (!"".equals(enabledStr)) {
                            this.itsRuleSequence.enableObjFlow(Boolean.valueOf(enabledStr));
                        }
                        String indxStr = h.readAttr("index");
                        String[] indx = indxStr.split(":");
                        int indx1 = -1;
                        try {
                            indx1 = Integer.valueOf(indx[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int indx2 = -1;
                        try {
                            indx2 = Integer.valueOf(indx[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        String sourceOutputName = h.readAttr("output");
                        ExtObservable sourceOutput = this.getRule(sourceOutputName);
                        if (sourceOutput != null) {
                            if (indx1 == 0 && this.itsRuleSequence.getGraph() != null) {
                                sourceOutput = null;
                            }
                        } else {
                            sourceOutput = this.getGraph(sourceOutputName);
                            if (indx1 != 0) {
                                sourceOutput = null;
                            }
                        }
                        if ((sourceInput = this.getRule(sourceInputName = h.readAttr("input"))) != null && indx2 == 0) {
                            sourceInput = null;
                        }
                        if (sourceOutput != null && sourceInput != null && indx1 != -1 && indx2 != -1) {
                            ObjectFlow objFlow = new ObjectFlow(sourceOutput, sourceInput, indx1, indx2);
                            while (h.readSubTag("Mapping")) {
                                XMLObject o1 = h.getObject("orig", null, false);
                                XMLObject o2 = h.getObject("image", null, false);
                                if (o1 != null && o2 != null) {
                                    objFlow.addMapping(o1, o2);
                                }
                                h.close();
                            }
                            if (!objFlow.isEmpty()) {
                                this.itsRuleSequence.addObjFlow(objFlow);
                            }
                        }
                        h.close();
                    }
                } else {
                    String iters = h.readAttr("iterations");
                    if (!"".equals(iters)) {
                        Vector<Pair<String, String>> vec = new Vector<Pair<String, String>>();
                        while (h.readSubTag("Item")) {
                            ruleName2 = h.readAttr("rule");
                            ruleIters = h.readAttr("iterations");
                            vec.add(new Pair<String, String>(ruleName2, ruleIters));
                            h.close();
                        }
                        try {
                            this.itsRuleSequence.getSubSequenceList().add(new Pair(vec, iters));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.itsRuleSequence.setGraph(this.getGraph());
                    this.itsRuleSequence.setCheckAtGraph(true);
                }
                h.close();
                this.itsRuleSequence.getMatchSequence().reinit(this.itsRuleSequence);
                this.itsRuleSequence.makeFlatSequence();
            }
            h.close();
            if (!this.itsRuleSequences.isEmpty()) {
                this.itsRuleSequence = this.itsRuleSequences.get(0);
            }
        }
        if (tgl_ENABLED_MAX_MIN) {
            loadedLevel = 30;
        }
        if (loadedLevel == 20 || loadedLevel == 30) {
            this.setLevelOfTypeGraphCheck(loadedLevel);
        } else {
            this.typeSet.setLevelOfTypeGraph(loadedLevel);
        }
        this.setMorphismCompletionStrategy();
        this.refreshConstraints();
        int j = 0;
        while (j < this.itsAtomics.size()) {
            AtomConstraint a = this.itsAtomics.get(j);
            a.isValid();
            ++j;
        }
        int i = 0;
        while (i < rulesWithGC.size()) {
            Rule r = this.itsRules.get(i);
            if (!r.getUsedAtomics().isEmpty()) {
                r.convertUsedFormulas();
            }
            ++i;
        }
        rulesWithGC.clear();
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("GraphTransformationSystem", this);
        h.addAttr("name", this.itsName);
        h.addAttr("directed", String.valueOf(this.typeSet.isArcDirected()));
        h.addAttr("parallel", String.valueOf(this.typeSet.isArcParallel()));
        if (!"".equals(this.comment)) {
            h.addAttr("comment", this.comment);
        }
        this.saveXML(h);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        this.clear();
        if (h.isTag("GraphTransformationSystem", this)) {
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            str = h.readAttr("directed");
            if (!"".equals(str)) {
                this.typeSet.setArcDirected(Boolean.valueOf(str));
            }
            if (!"".equals(str = h.readAttr("parallel"))) {
                this.typeSet.setArcParallel(Boolean.valueOf(str));
            }
            if (!"".equals(str = h.readAttr("comment"))) {
                this.comment = str;
            }
            this.loadXML(h);
            h.close();
            this.isReadyToTransform();
            return;
        }
        if (h.isTag("CriticalPairs", this) && h.readSubTag("GraphTransformationSystem")) {
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            str = h.readAttr("comment");
            if (!"".equals(str)) {
                this.comment = str;
            }
            this.loadXML(h);
            h.close();
            this.trimToSize();
            this.isReadyToTransform();
        }
    }
}

