/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrException;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomConstraint;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.Version;
import agg.xt_basis.agt.RuleScheme;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class RuleSequencesGraTraImpl
extends GraTra {
    protected boolean appliedOnce;
    protected boolean eachRuleToApply;
    protected boolean trafoSequenceBroken;
    protected boolean allRulesEnabled = false;
    protected int indx = -1;
    protected RuleSequence ruleSequence;
    protected List<Pair<List<Pair<Rule, String>>, String>> ruleSubsequences;
    protected List<String> ruleNameSequences;
    protected File f;
    protected FileOutputStream os;
    protected String protocolFileName = "";
    protected boolean grammarChecked;
    protected long time;

    @Override
    public void dispose() {
        this.clearRuleSequence();
        super.dispose();
    }

    @Override
    public boolean setGraGra(GraGra gg) {
        boolean res = super.setGraGra(gg);
        if (this.grammar.getRuleSequenceList() != null) {
            this.setRuleSequence(this.grammar.getRuleSequenceList());
        }
        return res;
    }

    public void setEachRuleToApply(boolean b) {
        this.eachRuleToApply = b;
    }

    public boolean isEachRuleToApply() {
        return this.eachRuleToApply;
    }

    @Override
    public boolean apply() {
        if (this.ruleSequence != null) {
            this.addGraTraListener(this.ruleSequence);
        }
        int i = 0;
        while (i < this.ruleSubsequences.size() && !this.stopping) {
            String rs = String.valueOf(i + 1) + ". subsequence: " + this.ruleNameSequences.get(i);
            if (this.ruleSubsequences.size() > 1) {
                System.out.println(rs);
            }
            if (this.os != null) {
                this.writeTransformProtocol(rs);
            }
            Pair<List<Pair<Rule, String>>, String> p = this.ruleSubsequences.get(i);
            this.apply((List)p.first, (String)p.second);
            if (this.os != null) {
                this.writeTransformProtocol(String.valueOf(rs) + "\t applied");
            }
            ++i;
        }
        if (this.ruleSequence != null) {
            this.removeGraTraListener(this.ruleSequence);
        }
        return this.appliedOnce;
    }

    public void setRuleSequence(RuleSequence ruleSeq) {
        this.ruleSequence = ruleSeq;
        this.setRuleSequence(ruleSeq.getSubSequenceList());
    }

    protected void setRuleSequence(List<Pair<List<Pair<String, String>>, String>> sequence) {
        this.ruleSubsequences = new Vector<Pair<List<Pair<Rule, String>>, String>>(sequence.size());
        int i = 0;
        while (i < sequence.size()) {
            Pair<List<Pair<String, String>>, String> pi = sequence.get(i);
            List v = (List)pi.first;
            Vector<Pair<Rule, String>> vec = new Vector<Pair<Rule, String>>(v.size());
            int j = 0;
            while (j < v.size()) {
                Pair pj = (Pair)v.get(j);
                Rule r = this.grammar.getRuleByQualifiedName((String)pj.first);
                Pair<Rule, String> p = new Pair<Rule, String>(r, (String)pj.second);
                vec.add(p);
                ++j;
            }
            this.ruleSubsequences.add(new Pair(vec, (String)pi.second));
            ++i;
        }
    }

    protected void clearRuleSequence() {
        int i = 0;
        while (i < this.ruleSubsequences.size()) {
            Pair<List<Pair<Rule, String>>, String> pi = this.ruleSubsequences.get(i);
            List v = (List)pi.first;
            int j = 0;
            while (j < v.size()) {
                ((Pair)v.get((int)j)).first = null;
                ++j;
            }
            v.clear();
            ++i;
        }
        this.ruleSubsequences.clear();
    }

    protected void apply(Rule r, String iters) {
        boolean ruleapplied = true;
        if (iters.equals("*")) {
            int i = 0;
            while (ruleapplied && !this.stopping) {
                if (this.options.hasOption("waitAfterStep")) {
                    this.fireGraTra(new GraTraEvent((Object)this, 22, r));
                }
                if (this.ruleSequence.isTrafoByObjFlow() && !this.ruleSequence.getObjectFlow().isEmpty()) {
                    if (this.ruleSequence.getRule(this.indx) != r || this.ruleSequence.getRule(this.indx - 1) != r) {
                        ++this.indx;
                        this.ruleSequence.getMatchSequence().setTrafoIndex(this.indx);
                    }
                    this.propagateObjFlowOfRule(this.indx, r);
                }
                if (ruleapplied = this.currentRule.getRuleScheme() != null ? this.apply((RuleScheme)this.currentRule) : this.apply(r)) {
                    ++i;
                    this.appliedOnce = true;
                }
                System.out.println(String.valueOf(r.getName()) + " \t applied:  " + ruleapplied);
                if (this.os != null) {
                    this.writeTransformProtocol(String.valueOf(r.getName()) + " \t applied:  " + ruleapplied);
                }
                if ((i != 0 || ruleapplied || !this.eachRuleToApply) && this.isGraphConsistent()) continue;
                this.stopping = true;
                this.trafoSequenceBroken = true;
            }
        } else {
            long N = new Long(iters);
            long i = 0L;
            while (i < N && !this.stopping) {
                if (this.options.hasOption("waitAfterStep")) {
                    this.fireGraTra(new GraTraEvent((Object)this, 22, r));
                }
                if (this.ruleSequence.isTrafoByObjFlow() && !this.ruleSequence.getObjectFlow().isEmpty()) {
                    ++this.indx;
                    this.ruleSequence.getMatchSequence().setTrafoIndex(this.indx);
                    this.propagateObjFlowOfRule(this.indx, r);
                }
                if (!this.stopping) {
                    ruleapplied = this.currentRule.getRuleScheme() != null ? this.apply((RuleScheme)this.currentRule) : this.apply(r);
                    if (ruleapplied) {
                        this.appliedOnce = true;
                    }
                    System.out.println(String.valueOf(r.getName()) + " \t applied:  " + ruleapplied);
                    if (this.os != null) {
                        this.writeTransformProtocol(String.valueOf(r.getName()) + " \t applied:  " + ruleapplied);
                    }
                    if (i == 0L && !ruleapplied && this.eachRuleToApply || !this.isGraphConsistent()) {
                        this.stopping = true;
                        this.trafoSequenceBroken = true;
                    }
                }
                ++i;
            }
        }
    }

    private void propagateObjFlowOfRule(int ind, Rule r) {
        Hashtable<GraphObject, GraphObject> matchMap;
        Hashtable<GraphObject, GraphObject> hashtable = matchMap = r.getRuleScheme() == null ? this.ruleSequence.getMatchSequence().getMatch(ind, r) : this.ruleSequence.getMatchSequence().getMatch(ind, r.getRuleScheme().getKernelRule());
        if (r.getMatch() == null) {
            this.currentMatch = r.getRuleScheme() == null ? this.grammar.createMatch(r) : r.getRuleScheme().getKernelMatch(this.grammar.getGraph());
            this.currentMatch.setCompletionStrategy((MorphCompletionStrategy)this.strategy.clone(), true);
        } else {
            Match match = this.currentMatch = r.getRuleScheme() == null ? r.getMatch() : r.getRuleScheme().getKernelMatch(this.grammar.getGraph());
        }
        if (matchMap != null && !matchMap.isEmpty()) {
            try {
                this.currentMatch.addMapping(matchMap);
                this.currentMatch.setPartialMorphismCompletion(true);
                this.currentMatch.adaptAttrContextValues(this.currentMatch.getRule().getAttrContext());
                this.currentMatch.adaptAttrContextValuesFromExistingObjMapping();
            }
            catch (BadMappingException ex) {
                this.fireGraTra(new GraTraEvent(this, 3, this.currentMatch, ex.getMessage()));
                this.currentMatch.clear();
                this.stopping = true;
                this.trafoSequenceBroken = true;
            }
        }
    }

    protected boolean apply(List<Pair<Rule, String>> group, String iters) {
        if (iters.equals("*")) {
            this.appliedOnce = true;
            while (this.appliedOnce && !this.stopping) {
                this.appliedOnce = false;
                long time0 = System.currentTimeMillis();
                int j = 0;
                while (j < group.size() && !this.stopping) {
                    Pair<Rule, String> p = group.get(j);
                    if (p.first != null) {
                        this.currentRule = (Rule)p.first;
                        if (this.currentRule.isEnabled()) {
                            this.apply(this.currentRule, (String)p.second);
                        }
                    }
                    ++j;
                }
                this.time += System.currentTimeMillis() - time0;
                System.out.println("used time: " + this.time + "ms");
                if (this.os == null) continue;
                this.writeUsedTimeToProtocol("used time: ", this.time);
            }
        } else {
            long N = new Long(iters);
            long i = 0L;
            while (i < N && !this.stopping) {
                long time0 = System.currentTimeMillis();
                int j = 0;
                while (j < group.size() && !this.stopping) {
                    Pair<Rule, String> p = group.get(j);
                    if (p.first != null) {
                        this.currentRule = (Rule)p.first;
                        if (this.currentRule.isEnabled()) {
                            this.apply(this.currentRule, (String)p.second);
                        }
                    }
                    ++j;
                }
                this.time += System.currentTimeMillis() - time0;
                System.out.println("used time: " + this.time + "ms");
                if (this.os != null) {
                    this.writeUsedTimeToProtocol("used time: ", this.time);
                }
                ++i;
            }
        }
        if (this.options.hasOption("consistencyCheckAfterGraphTrafo")) {
            this.checkGraphConsistency();
        }
        return this.appliedOnce;
    }

    @Override
    public boolean apply(Rule r) {
        this.stoppingRule = false;
        boolean result = false;
        boolean valid = false;
        this.currentMatch = r.getMatch();
        if (this.currentMatch == null) {
            this.currentMatch = this.grammar.createMatch(r);
            this.currentMatch.setCompletionStrategy((MorphCompletionStrategy)this.strategy.clone(), true);
        } else if (this.updateTypeObjectsMapAfterStep) {
            this.currentMatch.setTypeObjectsMapChanged(true);
        }
        boolean parallelApply = true;
        boolean is_applied = false;
        while (parallelApply) {
            if (!this.isInputParameterSet(r.getLeft(), true, this.currentMatch)) {
                this.fireGraTra(new GraTraEvent((Object)this, 1, this.currentMatch));
            }
            if (this.stopping || this.stoppingRule) {
                this.currentMatch.clear();
                return false;
            }
            if (this.pauseRule) {
                return false;
            }
            valid = false;
            while (!valid) {
                if (this.ruleSequence.isTrafoByObjFlow() && this.currentMatch.isTotal() && this.currentMatch.isAttrConditionSatisfied() && this.currentMatch.arePACsSatisfied() && this.currentMatch.areNACsSatisfied() && this.currentMatch.getRule().evalFormula() && this.currentMatch.isValid()) {
                    valid = true;
                    break;
                }
                if (this.currentMatch.nextCompletion()) {
                    if (this.currentMatch.isValid()) {
                        valid = true;
                        if (!r.isParallelApplyEnabled() || !this.currentMatch.typeObjectsMapChanged) break;
                        this.currentMatch.typeObjectsMapChanged = false;
                        this.updateTypeObjectsMapAfterStep = false;
                        break;
                    }
                    this.errorMsg = this.currentMatch.getErrorMsg();
                    this.currentMatch.clear();
                    continue;
                }
                this.errorMsg = this.currentMatch.getErrorMsg();
                break;
            }
            if (valid) {
                this.fireGraTra(new GraTraEvent((Object)this, 8, this.currentMatch));
                if (!this.isInputParameterSet(r.getRight(), false, this.currentMatch)) {
                    this.fireGraTra(new GraTraEvent((Object)this, 1, this.currentMatch));
                }
                try {
                    boolean checkVarsOnly = true;
                    this.currentMatch.getAttrContext().getVariables().getAttrManager().checkIfReadyToTransform(this.currentMatch.getAttrContext(), checkVarsOnly);
                }
                catch (AttrException ex) {
                    this.fireGraTra(new GraTraEvent((Object)this, 6, r.getName()));
                    return false;
                }
                Morphism coMatch = this.apply(this.currentMatch);
                if (coMatch != null) {
                    result = true;
                    this.errorMsg = "";
                    is_applied = true;
                    this.currentMatch.clear();
                    coMatch.dispose();
                    coMatch = null;
                } else {
                    result = false;
                    valid = false;
                    this.fireGraTra(new GraTraEvent(this, 3, this.currentMatch, this.errorMsg));
                    this.currentMatch.clear();
                }
            } else {
                result = false;
                this.fireGraTra(new GraTraEvent(this, 3, this.currentMatch, this.currentMatch.getErrorMsg()));
                this.currentMatch.clear();
            }
            if (r.isParallelApplyEnabled()) {
                if (!valid) {
                    parallelApply = false;
                    this.currentMatch.typeObjectsMapChanged = true;
                    this.updateTypeObjectsMapAfterStep = true;
                }
                if (!is_applied) continue;
                result = true;
                continue;
            }
            parallelApply = false;
            break;
        }
        return result;
    }

    @Override
    public void transform(List<Rule> rules) {
        if (this.grammar == null || this.ruleSubsequences == null || this.ruleSubsequences.isEmpty()) {
            return;
        }
        this.apply();
    }

    @Override
    public void transform() {
        System.out.println("GraTra   by  " + this.getClass().getName() + "  running");
        this.stopping = false;
        if (!this.grammar.getListOfRules().isEmpty() && this.currentRuleSet.isEmpty()) {
            this.setRuleSet();
        }
        String ruleSequencesAsText = this.getRuleSequenceAsText();
        String s2 = "rule sequence: " + ruleSequencesAsText;
        System.out.println(s2);
        if (this.writeLogFile) {
            String dirName = this.grammar.getDirName();
            String fileName = this.grammar.getFileName();
            if (fileName == null || fileName.equals("")) {
                fileName = this.grammar.getName();
            }
            this.openTransformProtocol(dirName, fileName);
            String version = "Version:  AGG " + Version.getID() + "\n";
            this.writeTransformProtocol(version);
            String s0 = "Graph transformation by rule sequence of : " + this.grammar.getName();
            String s1 = "on graph : " + this.grammar.getGraph().getName();
            this.writeTransformProtocol(s0);
            this.writeTransformProtocol(s1);
            this.writeTransformProtocol(s2);
        }
        if (!this.grammarChecked) {
            Pair<Object, String> checkpair = this.grammar.isReadyToTransform(true);
            if (checkpair != null) {
                Object test = checkpair.first;
                if (test != null) {
                    String s = String.valueOf((String)checkpair.second) + "\nTransformation is stopped.";
                    if (test instanceof Type) {
                        this.fireGraTra(new GraTraEvent((Object)this, 15, s));
                    } else if (test instanceof Rule) {
                        this.fireGraTra(new GraTraEvent((Object)this, 9, s));
                    } else if (test instanceof AtomConstraint) {
                        this.fireGraTra(new GraTraEvent((Object)this, 14, s));
                    }
                    this.transformFailed(s);
                    return;
                }
            } else {
                String s;
                if (!this.grammar.isGraphReadyForTransform()) {
                    s = "Graph of the grammar isn't fine.\nPlease check attribute settings of the objects.\nTransformation is stopped.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s));
                    this.transformFailed(s);
                    return;
                }
                if (!this.checkGraphConsistency()) {
                    s = "Graph consistency failed.\nPlease check the host graph against the graph constraints.\nTransformation is stopped.";
                    this.fireGraTra(new GraTraEvent((Object)this, 10, s));
                    this.transformFailed(s);
                    return;
                }
            }
            this.grammarChecked = true;
        }
        long startTime = System.currentTimeMillis();
        this.transform(this.grammar.getListOfRules());
        if (this.options.hasOption("consistencyCheckAfterGraphTrafo")) {
            this.checkGraphConsistency();
        }
        if (this.writeLogFile) {
            this.writeUsedTimeToProtocol("Used time for graph transformation: ", startTime);
            this.writeTransformProtocol("Graph transformation finished");
            this.closeTransformProtocol();
        }
        this.fireGraTra(new GraTraEvent((Object)this, 5, this.errorMsg));
    }

    public boolean isTrafoSequenceBroken() {
        return this.trafoSequenceBroken;
    }

    protected Vector<Rule> getEnabledRules(Vector<Rule> ruleSet) {
        Vector<Rule> vec = new Vector<Rule>(ruleSet.size());
        int j = 0;
        while (j < ruleSet.size()) {
            if (ruleSet.elementAt(j).isEnabled()) {
                vec.add(ruleSet.elementAt(j));
            }
            ++j;
        }
        return vec;
    }

    protected void transformFailed(String text) {
        System.out.println(text);
        this.writeTransformProtocol(text);
        this.writeTransformProtocol("\nGraph transformation failed");
        this.fireGraTra(new GraTraEvent((Object)this, 5, this.errorMsg));
        this.closeTransformProtocol();
    }

    @Override
    public boolean transformationDone() {
        return this.appliedOnce;
    }

    public String getProtocolName() {
        return this.protocolFileName;
    }

    protected String getRuleNames(Vector<Rule> rules) {
        String names = "[  ";
        int j = 0;
        while (j < rules.size()) {
            Rule r = rules.elementAt(j);
            names = String.valueOf(names) + r.getName() + "  ";
            ++j;
        }
        names = String.valueOf(names) + "]";
        return names;
    }

    protected String getRuleNamesOfSubsequence(Vector<Pair<Rule, String>> rules) {
        String names = "Rule subsequence: ( ";
        int j = 0;
        while (j < rules.size()) {
            Pair<Rule, String> p = rules.get(j);
            String rname = ((Rule)p.first).getName();
            names = String.valueOf(names) + rname;
            String iters = (String)p.second;
            if (!iters.equals("1")) {
                names = String.valueOf(names) + "{" + iters + "}";
            }
            names = String.valueOf(names) + " ";
            ++j;
        }
        names = String.valueOf(names) + ")";
        return names;
    }

    protected void openTransformProtocol(String dirName, String fileName) {
        String dName = dirName;
        String fName = "RuleSequencesGraTra.log";
        if (fileName != null && !fileName.equals("")) {
            fName = fileName.endsWith(".ggx") ? String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_GraTra.log" : String.valueOf(fileName) + "_GraTra.log";
        }
        if (dName != null && !dName.equals("")) {
            this.f = new File(dirName);
            dName = this.f.exists() ? (this.f.isFile() ? (this.f.getParent() != null ? String.valueOf(this.f.getParent()) + File.separator : "." + File.separator) : (this.f.isDirectory() ? String.valueOf(this.f.getPath()) + File.separator : "." + File.separator)) : "." + File.separator;
            this.f = new File(String.valueOf(dirName) + fName);
        } else {
            this.f = new File(fName);
        }
        try {
            this.os = new FileOutputStream(this.f);
            this.protocolFileName = this.f.getName();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.writeTransformProtocol(new Date().toString());
    }

    protected void writeTransformProtocol(String s) {
        if (this.os == null) {
            return;
        }
        if (!this.os.getChannel().isOpen()) {
            return;
        }
        try {
            if (!s.equals("\n")) {
                this.os.write(s.getBytes());
            }
            this.os.write(10);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void writeUsedTimeToProtocol(String text, long beginTime) {
        this.writeTransformProtocol(String.valueOf(text) + (System.currentTimeMillis() - beginTime) + "ms\n");
    }

    protected void closeTransformProtocol() {
        if (this.os == null) {
            return;
        }
        try {
            this.os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Pair<Morphism, Morphism> derivation(Match m) {
        return null;
    }

    public String getRuleSequenceAsText() {
        this.ruleNameSequences = new Vector<String>(this.ruleSubsequences.size());
        String s = "";
        int i = 0;
        while (i < this.ruleSubsequences.size()) {
            Pair<List<Pair<Rule, String>>, String> grp = this.ruleSubsequences.get(i);
            String grpStr = "";
            List grpRules = (List)grp.first;
            long grpIters = -1L;
            String grpItersStr = (String)grp.second;
            if (grpItersStr.equals("*")) {
                grpStr = String.valueOf(grpStr) + "( ";
            } else {
                grpIters = new Long((String)grp.second);
                if (grpRules.size() > 1 || grpIters > 1L) {
                    grpStr = String.valueOf(grpStr) + "( ";
                }
            }
            int j = 0;
            while (j < grpRules.size()) {
                Pair p = (Pair)grpRules.get(j);
                if (p.first != null) {
                    String rulename = ((Rule)p.first).getName();
                    grpStr = String.valueOf(grpStr) + rulename;
                    long ruleIters = -1L;
                    String ruleItersStr = (String)p.second;
                    if (ruleItersStr.equals("*")) {
                        grpStr = String.valueOf(grpStr) + "{" + ruleItersStr + "}";
                    } else {
                        ruleIters = new Long((String)p.second);
                        if (ruleIters > 1L) {
                            grpStr = String.valueOf(grpStr) + "{" + ruleIters + "}";
                        }
                    }
                    grpStr = String.valueOf(grpStr) + " ";
                }
                ++j;
            }
            if (grpItersStr.equals("*")) {
                grpStr = String.valueOf(grpStr) + ")";
            } else if (grpRules.size() > 1 || grpIters > 1L) {
                grpStr = String.valueOf(grpStr) + ")";
            }
            if (grpRules.size() > 0) {
                if (grpItersStr.equals("*")) {
                    grpStr = String.valueOf(grpStr) + "{" + grpItersStr + "}";
                } else if (grpIters > 1L) {
                    grpStr = String.valueOf(grpStr) + "{" + grpIters + "}";
                }
            } else {
                grpStr = "()";
            }
            this.ruleNameSequences.add(grpStr);
            grpStr = String.valueOf(grpStr) + "\n";
            s = String.valueOf(s) + grpStr;
            ++i;
        }
        return s;
    }

    @Override
    protected boolean isInputParameterSet(Graph g, boolean left, Match match) {
        if (match != null && left && this.ruleSequence != null && !this.ruleSequence.getObjectFlow().isEmpty() && ((VarTuple)match.getAttrContext().getVariables()).areInputParametersSet()) {
            return true;
        }
        return super.isInputParameterSet(g, left, match);
    }
}

