/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.agt;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.XMLHelper;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeSet;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.Covering;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class RuleScheme
extends Rule {
    private String schemeName = "RuleScheme";
    private int itsIndex = -1;
    private boolean hasInputParameter;
    private boolean valid;
    private KernelRule kernelRule;
    private final List<Rule> multiRules = new Vector<Rule>();
    private AmalgamatedRule amalgamRule;
    private Hashtable<GraphObject, GraphObject> amalgamLHS2kernelLHS;
    private Hashtable<GraphObject, GraphObject> amalgamRHS2kernelRHS;
    private boolean parallelKernel;
    private boolean disjointMultis = true;
    private boolean checkDeleteUseConflict = true;
    private boolean atLeastOneMultiMatch;
    private boolean shiftDone;

    public RuleScheme(String aSchemeName, TypeSet types) {
        super(types);
        super.trimToSize();
        this.itsName = aSchemeName;
        this.schemeName = aSchemeName;
        this.kernelRule = new KernelRule(types);
        this.kernelRule.setRuleScheme(this);
    }

    public RuleScheme(String aSchemeName, KernelRule kernel) {
        super(kernel.getTypeSet());
        super.trimToSize();
        this.itsName = aSchemeName;
        this.schemeName = aSchemeName;
        this.kernelRule = kernel;
        this.kernelRule.setRuleScheme(this);
    }

    @Override
    public boolean hasNestedACs() {
        boolean hasGACs = this.kernelRule.hasNestedACs();
        int i = 0;
        while (i < this.multiRules.size()) {
            hasGACs = hasGACs || this.multiRules.get(i).hasNestedACs();
            ++i;
        }
        return hasGACs;
    }

    public Match getKernelMatch(Graph graph) {
        if (this.kernelRule.getMatch() == null) {
            this.kernelRule.setMatch(BaseFactory.theFactory().createMatch(this.kernelRule, graph));
        }
        return this.kernelRule.getMatch();
    }

    public void clearMatches() {
        if (this.kernelRule.getMatch() != null) {
            this.kernelRule.getMatch().dispose();
            this.kernelRule.setMatch(null);
        }
        this.clearMatchesOfMultiRules();
        this.unsetAttrContextVars();
        this.clear();
        ((VarTuple)this.getAttrContext().getVariables()).unsetVariables();
    }

    public void unsetAttrContextVars() {
        ((VarTuple)this.kernelRule.getAttrContext().getVariables()).unsetVariables();
        int s = ((VarTuple)this.kernelRule.getAttrContext().getVariables()).getSize();
        int j = 0;
        while (j < s) {
            ((VarTuple)this.kernelRule.getAttrContext().getVariables()).getVarMemberAt(j).setExpr(null);
            ++j;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            ((VarTuple)multiRule.getAttrContext().getVariables()).unsetVariables();
            s = ((VarTuple)multiRule.getAttrContext().getVariables()).getSize();
            int j2 = 0;
            while (j2 < s) {
                ((VarTuple)multiRule.getAttrContext().getVariables()).getVarMemberAt(j2).setExpr(null);
                ++j2;
            }
            ++i;
        }
    }

    public void showAttrContextVars() {
        ((VarTuple)this.kernelRule.getAttrContext().getVariables()).showVariables();
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            ((VarTuple)multiRule.getAttrContext().getVariables()).showVariables();
            ++i;
        }
    }

    public void clearMatchesOfMultiRules() {
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            if (multiRule.getMatch() != null) {
                multiRule.getMatch().dispose();
                multiRule.setMatch(null);
            }
            ++i;
        }
    }

    public void disposeMatch() {
        this.clearMatches();
        this.unsetAttrContextVars();
        if (this.amalgamRule != null && this.amalgamRule.getMatch() != null) {
            this.amalgamRule.getMatch().dispose();
        }
    }

    public void disposeAmalgamatedRule() {
        this.clearMatches();
        this.unsetAttrContextVars();
        if (this.amalgamRule != null) {
            if (this.amalgamRule.getMatch() != null) {
                this.amalgamRule.getMatch().dispose();
            }
            this.amalgamRule.dispose();
            this.amalgamRule = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearMatches();
        if (this.amalgamRule != null) {
            this.amalgamRule.dispose();
            this.amalgamRule = null;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            this.multiRules.get(i).dispose();
            ++i;
        }
        this.multiRules.clear();
        this.kernelRule.dispose();
    }

    @Override
    public RuleScheme getClone() {
        return BaseFactory.theFactory().cloneRuleScheme(this);
    }

    @Override
    public RuleScheme getClone(TypeSet types) {
        return BaseFactory.theFactory().cloneRuleScheme(this, types);
    }

    public void propagateAddRuleMappingToMultiRule(GraphObject leftgo, GraphObject rightgo) throws BadMappingException {
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            try {
                GraphObject objL = multiRule.getEmbeddingLeft().getImage(leftgo);
                GraphObject objR = multiRule.getEmbeddingRight().getImage(rightgo);
                if (objL != null && objR != null) {
                    multiRule.addMapping(objL, objR);
                }
            }
            catch (BadMappingException ex) {
                System.out.println("RuleScheme.propagateCreatedMappingToMultiRule: " + ex.getLocalizedMessage());
                throw ex;
            }
            ++i;
        }
    }

    public void propagateRemoveRuleMappingToMultiRule(GraphObject go, boolean left) {
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            if (left) {
                GraphObject objL = multiRule.getEmbeddingLeft().getImage(go);
                if (objL != null) {
                    multiRule.removeMapping(go);
                }
            } else {
                GraphObject objR = multiRule.getEmbeddingRight().getImage(go);
                if (objR != null && this.getInverseImage(objR).hasMoreElements()) {
                    multiRule.removeMapping(this.getInverseImage(go).nextElement());
                }
            }
            ++i;
        }
    }

    public boolean isAmalgamable() {
        this.errorMsg = null;
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            if (!(multiRule.isLeftEmbeddingValid() && multiRule.isRightEmbeddingValid() && multiRule.isMorphismEmbeddingValid())) {
                this.errorMsg = multiRule.getName();
                return false;
            }
            ++i;
        }
        return true;
    }

    public void storeIndexOfRuleList(int i) {
        this.itsIndex = i;
    }

    public int getStoredIndexOfRuleList() {
        return this.itsIndex;
    }

    @Override
    public void trimToSize() {
        this.kernelRule.trimToSize();
        int i = 0;
        while (i < this.multiRules.size()) {
            this.multiRules.get(i).trimToSize();
            ++i;
        }
    }

    @Override
    public void setName(String aName) {
        this.itsName = this.schemeName = aName;
    }

    public void setSchemeName(String aName) {
        this.itsName = this.schemeName = aName;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    @Override
    public void setLayer(int l) {
        this.layer = l;
        this.kernelRule.setLayer(l);
        int i = 0;
        while (i < this.multiRules.size()) {
            this.multiRules.get(i).setLayer(l);
            ++i;
        }
    }

    public void setCheckDeleteUseConflictRequired(boolean b) {
        this.checkDeleteUseConflict = b;
    }

    public boolean checkDeleteUseConflictRequired() {
        return this.checkDeleteUseConflict;
    }

    public void setAtLeastOneMultiMatchRequired(boolean b) {
        this.atLeastOneMultiMatch = b;
    }

    public boolean atLeastOneMultiMatchRequired() {
        return this.atLeastOneMultiMatch;
    }

    public void setDisjointMultiMatches(boolean b) {
        this.disjointMultis = b;
    }

    public boolean disjointMultiMatches() {
        return this.disjointMultis;
    }

    public void setParallelKernelMatch(boolean b) {
        this.parallelKernel = b;
    }

    public boolean parallelKernelMatch() {
        return this.parallelKernel;
    }

    @Override
    public RuleScheme getRuleScheme() {
        return this;
    }

    public Rule getKernelRule() {
        return this.kernelRule;
    }

    public MultiRule getMultiRule(Graph g) {
        int i = 0;
        while (i < this.multiRules.size()) {
            Rule multiRule = this.multiRules.get(i);
            if (multiRule.getLeft() == g || multiRule.getRight() == g) {
                return (MultiRule)multiRule;
            }
            ++i;
        }
        return null;
    }

    public MultiRule getMultiRule(int index) {
        if (index >= 0 && index < this.multiRules.size()) {
            return (MultiRule)this.multiRules.get(index);
        }
        return null;
    }

    public MultiRule getLastMultiRule() {
        return (MultiRule)this.multiRules.get(this.multiRules.size() - 1);
    }

    public boolean isLastMultiRule(Rule r) {
        return this.multiRules.get(this.multiRules.size() - 1) == r;
    }

    public Rule getRule(String rulename) {
        if (this.getName().equals(rulename)) {
            return this;
        }
        if (this.kernelRule.getName().equals(rulename) || rulename.equals(String.valueOf(this.itsName) + "." + this.kernelRule.getName())) {
            return this.kernelRule;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            if (multiRule.getName().equals(rulename) || rulename.equals(String.valueOf(this.itsName) + "." + multiRule.getName())) {
                return multiRule;
            }
            ++i;
        }
        return null;
    }

    public Rule getRuleByQualifiedName(String rname) {
        if (this.getName().equals(rname)) {
            return this;
        }
        if (this.kernelRule.getName().equals(rname) || rname.equals(String.valueOf(this.itsName) + "." + this.kernelRule.getName())) {
            return this.kernelRule;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule = (MultiRule)this.multiRules.get(i);
            if (multiRule.getName().equals(rname) || rname.equals(String.valueOf(this.itsName) + "." + multiRule.getName())) {
                return multiRule;
            }
            ++i;
        }
        return null;
    }

    public List<Rule> getMultiRules() {
        return this.multiRules;
    }

    public int getCountOfMultiRules() {
        return this.multiRules.size();
    }

    public Rule addMultiRule(String name) {
        MultiRule r = this.createMultiRule(name);
        this.kernelRule.getLeft().addObserver(r);
        this.kernelRule.getRight().addObserver(r);
        this.kernelRule.addObserver(r);
        return r;
    }

    public boolean isRuleOfScheme(Rule r) {
        if (this == r) {
            return true;
        }
        if (this.amalgamRule == r) {
            return true;
        }
        if (this.kernelRule == r) {
            return true;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            if (this.multiRules.get(i) == r) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAmalgamatedRule(AmalgamatedRule amalgamRule) {
        this.amalgamRule = amalgamRule;
        if (this.amalgamRule != null) {
            this.amalgamRule.setRuleScheme(this);
        }
    }

    private AmalgamatedRule createAmalgamatedRule(Graph g, MorphCompletionStrategy s) {
        Covering cov = new Covering(this, g, s);
        if (cov.amalgamate()) {
            this.errorMsg = "";
            this.amalgamRHS2kernelRHS = cov.getRHSMappingAmalgamToKernelRule();
            this.amalgamLHS2kernelLHS = cov.getLHSMappingAmalgamToKernelRule();
            return cov.getAmalgamatedRule();
        }
        this.errorMsg = cov.getErrorMessage();
        return null;
    }

    public GraphObject getKernelOfAmalgamRuleObject(GraphObject amalgamObj) {
        return this.amalgamRHS2kernelRHS.get(amalgamObj);
    }

    public GraphObject getLHSKernelOfAmalgamRuleObject(GraphObject amalgamObj) {
        return this.amalgamLHS2kernelLHS.get(amalgamObj);
    }

    public GraphObject getRHSKernelOfAmalgamRuleObject(GraphObject amalgamObj) {
        return this.amalgamRHS2kernelRHS.get(amalgamObj);
    }

    public AmalgamatedRule getAmalgamatedRule(Graph g, MorphCompletionStrategy s) {
        this.amalgamRule = this.createAmalgamatedRule(g, s);
        return this.amalgamRule;
    }

    public AmalgamatedRule getAmalgamatedRule() {
        return this.amalgamRule;
    }

    public void removeAmalgamatedRule() {
        if (this.amalgamRule != null) {
            this.amalgamRule.setRuleScheme(null);
            this.amalgamRule.dispose();
            this.amalgamRule = null;
        }
    }

    public boolean isValid() {
        this.valid = this.isReadyToTransform();
        return this.valid;
    }

    @Override
    public boolean isElement(Graph g) {
        if (this.kernelRule.isElement(g)) {
            return true;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            Rule r = this.multiRules.get(i);
            if (r.isElement(g)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void refreshAttributed() {
        this.kernelRule.refreshAttributed();
        int i = 0;
        while (i < this.multiRules.size()) {
            this.multiRules.get(i).refreshAttributed();
            ++i;
        }
    }

    @Override
    public boolean isUsingType(GraphObject typeObj) {
        if (this.kernelRule.isUsingType(typeObj)) {
            return true;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            if (this.multiRules.get(i).isUsingType(typeObj)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasInputParameter() {
        return this.hasInputParameter;
    }

    public Match getMatch(Graph g, MorphCompletionStrategy s) {
        if (this.hasInputParameter) {
            this.applyValueOfInputParameter();
        }
        this.amalgamRule = this.createAmalgamatedRule(g, s);
        if (this.amalgamRule != null) {
            this.amalgamRule.setWaitBeforeApplyEnabled(this.isWaitBeforeApplyEnabled());
            return this.amalgamRule.getMatch();
        }
        return null;
    }

    @Override
    public Match getMatch() {
        if (this.amalgamRule != null) {
            this.amalgamRule.setWaitBeforeApplyEnabled(this.isWaitBeforeApplyEnabled());
            return this.amalgamRule.getMatch();
        }
        return null;
    }

    @Override
    public boolean hasEnabledACs(boolean checkBefore) {
        if (checkBefore) {
            this.hasEnabledGACs = this.kernelRule.hasEnabledACs(checkBefore);
            if (!this.hasEnabledGACs) {
                int i = 0;
                while (i < this.multiRules.size()) {
                    if (this.multiRules.get(i).isEnabled() && this.multiRules.get(i).hasEnabledACs(checkBefore)) {
                        this.hasEnabledGACs = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return this.hasEnabledGACs;
    }

    @Override
    public boolean isCreating() {
        this.isCreating = this.kernelRule.isCreating();
        int i = 0;
        while (i < this.multiRules.size() && !this.isCreating) {
            this.isCreating = this.multiRules.get(i).isCreating();
            ++i;
        }
        return this.isCreating;
    }

    @Override
    public boolean isDeleting() {
        this.isDeleting = this.kernelRule.isDeleting();
        int i = 0;
        while (i < this.multiRules.size() && !this.isDeleting) {
            this.isDeleting = this.multiRules.get(i).isDeleting();
            ++i;
        }
        return this.isDeleting;
    }

    @Override
    public boolean isNodeDeleting() {
        this.isNodeDeleting = this.kernelRule.isNodeDeleting();
        int i = 0;
        while (i < this.multiRules.size() && !this.isNodeDeleting) {
            this.isNodeDeleting = this.multiRules.get(i).isNodeDeleting();
            ++i;
        }
        return this.isNodeDeleting;
    }

    @Override
    public boolean isReadyToTransform() {
        this.valid = false;
        if (!this.kernelRule.isReadyToTransform()) {
            return false;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            if (this.multiRules.get(i).isEnabled() && !this.multiRules.get(i).isReadyToTransform()) {
                return false;
            }
            ++i;
        }
        this.valid = true;
        return true;
    }

    @Override
    public boolean isApplicable(Graph g, MorphCompletionStrategy strategy, boolean doCheckIfReadyToTransform) {
        boolean result = this.enabled;
        if (result && doCheckIfReadyToTransform) {
            result = this.isReadyToTransform();
        }
        if (result) {
            result = false;
            Match m = BaseFactory.theFactory().createMatch(this.kernelRule, g);
            if (m != null) {
                m.setCompletionStrategy(strategy, true);
                m.enableInputParameter(false);
                if (m.nextCompletion()) {
                    result = true;
                }
                m.dispose();
            }
        }
        return result;
    }

    @Override
    public void setApplicable(boolean appl) {
        this.applicable = appl;
        this.kernelRule.setApplicable(appl);
    }

    public boolean isInputParameterSet(boolean left) {
        Rule r = this.kernelRule;
        this.addToAttrContext((VarTuple)r.getAttrContext().getVariables());
        if (r.getMatch() != null) {
            this.adaptAttrContextValues(r.getMatch().getAttrContext());
        } else {
            this.adaptAttrContextValues(r.getAttrContext());
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            r = this.multiRules.get(i);
            if (r.isEnabled()) {
                this.addToAttrContext((VarTuple)r.getAttrContext().getVariables());
                if (r.getMatch() != null) {
                    this.adaptAttrContextValues(r.getMatch().getAttrContext());
                }
            }
            ++i;
        }
        return this.isInputParameterSet(this.getAttrContext(), left);
    }

    public void applyValueOfInputParameter() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember v = vars.getVarMemberAt(i);
            if (v.isInputParameter() && v.isSet()) {
                VarMember vm = ((VarTuple)this.kernelRule.getAttrContext().getVariables()).getVarMemberAt(v.getName());
                if (!(vm == null || vm.getExpr() != null && v.getExprAsText().equals(vm.getExprAsText()))) {
                    vm.setExpr(v.getExpr());
                }
                int j = 0;
                while (j < this.multiRules.size()) {
                    vm = ((VarTuple)this.multiRules.get(j).getAttrContext().getVariables()).getVarMemberAt(v.getName());
                    if (!(vm == null || vm.getExpr() != null && v.getExprAsText().equals(vm.getExprAsText()))) {
                        vm.setExpr(v.getExpr());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean leftGraphIsUsingVariable(VarMember var) {
        if (this.kernelRule.getLeft().isUsingVariable(var)) {
            return true;
        }
        if (this.nacIsUsingVariable(var, this.kernelRule.getAttrContext().getConditions(), this.kernelRule.getNACsList())) {
            return true;
        }
        if (this.pacIsUsingVariable(var, this.kernelRule.getAttrContext().getConditions(), this.kernelRule.getPACsList())) {
            return true;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            if (this.multiRules.get(i).getLeft().isUsingVariable(var)) {
                return true;
            }
            if (this.nacIsUsingVariable(var, this.multiRules.get(i).getAttrContext().getConditions(), this.multiRules.get(i).getNACsList())) {
                return true;
            }
            if (this.pacIsUsingVariable(var, this.multiRules.get(i).getAttrContext().getConditions(), this.multiRules.get(i).getPACsList())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean nacIsUsingVariable(VarMember var, AttrConditionTuple act, List<OrdinaryMorphism> nacs) {
        int l = 0;
        while (l < nacs.size()) {
            OrdinaryMorphism nac = nacs.get(l);
            if (nac.getTarget().isUsingVariable(var)) {
                return true;
            }
            Vector<String> nacVars = nac.getTarget().getVariableNamesOfAttributes();
            int j = 0;
            while (j < nacVars.size()) {
                String varName = nacVars.get(j);
                int k = 0;
                while (k < act.getNumberOfEntries()) {
                    CondMember cond = (CondMember)act.getMemberAt(k);
                    Vector<String> condVars = cond.getAllVariables();
                    if (condVars.contains(varName) && condVars.contains(var.getName())) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++l;
        }
        return false;
    }

    private boolean pacIsUsingVariable(VarMember var, AttrConditionTuple act, List<OrdinaryMorphism> pacs) {
        int l = 0;
        while (l < pacs.size()) {
            OrdinaryMorphism pac = pacs.get(l);
            if (pac.getTarget().isUsingVariable(var)) {
                return true;
            }
            Vector<String> pacVars = pac.getTarget().getVariableNamesOfAttributes();
            int j = 0;
            while (j < pacVars.size()) {
                String varName = pacVars.get(j);
                int k = 0;
                while (k < act.getNumberOfEntries()) {
                    CondMember cond = (CondMember)act.getMemberAt(k);
                    Vector<String> condVars = cond.getAllVariables();
                    if (condVars.contains(varName) && condVars.contains(var.getName())) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++l;
        }
        return false;
    }

    private boolean rightGraphIsUsingVariable(VarMember var) {
        if (this.kernelRule.getRight().isUsingVariable(var)) {
            return true;
        }
        int i = 0;
        while (i < this.multiRules.size()) {
            if (this.multiRules.get(i).getRight().isUsingVariable(var)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isInputParameterSet(AttrContext attrContext, boolean left) {
        AttrVariableTuple avt = attrContext.getVariables();
        int i = 0;
        while (i < avt.getNumberOfEntries()) {
            VarMember v = avt.getVarMemberAt(i);
            if (v.isInputParameter()) {
                this.hasInputParameter = true;
                if (!v.isSet()) {
                    if (left && this.leftGraphIsUsingVariable(v)) {
                        return false;
                    }
                    if (!left && this.rightGraphIsUsingVariable(v)) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    protected MultiRule createEmptyMultiRule() {
        MultiRule mr = new MultiRule(this.kernelRule.getTypeSet());
        mr.setEmbeddingLeft(new OrdinaryMorphism(this.kernelRule.getLeft(), mr.getLeft(), AttrTupleManager.getDefaultManager().newContext(0)));
        mr.setEmbeddingRight(new OrdinaryMorphism(this.kernelRule.getRight(), mr.getRight(), AttrTupleManager.getDefaultManager().newContext(0)));
        mr.setRuleScheme(this);
        mr.getLeft().xyAttr = this.kernelRule.getLeft().xyAttr;
        mr.getRight().xyAttr = this.kernelRule.getLeft().xyAttr;
        this.multiRules.add(mr);
        return mr;
    }

    public MultiRule createMultiRule(String ruleName) {
        OrdinaryMorphism embR;
        OrdinaryMorphism embL = this.kernelRule.getLeft().plainCopy();
        if (embL == null) {
            embL = new OrdinaryMorphism(this.kernelRule.getLeft(), BaseFactory.theFactory().createGraph(this.kernelRule.getLeft().getTypeSet(), false), AttrTupleManager.getDefaultManager().newContext(0));
        }
        if ((embR = this.kernelRule.getRight().plainCopy()) == null) {
            embR = new OrdinaryMorphism(this.kernelRule.getRight(), BaseFactory.theFactory().createGraph(this.kernelRule.getRight().getTypeSet(), false), AttrTupleManager.getDefaultManager().newContext(0));
        }
        MultiRule multiRule = new MultiRule(this.kernelRule, embL, embR);
        if (this.kernelRule.hasNACs() || this.kernelRule.hasPACs()) {
            Vector<String> list = this.kernelRule.getLeft().getVariableNamesOfAttributes();
            list.addAll(this.kernelRule.getRight().getVariableNamesOfAttributes());
            multiRule.addToAttrContextAccordingList((VarTuple)this.kernelRule.getAttrContext().getVariables(), list);
        } else {
            multiRule.addToAttrContext((VarTuple)this.kernelRule.getAttrContext().getVariables());
        }
        multiRule.setRuleScheme(this);
        multiRule.setName(ruleName);
        multiRule.getLeft().setKind("LHS");
        multiRule.getRight().setKind("RHS");
        multiRule.getLeft().xyAttr = this.kernelRule.getLeft().xyAttr;
        multiRule.getRight().xyAttr = this.kernelRule.getLeft().xyAttr;
        this.multiRules.add(multiRule);
        this.kernelRule.getLeft().addObserver(multiRule);
        this.kernelRule.getRight().addObserver(multiRule);
        this.kernelRule.addObserver(multiRule);
        this.kernelRule.setChanged(false);
        return multiRule;
    }

    public void removeMultiRules() {
        this.multiRules.clear();
    }

    public void removeMultiRule(Rule r) {
        if (this.multiRules.contains(r)) {
            this.multiRules.remove(r);
        }
    }

    public void propagateApplCondsOfKernelToMultiRules() {
        if (!this.shiftDone) {
            int j = 0;
            while (j < this.multiRules.size()) {
                Rule mRule = this.multiRules.get(j);
                if (mRule.isEnabled()) {
                    this.shiftApplCondsOfKernelToMultiRule((MultiRule)mRule);
                }
                ++j;
            }
            this.shiftDone = true;
        }
    }

    private boolean shiftApplCondsOfKernelToMultiRule(MultiRule multiRule) {
        OrdinaryMorphism shiftCond;
        OrdinaryMorphism kernCond;
        List<OrdinaryMorphism> kernConds = this.kernelRule.getPACsList();
        int i = 0;
        while (i < kernConds.size()) {
            kernCond = kernConds.get(i);
            if (kernCond.isEnabled() && (shiftCond = this.shiftApplCondAlongMorph(kernCond, multiRule.getEmbeddingLeft())) != null) {
                shiftCond.setName(kernCond.getName().concat("(shifted)"));
                shiftCond.setEnabled(kernCond.isEnabled());
                multiRule.addShiftedKernelApplCond(shiftCond, true);
                this.shiftDone = true;
            }
            ++i;
        }
        kernConds = this.kernelRule.getNACsList();
        i = 0;
        while (i < kernConds.size()) {
            kernCond = kernConds.get(i);
            if (kernCond.isEnabled() && (shiftCond = this.shiftApplCondAlongMorph(kernCond, multiRule.getEmbeddingLeft())) != null) {
                shiftCond.setName(kernCond.getName().concat("(shifted)"));
                shiftCond.setEnabled(kernCond.isEnabled());
                multiRule.addShiftedKernelApplCond(shiftCond, false);
                this.shiftDone = true;
            }
            ++i;
        }
        kernConds = this.kernelRule.getNestedACsList();
        i = 0;
        while (i < kernConds.size()) {
            if (!(kernConds.get(i) instanceof NestedApplCond)) break;
            kernCond = (NestedApplCond)kernConds.get(i);
            if (kernCond.isEnabled() && (shiftCond = this.shiftNestedApplCondAlongEmbMorphism((NestedApplCond)kernCond, multiRule.getEmbeddingLeft(), this.kernelRule.getRight().getAttrContext())) != null) {
                ((NestedApplCond)shiftCond).setName(((NestedApplCond)kernCond).getName().concat("(shifted)"));
                shiftCond.setEnabled(kernCond.isEnabled());
                multiRule.addShiftedKernelNestedApplCond((NestedApplCond)shiftCond);
                this.shiftDone = true;
            }
            ++i;
        }
        this.addAttrCondsOfKernelToMultiRule(multiRule);
        return true;
    }

    public void removeShiftedApplConditionsFromMultiRules() {
        int i = 0;
        while (i < this.multiRules.size()) {
            Rule mRule = this.multiRules.get(i);
            ((MultiRule)mRule).removeShiftedKernelApplConds();
            this.removeAttrCondsOfKernelFromMultiRule(mRule);
            ++i;
        }
        this.shiftDone = false;
    }

    private void addAttrCondsOfKernelToMultiRule(Rule multiRule) {
        CondTuple kernConds = (CondTuple)this.kernelRule.getAttrContext().getConditions();
        CondTuple multiConds = (CondTuple)multiRule.getAttrContext().getConditions();
        int i = 0;
        while (i < kernConds.getNumberOfEntries()) {
            String kernCond = kernConds.getCondMemberAt(i).getExprAsText();
            if (!multiConds.contains(kernCond)) {
                CondMember cm = (CondMember)multiConds.addCondition(0, kernCond);
                cm.setShifted(true);
            }
            ++i;
        }
    }

    private void removeAttrCondsOfKernelFromMultiRule(Rule multiRule) {
        CondTuple conds = (CondTuple)multiRule.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getNumberOfEntries()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.isShifted()) {
                conds.getTupleType().deleteMemberAt(i);
                --i;
            }
            ++i;
        }
    }

    private void mapKernel2MultiObject(MultiRule multiRule) {
        OrdinaryMorphism embLeft = multiRule.getEmbeddingLeft();
        Enumeration<GraphObject> domLeft = embLeft.getDomain();
        while (domLeft.hasMoreElements()) {
            GraphObject kern = domLeft.nextElement();
            multiRule.mapKernel2MultiObject(kern, embLeft.getImage(kern));
        }
        OrdinaryMorphism embRight = multiRule.getEmbeddingRight();
        Enumeration<GraphObject> domRight = embRight.getDomain();
        while (domRight.hasMoreElements()) {
            GraphObject kern = domRight.nextElement();
            multiRule.mapKernel2MultiObject(kern, embRight.getImage(kern));
        }
    }

    @Override
    public void createAttrInstanceWhereNeeded() {
        this.kernelRule.createAttrInstanceWhereNeeded();
        int i = 0;
        while (i < this.multiRules.size()) {
            this.multiRules.get(i).createAttrInstanceWhereNeeded();
            ++i;
        }
    }

    @Override
    public void createAttrInstanceOfTypeWhereNeeded(Type t) {
        this.kernelRule.createAttrInstanceOfTypeWhereNeeded(t);
        int i = 0;
        while (i < this.multiRules.size()) {
            this.multiRules.get(i).createAttrInstanceOfTypeWhereNeeded(t);
            ++i;
        }
    }

    private OrdinaryMorphism shiftApplCondAlongMorph(OrdinaryMorphism cond, OrdinaryMorphism morph) {
        if (cond.getSource() == morph.getSource()) {
            OrdinaryMorphism condIso = cond.getTarget().isomorphicCopy();
            if (condIso == null) {
                return null;
            }
            OrdinaryMorphism shiftCond = cond instanceof NestedApplCond ? BaseFactory.theFactory().createGeneralMorphism(morph.getTarget(), condIso.getTarget()) : BaseFactory.theFactory().createMorphism(morph.getTarget(), condIso.getTarget());
            Enumeration<GraphObject> condDom = cond.getDomain();
            while (condDom.hasMoreElements()) {
                GraphObject go = condDom.nextElement();
                GraphObject condImg = cond.getImage(go);
                if (condImg == null) continue;
                GraphObject embedImg = morph.getImage(go);
                GraphObject isoImg = condIso.getImage(condImg);
                if (embedImg != null && isoImg != null) {
                    try {
                        shiftCond.addMapping(embedImg, isoImg);
                        continue;
                    }
                    catch (BadMappingException ex) {
                        shiftCond.dispose();
                        condIso.dispose(false, true);
                        return null;
                    }
                }
                shiftCond.dispose();
                condIso.dispose(false, true);
                return null;
            }
            return shiftCond;
        }
        return null;
    }

    private NestedApplCond shiftNestedApplCondAlongEmbMorphism(NestedApplCond cond, OrdinaryMorphism embedding, AttrContext ac) {
        if (cond.getSource() == embedding.getSource()) {
            OrdinaryMorphism condIso = cond.getTarget().isomorphicCopy();
            if (condIso == null) {
                return null;
            }
            NestedApplCond shiftCond = new NestedApplCond(embedding.getTarget(), condIso.getTarget(), ac);
            if (this.propagateMapping(cond, shiftCond, embedding, condIso)) {
                int i = 0;
                while (i < cond.getNestedACs().size()) {
                    NestedApplCond nc = cond.getNestedACAt(i);
                    NestedApplCond shiftnc = this.shiftNestedApplCondAlongEmbMorphism(nc, condIso, cond.getAttrContext());
                    if (shiftnc == null) {
                        return null;
                    }
                    shiftnc.setName(nc.getName());
                    shiftnc.setEnabled(nc.isEnabled());
                    shiftCond.addNestedAC(shiftnc);
                    ++i;
                }
                return shiftCond;
            }
            shiftCond.dispose();
            condIso.dispose();
        }
        return null;
    }

    private boolean propagateMapping(OrdinaryMorphism from, OrdinaryMorphism to, OrdinaryMorphism above1, OrdinaryMorphism above2) {
        Enumeration<GraphObject> condDom = from.getDomain();
        while (condDom.hasMoreElements()) {
            GraphObject go = condDom.nextElement();
            GraphObject condImg = from.getImage(go);
            if (condImg == null) continue;
            GraphObject embedImg = above1.getImage(go);
            GraphObject isoImg = above2.getImage(condImg);
            if (embedImg == null || isoImg == null) continue;
            try {
                to.addMapping(embedImg, isoImg);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("RuleScheme", this);
        h.addAttr("name", this.schemeName);
        if (!this.enabled) {
            h.addAttr("enabled", "false");
        }
        h.addAttr("disjointMultis", String.valueOf(this.disjointMultis));
        h.addAttr("parallelKernel", String.valueOf(this.parallelKernel));
        h.addAttr("checkConflict", String.valueOf(this.checkDeleteUseConflict));
        h.addAttr("atLeastOneMultiMatch", String.valueOf(this.atLeastOneMultiMatch));
        h.addAttr("index", this.itsIndex);
        h.openSubTag("Kernel");
        h.addObject("", this.kernelRule, true);
        h.close();
        int i = 0;
        while (i < this.multiRules.size()) {
            h.openSubTag("Multi");
            MultiRule r = (MultiRule)this.multiRules.get(i);
            h.addObject("", r, true);
            h.openSubTag("EmbeddingLeft");
            r.getEmbeddingLeft().writeMorphism(h);
            h.close();
            h.openSubTag("EmbeddingRight");
            r.getEmbeddingRight().writeMorphism(h);
            h.close();
            h.close();
            ++i;
        }
        if (this.amalgamRule != null) {
            h.openSubTag("Amalgamated");
            h.addObject("", this.amalgamRule, true);
            h.close();
        }
        h.openSubTag("TaggedValue");
        h.addAttr("Tag", "layer");
        h.addAttr("TagValue", this.layer);
        h.close();
        h.openSubTag("TaggedValue");
        h.addAttr("Tag", "priority");
        h.addAttr("TagValue", this.priority);
        h.close();
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("RuleScheme", this)) {
            int v2;
            String t;
            String attr_str = "";
            attr_str = h.readAttr("atLeastOneMultiMatch");
            if (!"".equals(attr_str)) {
                this.atLeastOneMultiMatch = Boolean.valueOf(attr_str);
            }
            if (!"".equals(attr_str = h.readAttr("checkConflict"))) {
                this.checkDeleteUseConflict = Boolean.valueOf(attr_str);
            }
            if (!"".equals(attr_str = h.readAttr("disjointMultis"))) {
                this.disjointMultis = Boolean.valueOf(attr_str);
            }
            if (!"".equals(attr_str = h.readAttr("enabled"))) {
                this.enabled = Boolean.valueOf(attr_str);
            }
            if (!"".equals(attr_str = h.readAttr("index"))) {
                this.itsIndex = Integer.valueOf(attr_str);
            }
            if (!"".equals(attr_str = h.readAttr("name"))) {
                this.setSchemeName(attr_str);
            }
            if (!"".equals(attr_str = h.readAttr("parallelKernel"))) {
                this.parallelKernel = Boolean.valueOf(attr_str);
            }
            if (h.readSubTag("Kernel")) {
                this.kernelRule.getLeft().setKind("LHS");
                this.kernelRule.getRight().setKind("RHS");
                this.kernelRule.setRuleScheme(this);
                h.getObject("", this.kernelRule, true);
                h.close();
            }
            while (h.readSubTag("Multi")) {
                MultiRule mr = this.createEmptyMultiRule();
                mr.getLeft().setKind("LHS");
                mr.getRight().setKind("RHS");
                mr.setRuleScheme(this);
                h.getObject("", mr, true);
                if (h.readSubTag("EmbeddingLeft")) {
                    mr.getEmbeddingLeft().readMorphism(h);
                    h.close();
                }
                if (h.readSubTag("EmbeddingRight")) {
                    mr.getEmbeddingRight().readMorphism(h);
                    h.close();
                }
                h.close();
                mr.applyEmbeddedRuleMapping(this.kernelRule);
                this.mapKernel2MultiObject(mr);
                this.kernelRule.getLeft().addObserver(mr);
                this.kernelRule.getRight().addObserver(mr);
            }
            this.kernelRule.setChanged(false);
            if (h.readSubTag("TaggedValue")) {
                int v = 0;
                t = h.readAttr("Tag");
                v2 = h.readIAttr("TagValue");
                if (v2 > 0) {
                    v = v2;
                }
                if (t.equals("layer")) {
                    this.layer = v;
                }
                h.close();
            }
            if (h.readSubTag("TaggedValue")) {
                int v = 0;
                t = h.readAttr("Tag");
                v2 = h.readIAttr("TagValue");
                if (v2 > 0) {
                    v = v2;
                }
                if (t.equals("priority")) {
                    this.priority = v;
                }
                h.close();
            }
            h.close();
        }
    }
}

