/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.sheet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.helpers.ColorModeHelper;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.provider.util.HenshinColorMode;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ColorModePropertySection
extends AbstractNotationPropertiesSection {
    private Group colorModeGroup;
    private List modeList;
    private ArrayList<HenshinColorMode> modes;
    private View view;

    protected void initializeControls(Composite parent) {
        super.initializeControls(parent);
        FormLayout layout = (FormLayout)this.composite.getLayout();
        layout.marginWidth = 12;
        this.createColorModeGroup();
    }

    protected void createColorModeGroup() {
        this.colorModeGroup = this.getWidgetFactory().createGroup(this.composite, "Color Mode");
        GridLayout layout = new GridLayout(1, false);
        this.colorModeGroup.setLayout((Layout)layout);
        this.modeList = this.getWidgetFactory().createList((Composite)this.colorModeGroup, 4);
        this.modes = new ArrayList(HenshinColorMode.REGISTRY.values());
        Collections.sort(this.modes, new Comparator<HenshinColorMode>(){

            @Override
            public int compare(HenshinColorMode m1, HenshinColorMode m2) {
                return String.valueOf(m1.getName()).compareToIgnoreCase(String.valueOf(m2.getName()));
            }
        });
        HenshinColorMode def = HenshinColorMode.getDefaultColorMode();
        if (def != null) {
            this.modes.remove(def);
            this.modes.add(0, def);
        }
        int i = 0;
        while (i < this.modes.size()) {
            this.modeList.add(String.valueOf(this.modes.get(i).getName()));
            ++i;
        }
        this.modeList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorModePropertySection.this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ColorModePropertySection.this.selectionChanged();
            }
        });
    }

    private void selectionChanged() {
        int index = this.modeList.getSelectionIndex();
        final HenshinColorMode mode = index >= 0 ? this.modes.get(index) : HenshinColorMode.getDefaultColorMode();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.view);
        if (editingDomain != null) {
            AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Set Color Mode", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    ColorModeHelper.setColorMode(ColorModePropertySection.this.view, mode);
                    return CommandResult.newOKCommandResult();
                }
            };
            try {
                command.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.refreshEditPart(this.getSingleInput());
    }

    private void refreshEditPart(IGraphicalEditPart ep) {
        ep.refresh();
        for (Object o : ep.getChildren()) {
            if (!(o instanceof IGraphicalEditPart)) continue;
            this.refreshEditPart((IGraphicalEditPart)o);
        }
        if (ep instanceof DiagramEditPart) {
            for (Object o : ((DiagramEditPart)ep).getConnections()) {
                if (!(o instanceof IGraphicalEditPart)) continue;
                this.refreshEditPart((IGraphicalEditPart)o);
            }
        }
    }

    public void refresh() {
        super.refresh();
        this.view = null;
        if (!this.isDisposed()) {
            IGraphicalEditPart ep = this.getSingleInput();
            if (ep == null) {
                return;
            }
            this.view = ep.getNotationView();
            if (this.view == null) {
                return;
            }
            if (this.view.getElement() instanceof Module) {
                HenshinColorMode mode = ColorModeHelper.getColorMode(this.view);
                if (mode == null) {
                    mode = HenshinColorMode.getDefaultColorMode();
                }
                this.modeList.select(this.modes.indexOf(mode));
            }
        }
    }
}

