/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.henshin.statespace.StateSpaceExporter;
import org.eclipse.emf.henshin.statespace.StateSpacePluginInitializer;
import org.eclipse.emf.henshin.statespace.Validator;

public final class StateSpacePlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.henshin.statespace";
    public static final StateSpacePlugin INSTANCE = new StateSpacePlugin();
    private static Implementation plugin;
    private Map<String, Validator> validators;
    private Map<String, StateSpaceExporter> exporters;

    public StateSpacePlugin() {
        super(new ResourceLocator[0]);
    }

    public Map<String, Validator> getValidators() {
        if (this.validators == null) {
            this.validators = new HashMap<String, Validator>();
            try {
                StateSpacePluginInitializer.loadValidators();
            }
            catch (Throwable throwable) {}
        }
        return this.validators;
    }

    public Map<String, StateSpaceExporter> getExporters() {
        if (this.exporters == null) {
            this.exporters = new HashMap<String, StateSpaceExporter>();
            try {
                StateSpacePluginInitializer.loadExporters();
            }
            catch (Throwable throwable) {}
        }
        return this.exporters;
    }

    public void logError(String message, Throwable t) {
        if (plugin != null && plugin.getLog() != null) {
            plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, t));
        } else {
            System.err.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public void logWarning(String message) {
        if (plugin != null && plugin.getLog() != null) {
            plugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, message, null));
        } else {
            System.err.println(message);
        }
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

