/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.diagram.edit.helpers.UnitEditHelper;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.diagram.part.HenshinLinkUpdater;
import org.eclipse.emf.henshin.diagram.part.HenshinSymbolUpdater;
import org.eclipse.emf.henshin.model.MultiUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class InvocationDeleteCommand
extends AbstractTransactionalCommand {
    private View invocationView;

    public InvocationDeleteCommand(TransactionalEditingDomain domain, View invocationView) {
        super(domain, "Delete Invocation", null);
        this.invocationView = invocationView;
    }

    public boolean canExecute() {
        if (this.invocationView == null || this.getInvocation() == null || this.getUnit() == null) {
            return false;
        }
        return this.getUnit().getSubUnits(false).contains((Object)this.getInvocation());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View unitView = this.getUnitView();
        Unit unit = this.getUnit();
        Unit invocation = this.getInvocation();
        if (!(unit instanceof MultiUnit)) {
            return CommandResult.newErrorCommandResult((String)("Unsupport unit type: " + unit.eClass().getName()));
        }
        ((MultiUnit)unit).getSubUnits().remove((Object)invocation);
        UnitEditHelper.removeParameterMappingsToInvocation(unit, invocation);
        ViewUtil.destroy((View)this.invocationView);
        PreferencesHint prefHint = HenshinDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        new HenshinSymbolUpdater(prefHint, true).update(unitView);
        new HenshinLinkUpdater(prefHint, true).update(unitView);
        return CommandResult.newOKCommandResult();
    }

    private Unit getInvocation() {
        return (Unit)this.invocationView.getElement();
    }

    private Unit getUnit() {
        return (Unit)this.getUnitView().getElement();
    }

    private View getUnitView() {
        return (View)this.invocationView.eContainer().eContainer();
    }
}

