/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.EdgeMapping;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.NodeMapping;

public class Intersection {
    private EList<NodeMapping> nodeMappings = new BasicEList();
    private EList<EdgeMapping> edgeMappings = new BasicEList();

    public Graph getSourceGraph() {
        return (Graph)((NodeMapping)this.nodeMappings.get(0)).getSourceNode().eContainer();
    }

    public EList<NodeMapping> getNodeMappings() {
        return this.nodeMappings;
    }

    public EList<EdgeMapping> getEdgeMappings() {
        return this.edgeMappings;
    }

    public void addNodeMapping(NodeMapping nodeMapping) {
        this.nodeMappings.add((Object)nodeMapping);
    }

    public void addEdgeMapping(EdgeMapping edgeMapping) {
        this.edgeMappings.add((Object)edgeMapping);
    }

    public boolean containsTarget(Node node) {
        for (NodeMapping mapping : this.nodeMappings) {
            if (mapping.getTargetNode() != node) continue;
            return true;
        }
        return false;
    }

    public boolean containsTarget(Edge edge) {
        for (EdgeMapping mapping : this.edgeMappings) {
            if (mapping.getTargetEdge() != edge) continue;
            return true;
        }
        return false;
    }

    public Node getSourceNode(Node node) {
        for (NodeMapping mapping : this.nodeMappings) {
            if (mapping.getTargetNode() != node) continue;
            return mapping.getSourceNode();
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Node Mappings:");
        for (NodeMapping nodeMapping : this.nodeMappings) {
            result.append("\n- from ");
            result.append(nodeMapping.getSourceNode().toString());
            result.append(" to ");
            result.append(nodeMapping.getTargetNode().toString());
            result.append("\n- graphs: " + nodeMapping.getSourceNode().eContainer() + " and " + nodeMapping.getTargetNode().eContainer());
        }
        result.append("\nEdge Mappings: ");
        for (EdgeMapping edgeMapping : this.edgeMappings) {
            result.append("\n- between ");
            result.append(edgeMapping.getSourceEdge().toString());
            result.append(" and ");
            result.append(edgeMapping.getTargetEdge().toString());
        }
        return result.toString();
    }

    public boolean containsSource(Node node) {
        for (NodeMapping mapping : this.nodeMappings) {
            Node sourceNode = mapping.getSourceNode();
            if (!sourceNode.getName().equals(node.getName()) || sourceNode.getType() != node.getType()) continue;
            return true;
        }
        return false;
    }

    public Node getSourceNode1(Node node) {
        for (NodeMapping mapping : this.nodeMappings) {
            Node targetNode = mapping.getTargetNode();
            if (!targetNode.getName().equals(node.getName()) || targetNode.getType() != node.getType()) continue;
            return mapping.getSourceNode();
        }
        return null;
    }
}

