/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.gui.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrManager;
import agg.attribute.AttrTuple;
import agg.attribute.gui.AttrEditorManager;
import agg.attribute.gui.AttrTopEditor;
import agg.attribute.gui.impl.AbstractEditor;
import agg.attribute.gui.impl.ContextEditor;
import agg.attribute.gui.impl.CustomizingEditor;
import agg.attribute.gui.impl.FullInstanceTupleEditor;
import agg.attribute.view.AttrViewSetting;
import agg.gui.saveload.GraphicsExportJPEG;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TopEditor
extends AbstractEditor
implements AttrTopEditor {
    protected JPanel titlePanel;
    protected JLabel titleLabel;
    protected JPanel instPanel;
    protected JPanel contextPanel;
    protected JTabbedPane tabbedPane;
    protected JPanel tabPanel;
    protected ContextEditor contextEditor;
    protected FullInstanceTupleEditor instEditor;
    protected CustomizingEditor customEditor;
    protected GraphicsExportJPEG exportJPEG;
    protected JButton exportJPEGButton;

    public TopEditor(AttrManager m, AttrEditorManager em) {
        super(m, em);
    }

    @Override
    protected void genericCreateAllViews() {
        this.contextEditor = new ContextEditor(this.getAttrManager(), this.getEditorManager());
        this.instEditor = new FullInstanceTupleEditor(this.getAttrManager(), this.getEditorManager());
        this.customEditor = new CustomizingEditor(this.getAttrManager(), this.getEditorManager());
    }

    @Override
    protected void genericCustomizeMainLayout() {
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addTab("Attribute Context", this.contextEditor.getComponent());
        this.tabbedPane.addTab("Current Attribute", this.instEditor.getComponent());
        this.tabbedPane.addTab("Customize", this.customEditor.getComponent());
        int i = this.tabbedPane.indexOfTab("Current Attribute");
        this.tabbedPane.setSelectedIndex(i);
        this.tabPanel = new JPanel(new BorderLayout());
        this.tabPanel.add((Component)this.tabbedPane, "Center");
        this.exportJPEGButton = this.createExportJPEGButton();
        this.titlePanel = new JPanel(new BorderLayout());
        this.titleLabel = new JLabel("     ");
        this.titlePanel.add((Component)this.titleLabel, "Center");
        this.titlePanel.add((Component)new JLabel("  "), "West");
        if (this.exportJPEGButton != null) {
            this.titlePanel.add((Component)this.exportJPEGButton, "East");
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.titlePanel, "North");
        this.mainPanel.add((Component)this.tabPanel, "Center");
    }

    private JButton createExportJPEGButton() {
        URL imgsrc = ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/print.gif");
        if (imgsrc != null) {
            ImageIcon image = new ImageIcon(imgsrc);
            JButton b = new JButton(image);
            b.setToolTipText("Export JPEG");
            b.setMargin(new Insets(-5, 0, -5, 0));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TopEditor.this.exportJPEG != null) {
                        TopEditor.this.exportJPEG.save(TopEditor.this.tabPanel);
                    }
                }
            });
            b.setEnabled(true);
            return b;
        }
        return null;
    }

    @Override
    protected void arrangeMainPanel() {
        int i = this.tabbedPane.indexOfTab("Current Attribute");
        this.tabbedPane.setSelectedIndex(i);
    }

    public void selectAttributeEditor(boolean b) {
        if (b) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfTab("Current Attribute"));
        } else {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void selectContextEditor(boolean b) {
        if (b) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfTab("Attribute Context"));
        } else {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfTab("Current Attribute"));
        }
    }

    public void selectCustomEditor(boolean b) {
        if (b) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfTab("Customize"));
        } else {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfTab("Current Attribute"));
        }
    }

    public FullInstanceTupleEditor getAttrInstanceEditor() {
        return this.instEditor;
    }

    public ContextEditor getContextEditor() {
        return this.contextEditor;
    }

    public CustomizingEditor getCustomizingEditor() {
        return this.customEditor;
    }

    @Override
    public void enableContextEditor(boolean b) {
        this.arrangeMainPanel();
        int i = this.tabbedPane.indexOfTab("Attribute Context");
        if (i != -1) {
            this.tabbedPane.setEnabledAt(i, b);
        }
    }

    @Override
    public void setContext(AttrContext anAttrContext) {
        this.contextEditor.setContext(anAttrContext);
    }

    @Override
    public AttrContext getContext() {
        return this.contextEditor.getContext();
    }

    @Override
    public void setAttrManager(AttrManager m) {
        super.setAttrManager(m);
        this.contextEditor.setAttrManager(m);
        this.instEditor.setAttrManager(m);
        this.customEditor.setAttrManager(m);
    }

    @Override
    public void setEditorManager(AttrEditorManager m) {
        super.setEditorManager(m);
        this.contextEditor.setEditorManager(m);
        this.instEditor.setEditorManager(m);
        this.customEditor.setEditorManager(m);
    }

    @Override
    public void setTuple(AttrTuple anAttrTuple) {
        this.instEditor.setTuple(anAttrTuple);
    }

    @Override
    public AttrTuple getTuple() {
        return this.instEditor.getTuple();
    }

    @Override
    public void setViewSetting(AttrViewSetting anAttrViewSetting) {
        if (this.instEditor != null) {
            this.instEditor.setViewSetting(anAttrViewSetting);
        }
    }

    @Override
    public AttrViewSetting getViewSetting() {
        return this.instEditor.getViewSetting();
    }

    public String getTitleOfSelectedEditor() {
        return this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    public void setTitleText(String str) {
        this.titleLabel.setText(str);
    }
}

