/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrMapping;
import agg.attribute.AttrType;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AvailableHandlers;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.AttrObject;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.impl.VerboseControl;
import agg.attribute.view.AttrViewSetting;
import agg.attribute.view.impl.OpenViewSetting;
import java.util.HashMap;
import java.util.Vector;

public class AttrTupleManager
extends AttrObject
implements AttrManager {
    public HashMap<String, Boolean> classNameLookupMap;
    protected AttrHandler[] handlers = AvailableHandlers.newInstances();
    protected AttrViewSetting defaultOpenView;
    protected AttrViewSetting defaultMaskedView;
    protected AttrViewSetting fixedViewSetting;
    protected ContextView defaultContext;
    protected boolean isCorrectInputEnforced = false;
    private String errorMsg = "";
    private boolean variableContext = false;
    protected static AttrTupleManager myDefaultInstance = new AttrTupleManager();

    public static AttrManager getDefaultManager() {
        return myDefaultInstance;
    }

    public AttrTupleManager() {
        new AttrSession();
        this.setDebug(true);
        this.classNameLookupMap = new HashMap();
        this.defaultOpenView = new OpenViewSetting(this);
        this.defaultMaskedView = this.defaultOpenView.getMaskedView();
        this.fixedViewSetting = new OpenViewSetting(this);
        this.defaultContext = this.makeDefaultContext();
    }

    private ContextView makeDefaultContext() {
        ContextView c = new ContextView(this, 0);
        c.setAllowVarDeclarations(false);
        c.setAllowComplexExpr(false);
        c.setAllowEmptyValues(false);
        c.setAllowInitialExpr(true);
        return c;
    }

    @Override
    public AttrContext newContext(int mapStyle) {
        ContextView c = new ContextView(this, mapStyle, null);
        c.setVariableContext(this.variableContext);
        return c;
    }

    @Override
    public AttrContext newContext(int mapStyle, AttrContext parent) {
        ContextView c = new ContextView(this, mapStyle, parent);
        c.setVariableContext(this.variableContext);
        return c;
    }

    @Override
    public AttrContext newLeftContext(AttrContext context) {
        ContextView c = new ContextView(this, context, true);
        c.setVariableContext(this.variableContext);
        return c;
    }

    @Override
    public AttrContext newRightContext(AttrContext context) {
        ContextView c = new ContextView(this, context, false);
        c.setVariableContext(this.variableContext);
        return c;
    }

    public void setVariableContext(boolean b) {
        this.variableContext = b;
    }

    public boolean isVariableContext() {
        return this.variableContext;
    }

    @Override
    public AttrHandler getHandler(String name) {
        int i = 0;
        while (i < this.handlers.length) {
            if (this.handlers[i].getName().equals(name)) {
                return this.handlers[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public AttrType newType() {
        return new DeclTuple(this);
    }

    @Override
    public AttrInstance newInstance(AttrType type) {
        return this.newInstance(type, null);
    }

    @Override
    public AttrInstance newInstance(AttrType type, AttrContext context) {
        if (type == null) {
            return null;
        }
        if (context == null) {
            return new ValueTuple(this, (DeclTuple)type, this.defaultContext);
        }
        return new ValueTuple(this, (DeclTuple)type, (ContextView)context);
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void clearErrorMsg() {
        this.errorMsg = "";
    }

    @Override
    public void checkIfReadyToMatch(AttrContext ruleContext) throws AttrException {
        if (ruleContext == null) {
            throw new AttrException("Null context supplied.");
        }
        ContextView context = (ContextView)ruleContext;
        String text = "";
        CondTuple conds = (CondTuple)context.getConditions();
        int k = 0;
        while (k < conds.getSize()) {
            CondMember cm = conds.getCondMemberAt(k);
            if (cm.isEnabled() && cm.getMark() == 0 && cm.isFalse()) {
                text = "Condition:  " + cm.getExprAsText() + "  failed!";
            }
            ++k;
        }
        if (text.length() > 0) {
            this.errorMsg = text;
            throw new AttrException(text);
        }
    }

    @Override
    public AttrMapping newMapping(AttrContext mappingContext, AttrInstance source, AttrInstance target) throws AttrException {
        this.errorMsg = "";
        try {
            return new TupleMapping((ContextView)mappingContext, (ValueTuple)source, (ValueTuple)target);
        }
        catch (AttrImplException ex1) {
            this.errorMsg = "Attributes don't match.";
            throw new AttrException(this.errorMsg);
        }
    }

    public AttrMapping newMappingChild2Parent(AttrContext mappingContext, AttrInstance source, AttrInstance target) throws AttrException {
        this.errorMsg = "";
        try {
            return new TupleMapping((ContextView)mappingContext, (ValueTuple)source, (ValueTuple)target);
        }
        catch (AttrImplException ex1) {
            this.errorMsg = "Attributes don't match.";
            throw new AttrException(this.errorMsg);
        }
    }

    @Override
    public void checkIfReadyToTransform(AttrContext matchContext) throws AttrException {
        if (matchContext == null) {
            this.errorMsg = "Null context supplied.";
            throw new AttrException(this.errorMsg);
        }
        this.errorMsg = "";
        VarTuple vars = (VarTuple)matchContext.getVariables();
        int k = 0;
        while (k < vars.getSize()) {
            VarMember vm = vars.getVarMemberAt(k);
            if (vm.isEnabled() && vm.getMark() != 3 && vm.getMark() != 2 && vm.getMark() != 4 && !vm.isDefinite()) {
                this.errorMsg = "Variable:  " + vm.getName() + "  is not definite!";
            }
            ++k;
        }
        CondTuple conds = (CondTuple)matchContext.getConditions();
        int k2 = 0;
        while (k2 < conds.getSize()) {
            CondMember cm = conds.getCondMemberAt(k2);
            if (cm.isEnabled() && cm.getMark() == 0 && !cm.isTrue()) {
                this.errorMsg = "Condition:  " + cm.getExprAsText() + "  is not satisfied!";
            }
            ++k2;
        }
        if (this.errorMsg.length() > 0) {
            throw new AttrException(this.errorMsg);
        }
    }

    @Override
    public void checkIfReadyToTransform(AttrContext matchContext, boolean checkVariablesOnly) throws AttrException {
        if (!checkVariablesOnly) {
            try {
                this.checkIfReadyToTransform(matchContext);
            }
            catch (AttrException ex) {
                this.errorMsg = ex.getMessage();
            }
        } else {
            this.errorMsg = "";
            if (matchContext == null) {
                this.errorMsg = "Null context supplied.";
                throw new AttrException(this.errorMsg);
            }
            VarTuple vars = (VarTuple)matchContext.getVariables();
            int k = 0;
            while (k < vars.getSize()) {
                VarMember vm = vars.getVarMemberAt(k);
                if (vm.isEnabled() && vm.getMark() != 3 && vm.getMark() != 2 && vm.getMark() != 4 && !vm.isDefinite()) {
                    this.errorMsg = "Variable:  " + vm.getName() + "  is not definite!";
                }
                ++k;
            }
            if (this.errorMsg.length() > 0) {
                throw new AttrException(this.errorMsg);
            }
        }
    }

    @Override
    public AttrViewSetting newViewSetting() {
        return new OpenViewSetting(this);
    }

    @Override
    public AttrViewSetting getDefaultOpenView() {
        return this.defaultOpenView;
    }

    @Override
    public AttrViewSetting getDefaultMaskedView() {
        return this.defaultMaskedView;
    }

    public AttrViewSetting getFixedViewSetting() {
        return this.fixedViewSetting;
    }

    public void setDebug(boolean b) {
        VerboseControl.setDebug(b);
    }

    @Override
    public AttrHandler[] getHandlers() {
        AttrHandler[] handlersCopy = new AttrHandler[this.handlers.length];
        System.arraycopy(this.handlers, 0, handlersCopy, 0, this.handlers.length);
        return handlersCopy;
    }

    public boolean isCorrectInputEnforced() {
        return this.isCorrectInputEnforced;
    }

    public void setCorrectInputEnforced(boolean b) {
        this.isCorrectInputEnforced = b;
    }

    @Override
    public String isClassName(String name) {
        String result = null;
        boolean isClass = false;
        try {
            Class.forName(name);
            result = name;
            isClass = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!isClass) {
            AttrHandler[] attrHandlers = AttrTupleManager.getDefaultManager().getHandlers();
            int h = 0;
            while (h < attrHandlers.length) {
                AttrHandler attrh = attrHandlers[h];
                Vector<String> packs = ((JexHandler)attrh).getClassResolver().getPackages();
                int pi = 0;
                while (pi < packs.size()) {
                    String pack = packs.get(pi);
                    try {
                        Class.forName(String.valueOf(pack) + "." + name);
                        result = String.valueOf(pack) + "." + name;
                        isClass = true;
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ++pi;
                    }
                }
                if (isClass) break;
                ++h;
            }
        }
        return result;
    }

    @Override
    public String getStaticMethodCall(String aValue) {
        if (aValue.indexOf("$") == 0) {
            int ind = aValue.substring(1).indexOf("$");
            if (ind > 0) {
                String clstr = aValue.substring(1, ind + 1);
                try {
                    Class.forName(clstr);
                    String tst = clstr.substring(clstr.indexOf(".") + 1);
                    while (tst.indexOf(".") != -1) {
                        clstr = tst.concat("");
                        tst = clstr.substring(clstr.indexOf(".") + 1);
                    }
                    clstr = tst.concat("");
                    String result = String.valueOf(clstr) + aValue.substring(ind + 2);
                    return result;
                }
                catch (ClassNotFoundException tst) {}
            }
        } else {
            AttrHandler[] attrHandlers = AttrTupleManager.getDefaultManager().getHandlers();
            int h = 0;
            while (h < attrHandlers.length) {
                AttrHandler attrh = attrHandlers[h];
                Vector<String> packs = ((JexHandler)attrh).getClassResolver().getPackages();
                int pi = 0;
                while (pi < packs.size()) {
                    String pack = packs.get(pi);
                    String tst = aValue;
                    String pname = null;
                    String tmp = "";
                    while (tst.indexOf(".") != -1) {
                        String next = tst.substring(0, tst.indexOf("."));
                        String p = String.valueOf(tmp) + next;
                        if (p.equals(pack)) {
                            pname = pack;
                            break;
                        }
                        tmp = String.valueOf(tmp) + next;
                        tmp = String.valueOf(tmp) + ".";
                        tst = tst.substring(tst.indexOf(".") + 1, tst.length());
                    }
                    if (pname != null) {
                        String result = aValue.replaceFirst(String.valueOf(pname) + ".", "");
                        String clstr = result.substring(0, result.indexOf("."));
                        try {
                            Class.forName(String.valueOf(pname) + "." + clstr);
                            return result;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++pi;
                }
                ++h;
            }
        }
        return aValue;
    }
}

