/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.cons.Formula;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ConstraintPriority {
    Hashtable<Object, Object> constraintPriority;
    Enumeration<Formula> constraints;
    Vector<Formula> constraintsVec;

    public ConstraintPriority(Enumeration<Formula> constraints) {
        this.constraints = constraints;
        this.constraintsVec = new Vector(0);
        while (constraints.hasMoreElements()) {
            this.constraintsVec.addElement(constraints.nextElement());
        }
        this.initConstraintPriority();
    }

    public ConstraintPriority(List<Formula> constraints) {
        this.constraintsVec = new Vector(0);
        int i = 0;
        while (i < constraints.size()) {
            this.constraintsVec.add(constraints.get(i));
            ++i;
        }
        this.constraints = this.constraintsVec.elements();
        this.initConstraintPriority();
    }

    public ConstraintPriority(Vector<Formula> constraints) {
        this.constraintsVec = constraints;
        this.constraints = this.constraintsVec.elements();
        this.initConstraintPriority();
    }

    public void addPriority(Formula constraint, int prior) {
        constraint.addPriority(prior);
        this.constraintPriority.put(constraint, constraint.getPriority());
    }

    private void initConstraintPriority() {
        this.constraintPriority = new Hashtable();
        int i = 0;
        while (i < this.constraintsVec.size()) {
            Formula constraint = this.constraintsVec.elementAt(i);
            if (constraint instanceof Formula) {
                Vector<Integer> prior = constraint.getPriority();
                if (prior != null) {
                    this.constraintPriority.put(constraint, prior);
                }
            } else if (constraint instanceof String) {
                this.constraintPriority.put(constraint, 0);
            }
            ++i;
        }
    }

    public Hashtable<Object, Object> getConstraintPriority() {
        return this.constraintPriority;
    }

    public Integer getStartPriority() {
        int startPrior = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration<Object> keys = this.constraintPriority.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Vector prior = (Vector)this.constraintPriority.get(key);
            if (prior == null) continue;
            if (prior.isEmpty()) {
                startPrior = 1;
                result = 1;
                continue;
            }
            Integer p = (Integer)prior.get(0);
            if (p >= startPrior) continue;
            startPrior = p;
            result = p;
        }
        return result;
    }

    public Hashtable<Integer, HashSet<Object>> invertPriority() {
        Hashtable<Integer, HashSet<Object>> inverted = new Hashtable<Integer, HashSet<Object>>();
        Enumeration<Object> keys = this.constraintPriority.keys();
        while (keys.hasMoreElements()) {
            HashSet<Object> invertedValue;
            Object key = keys.nextElement();
            Vector prior = (Vector)this.constraintPriority.get(key);
            if (prior == null) continue;
            Integer p = 1;
            if (!prior.isEmpty()) {
                p = (Integer)prior.get(0);
            }
            if ((invertedValue = inverted.get(p)) == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(p, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Formula:\t\tPriority:\n";
        Enumeration<Object> keys = this.constraintPriority.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            resultString = String.valueOf(resultString) + ((Formula)key).getName() + "\t\t";
            Vector valueVec = (Vector)this.constraintPriority.get(key);
            int i = 0;
            while (i < valueVec.size()) {
                Integer value = (Integer)valueVec.get(i);
                resultString = String.valueOf(resultString) + value.toString() + "  ";
                ++i;
            }
            resultString = String.valueOf(resultString) + "\n";
        }
        return resultString;
    }
}

