/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.options;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdType;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import agg.gui.options.AbstractOptionGUI;
import agg.layout.evolutionary.EvolutionaryGraphLayout;
import agg.layout.evolutionary.LayoutPattern;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class GraphLayouterOptionGUI
extends AbstractOptionGUI
implements ActionListener,
ListSelectionListener,
ChangeListener {
    protected EvolutionaryGraphLayout layouter;
    protected JCheckBox enableLayouterCB;
    protected JCheckBox saveCB;
    protected JCheckBox metricsCB;
    protected JCheckBox centerCB;
    protected JCheckBox fixedNodePositionCB;
    protected JCheckBox usePatternCB;
    protected JRadioButtonMenuItem x_leftCB;
    protected JRadioButtonMenuItem x_rightCB;
    protected JRadioButtonMenuItem x_equalCB;
    protected JRadioButtonMenuItem y_aboveCB;
    protected JRadioButtonMenuItem y_underCB;
    protected JRadioButtonMenuItem y_equalCB;
    protected Vector<JRadioButtonMenuItem> edgeXgroup;
    protected Vector<JRadioButtonMenuItem> edgeYgroup;
    protected JTextField iterLayoutTF;
    protected JTextField generalEdgeLengthTF;
    protected JTextField temperatureTF;
    protected JTextField nodeClusterSpanTF;
    protected JTextField edgeLengthTF;
    protected int edgeLength;
    protected int iterCount;
    protected int generalEdgeLength;
    protected int temperature;
    protected int nodeClusterSpan;
    protected JComboBox edgeTypeCB;
    protected JComboBox nodeTypeCB;
    protected JButton showPattern;
    protected JButton displaySwitch1;
    protected JButton displaySwitch2;
    protected JPanel layoutOptions;
    protected JPanel generalLayoutPatternP;
    protected JPanel nodeLayoutPatternP;
    protected JPanel edgeLayoutPatternP;
    protected JTable patternTable;
    protected JTabbedPane tabbedPane;
    protected JScrollPane scrollpanePatternTable;
    protected JDialog tableFrame;
    protected Vector<EdType> edgeTypes;
    protected Vector<EdType> nodeTypes;
    protected EdGraGra gragra;

    public GraphLayouterOptionGUI(EvolutionaryGraphLayout graphLayouter) {
        this.layouter = graphLayouter;
        this.layoutOptions = this.createLayoutOptionsPanel();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.layoutOptions, c);
        this.validate();
        this.enableButtons(this.enableLayouterCB.isSelected());
        this.updateGraphLayouter();
    }

    private JPanel createLayoutOptionsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        TitledBorder border = new TitledBorder(" Evolutionary Layout for Graph Sequences ");
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        p.setBorder(border);
        JPanel p1 = new JPanel(new GridLayout(0, 1));
        this.enableLayouterCB = new JCheckBox(" perform during graph transformation ", null, false);
        this.layouter.setEnabled(false);
        this.enableLayouterCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setEnabled(((JCheckBox)e.getSource()).isSelected());
                GraphLayouterOptionGUI.this.enableButtons(((JCheckBox)e.getSource()).isSelected());
            }
        });
        p1.add(this.enableLayouterCB);
        JPanel p2 = new JPanel(new GridLayout(0, 1));
        p2.setBorder(new TitledBorder(" Output "));
        JLabel l = new JLabel(" Graph sequence as JPEG ( .jpg ) images ");
        p2.add(l);
        this.saveCB = new JCheckBox(" write to directory", null, false);
        this.saveCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setJpgOutput(((JCheckBox)e.getSource()).isSelected());
                if (((JCheckBox)e.getSource()).isSelected()) {
                    GraphLayouterOptionGUI.this.metricsCB.setSelected(true);
                    GraphLayouterOptionGUI.this.layouter.setWriteMetricValues(true);
                }
            }
        });
        p2.add(this.saveCB);
        l = new JLabel(" Quality metrics ");
        p2.add(l);
        this.metricsCB = new JCheckBox(" write to ( .log ) file ", null, false);
        this.metricsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setWriteMetricValues(((JCheckBox)e.getSource()).isSelected());
            }
        });
        p2.add(this.metricsCB);
        JPanel p7 = new JPanel(new GridLayout(0, 1));
        this.usePatternCB = new JCheckBox(" use layout pattern ", null, false);
        this.usePatternCB.setEnabled(false);
        this.usePatternCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.layouter.setUsePattern(((JCheckBox)e.getSource()).isSelected());
                GraphLayouterOptionGUI.this.enablePattern(GraphLayouterOptionGUI.this.enableLayouterCB.isSelected(), GraphLayouterOptionGUI.this.usePatternCB.isSelected());
            }
        });
        p7.add(this.usePatternCB);
        JPanel p8 = this.createLayoutPatternOptionsPanel();
        this.constrainBuild(p, p1, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p2, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 15, 5);
        this.constrainBuild(p, p7, 0, 6, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p8, 0, 7, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        p.validate();
        return p;
    }

    private JPanel createLayoutPatternOptionsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.generalLayoutPatternP = this.createGeneralPatternOptionsPanel();
        this.edgeLayoutPatternP = this.createEdgeLayoutPatternOptionsPanel();
        this.nodeLayoutPatternP = this.createNodeLayoutPatternOptionsPanel();
        this.patternTable = this.createLayoutPatternTable();
        this.tabbedPane.addTab(" General ", null, this.generalLayoutPatternP, "");
        this.tabbedPane.addTab(" Edge Type Pattern ", null, this.edgeLayoutPatternP, "");
        this.tabbedPane.addTab(" Node Type Pattern ", null, this.nodeLayoutPatternP, "");
        JPanel p3 = new JPanel();
        JLabel l = new JLabel(" Table of Graph Layout Pattern ");
        this.showPattern = new JButton("Show");
        this.showPattern.setEnabled(false);
        this.showPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphLayouterOptionGUI.this.tableFrame != null) {
                    if (!GraphLayouterOptionGUI.this.tableFrame.isVisible()) {
                        GraphLayouterOptionGUI.this.tableFrame.setLocation(((JButton)e.getSource()).getLocationOnScreen());
                        GraphLayouterOptionGUI.this.tableFrame.setVisible(true);
                    } else {
                        GraphLayouterOptionGUI.this.tableFrame.toFront();
                    }
                }
            }
        });
        p3.add(l);
        p3.add(this.showPattern);
        p.add((Component)this.tabbedPane, "Center");
        p.add((Component)p3, "South");
        return p;
    }

    private JPanel createGeneralPatternOptionsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        JPanel p4 = new JPanel();
        JLabel l = new JLabel(" iteration count of layout process ");
        this.iterCount = 100;
        this.layouter.setIterationCount(this.iterCount);
        this.iterLayoutTF = new JTextField(Integer.valueOf(this.iterCount).toString(), 5);
        this.iterLayoutTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                        GraphLayouterOptionGUI.this.layouter.setIterationCount(nb);
                    }
                    catch (NumberFormatException ex) {
                        GraphLayouterOptionGUI.this.iterLayoutTF.setText("");
                    }
                }
            }
        });
        p4.add(this.iterLayoutTF);
        p4.add(l);
        JPanel p5 = new JPanel();
        l = new JLabel(" initial temperature of cooling ");
        this.temperature = 100;
        this.layouter.setBeginTemperature(this.temperature);
        this.temperatureTF = new JTextField(Integer.valueOf(this.temperature).toString(), 5);
        this.temperatureTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                        GraphLayouterOptionGUI.this.layouter.setBeginTemperature(nb);
                    }
                    catch (NumberFormatException ex) {
                        GraphLayouterOptionGUI.this.temperatureTF.setText("");
                    }
                }
            }
        });
        p5.add(this.temperatureTF);
        p5.add(l);
        JPanel p6 = new JPanel();
        l = new JLabel(" preferred edge length ");
        this.generalEdgeLength = 100;
        this.layouter.setGeneralEdgeLength(this.generalEdgeLength);
        this.generalEdgeLengthTF = new JTextField(Integer.valueOf(this.generalEdgeLength).toString(), 5);
        this.generalEdgeLengthTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                        GraphLayouterOptionGUI.this.layouter.setGeneralEdgeLength(nb);
                    }
                    catch (NumberFormatException ex) {
                        GraphLayouterOptionGUI.this.generalEdgeLengthTF.setText("200");
                    }
                }
            }
        });
        p6.add(this.generalEdgeLengthTF);
        p6.add(l);
        JPanel p7 = new JPanel();
        l = new JLabel(" span of node cluster ");
        this.nodeClusterSpan = 200;
        this.layouter.getLayoutMetrics().setEpsilon(this.nodeClusterSpan);
        this.nodeClusterSpanTF = new JTextField(Integer.valueOf(this.nodeClusterSpan).toString(), 5);
        this.nodeClusterSpanTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JTextField)e.getSource()).getText().equals("")) {
                    try {
                        Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                        GraphLayouterOptionGUI.this.layouter.getLayoutMetrics().setEpsilon(nb);
                    }
                    catch (NumberFormatException ex) {
                        GraphLayouterOptionGUI.this.nodeClusterSpanTF.setText("");
                    }
                }
            }
        });
        p7.add(this.nodeClusterSpanTF);
        p7.add(l);
        this.constrainBuild(p, p4, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 0, 5, 0, 5);
        this.constrainBuild(p, p5, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 0, 5, 0, 5);
        this.constrainBuild(p, p6, 0, 2, 1, 1, 1, 10, 1.0, 0.0, 0, 5, 0, 5);
        this.constrainBuild(p, p7, 0, 3, 1, 1, 1, 10, 1.0, 0.0, 0, 5, 0, 5);
        return p;
    }

    private JPanel createEdgeLayoutPatternOptionsPanel() {
        if (this.edgeXgroup == null) {
            this.edgeXgroup = new Vector();
        }
        if (this.edgeYgroup == null) {
            this.edgeYgroup = new Vector();
        }
        GridBagLayout gridbag = new GridBagLayout();
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        JPanel p1 = new JPanel(new GridLayout(1, 0));
        JLabel l = new JLabel(" Selected edge type ");
        p1.add(l);
        this.edgeTypeCB = this.createEdgeTypeComboBox();
        p1.add(this.edgeTypeCB);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(new TitledBorder(" Layout Pattern "));
        JPanel p2_1 = new JPanel(new GridLayout(1, 0));
        JPanel p2_1_1 = new JPanel(new GridLayout(0, 1));
        l = new JLabel("  X - Axis");
        p2_1_1.add(l);
        this.x_leftCB = new JRadioButtonMenuItem(" Target left Source", null, false);
        this.x_leftCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeXgroup, GraphLayouterOptionGUI.this.x_leftCB);
                int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                if (GraphLayouterOptionGUI.this.x_leftCB.isSelected()) {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("hor_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'x', -1);
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("hor_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'x', -1);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarLeftSrc", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 1);
                    }
                } else {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "hor_tree");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "hor_tree");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 1);
                    }
                }
            }
        });
        this.edgeXgroup.add(this.x_leftCB);
        p2_1_1.add(this.x_leftCB);
        this.x_rightCB = new JRadioButtonMenuItem(" Target right Source", null, false);
        this.x_rightCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeXgroup, GraphLayouterOptionGUI.this.x_rightCB);
                int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                if (GraphLayouterOptionGUI.this.x_rightCB.isSelected()) {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("hor_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'x', 1);
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("hor_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'x', 1);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarRightSrc", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 1);
                    }
                } else {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "hor_tree");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "hor_tree");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 1);
                    }
                }
            }
        });
        this.edgeXgroup.add(this.x_rightCB);
        p2_1_1.add(this.x_rightCB);
        this.x_equalCB = new JRadioButtonMenuItem(" Target equal Source", null, false);
        this.x_equalCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeXgroup, GraphLayouterOptionGUI.this.x_equalCB);
                int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                if (GraphLayouterOptionGUI.this.x_equalCB.isSelected()) {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("hor_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'x', 0);
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("hor_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'x', 0);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarEqualSrc", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 1);
                    }
                } else {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "hor_tree");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "hor_tree");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 1);
                    }
                }
            }
        });
        this.edgeXgroup.add(this.x_equalCB);
        p2_1_1.add(this.x_equalCB);
        JPanel p2_1_2 = new JPanel(new GridLayout(0, 1));
        l = new JLabel("  Y - Axis");
        p2_1_2.add(l);
        this.y_aboveCB = new JRadioButtonMenuItem(" Target above Source", null, false);
        this.y_aboveCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeYgroup, GraphLayouterOptionGUI.this.y_aboveCB);
                int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                if (GraphLayouterOptionGUI.this.y_aboveCB.isSelected()) {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("ver_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'y', -1);
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("ver_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'y', -1);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarAboveSrc", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 2);
                    }
                } else {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "ver_tree");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "ver_tree");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 2);
                    }
                }
            }
        });
        this.edgeYgroup.add(this.y_aboveCB);
        p2_1_2.add(this.y_aboveCB);
        this.y_underCB = new JRadioButtonMenuItem(" Target under Source", null, false);
        this.y_underCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeYgroup, GraphLayouterOptionGUI.this.y_underCB);
                int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                if (GraphLayouterOptionGUI.this.y_underCB.isSelected()) {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("ver_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'y', 1);
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("ver_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'y', 1);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarUnderSrc", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 2);
                    }
                } else {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "ver_tree");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "ver_tree");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 2);
                    }
                }
            }
        });
        this.edgeYgroup.add(this.y_underCB);
        p2_1_2.add(this.y_underCB);
        this.y_equalCB = new JRadioButtonMenuItem(" Target equal Source", null, false);
        this.y_equalCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraphLayouterOptionGUI.this.updateGroup(GraphLayouterOptionGUI.this.edgeYgroup, GraphLayouterOptionGUI.this.y_equalCB);
                int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                if (GraphLayouterOptionGUI.this.y_equalCB.isSelected()) {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("ver_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'y', 0);
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("ver_tree", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), 'y', 0);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("TarEqualSrc", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 2);
                    }
                } else {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "ver_tree");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "ver_tree");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 2);
                    }
                }
            }
        });
        this.edgeYgroup.add(this.y_equalCB);
        p2_1_2.add(this.y_equalCB);
        p2_1.add(p2_1_1);
        p2_1.add(p2_1_2);
        JPanel p2_2 = new JPanel();
        l = new JLabel(" preferred length ");
        this.edgeLength = 0;
        this.edgeLengthTF = new JTextField(String.valueOf(this.edgeLength), 5);
        this.edgeLengthTF.setColumns(5);
        this.edgeLengthTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block21: {
                    int indx = GraphLayouterOptionGUI.this.edgeTypeCB.getSelectedIndex();
                    if (!((JTextField)e.getSource()).getText().equals("")) {
                        try {
                            Integer nb = Integer.valueOf(((JTextField)e.getSource()).getText());
                            if (nb > 0) {
                                if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.gragra.createLayoutPattern("edge_length", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), nb);
                                } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.layouter.createLayoutPattern("edge_length", "edge", GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), nb);
                                }
                                if (GraphLayouterOptionGUI.this.patternTable != null) {
                                    GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt(nb.toString(), indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 3);
                                }
                            } else {
                                GraphLayouterOptionGUI.this.edgeLengthTF.setText("0");
                                if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "edge_length");
                                } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                                    GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "edge_length");
                                }
                                if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                                    GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 3);
                                }
                            }
                            break block21;
                        }
                        catch (NumberFormatException ex) {
                            GraphLayouterOptionGUI.this.edgeLengthTF.setText("0");
                            if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                                GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "edge_length");
                            } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                                GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "edge_length");
                            }
                            if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                                GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 3);
                            }
                            break block21;
                        }
                    }
                    GraphLayouterOptionGUI.this.edgeLengthTF.setText("0");
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "edge_length");
                    } else if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.removeLayoutPattern(GraphLayouterOptionGUI.this.edgeTypes.get(indx).getBasisType(), "edge_length");
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null && GraphLayouterOptionGUI.this.patternTable.getRowCount() > indx + GraphLayouterOptionGUI.this.nodeTypes.size()) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx + GraphLayouterOptionGUI.this.nodeTypes.size(), 3);
                    }
                }
            }
        });
        p2_2.add((Component)this.edgeLengthTF, "West");
        p2_2.add((Component)l, "Center");
        p2.add((Component)p2_1, "Center");
        p2.add((Component)p2_2, "South");
        this.constrainBuild(p, p1, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p2, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        p.validate();
        return p;
    }

    private JPanel createNodeLayoutPatternOptionsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel p = new JPanel();
        p.setLayout(gridbag);
        JPanel p1 = new JPanel(new GridLayout(1, 0));
        JLabel l = new JLabel(" Selected node type ");
        p1.add(l);
        this.nodeTypeCB = this.createNodeTypeComboBox();
        p1.add(this.nodeTypeCB);
        JPanel p2 = new JPanel(new GridLayout(0, 1));
        this.fixedNodePositionCB = new JCheckBox(" fix node position ", null, false);
        this.fixedNodePositionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int indx = GraphLayouterOptionGUI.this.nodeTypeCB.getSelectedIndex();
                if (indx == -1) {
                    return;
                }
                if (((JCheckBox)e.getSource()).isSelected()) {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.nodeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("frozen_node", "node", GraphLayouterOptionGUI.this.nodeTypes.get(indx).getBasisType(), true);
                    } else if (GraphLayouterOptionGUI.this.nodeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("frozen_node", "node", GraphLayouterOptionGUI.this.nodeTypes.get(indx).getBasisType(), true);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("true", indx, 4);
                    }
                } else {
                    if (GraphLayouterOptionGUI.this.gragra != null && GraphLayouterOptionGUI.this.nodeTypes != null) {
                        GraphLayouterOptionGUI.this.gragra.createLayoutPattern("frozen_node", "node", GraphLayouterOptionGUI.this.nodeTypes.get(indx).getBasisType(), false);
                    } else if (GraphLayouterOptionGUI.this.nodeTypes != null) {
                        GraphLayouterOptionGUI.this.layouter.createLayoutPattern("frozen_node", "node", GraphLayouterOptionGUI.this.nodeTypes.get(indx).getBasisType(), false);
                    }
                    if (GraphLayouterOptionGUI.this.patternTable != null) {
                        GraphLayouterOptionGUI.this.patternTable.getModel().setValueAt("", indx, 4);
                    }
                }
            }
        });
        p2.add(this.fixedNodePositionCB);
        this.constrainBuild(p, p1, 0, 0, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        this.constrainBuild(p, p2, 0, 1, 1, 1, 1, 10, 1.0, 0.0, 5, 5, 5, 5);
        p.validate();
        return p;
    }

    private JComboBox createNodeTypeComboBox() {
        if (this.nodeTypeCB == null) {
            this.nodeTypeCB = new JComboBox();
            this.nodeTypeCB.setRenderer(new MyCellRenderer(true));
            this.nodeTypeCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel l;
                    int indx;
                    if (((JComboBox)e.getSource()).getSelectedItem() instanceof JLabel && (indx = ((JComboBox)e.getSource()).getSelectedIndex()) < GraphLayouterOptionGUI.this.nodeTypes.size() && (l = (JLabel)((JComboBox)e.getSource()).getSelectedItem()) != null) {
                        GraphLayouterOptionGUI.this.nodeTypeCB.getModel().setSelectedItem(l);
                        GraphLayouterOptionGUI.this.updateLayoutPatternOfType(GraphLayouterOptionGUI.this.nodeTypes.get(indx), indx);
                    }
                }
            });
            this.nodeTypeCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.nodeTypeCB;
    }

    private JComboBox updateNodeTypeComboBox(Vector<EdType> nodetypes) {
        if (nodetypes == null) {
            if (this.patternTable != null) {
                if (this.gragra == null) {
                    this.layouter.clearLayoutPatterns();
                }
                this.patternTable.removeAll();
                this.patternTable = null;
            }
            if (this.nodeTypeCB != null) {
                this.nodeTypeCB.removeAllItems();
            }
            if (this.fixedNodePositionCB != null) {
                this.fixedNodePositionCB.setSelected(false);
            }
        }
        this.nodeTypes = nodetypes;
        if (this.nodeTypes == null) {
            return this.nodeTypeCB;
        }
        if (this.nodeTypeCB != null) {
            this.nodeTypeCB.removeAllItems();
        }
        if (this.gragra == null) {
            this.layouter.clearLayoutPatterns();
        }
        if (this.nodeTypes != null) {
            int i = 0;
            while (i < this.nodeTypes.size()) {
                EdType t = this.nodeTypes.get(i);
                JLabel l = new JLabel(t.getName());
                l.setIcon(this.getNodeTypeIcon(t));
                l.setForeground(t.getColor());
                this.nodeTypeCB.addItem(l);
                ++i;
            }
        } else {
            this.showPattern.setEnabled(false);
        }
        return this.nodeTypeCB;
    }

    public void updateNodeTypeComboBox(EdType t, int index, int msg) {
        if (msg == 13) {
            JLabel mi = new JLabel(t.getName());
            mi.setIcon(this.getNodeTypeIcon(t));
            mi.setForeground(t.getColor());
            Vector<Object> tablerow = new Vector<Object>(5);
            tablerow.add(mi);
            tablerow.add("");
            tablerow.add("");
            tablerow.add("");
            tablerow.add("");
            if (index >= this.nodeTypeCB.getItemCount()) {
                ((DefaultComboBoxModel)this.nodeTypeCB.getModel()).addElement(mi);
            } else {
                ((DefaultComboBoxModel)this.nodeTypeCB.getModel()).insertElementAt(mi, index);
            }
            ((DefaultTableModel)this.patternTable.getModel()).insertRow(index, tablerow);
        } else if (msg == 14) {
            ((DefaultTableModel)this.patternTable.getModel()).removeRow(index);
            this.layouter.removeLayoutPattern(t.getBasisType());
            ((DefaultComboBoxModel)this.nodeTypeCB.getModel()).removeElementAt(index);
        } else if (msg == 12) {
            JLabel mi = (JLabel)this.nodeTypeCB.getItemAt(index);
            if (!mi.getText().equals(t.getName())) {
                this.layouter.removeLayoutPattern(t.getBasisType());
            }
            mi.setText(t.getName());
            mi.setForeground(t.getColor());
            mi.setIcon(this.getNodeTypeIcon(t));
            if (index == this.nodeTypeCB.getSelectedIndex()) {
                if (index < this.nodeTypeCB.getItemCount() - 1) {
                    this.nodeTypeCB.setSelectedIndex(this.nodeTypeCB.getItemCount() - 1);
                } else {
                    this.nodeTypeCB.setSelectedIndex(0);
                }
            }
            this.nodeTypeCB.setSelectedItem(mi);
            this.patternTable.setValueAt(mi, index, 0);
            this.patternTable.setValueAt("", index, 1);
            this.patternTable.setValueAt("", index, 2);
            this.patternTable.setValueAt("", index, 3);
            this.patternTable.setValueAt("", index, 4);
            this.updateLayoutPatternOfType(t, index);
        }
    }

    void updateGroup(Vector<JRadioButtonMenuItem> grp, JRadioButtonMenuItem b) {
        if (b.isSelected()) {
            int i = 0;
            while (i < grp.size()) {
                JRadioButtonMenuItem bi = grp.get(i);
                if (bi != b) {
                    bi.setSelected(false);
                }
                ++i;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 690);
    }

    @Override
    public String getTabTitle() {
        return "Layouter";
    }

    @Override
    public String getTabTip() {
        return "Graph Layouter's Options";
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.updateNodeTypeComboBox(null);
        this.updateEdgeTypeComboBox(null);
        if (this.tableFrame != null) {
            this.tableFrame.setVisible(false);
        }
        if (this.gragra != null) {
            this.layouter.setLayoutPatterns(this.gragra.getLayoutPatterns());
            this.updateNodeTypeComboBox(this.gragra.getTypeSet().getNodeTypes());
            this.updateEdgeTypeComboBox(this.gragra.getTypeSet().getArcTypes());
            this.updateLayoutPatternTable();
            try {
                int indx = this.nodeTypeCB.getSelectedIndex();
                this.updateLayoutPatternOfType(this.nodeTypes.get(indx), indx);
                indx = this.edgeTypeCB.getSelectedIndex();
                this.updateLayoutPatternOfType(this.edgeTypes.get(indx), indx + this.nodeTypes.size());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void updateLayoutPatternTable() {
        this.patternTable = this.createLayoutPatternTable();
        this.createEdgePatternTableEntries(this.patternTable);
        this.createNodePatternTableEntries(this.patternTable);
        this.createPatternTableFrame(this.patternTable);
    }

    @Override
    public void update() {
        this.updateGraphLayouter();
    }

    public void addActionListener(ActionListener l) {
    }

    public void updateGraphLayouter() {
        this.layouter.setEnabled(this.enableLayouterCB.isSelected());
        this.layouter.setJpgOutput(this.saveCB.isSelected());
        this.layouter.setWriteMetricValues(this.metricsCB.isSelected());
        this.layouter.setIterationCount(this.iterCount);
        this.layouter.setUsePattern(this.usePatternCB.isSelected());
        this.layouter.setCentre(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    void enableButtons(boolean b) {
        this.saveCB.setEnabled(b);
        this.metricsCB.setEnabled(b);
        this.usePatternCB.setEnabled(b);
        this.enablePattern(b, this.usePatternCB.isEnabled() && this.usePatternCB.isSelected());
    }

    void enablePattern(boolean layouterSelected, boolean usePatternSelected) {
        this.tabbedPane.setEnabled(layouterSelected);
        this.generalLayoutPatternP.setEnabled(layouterSelected);
        this.iterLayoutTF.setEnabled(layouterSelected);
        this.temperatureTF.setEnabled(layouterSelected);
        this.generalEdgeLengthTF.setEnabled(layouterSelected);
        this.nodeClusterSpanTF.setEnabled(layouterSelected);
        this.nodeLayoutPatternP.setEnabled(usePatternSelected);
        this.nodeTypeCB.setEnabled(usePatternSelected);
        this.fixedNodePositionCB.setEnabled(usePatternSelected);
        this.edgeLayoutPatternP.setEnabled(usePatternSelected);
        this.edgeTypeCB.setEnabled(usePatternSelected);
        this.x_leftCB.setEnabled(usePatternSelected);
        this.x_rightCB.setEnabled(usePatternSelected);
        this.x_equalCB.setEnabled(usePatternSelected);
        this.y_aboveCB.setEnabled(usePatternSelected);
        this.y_underCB.setEnabled(usePatternSelected);
        this.y_equalCB.setEnabled(usePatternSelected);
        this.edgeLengthTF.setEnabled(usePatternSelected);
        this.showPattern.setEnabled(usePatternSelected);
    }

    private JComboBox createEdgeTypeComboBox() {
        if (this.edgeTypeCB == null) {
            this.edgeTypeCB = new JComboBox();
            this.edgeTypeCB.setRenderer(new MyCellRenderer(true));
            this.edgeTypeCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel l;
                    int indx;
                    if (((JComboBox)e.getSource()).getSelectedItem() instanceof JLabel && (indx = ((JComboBox)e.getSource()).getSelectedIndex()) < GraphLayouterOptionGUI.this.edgeTypes.size() && (l = (JLabel)((JComboBox)e.getSource()).getSelectedItem()) != null) {
                        GraphLayouterOptionGUI.this.updateLayoutPatternOfType(GraphLayouterOptionGUI.this.edgeTypes.get(indx), indx + GraphLayouterOptionGUI.this.nodeTypes.size());
                    }
                }
            });
            this.edgeTypeCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    e.getStateChange();
                }
            });
        }
        return this.edgeTypeCB;
    }

    private JComboBox updateEdgeTypeComboBox(Vector<EdType> arcTypes) {
        this.edgeTypes = arcTypes;
        if (this.edgeTypes == null) {
            if (this.edgeTypeCB != null) {
                this.edgeTypeCB.removeAllItems();
            }
            if (this.x_leftCB != null) {
                this.x_leftCB.setSelected(false);
            }
            if (this.x_rightCB != null) {
                this.x_rightCB.setSelected(false);
            }
            if (this.x_equalCB != null) {
                this.x_equalCB.setSelected(false);
            }
            if (this.y_aboveCB != null) {
                this.y_aboveCB.setSelected(false);
            }
            if (this.y_underCB != null) {
                this.y_underCB.setSelected(false);
            }
            if (this.y_equalCB != null) {
                this.y_equalCB.setSelected(false);
            }
            if (this.edgeLengthTF != null) {
                this.edgeLengthTF.setText("0");
            }
        }
        if (this.edgeTypeCB != null) {
            this.edgeTypeCB.removeAllItems();
        }
        if (this.gragra == null) {
            this.layouter.clearLayoutPatterns();
        }
        if (this.edgeTypes != null) {
            int i = 0;
            while (i < this.edgeTypes.size()) {
                EdType t = this.edgeTypes.get(i);
                JLabel l = new JLabel(t.getName());
                l.setIcon(this.getArcTypeIcon(t));
                l.setForeground(t.getColor());
                this.edgeTypeCB.addItem(l);
                ++i;
            }
        }
        return this.edgeTypeCB;
    }

    public void updateEdgeTypeComboBox(EdType t, int index, int msg) {
        if (msg == 13) {
            JLabel mi = new JLabel(t.getName());
            mi.setIcon(this.getArcTypeIcon(t));
            mi.setForeground(t.getColor());
            Vector<Object> tablerow = new Vector<Object>(5);
            tablerow.add(mi);
            tablerow.add("");
            tablerow.add("");
            tablerow.add("");
            tablerow.add("");
            if (index >= this.edgeTypeCB.getItemCount()) {
                ((DefaultComboBoxModel)this.edgeTypeCB.getModel()).addElement(mi);
            } else {
                ((DefaultComboBoxModel)this.edgeTypeCB.getModel()).insertElementAt(mi, index);
            }
            ((DefaultTableModel)this.patternTable.getModel()).insertRow(index, tablerow);
        } else if (msg == 14) {
            this.layouter.removeLayoutPattern(t.getBasisType());
            ((DefaultTableModel)this.patternTable.getModel()).removeRow(index + this.nodeTypes.size());
            ((DefaultComboBoxModel)this.edgeTypeCB.getModel()).removeElementAt(index);
        } else if (msg == 12) {
            JLabel mi = (JLabel)this.edgeTypeCB.getItemAt(index);
            if (!mi.getText().equals(t.getName())) {
                this.layouter.removeLayoutPattern(t.getBasisType());
            }
            mi.setText(t.getName());
            mi.setForeground(t.getColor());
            mi.setIcon(this.getArcTypeIcon(t));
            if (index == this.edgeTypeCB.getSelectedIndex()) {
                if (index < this.edgeTypeCB.getItemCount() - 1) {
                    this.edgeTypeCB.setSelectedIndex(this.edgeTypeCB.getItemCount() - 1);
                } else {
                    this.edgeTypeCB.setSelectedIndex(0);
                }
            }
            this.edgeTypeCB.setSelectedItem(mi);
            int indx = index + this.nodeTypes.size();
            this.patternTable.setValueAt(mi, indx, 0);
            this.patternTable.setValueAt("", indx, 1);
            this.patternTable.setValueAt("", indx, 2);
            this.patternTable.setValueAt("", indx, 3);
            this.patternTable.setValueAt("", indx, 4);
            this.updateLayoutPatternOfType(t, indx);
        }
    }

    private JTable createLayoutPatternTable() {
        DefaultTableModel dataModel = new DefaultTableModel(new String[]{"Type", "X-Axis", "Y-Axis", "Length", "FixNodePos"}, 5){

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public int getRowCount() {
                int nn = 0;
                if (GraphLayouterOptionGUI.this.nodeTypes != null) {
                    nn = GraphLayouterOptionGUI.this.nodeTypes.size();
                }
                if (GraphLayouterOptionGUI.this.edgeTypes != null) {
                    nn += GraphLayouterOptionGUI.this.edgeTypes.size();
                }
                return nn;
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row < super.getRowCount() && col < super.getColumnCount()) {
                    return super.getValueAt(row, col);
                }
                return null;
            }
        };
        JTable table = new JTable(dataModel);
        table.getSelectionModel().setSelectionMode(0);
        table.setDefaultRenderer(table.getColumnClass(0), new MyTableCellRenderer(false));
        if (this.scrollpanePatternTable == null) {
            this.scrollpanePatternTable = new JScrollPane(table);
        } else {
            this.scrollpanePatternTable.setViewportView(table);
        }
        return table;
    }

    private void createEdgePatternTableEntries(JTable table) {
        int row = 0;
        while (row < this.edgeTypes.size()) {
            EdType type = this.edgeTypes.get(row);
            JLabel typel = new JLabel(type.getName());
            typel.setIcon(this.getArcTypeIcon(type));
            typel.setForeground(type.getColor());
            int r = row + this.nodeTypes.size();
            table.getModel().setValueAt(typel, r, 0);
            table.getModel().setValueAt("", r, 1);
            table.getModel().setValueAt("", r, 2);
            table.getModel().setValueAt("", r, 3);
            table.getModel().setValueAt("", r, 4);
            if (this.gragra != null) {
                Vector<LayoutPattern> v = this.gragra.getLayoutPatternsForType(type.getBasisType());
                int j = 0;
                while (j < v.size()) {
                    LayoutPattern lp = v.get(j);
                    if (lp.isEdgePattern() && lp.isXOffset()) {
                        if (lp.getOffset() == 1) {
                            table.getModel().setValueAt("TarRightSrc", r, 1);
                        } else if (lp.getOffset() == -1) {
                            table.getModel().setValueAt("TarLeftSrc", r, 1);
                        } else if (lp.getOffset() == 0) {
                            table.getModel().setValueAt("TarEqualSrc", r, 1);
                        }
                    } else if (lp.isEdgePattern() && lp.isYOffset()) {
                        if (lp.getOffset() == 1) {
                            table.getModel().setValueAt("TarUnderSrc", r, 2);
                        } else if (lp.getOffset() == -1) {
                            table.getModel().setValueAt("TarAboveSrc", r, 2);
                        } else if (lp.getOffset() == 0) {
                            table.getModel().setValueAt("TarEqualSrc", r, 2);
                        }
                    } else if (lp.isEdgePattern() && lp.isLengthPattern()) {
                        table.getModel().setValueAt(String.valueOf(lp.getLength()), r, 3);
                    }
                    ++j;
                }
            }
            ++row;
        }
    }

    private void createNodePatternTableEntries(JTable table) {
        int row = 0;
        while (row < this.nodeTypes.size()) {
            EdType type = this.nodeTypes.get(row);
            JLabel typel = new JLabel(type.getName());
            typel.setIcon(this.getNodeTypeIcon(type));
            typel.setForeground(type.getColor());
            table.getModel().setValueAt(typel, row, 0);
            table.getModel().setValueAt("", row, 1);
            table.getModel().setValueAt("", row, 2);
            table.getModel().setValueAt("", row, 3);
            table.getModel().setValueAt("", row, 4);
            if (this.gragra != null) {
                Vector<LayoutPattern> v = this.gragra.getLayoutPatternsForType(type.getBasisType());
                int j = 0;
                while (j < v.size()) {
                    LayoutPattern lp = v.get(j);
                    if (lp.isNodePattern() && lp.getName().equals("frozen_node")) {
                        table.getModel().setValueAt("true", row, 4);
                    }
                    ++j;
                }
            }
            ++row;
        }
    }

    private void createPatternTableFrame(JTable table) {
        this.scrollpanePatternTable = new JScrollPane(table);
        table.getSelectionModel().addListSelectionListener(this);
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphLayouterOptionGUI.this.tableFrame.setVisible(false);
            }
        });
        this.tableFrame = new JDialog();
        this.tableFrame.setTitle(" Node & Edge Type Layout Pattern ");
        this.tableFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GraphLayouterOptionGUI.this.setVisible(false);
            }
        });
        this.tableFrame.setModal(false);
        this.tableFrame.getContentPane().setLayout(new BorderLayout());
        this.tableFrame.getContentPane().add((Component)this.scrollpanePatternTable, "Center");
        this.tableFrame.getContentPane().add((Component)closeButton, "South");
        int fheight = 100;
        if (table.getRowCount() > 0) {
            fheight = table.getCellRect((int)0, (int)0, (boolean)true).height * (table.getRowCount() + 6);
        }
        this.tableFrame.setSize(new Dimension(400, fheight));
        this.tableFrame.validate();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int indx = e.getFirstIndex();
        if (indx < this.edgeTypeCB.getItemCount()) {
            this.edgeTypeCB.setSelectedIndex(indx);
        }
    }

    private Icon getArcTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 61: {
                icon = new ColorSolidLineIcon(et.color);
                break;
            }
            case 62: {
                icon = new ColorDashLineIcon(et.color);
                break;
            }
            case 63: {
                icon = new ColorDotLineIcon(et.color);
                break;
            }
        }
        return icon;
    }

    public Icon getNodeTypeIcon(EdType et) {
        Icon icon = null;
        switch (et.shape) {
            case 51: {
                icon = new RectShapeIcon(et.color);
                break;
            }
            case 54: {
                icon = new RoundRectShapeIcon(et.color);
                break;
            }
            case 52: {
                icon = new CircleShapeIcon(et.color);
                break;
            }
            case 53: {
                icon = new OvalShapeIcon(et.color);
                break;
            }
        }
        return icon;
    }

    void updateLayoutPatternOfType(EdType type, int indx) {
        boolean isNode;
        if (this.patternTable == null) {
            return;
        }
        boolean bl = isNode = this.nodeTypes.contains(type);
        if (this.patternTable.getModel().getValueAt(indx, 1) == null) {
            return;
        }
        if (type.getTypeName().equals(((JLabel)this.patternTable.getModel().getValueAt(indx, 0)).getText())) {
            if (!isNode) {
                if (((String)this.patternTable.getModel().getValueAt(indx, 1)).equals("TarLeftSrc")) {
                    this.x_leftCB.setSelected(true);
                    this.x_rightCB.setSelected(false);
                    this.x_equalCB.setSelected(false);
                } else if (((String)this.patternTable.getModel().getValueAt(indx, 1)).equals("TarRightSrc")) {
                    this.x_leftCB.setSelected(false);
                    this.x_rightCB.setSelected(true);
                    this.x_equalCB.setSelected(false);
                } else if (((String)this.patternTable.getModel().getValueAt(indx, 1)).equals("TarEqualSrc")) {
                    this.x_leftCB.setSelected(false);
                    this.x_rightCB.setSelected(false);
                    this.x_equalCB.setSelected(true);
                } else {
                    this.x_leftCB.setSelected(false);
                    this.x_rightCB.setSelected(false);
                    this.x_equalCB.setSelected(false);
                }
                if (((String)this.patternTable.getModel().getValueAt(indx, 2)).equals("TarAboveSrc")) {
                    this.y_aboveCB.setSelected(true);
                    this.y_underCB.setSelected(false);
                    this.y_equalCB.setSelected(false);
                } else if (((String)this.patternTable.getModel().getValueAt(indx, 2)).equals("TarUnderSrc")) {
                    this.y_aboveCB.setSelected(false);
                    this.y_underCB.setSelected(true);
                    this.y_equalCB.setSelected(false);
                } else if (((String)this.patternTable.getModel().getValueAt(indx, 2)).equals("TarEqualSrc")) {
                    this.y_aboveCB.setSelected(false);
                    this.y_underCB.setSelected(false);
                    this.y_equalCB.setSelected(true);
                } else {
                    this.y_aboveCB.setSelected(false);
                    this.y_underCB.setSelected(false);
                    this.y_equalCB.setSelected(false);
                }
                if (!((String)this.patternTable.getModel().getValueAt(indx, 3)).equals("")) {
                    this.edgeLengthTF.setText((String)this.patternTable.getModel().getValueAt(indx, 3));
                } else {
                    this.edgeLengthTF.setText("0");
                }
            } else if (((String)this.patternTable.getModel().getValueAt(indx, 4)).equals("true")) {
                if (!this.fixedNodePositionCB.isSelected()) {
                    this.fixedNodePositionCB.setSelected(true);
                }
            } else if (this.fixedNodePositionCB.isSelected()) {
                this.fixedNodePositionCB.setSelected(false);
            }
        }
    }

    private void constrainBuild(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    @Override
    public void executeOnClose() {
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        boolean allowSelect;

        public MyCellRenderer(boolean allowSelect) {
            this.allowSelect = allowSelect;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JLabel) {
                JLabel l = (JLabel)value;
                this.setForeground(l.getForeground());
                this.setIcon(l.getIcon());
                this.setText(l.getText());
            } else if (value instanceof String) {
                this.setText((String)value);
            } else {
                this.setText("");
            }
            if (this.allowSelect && isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            this.setOpaque(true);
            return this;
        }
    }

    class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        boolean allowSelect;

        public MyTableCellRenderer(boolean allowSelect) {
            this.allowSelect = allowSelect;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (this.allowSelect && isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            if (value instanceof JLabel) {
                JLabel l = (JLabel)value;
                if (column == 0) {
                    this.setIcon(l.getIcon());
                    this.setForeground(l.getForeground());
                    this.setText(l.getText());
                    return this;
                }
                return new JLabel(l.getText());
            }
            if (value instanceof String) {
                return new JLabel((String)value);
            }
            return new JLabel("");
        }
    }
}

