/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.PairContainer;
import agg.parser.Parser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserMessageEvent;
import agg.parser.RuleInstances;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.StaticStep;
import agg.xt_basis.TypeException;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractParser
implements Parser {
    protected GraGra grammar;
    protected Graph graph;
    protected Graph stopGraph;
    protected PairContainer pairContainer;
    protected Vector<ParserEventListener> listener = new Vector();
    protected int delay;

    public AbstractParser(GraGra grammar, Graph hostGraph, Graph stopGraph, PairContainer pairContainer) {
        this.setHostGraph(hostGraph);
        this.setStopGraph(stopGraph);
        this.setGrammar(grammar);
        this.setCriticalPairs(pairContainer);
    }

    @Override
    public void setHostGraph(Graph hostGraph) {
        this.graph = hostGraph;
    }

    @Override
    public void setStopGraph(Graph stopGraph) {
        this.stopGraph = stopGraph;
    }

    @Override
    public void setCriticalPairs(PairContainer pairs) {
        this.pairContainer = pairs;
    }

    @Override
    public void setGrammar(GraGra grammar) {
        this.grammar = grammar;
    }

    @Override
    public Graph getHostGraph() {
        return this.graph;
    }

    @Override
    public Graph getGraph() {
        return this.getHostGraph();
    }

    @Override
    public Graph getStopGraph() {
        return this.stopGraph;
    }

    @Override
    public abstract boolean parse();

    protected boolean applyRule(Match m) {
        Morphism comatch = null;
        if (m.isValid()) {
            try {
                comatch = StaticStep.execute(m);
                ((OrdinaryMorphism)comatch).dispose();
            }
            catch (TypeException e) {
                this.fireParserEvent(new ParserErrorEvent(this, "Rule  <" + m.getRule().getName() + ">  cannot be applied"));
                return false;
            }
            this.fireParserEvent(new ParserMessageEvent(this, "Rule  <" + m.getRule().getName() + ">  is applied"));
            m.dispose();
        } else {
            this.fireParserEvent(new ParserErrorEvent(this, "Rule  <" + m.getRule().getName() + ">  cannot be applied"));
        }
        return true;
    }

    protected Match findMatch(Graph g, Iterator<?> rules, RuleInstances eri) {
        boolean found = false;
        Match resultMatch = null;
        while (rules.hasNext() && !found) {
            Rule rule = (Rule)rules.next();
            resultMatch = BaseFactory.theFactory().createMatch(rule, g);
            resultMatch.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
            while (!found && resultMatch.nextCompletion()) {
                if (!resultMatch.isValid()) continue;
                if (eri != null) {
                    if (eri.isIn(resultMatch)) continue;
                    found = true;
                    continue;
                }
                found = true;
            }
            if (found) continue;
            BaseFactory.theFactory().destroyMatch(resultMatch);
            resultMatch = null;
        }
        return resultMatch;
    }

    protected Match findMatch(Graph g, Iterator<Rule> rules) {
        return this.findMatch(g, rules, null);
    }

    protected void finalize() {
        this.getHostGraph().dispose();
    }

    public void parseString() {
    }

    @Override
    public void addParserEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.addElement(l);
        }
    }

    @Override
    public void removeParserEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    protected synchronized void fireParserEvent(ParserEvent event) {
        int i = 0;
        while (i < this.listener.size()) {
            this.listener.elementAt(i).parserEventOccured(event);
            ++i;
        }
    }

    protected void printImageGraph(Morphism m) {
        GraphObject i;
        System.out.println("Image graph of match:  " + m);
        Graph left = m.getOriginal();
        for (GraphObject graphObject : left.getNodesSet()) {
            i = m.getImage(graphObject);
            if (i == null) continue;
            System.out.print(i);
        }
        for (GraphObject graphObject : left.getArcsSet()) {
            i = m.getImage(graphObject);
            if (i == null) continue;
            System.out.print(i);
        }
        System.out.println();
    }

    protected void printGraph(Graph g) {
        System.out.println("Graph of match:  ");
        for (GraphObject graphObject : g.getNodesSet()) {
            System.out.print(graphObject);
        }
        for (GraphObject graphObject : g.getArcsSet()) {
            System.out.print(graphObject);
        }
        System.out.println();
    }

    @Override
    public void setDelayAfterApplyRule(int miliseconds) {
        this.delay = miliseconds;
    }
}

