/*
 * Decompiled with CFR 0.152.
 */
package agg.ruleappl;

import agg.parser.CriticalPairOption;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Rule;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ApplRuleSequence
implements XMLObject {
    private String dirName;
    private GraGra gragra;
    private CriticalPairOption cpOption;
    private final List<RuleSequence> ruleSequences = new Vector<RuleSequence>();

    public ApplRuleSequence(CriticalPairOption cpOption) {
        this.cpOption = cpOption;
    }

    public void dispose() {
        this.clear();
        this.gragra = null;
    }

    public void clear() {
        this.ruleSequences.clear();
    }

    public void setGraGra(GraGra gra) {
        this.gragra = gra;
        this.ruleSequences.clear();
    }

    public GraGra getGraGra() {
        return this.gragra;
    }

    public boolean isEmpty() {
        return this.ruleSequences.isEmpty();
    }

    public List<RuleSequence> getRuleSequences() {
        return this.ruleSequences;
    }

    public RuleSequence getRuleSequence(int indx) {
        if (indx >= 0 && indx < this.ruleSequences.size()) {
            return this.ruleSequences.get(indx);
        }
        return null;
    }

    public Pair<Boolean, String> getApplicabilityResult(int indx) {
        Pair<Boolean, String> result = null;
        if (indx >= 0 && indx < this.ruleSequences.size()) {
            result = this.ruleSequences.get(indx).getApplicabilityResult();
        }
        return result;
    }

    public Pair<Boolean, String> getNonApplicabilityResult(int indx) {
        Pair<Boolean, String> result = null;
        if (indx >= 0 && indx < this.ruleSequences.size()) {
            result = this.ruleSequences.get(indx).getNonApplicabilityResult();
        }
        return result;
    }

    public boolean removeResult(int indx) {
        if (indx >= 0 && indx < this.ruleSequences.size()) {
            this.ruleSequences.get(indx).uncheck();
            return true;
        }
        return false;
    }

    public void setRuleSequences(List<RuleSequence> list) {
        this.ruleSequences.clear();
        int i = 0;
        while (i < list.size()) {
            this.ruleSequences.add(list.get(i));
            ++i;
        }
    }

    public void setRuleSequence(RuleSequence sequence) {
        this.ruleSequences.clear();
        this.ruleSequences.add(sequence);
    }

    public RuleSequence addRuleSequence(List<String> listOfRuleNames, Graph graph) {
        if (this.gragra == null) {
            return null;
        }
        RuleSequence rseq = new RuleSequence(this.gragra, "RuleSequence", this.cpOption);
        rseq.setGraph(graph);
        int i = 0;
        while (i < listOfRuleNames.size()) {
            String rname = listOfRuleNames.get(i);
            Rule rule = this.gragra.getRule(rname);
            if (rule == null) {
                rseq.dispose();
                return null;
            }
            rseq.addRule(rule);
            ++i;
        }
        return rseq;
    }

    public void addRuleSequence(RuleSequence sequence) {
        this.ruleSequences.add(sequence);
    }

    public void addRuleSequenceAt(int indx, RuleSequence sequence) {
        this.ruleSequences.add(indx, sequence);
    }

    public void setGraphOfRuleSequence(int indx, Graph g) {
        if (indx >= 0 && indx < this.ruleSequences.size()) {
            RuleSequence seq = this.ruleSequences.get(indx);
            seq.setGraph(g);
        }
    }

    public boolean removeRuleSequence(int indx) {
        if (indx >= 0 && indx < this.ruleSequences.size()) {
            RuleSequence seq = this.ruleSequences.get(indx);
            this.ruleSequences.remove(indx);
            seq.dispose();
            return true;
        }
        return false;
    }

    public RuleSequence copyRuleSequence(int seqIndx) {
        if (seqIndx >= 0 && seqIndx < this.ruleSequences.size()) {
            RuleSequence seq = this.ruleSequences.get(seqIndx);
            RuleSequence seqCopy = seq.getCopy();
            if (++seqIndx < this.ruleSequences.size()) {
                this.ruleSequences.add(seqIndx, seqCopy);
            } else {
                this.ruleSequences.add(seqCopy);
            }
            return seqCopy;
        }
        return null;
    }

    public void moveRuleSequence(int from, int to) {
        if (from >= 0 && from < this.ruleSequences.size() && to >= 0 && to < this.ruleSequences.size()) {
            this.moveSequence(from, to);
        }
    }

    private void moveSequence(int from, int to) {
        RuleSequence seq = this.ruleSequences.get(from);
        this.ruleSequences.remove(from);
        this.ruleSequences.add(to, seq);
    }

    public void moveRuleInsideSequence(int seqIndx, int from, int to) {
        if (seqIndx >= 0 && seqIndx < this.ruleSequences.size()) {
            RuleSequence seq = this.ruleSequences.get(seqIndx);
            seq.moveRule(from, to);
        }
    }

    public boolean hasChecked(int seqIndx) {
        return this.ruleSequences.get(seqIndx).isChecked();
    }

    public Pair<Boolean, List<String>> getRuleResult(int seqIndx, int indx, String ruleName, String criterion) {
        RuleSequence seq = this.ruleSequences.get(seqIndx);
        return seq.getRuleResult(indx, ruleName, criterion);
    }

    public boolean check(int seqIndx) {
        if (seqIndx >= 0 && seqIndx < this.ruleSequences.size()) {
            RuleSequence seq = this.ruleSequences.get(seqIndx);
            return this.check(seq);
        }
        return false;
    }

    public boolean check(RuleSequence sequence) {
        boolean result = sequence.check();
        return result;
    }

    public int getIndexOf(RuleSequence sequence) {
        return this.ruleSequences.indexOf(sequence);
    }

    public void save(String filename) {
        String rsx = ".rsx";
        String outfileName = "";
        if ("".equals(filename)) {
            outfileName = this.gragra.getFileName().concat("_out.rsx");
        } else {
            outfileName = filename;
            if (outfileName.indexOf(rsx) == -1) {
                outfileName = outfileName.concat(rsx);
            }
        }
        XMLHelper xmlh = new XMLHelper();
        xmlh.addTopObject(this);
        xmlh.save_to_xml(outfileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GraGra load(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) throw new Exception("File  \"" + filename + "\"  doesn't exist!");
        if (!filename.endsWith(".rsx")) throw new Exception("File  \"" + filename + "\"  is not a  \".rsx\"  file!");
        this.gragra = BaseFactory.theFactory().createGraGra(false);
        XMLHelper h = new XMLHelper();
        if (!h.read_from_xml(filename)) throw new Exception("File  \"" + filename + "\"  is not a  \".rsx\"  file!");
        h.getTopObject(this);
        this.dirName = f.getParent() == null ? "." + File.separator : String.valueOf(f.getParent()) + File.separator;
        return this.gragra;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GraGra load(String filename, XMLHelper h) throws Exception {
        File f = new File(filename);
        if (!f.exists()) throw new Exception("File  \"" + filename + "\"  doesn't exist!");
        if (!filename.endsWith(".rsx")) throw new Exception("File  \"" + filename + "\"  is not a  \".rsx\"  file!");
        this.gragra = BaseFactory.theFactory().createGraGra(false);
        if (!h.read_from_xml(filename)) {
            throw new Exception("File  \"" + filename + "\"  is not a  \".rsx\"  file!");
        }
        h.getTopObject(this);
        String fileName = f.getName();
        this.dirName = f.getParent() == null ? "." + File.separator : String.valueOf(f.getParent()) + File.separator;
        this.gragra.setDirName(this.dirName);
        this.gragra.setFileName(fileName);
        return this.gragra;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("RuleSequenceApplicability", this);
        h.addObject("GraGra", this.gragra, true);
        h.openSubTag("RuleSequences");
        int i = 0;
        while (i < this.ruleSequences.size()) {
            RuleSequence seq = this.ruleSequences.get(i);
            boolean result = (Boolean)seq.getApplicabilityResult().first;
            String text = (String)seq.getApplicabilityResult().second;
            boolean result2 = (Boolean)seq.getNonApplicabilityResult().first;
            String text2 = (String)seq.getNonApplicabilityResult().second;
            h.openSubTag("Sequence");
            h.addAttr("name", seq.getName());
            h.openSubTag("ConcurrentRule");
            if (seq.getDepthOfConcurrentRule() == -1) {
                h.addAttr("depth", "undefined");
            } else {
                h.addAttr("depth", String.valueOf(seq.getDepthOfConcurrentRule()));
            }
            h.addAttr("complete", String.valueOf(seq.getCompleteConcurrency()));
            h.addAttr("completecpa", String.valueOf(seq.getCompleteCPAOfConcurrency()));
            h.addAttr("ignoredanglingedge", String.valueOf(seq.getIgnoreDanglingEdgeOfDelNode()));
            h.close();
            h.openSubTag("Item");
            h.addAttr("kind", "applicable");
            h.addAttr("result", String.valueOf(result));
            h.addAttr("criterion", text);
            h.close();
            h.openSubTag("Item");
            h.addAttr("kind", "nonapplicable");
            h.addAttr("result", String.valueOf(result2));
            h.addAttr("criterion", text2);
            h.close();
            if (seq.getGraph() != null) {
                h.openSubTag("Graph");
                h.addObject("id", seq.getGraph(), false);
                h.close();
            }
            Hashtable<String, Pair<Boolean, List<String>>> ruleRes = seq.getRuleResults();
            int j = 0;
            while (j < seq.getRules().size()) {
                Rule rule = seq.getRules().get(j);
                String ruleName = rule.getName();
                h.openSubTag("Rule");
                h.addObject("id", rule, false);
                if (ruleRes != null) {
                    Enumeration<String> keys = ruleRes.keys();
                    while (keys.hasMoreElements()) {
                        Pair<Boolean, List<String>> resultpair;
                        String key = keys.nextElement();
                        if (key.indexOf(String.valueOf(j).concat(ruleName)) != 0 || (resultpair = ruleRes.get(key)) == null) continue;
                        h.openSubTag("Item");
                        h.addAttr("result", String.valueOf(resultpair.first));
                        h.addAttr("criterion", (String)((List)resultpair.second).get(0));
                        h.addAttr("text", (String)((List)resultpair.second).get(1));
                        h.close();
                    }
                } else {
                    h.addAttr("result", "true");
                    h.addAttr("criterion", "undefined");
                    h.addAttr("text", "undefined");
                }
                h.close();
                ++j;
            }
            h.close();
            ++i;
        }
        h.close();
        h.close();
    }

    private RuleSequence getSequence(String name) {
        int i = 0;
        while (i < this.ruleSequences.size()) {
            if (this.ruleSequences.get(i).getName().equals(name)) {
                return this.ruleSequences.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("RuleSequenceApplicability", this)) {
            h.getObject("", this.gragra, true);
            this.ruleSequences.clear();
            if (!this.gragra.getRuleSequences().isEmpty()) {
                this.setRuleSequences(this.gragra.getRuleSequences());
            }
            if (h.readSubTag("RuleSequences")) {
                while (h.readSubTag("Sequence")) {
                    String strName = h.readAttr("name");
                    boolean newSequence = false;
                    RuleSequence seq = this.getSequence(strName);
                    if (seq == null) {
                        seq = new RuleSequence(this.gragra, "RuleSequence", this.cpOption);
                        if (!strName.equals("")) {
                            seq.setName(strName);
                        }
                        this.ruleSequences.add(seq);
                        newSequence = true;
                    }
                    if (h.readSubTag("ConcurrentRule")) {
                        String depthstr = h.readAttr("depth");
                        if ("undefined".equals(depthstr)) {
                            seq.setDepthOfConcurrentRule(-1);
                        } else {
                            seq.setDepthOfConcurrentRule(Integer.valueOf(depthstr));
                        }
                        String completestr = h.readAttr("complete");
                        seq.setCompleteConcurrency(Boolean.valueOf(completestr));
                        String completecpastr = h.readAttr("completecpa");
                        seq.setCompleteCPAOfConcurrency(Boolean.valueOf(completecpastr));
                        String danglingedgestr = h.readAttr("ignoredanglingedge");
                        seq.setIgnoreDanglingEdgeOfDelNode(Boolean.valueOf(danglingedgestr));
                        h.close();
                    }
                    Pair<Object, Object> result = new Pair<Object, Object>(null, null);
                    Pair<Object, Object> criterion = new Pair<Object, Object>(null, null);
                    while (h.readSubTag("Item")) {
                        String kind = h.readAttr("kind");
                        String res = h.readAttr("result");
                        String str = h.readAttr("criterion");
                        if ("applicable".equals(kind)) {
                            result.first = Boolean.valueOf(res);
                            criterion.first = str;
                        } else if ("nonapplicable".equals(kind)) {
                            result.second = Boolean.valueOf(res);
                            criterion.second = str;
                        }
                        h.close();
                    }
                    if (newSequence && h.readSubTag("Graph")) {
                        Graph g = (Graph)h.getObject("id", null, false);
                        if (g != null) {
                            seq.setGraph(g);
                        }
                        h.close();
                    }
                    int indx = -1;
                    while (h.readSubTag("Rule")) {
                        Rule r = (Rule)h.getObject("id", null, false);
                        if (newSequence) {
                            seq.addRule(r);
                        }
                        ++indx;
                        while (h.readSubTag("Item")) {
                            String criterionStr = h.readAttr("criterion");
                            String res = h.readAttr("result");
                            String text = h.readAttr("text");
                            h.close();
                            seq.setRuleResult(indx, r.getName(), Boolean.parseBoolean(res), criterionStr, text);
                        }
                        h.close();
                    }
                    seq.setApplicabilityResult((Boolean)result.first, (String)criterion.first);
                    seq.setNonApplicabilityResult((Boolean)result.second, (String)criterion.second);
                    seq.checked = !"undefined".equals(criterion.first) && !"undefined".equals(criterion.second);
                    h.close();
                }
                h.close();
            }
            h.close();
        }
    }
}

