/*
 * Decompiled with CFR 0.152.
 */
package agg.ruleappl;

import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ObjectFlow {
    final Hashtable<Object, Object> outputInputMap;
    final Object srcOfOutput;
    final Object srcOfInput;
    int indxOfOutput = -1;
    int indxOfInput = -1;

    public ObjectFlow(Object sourceOfOutput, Object sourceOfInput, int indxOfOutput, int indxOfInput) {
        this.srcOfOutput = sourceOfOutput;
        this.srcOfInput = sourceOfInput;
        this.indxOfOutput = indxOfOutput;
        this.indxOfInput = indxOfInput;
        this.outputInputMap = new Hashtable();
    }

    public ObjectFlow(Object sourceOfOutput, Object sourceOfInput, int indxOfOutput, int indxOfInput, Hashtable<Object, Object> outputInputMap) {
        this.srcOfOutput = sourceOfOutput;
        this.srcOfInput = sourceOfInput;
        this.indxOfOutput = indxOfOutput;
        this.indxOfInput = indxOfInput;
        this.outputInputMap = outputInputMap;
    }

    public boolean isGraphExtended() {
        return this.srcOfOutput instanceof Graph;
    }

    public Object getSourceOfOutput() {
        return this.srcOfOutput;
    }

    public Object getSourceOfInput() {
        return this.srcOfInput;
    }

    public int getIndexOfOutput() {
        return this.indxOfOutput;
    }

    public int getIndexOfInput() {
        return this.indxOfInput;
    }

    public String getNameOfOutput() {
        if (this.srcOfOutput instanceof Graph) {
            return ((Graph)this.srcOfOutput).getName();
        }
        if (this.srcOfOutput instanceof Rule) {
            return ((Rule)this.srcOfOutput).getName();
        }
        return "";
    }

    public String getNameOfInput() {
        if (this.srcOfInput instanceof Rule) {
            return ((Rule)this.srcOfInput).getName();
        }
        return "";
    }

    public boolean isSourceOfOutput(Object src) {
        return src == this.srcOfOutput;
    }

    public boolean isSourceOfInput(Object src) {
        return src == this.srcOfInput;
    }

    public void addMapping(Object output, Object input) {
        if (output != null && input != null) {
            this.outputInputMap.put(output, input);
        }
    }

    public void removeMapping(Object output) {
        if (output != null) {
            this.outputInputMap.remove(output);
        }
    }

    public Hashtable<Object, Object> getMapping() {
        return this.outputInputMap;
    }

    public int getSizeOfInput() {
        return this.outputInputMap.size();
    }

    public Object getOutput(Object input) {
        if (input != null) {
            Enumeration<Object> keys = this.outputInputMap.keys();
            while (keys.hasMoreElements()) {
                Object out = keys.nextElement();
                if (this.outputInputMap.get(out) != input) continue;
                return out;
            }
        }
        return null;
    }

    public Object getConnectedInput(ObjectFlow otherObjFlow, Object myInputObj) {
        Enumeration<GraphObject> inv;
        Object outObj = this.getOutput(myInputObj);
        if (this.srcOfOutput instanceof Rule && outObj instanceof GraphObject && (inv = ((Rule)this.srcOfOutput).getInverseImage((GraphObject)outObj)).hasMoreElements()) {
            return inv.nextElement();
        }
        return null;
    }

    public Object getConnectedOutput(ObjectFlow otherObjFlow, Object myInputObj) {
        Enumeration<GraphObject> inv;
        Object outObj = this.getOutput(myInputObj);
        if (this.srcOfOutput instanceof Rule && outObj instanceof GraphObject && (inv = ((Rule)this.srcOfOutput).getInverseImage((GraphObject)outObj)).hasMoreElements()) {
            GraphObject otherInput = inv.nextElement();
            return otherObjFlow.getOutput(otherInput);
        }
        return null;
    }

    public boolean isInputObject(Object obj) {
        Iterator<Object> inputs = this.outputInputMap.values().iterator();
        while (inputs.hasNext()) {
            if (inputs.next() != obj) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputObject(Object obj) {
        Enumeration<Object> outputs = this.outputInputMap.keys();
        while (outputs.hasMoreElements()) {
            if (outputs.nextElement() != obj) continue;
            return true;
        }
        return false;
    }

    public Object getInput(Object output) {
        if (output != null) {
            return this.outputInputMap.get(output);
        }
        return null;
    }

    public List<Object> getInputs() {
        return new Vector<Object>(this.outputInputMap.values());
    }

    public boolean isEmpty() {
        return this.outputInputMap.isEmpty();
    }

    public String getKey() {
        return String.valueOf(this.indxOfOutput).concat(":").concat(String.valueOf(this.indxOfInput));
    }

    public boolean compareTo(ObjectFlow objFlow) {
        if (objFlow == null) {
            return false;
        }
        Vector<Object> keys1 = new Vector<Object>(this.outputInputMap.keySet());
        Vector<Object> keys2 = new Vector<Object>(objFlow.getMapping().keySet());
        if (keys1.size() == keys2.size() && keys1.containsAll(keys2)) {
            int i = 0;
            while (i < keys1.size()) {
                if (this.outputInputMap.get(keys1.get(i)) != objFlow.getMapping().get(keys1.get(i))) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }
}

