/*
 * Decompiled with CFR 0.152.
 */
package agg.util;

import agg.attribute.AttrInstance;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public final class Debug {
    public static boolean DEBUG = false;
    public static boolean ABSTRACTION = false;
    public static boolean PARSING = false;
    public static boolean HASHCODE = false;
    public static boolean MATCH = false;
    public static boolean CSP_VAR = false;
    private static HashMap<Object, Integer> hash = null;
    private static int new_id;
    private static File f;
    private static FileOutputStream os;

    private Debug() {
    }

    public static final void println(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static final void print(String msg) {
        if (DEBUG) {
            System.out.print(msg);
        }
    }

    public static final void println(String msg, Object obj) {
        if (DEBUG) {
            System.out.println(String.valueOf(obj.getClass().getName()) + ": " + msg);
        }
    }

    public static final void print(String msg, Object obj) {
        if (DEBUG) {
            System.out.print(String.valueOf(obj.getClass().getName()) + ": " + msg);
        }
    }

    public static final void println(String msg, Object obj, boolean topic) {
        if (topic) {
            System.out.println(String.valueOf(obj.getClass().getName()) + ": " + msg);
        }
    }

    public static void printlnGraph(Graph printGraph, String name, boolean topic) {
        if (topic) {
            Debug.printlnGraph(printGraph, name);
        }
    }

    private static void reset() {
        hash = new HashMap();
        new_id = 1;
    }

    private static int get_id(Object o) {
        if (hash == null) {
            return 0;
        }
        Integer i = hash.get(o);
        if (i == null) {
            i = new Integer(new_id++);
            hash.put(o, i);
        }
        return i;
    }

    public static void printlnGraph(Graph g, String name) {
        Debug.printlnGraph2(g, name, false);
    }

    public static void printlnNode(GraphObject o) {
        System.out.print(String.valueOf(o.getType().getStringRepr()) + ": (");
        if (o.getAttribute() != null) {
            Debug.printAttributes(o.getAttribute());
        }
        System.out.println(")");
    }

    private static void printlnGraph2(Graph printGraph, String name, boolean for_morph) {
        Iterator<Node> nodes = printGraph.getNodesSet().iterator();
        System.out.println("--------------- Graph: " + name + " beginns ---------------");
        if (!for_morph) {
            System.out.println();
        }
        while (nodes.hasNext()) {
            Arc arc;
            Node node = nodes.next();
            System.out.print(String.valueOf(Debug.get_id(node)) + " " + node.getType().getStringRepr() + ": (");
            if (node.getAttribute() != null) {
                Debug.printAttributes(node.getAttribute());
            }
            System.out.println(") ");
            Iterator<Arc> incoming = node.getIncomingArcsSet().iterator();
            System.out.print("  incoming: ");
            while (incoming.hasNext()) {
                arc = incoming.next();
                Node src = (Node)arc.getSource();
                System.out.print("(" + Debug.get_id(arc) + " " + arc.getType().getStringRepr() + " <--  " + Debug.get_id(src) + " " + src.getType().getStringRepr() + "[ ");
                if (arc.getAttribute() != null) {
                    Debug.printAttributes(arc.getAttribute());
                }
                System.out.print("]) ");
            }
            System.out.println();
            Iterator<Arc> outgoing = node.getOutgoingArcsSet().iterator();
            if (!outgoing.hasNext()) continue;
            System.out.print("  outgoing: ");
            while (outgoing.hasNext()) {
                arc = outgoing.next();
                Node tar = (Node)arc.getTarget();
                System.out.print("(" + Debug.get_id(arc) + " " + arc.getType().getStringRepr() + " --> " + Debug.get_id(tar) + " " + tar.getType().getStringRepr() + "[ ");
                if (arc.getAttribute() != null) {
                    Debug.printAttributes(arc.getAttribute());
                }
                System.out.print("]) ");
            }
            System.out.println();
        }
        if (!for_morph) {
            System.out.println("--------------- Graph: " + name + " ends ---------------\n");
        }
    }

    private static void printAttributes(AttrInstance attribute) {
        int i = 0;
        while (i < attribute.getNumberOfEntries()) {
            System.out.print(String.valueOf(attribute.getNameAsString(i)) + "=");
            System.out.print(String.valueOf(attribute.getValueAsString(i)) + " ");
            ++i;
        }
    }

    public static void printlnMorph(Morphism morph, String name, boolean topic) {
        if (topic) {
            Debug.printlnMorph(morph, name);
        }
    }

    public static void printlnMorph(Morphism morph, String name) {
        Graph srcG = morph.getOriginal();
        Graph tarG = morph.getImage();
        Debug.reset();
        System.out.println("--------------- Morphism: " + name + " beginns ---------------");
        Debug.printlnGraph2(srcG, "source graph", true);
        Debug.printlnGraph2(tarG, "target graph", true);
        System.out.println("  ---- mappings ----");
        System.out.println("Nodes: ");
        for (Node node : srcG.getNodesSet()) {
            System.out.print("  source: " + Debug.get_id(node) + " " + node.getType().getStringRepr() + ": (");
            if (node.getAttribute() != null) {
                Debug.printAttributes(node.getAttribute());
            }
            System.out.print(") --> ");
            Node mappedNode = (Node)morph.getImage(node);
            if (mappedNode != null) {
                System.out.print("target: " + Debug.get_id(mappedNode) + " " + mappedNode.getType().getStringRepr() + ": (");
                if (mappedNode.getAttribute() != null) {
                    Debug.printAttributes(mappedNode.getAttribute());
                }
                System.out.println(")");
                continue;
            }
            System.out.println("no target");
        }
        System.out.println("--------------- Morphism: " + name + " ends ---------------\n");
        hash = null;
    }

    public static void openFile(String fname, String text) {
        f = new File(fname);
        try {
            os = new FileOutputStream(f);
            try {
                os.write(text.getBytes());
                os.write(10);
                try {
                    os.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static void closeFile(String fname) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        os = null;
        f = null;
    }

    public static void outInFile(String fname, String text) {
        f = new File(fname);
        try {
            os = new FileOutputStream(f, true);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        if (os != null) {
            try {
                os.write(text.getBytes());
                os.write(10);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

