/*
 * Decompiled with CFR 0.152.
 */
package agg.util.colim;

import agg.util.colim.Container;
import agg.util.colim.ForwardIterator;
import agg.util.colim.InputIterator;
import agg.util.colim.IntArray;
import agg.util.colim.IntIterator;
import java.util.Enumeration;

public class IntBuffer
implements Container {
    static final int HASH_SIZE = 16;
    static final int defaultValue = 0;
    int[] storage;
    int length;

    public IntBuffer() {
        this.clear();
    }

    public IntBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Attempt to create an IntBuffer with a negative size");
        }
        this.length = size;
        this.storage = new int[this.length];
    }

    public IntBuffer(int size, int object) {
        this(size);
        int i = 0;
        while (i < this.length) {
            this.storage[i] = object;
            ++i;
        }
    }

    public IntBuffer(int[] array) {
        this(array, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntBuffer(int[] array, boolean copyBuffer) {
        int[] nArray = array;
        synchronized (array) {
            this.length = array.length;
            if (copyBuffer) {
                this.storage = new int[this.length];
                System.arraycopy(array, 0, this.storage, 0, this.length);
            } else {
                this.storage = array;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public IntBuffer(IntBuffer array) {
        this(array.storage);
    }

    @Override
    public synchronized Object clone() {
        return new IntBuffer(this);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof IntBuffer && this.equals((IntBuffer)object) || object instanceof IntArray && this.equals((IntArray)object);
    }

    public boolean equals(IntBuffer buffer) {
        return this.equals(new IntArray(buffer.storage));
    }

    public synchronized boolean equals(IntArray array) {
        return array.equals(this.storage);
    }

    public boolean equals(int[] array) {
        return this.equals(new IntArray(array));
    }

    @Override
    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer("IntBuffer");
        buffer.append("(");
        boolean first = true;
        IntIterator iter = this.begin();
        while (iter.hasMoreElements()) {
            if (first) {
                buffer.append(" ");
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(iter.nextElement());
        }
        if (first) {
            buffer.append(")");
        } else {
            buffer.append(" )");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copy(IntBuffer buffer) {
        if (this == buffer) {
            return;
        }
        IntBuffer intBuffer = buffer;
        synchronized (intBuffer) {
            if (buffer.length > this.storage.length) {
                this.storage = buffer.get();
            } else {
                System.arraycopy(buffer.storage, 0, this.storage, 0, buffer.length);
                int i = buffer.length;
                while (i < this.length) {
                    this.storage[i] = 0;
                    ++i;
                }
            }
            this.length = buffer.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyTo(int[] array) {
        int[] nArray = array;
        synchronized (array) {
            System.arraycopy(this.storage, 0, array, 0, Math.min(this.length, array.length));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized int[] get() {
        int[] data = new int[this.length];
        this.copyTo(data);
        return data;
    }

    public synchronized int hashCode() {
        return IntBuffer.orderedHash(this.begin(), this.length);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    @Override
    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int index) {
        return new Integer(this.intAt(index));
    }

    public synchronized int intAt(int index) {
        IntArray.checkIndex(index, this.length);
        return this.storage[index];
    }

    public synchronized void put(int index, Object object) {
        this.put(index, IntBuffer.asInt(object));
    }

    public synchronized void put(int index, int object) {
        IntArray.checkIndex(index, this.length);
        this.storage[index] = object;
    }

    @Override
    public synchronized void clear() {
        this.storage = new int[10];
        this.length = 0;
    }

    public synchronized Object remove(int index) {
        IntArray.checkIndex(index, this.length);
        Integer retval = new Integer(this.storage[index]);
        System.arraycopy(this.storage, index + 1, this.storage, index, this.length - index - 1);
        this.storage[--this.length] = 0;
        return retval;
    }

    public synchronized int remove(int first, int last) {
        if (last < first) {
            return 0;
        }
        IntArray.checkRange(first, last, this.length);
        int amount = last - first + 1;
        System.arraycopy(this.storage, last + 1, this.storage, first, this.length - last - 1);
        int i = this.length - amount;
        while (i < this.length) {
            this.storage[i] = 0;
            ++i;
        }
        this.length -= amount;
        return amount;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new RuntimeException("IntBuffer is empty");
        }
        Integer r = new Integer(this.storage[--this.length]);
        this.storage[this.length] = 0;
        return r;
    }

    @Override
    public synchronized Object add(Object object) {
        this.add(IntBuffer.asInt(object));
        return null;
    }

    public synchronized void add(int object) {
        if (this.length == this.storage.length) {
            int[] tmp = this.getNextStorage(1);
            this.copyTo(tmp);
            this.storage = tmp;
        }
        this.storage[this.length++] = object;
    }

    public void pushBack(Object object) {
        this.add(IntBuffer.asInt(object));
    }

    public void pushBack(int object) {
        this.add(object);
    }

    public IntIterator insert(IntIterator pos, Object object) {
        return this.insert(pos, IntBuffer.asInt(object));
    }

    public IntIterator insert(IntIterator pos, int object) {
        this.insert(pos.index, object);
        return new IntIterator(this, pos.index);
    }

    public void insert(int index, Object object) {
        this.insert(index, IntBuffer.asInt(object));
    }

    public synchronized void insert(int index, int object) {
        IntArray.checkIndex(index, this.length + 1);
        if (this.length != this.storage.length) {
            if (index != this.length) {
                System.arraycopy(this.storage, index, this.storage, index + 1, this.length - index);
            }
        } else {
            int[] tmp = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, tmp, 0, index);
            System.arraycopy(this.storage, index, tmp, index + 1, this.length - index);
            this.storage = tmp;
        }
        this.storage[index] = object;
        ++this.length;
    }

    public void insert(IntIterator pos, int n, Object object) {
        this.insert(pos, n, IntBuffer.asInt(object));
    }

    public void insert(IntIterator pos, int n, int object) {
        this.insert(pos.index, n, object);
    }

    public void insert(int index, int n, Object object) {
        this.insert(index, n, IntBuffer.asInt(object));
    }

    public synchronized void insert(int index, int n, int object) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n == 0) {
            return;
        }
        IntArray.checkIndex(index, this.length + 1);
        if (this.storage.length - this.length >= n) {
            System.arraycopy(this.storage, index, this.storage, index + n, this.length - index);
        } else {
            int[] tmp = this.getNextStorage(n);
            System.arraycopy(this.storage, 0, tmp, 0, index);
            System.arraycopy(this.storage, index, tmp, index + n, this.length - index);
            this.storage = tmp;
        }
        int i = index;
        while (i < index + n) {
            this.storage[i] = object;
            ++i;
        }
        this.length += n;
    }

    public void insert(IntIterator pos, ForwardIterator first, ForwardIterator last) {
        this.insert(pos.index, first, last);
    }

    public synchronized void insert(int index, ForwardIterator first, ForwardIterator last) {
        int n = first.distance(last);
        if (n == 0) {
            return;
        }
        ForwardIterator firstx = (ForwardIterator)first.clone();
        if (this.storage.length - this.length >= n) {
            System.arraycopy(this.storage, index, this.storage, index + n, this.length - index);
        } else {
            int[] tmp = this.getNextStorage(n);
            System.arraycopy(this.storage, 0, tmp, 0, index);
            System.arraycopy(this.storage, index, tmp, index + n, this.length - index);
            this.storage = tmp;
        }
        this.length += n;
        int i = index;
        while (i < index + n) {
            this.put(i, firstx.nextElement());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void swap(IntBuffer array) {
        IntBuffer intBuffer = array;
        synchronized (intBuffer) {
            int oldLength = this.length;
            int[] oldStorage = this.storage;
            this.length = array.length;
            this.storage = array.storage;
            array.length = oldLength;
            array.storage = oldStorage;
        }
    }

    @Override
    public Enumeration elements() {
        return new IntIterator(this, 0);
    }

    @Override
    public synchronized IntIterator begin() {
        return new IntIterator(this, 0);
    }

    @Override
    public synchronized IntIterator end() {
        return new IntIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            int[] tmp = new int[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, tmp, 0, this.length);
            }
            this.storage = tmp;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new RuntimeException("IntBuffer is empty");
        }
        Integer result = new Integer(this.storage[0]);
        this.remove(0);
        return result;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(int object) {
        this.insert(0, object);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int count) {
        int tmp = IntBuffer.asInt(object);
        int removed = 0;
        while (count > 0) {
            int i = this.indexOf(tmp);
            if (i < 0) break;
            --count;
            ++removed;
            this.remove(i);
        }
        return removed;
    }

    public int replace(Object oldValue, Object newValue) {
        return this.replace(IntBuffer.asInt(oldValue), IntBuffer.asInt(newValue));
    }

    public int replace(int oldValue, int newValue) {
        return this.replace(0, this.length - 1, oldValue, newValue);
    }

    public int replace(int first, int last, Object oldValue, Object newValue) {
        return this.replace(first, last, IntBuffer.asInt(oldValue), IntBuffer.asInt(newValue));
    }

    public synchronized int replace(int first, int last, int oldValue, int newValue) {
        IntArray.checkRange(first, last, this.length);
        int n = 0;
        while (first < last) {
            if (this.storage[first] == oldValue) {
                this.storage[first] = newValue;
                ++n;
            }
            ++first;
        }
        return n;
    }

    public int count(Object object) {
        return this.count(IntBuffer.asInt(object));
    }

    public int count(int object) {
        return this.count(0, this.length - 1, object);
    }

    public int count(int first, int last, Object object) {
        return this.count(first, last, IntBuffer.asInt(object));
    }

    public synchronized int count(int first, int last, int object) {
        IntArray.checkRange(first, last, this.length);
        int n = 0;
        while (first < last) {
            if (this.storage[first] == object) {
                ++n;
            }
            ++first;
        }
        return n;
    }

    public int indexOf(Object object) {
        return this.indexOf(IntBuffer.asInt(object));
    }

    public int indexOf(int object) {
        return this.indexOf(0, this.length - 1, object);
    }

    public int indexOf(int first, int last, Object object) {
        return this.indexOf(first, last, IntBuffer.asInt(object));
    }

    public synchronized int indexOf(int first, int last, int object) {
        if (last < first) {
            return -1;
        }
        IntArray.checkRange(first, last, this.length);
        while (first < last) {
            if (this.storage[first] == object) {
                return first;
            }
            ++first;
        }
        return -1;
    }

    public synchronized void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > newSize) {
            this.remove(newSize, this.length - 1);
        } else if (this.length < newSize) {
            this.insert(this.length, newSize - this.length, 0);
        }
    }

    public boolean contains(Object object) {
        return this.contains(IntBuffer.asInt(object));
    }

    public boolean contains(int object) {
        return this.indexOf(object) != -1;
    }

    private int[] getNextStorage(int n) {
        int newSize = Math.max(IntArray.getNextSize(this.length), this.length + n);
        int[] tmp = new int[newSize];
        return tmp;
    }

    static int asInt(Object object) {
        return ((Number)object).intValue();
    }

    static final int orderedHash(ForwardIterator iter, int length) {
        int h = 0;
        int position = 0;
        int skip = 1;
        if (length >= 16) {
            skip = length / 16;
            iter.advance(length % 16);
        }
        while (iter.hasMoreElements()) {
            if (iter.get() != null) {
                h ^= iter.get().hashCode() / (position % 16 + 1);
            }
            ++position;
            iter.advance(skip);
        }
        return h;
    }

    public static InputIterator find(InputIterator first, InputIterator last, Object object) {
        InputIterator firstx = (InputIterator)first.clone();
        while (!firstx.equals(last) && !firstx.get().equals(object)) {
            firstx.advance();
        }
        return firstx;
    }
}

