/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrType;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeGraphArc;
import agg.xt_basis.TypeGraphNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ArcTypeImpl
implements Type {
    String comment = "";
    String itsStringRepr;
    AttrType itsAttrType = null;
    String additionalRepr;
    String imageFileName = "";
    HashMap<Type, HashMap<Type, TypeGraphArc>> edgeTypeGraphObjects;
    boolean typeGraphObjectDefined;
    String keyStr = null;

    protected ArcTypeImpl() {
        this.itsStringRepr = "";
        this.additionalRepr = ":SOLID_LINE:java.awt.Color[r=0,g=0,b=0]::[EDGE]:";
        this.resetKey();
    }

    protected ArcTypeImpl(String name) {
        this.itsStringRepr = name;
        this.additionalRepr = ":SOLID_LINE:java.awt.Color[r=0,g=0,b=0]::[EDGE]:";
        this.resetKey();
    }

    protected ArcTypeImpl(AttrType at, String name) {
        this(name);
        this.itsAttrType = at;
    }

    protected ArcTypeImpl(AttrType at) {
        this();
        this.itsAttrType = at;
    }

    @Override
    public void dispose() {
        this.itsAttrType = null;
        if (this.edgeTypeGraphObjects != null) {
            for (HashMap<Type, TypeGraphArc> map : this.edgeTypeGraphObjects.values()) {
                Iterator<TypeGraphArc> iter1 = map.values().iterator();
                while (iter1.hasNext()) {
                    iter1.next().dispose();
                }
            }
            this.edgeTypeGraphObjects.clear();
            this.edgeTypeGraphObjects = null;
        }
        this.typeGraphObjectDefined = false;
    }

    public void finalize() {
    }

    @Override
    public void createAttributeType() {
        this.itsAttrType = AttrTupleManager.getDefaultManager().newType();
    }

    public void setAttributeType(AttrType at) {
        this.itsAttrType = at;
    }

    @Override
    public void removeAttributeType() {
        if (this.itsAttrType != null) {
            ((DeclTuple)this.itsAttrType).dispose();
            this.itsAttrType = null;
        }
    }

    @Override
    public boolean isAttrTypeEmpty() {
        return this.getAttrType() == null;
    }

    @Override
    public boolean hasAnyAttrMember() {
        return this.getAttrType() != null && this.getAttrType().getNumberOfEntries() != 0;
    }

    @Override
    public boolean isNodeType() {
        return false;
    }

    @Override
    public boolean isArcType() {
        return true;
    }

    @Override
    public String convertToKey() {
        if (this.keyStr == null) {
            this.keyStr = this.itsStringRepr.concat("%").concat(this.additionalRepr);
        }
        return this.keyStr;
    }

    @Override
    public String resetKey() {
        this.keyStr = this.itsStringRepr.concat("%").concat(this.additionalRepr);
        return this.keyStr;
    }

    @Override
    public void adaptTypeAttribute(Type type) {
        if (type.getAttrType() == null) {
            return;
        }
        if (this.itsAttrType == null) {
            this.itsAttrType = AttrTupleManager.getDefaultManager().newType();
        }
        DeclTuple declTuple = (DeclTuple)this.itsAttrType;
        DeclTuple otherTuple = (DeclTuple)type.getAttrType();
        int i = 0;
        while (i < otherTuple.getSize()) {
            DeclMember otherMem = (DeclMember)otherTuple.getMemberAt(i);
            if (otherMem.getHoldingTuple() == otherTuple) {
                String otherName = otherMem.getName();
                String otherType = otherMem.getTypeName();
                boolean nameFound = false;
                boolean conflict = false;
                DeclMember mem = null;
                int j = 0;
                while (j < declTuple.getSize()) {
                    mem = (DeclMember)declTuple.getMemberAt(j);
                    if (mem.getHoldingTuple() == declTuple) {
                        if (mem.getName().equals(otherName)) {
                            nameFound = true;
                            if (!mem.getTypeName().equals(otherType)) {
                                conflict = true;
                                break;
                            }
                            mem = null;
                            break;
                        }
                        mem = null;
                    }
                    ++j;
                }
                if (nameFound && conflict && mem != null && mem.getHoldingTuple() == declTuple) {
                    mem.setName(String.valueOf(mem.getName()) + "?");
                    declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherType, otherName);
                } else if (!nameFound) {
                    declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherType, otherName);
                }
            }
            ++i;
        }
    }

    @Override
    public void checkDoubleAttributeType() {
        if (this.itsAttrType == null) {
            return;
        }
        DeclTuple declTuple = (DeclTuple)this.itsAttrType;
        int i = 0;
        while (i < declTuple.getSize()) {
            DeclMember memi = (DeclMember)declTuple.getMemberAt(i);
            String n = memi.getName();
            boolean nameFound = false;
            boolean conflict = false;
            DeclMember memj = null;
            int j = i + 1;
            while (j < declTuple.getSize()) {
                memj = (DeclMember)declTuple.getMemberAt(j);
                if (memj.getName().equals(n)) {
                    nameFound = true;
                    conflict = true;
                }
                if (nameFound && conflict) {
                    memj.setName(String.valueOf(memj.getName()) + "?");
                }
                nameFound = false;
                conflict = false;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean compareTo(Type t) {
        if (!this.getStringRepr().equals(t.getStringRepr())) {
            return false;
        }
        if (!this.getAdditionalRepr().equals(t.getAdditionalRepr())) {
            return false;
        }
        if (this.itsAttrType != null) {
            return t.getAttrType() != null && ((DeclTuple)this.itsAttrType).getSize() == ((DeclTuple)t.getAttrType()).getSize() && ((DeclTuple)this.itsAttrType).weakcompareTo(t.getAttrType());
        }
        return t.getAttrType() == null;
    }

    public boolean differentTo(Type t, Vector<String> difference) {
        String diff = "";
        if (!this.getStringRepr().equals(t.getStringRepr())) {
            diff = "Type name# " + this.getStringRepr() + " != " + t.getStringRepr();
            difference.add(diff);
        }
        if (!this.getAdditionalRepr().equals(t.getAdditionalRepr())) {
            diff = "Type graphical repr# " + this.getAdditionalRepr() + " != " + t.getAdditionalRepr();
            difference.add(diff);
        }
        if (this.itsAttrType != null) {
            if (t.getAttrType() == null) {
                diff = "Attribute Type# defined (is not null) != not defined (is null)";
                difference.add(diff);
            } else if (((DeclTuple)this.itsAttrType).getSize() != ((DeclTuple)t.getAttrType()).getSize()) {
                diff = "Attr member count# " + ((DeclTuple)this.itsAttrType).getSize() + " != " + ((DeclTuple)t.getAttrType()).getSize();
                difference.add(diff);
            } else if (!this.itsAttrType.compareTo(t.getAttrType())) {
                DeclTuple dt1 = (DeclTuple)this.itsAttrType;
                DeclTuple dt2 = (DeclTuple)t.getAttrType();
                int i = 0;
                while (i < dt1.getSize()) {
                    DeclMember dm2;
                    DeclMember dm1 = (DeclMember)dt1.getMemberAt(i);
                    if (!dm1.compareTo(dm2 = (DeclMember)dt2.getMemberAt(i))) {
                        diff = String.valueOf(i) + ". " + "Member decl(type:name)# " + dm1.getTypeName() + ":" + dm1.getName() + " != " + dm2.getTypeName() + ":" + dm2.getName();
                        difference.add(diff);
                    }
                    ++i;
                }
            }
        } else if (t.getAttrType() != null) {
            diff = "Attribute Type# not defined (is null) != defined (is not null)";
            difference.add(diff);
        }
        return !difference.isEmpty();
    }

    @Override
    public final String getStringRepr() {
        return this.itsStringRepr;
    }

    @Override
    public final void setStringRepr(String n) {
        this.itsStringRepr = n;
        this.resetKey();
    }

    @Override
    public void setTextualComment(String text) {
        this.comment = text;
    }

    @Override
    public String getTextualComment() {
        return this.comment;
    }

    public Vector<String> checkDoubleAttributeName(Type otherType) {
        Vector<String> v = new Vector<String>(5, 5);
        if (this.itsAttrType == null || otherType.getAttrType() == null) {
            return v;
        }
        DeclTuple myDecl = (DeclTuple)this.itsAttrType;
        DeclTuple otherDecl = (DeclTuple)otherType.getAttrType();
        int i = 0;
        while (i < otherDecl.getNumberOfEntries()) {
            DeclMember mem = (DeclMember)otherDecl.getMemberAt(i);
            if (myDecl.isLegalName(mem.getName()) > 0 && mem.getHoldingTuple() != myDecl.getMemberAt(mem.getName()).getHoldingTuple()) {
                v.add(otherDecl.getNameAsString(i));
            }
            ++i;
        }
        return v;
    }

    @Override
    public final AttrType getAttrType() {
        return this.itsAttrType;
    }

    @Override
    public String getAdditionalRepr() {
        return this.additionalRepr;
    }

    @Override
    public void setAdditionalRepr(String repr) {
        this.additionalRepr = repr.equals("EDGE") || repr.equals("[EDGE]") ? ":SOLID_LINE:java.awt.Color[r=0,g=0,b=0]:[EDGE]:" : repr;
        this.resetKey();
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        String n = this.getStringRepr();
        if (this.getAdditionalRepr() != null && !this.getAdditionalRepr().equals("")) {
            n = String.valueOf(n) + "%" + this.getAdditionalRepr();
        }
        if (n.indexOf("[EDGE]") >= 0) {
            h.openNewElem("EdgeType", this);
        } else {
            h.openNewElem("Type", this);
        }
        h.addAttr("name", n);
        if (!this.comment.equals("")) {
            h.addAttr("comment", this.comment);
        }
        h.addAttr("abstract", String.valueOf(false));
        if (this.itsAttrType != null && this.itsAttrType.getNumberOfEntries() > 0) {
            h.addObject("", this.itsAttrType, true);
        }
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("NodeType", this) || h.isTag("EdgeType", this) || h.isTag("Type", this)) {
            String test;
            String n = h.readAttr("name");
            String str = h.readAttr("comment");
            if (!str.equals("")) {
                this.comment = str.toString();
            }
            h.readAttr("abstract");
            int i = n.indexOf(37);
            if (i != -1) {
                test = n.substring(0, i);
                this.itsStringRepr = test = XMLHelper.checkNameDueToSpecialCharacters(test);
            } else {
                this.itsStringRepr = test = XMLHelper.checkNameDueToSpecialCharacters(n);
            }
            AttrType tmpAttr = AttrTupleManager.getDefaultManager().newType();
            h.enrichObject(tmpAttr);
            this.itsAttrType = tmpAttr.getNumberOfEntries() != 0 ? tmpAttr : null;
            if (i != -1) {
                String a = n.substring(i + 1);
                a = a.replaceAll("::", ":");
                n = n.substring(0, i);
                this.setAdditionalRepr(a);
            }
            h.close();
        }
    }

    @Override
    public String getName() {
        String stringRepr = this.getStringRepr();
        if ("".equals(stringRepr)) {
            return "unnamed";
        }
        return stringRepr;
    }

    @Override
    public TypeError check(GraphObject nodeOrArc, int level) {
        if (level == 0) {
            return null;
        }
        if (nodeOrArc instanceof Arc) {
            return this.check((Arc)nodeOrArc, level);
        }
        throw new IllegalArgumentException("parameter must be of Arc type.");
    }

    @Override
    public boolean hasTypeGraphArc(Type sourceType) {
        if (this.edgeTypeGraphObjects != null) {
            Vector<Type> mySrcParents = sourceType.getAllParents();
            int i = 0;
            while (i < mySrcParents.size()) {
                Type mySrcType = mySrcParents.get(i);
                HashMap<Type, TypeGraphArc> targets = this.edgeTypeGraphObjects.get(mySrcType);
                if (targets != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Vector<Type> getTargetsOfArc(Type sourceType) {
        Vector<Type> v = new Vector<Type>();
        if (this.edgeTypeGraphObjects != null) {
            Vector<Type> mySrcParents = sourceType.getAllParents();
            int i = 0;
            while (i < mySrcParents.size()) {
                Type mySrcType = mySrcParents.get(i);
                HashMap<Type, TypeGraphArc> targets = this.edgeTypeGraphObjects.get(mySrcType);
                if (targets != null) {
                    for (Type t : targets.keySet()) {
                        v.add(t);
                        Vector<Type> childs = t.getChildren();
                        int j = 0;
                        while (j < childs.size()) {
                            Type cht = childs.get(j);
                            v.add(cht);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return v;
    }

    @Override
    public boolean isEdgeCreatable(Type sourceType, Type targetType, int level) {
        Type mySrcType = sourceType;
        Type myTarType = targetType;
        Vector<Type> mySrcParents = sourceType.getAllParents();
        Vector<Type> myTarParents = targetType.getAllParents();
        TypeGraphArc subType = null;
        if (this.edgeTypeGraphObjects != null) {
            int j;
            HashMap<Type, TypeGraphArc> targets;
            int i = 0;
            while (i < mySrcParents.size()) {
                mySrcType = mySrcParents.get(i);
                targets = this.edgeTypeGraphObjects.get(mySrcType);
                if (targets != null) {
                    j = 0;
                    while (j < myTarParents.size()) {
                        myTarType = myTarParents.get(j);
                        subType = targets.get(myTarType);
                        if (subType != null) break;
                        ++j;
                    }
                    if (subType != null) break;
                }
                ++i;
            }
            if (subType == null) {
                i = 0;
                while (i < myTarParents.size()) {
                    myTarType = myTarParents.get(i);
                    targets = this.edgeTypeGraphObjects.get(myTarType);
                    if (targets != null) {
                        j = 0;
                        while (j < mySrcParents.size()) {
                            mySrcType = mySrcParents.get(j);
                            subType = targets.get(mySrcType);
                            if (subType != null) break;
                            ++j;
                        }
                        if (subType != null) break;
                    }
                    ++i;
                }
            }
        }
        return subType != null;
    }

    public TypeError check(Arc arc, int level) {
        if (this.edgeTypeGraphObjects != null) {
            Type sourceType = arc.getSource().getType();
            Type targetType = arc.getTarget().getType();
            Vector<Type> mySrcParents = sourceType.getAllParents();
            Vector<Type> myTarParents = targetType.getAllParents();
            Type mySrcType = arc.getSource().getType();
            Type myTarType = arc.getTarget().getType();
            TypeGraphArc subType = null;
            int i = 0;
            while (i < mySrcParents.size()) {
                mySrcType = mySrcParents.get(i);
                HashMap<Type, TypeGraphArc> targets = this.edgeTypeGraphObjects.get(mySrcType);
                if (targets != null) {
                    int j = 0;
                    while (j < myTarParents.size()) {
                        myTarType = myTarParents.get(j);
                        subType = targets.get(myTarType);
                        if (subType != null) break;
                        ++j;
                    }
                    if (subType != null) break;
                }
                ++i;
            }
            if (subType != null && subType.doesTypeGraphObjectExist()) {
                if (level > 10) {
                    int count = 0;
                    int sourceMax = subType.getSourceMax();
                    int targetMax = subType.getTargetMax();
                    int sourceMin = subType.getSourceMin();
                    int targetMin = subType.getTargetMin();
                    if (targetMax != -1 && (count = ((Node)arc.getSource()).getNumberOfOutgoingArcsOfTypeToTargetType(this, myTarType)) > targetMax) {
                        String isOrAre = "is";
                        if (targetMax != 1) {
                            isOrAre = "are";
                        }
                        return new TypeError(22, "- Too many edges of type \"" + this.getName() + "\" end at the node of type \"" + myTarType.getName() + "\".\nThere " + isOrAre + " only " + targetMax + " allowed ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                    }
                    if (sourceMax != -1 && (count = ((Node)arc.getTarget()).getNumberOfIncomingArcsOfTypeFromSourceType(this, mySrcType)) > sourceMax) {
                        String isOrAre = "is";
                        if (sourceMax != 1) {
                            isOrAre = "are";
                        }
                        return new TypeError(22, "- Too many edges of type \"" + this.getName() + "\" start at the node of type \"" + mySrcType.getName() + "\".\nThere " + isOrAre + " only " + sourceMax + " allowed ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                    }
                    if (level >= 30) {
                        if (targetMin > 0 && (count = ((Node)arc.getSource()).getNumberOfOutgoingArcsOfTypeToTargetType(this, myTarType)) < targetMin) {
                            String isOrAre = "is";
                            if (targetMin != 1) {
                                isOrAre = "are";
                            }
                            return new TypeError(23, "- Too few edges of type \"" + this.getName() + "\" end at the node of type \"" + targetType.getName() + "\".\nThere " + isOrAre + " at least " + targetMin + " required ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                        }
                        if (sourceMin > 0 && (count = ((Node)arc.getTarget()).getNumberOfIncomingArcsOfTypeFromSourceType(this, mySrcType)) < sourceMin) {
                            String isOrAre = "is";
                            if (sourceMin != 1) {
                                isOrAre = "are";
                            }
                            return new TypeError(23, "- Too few edges of type \"" + this.getName() + "\" start at the node of type \"" + sourceType.getName() + "\".\nThere " + isOrAre + " at least " + sourceMin + " required ( graph \"" + arc.getContext().getName() + "\" ).", arc, this);
                        }
                    }
                }
                return null;
            }
            if (level > 5) {
                return new TypeError(21, "- The type graph does not contain an edge type with name \"" + this.getName() + "\" \nbetween node type \"" + sourceType.getName() + "\" and \"" + targetType.getName() + "\"" + "\n ( see graph:  " + arc.getContext().getName() + " ).", arc, this);
            }
        }
        return null;
    }

    @Override
    public TypeError checkIfEdgeCreatable(Node src, Node tar, int level) {
        return this.checkIfEdgeCreatable(null, src, tar, level);
    }

    @Override
    public TypeError checkIfEdgeCreatable(Graph g, Node src, Node tar, int level) {
        if (level == 0 || level == 5 || level == 10) {
            return null;
        }
        TypeError typeError = this.checkSourceMax(g, src, tar);
        if (typeError == null) {
            typeError = this.checkTargetMax(g, src, tar);
        }
        return typeError;
    }

    @Override
    public TypeError checkSourceMax(Graph g, Node src, Node tar) {
        TypeGraphArc subType;
        HashMap<Type, TypeGraphArc> targets;
        String graphName = "";
        if (g != null) {
            graphName = g.getName();
        }
        Type sourceType = src.getType();
        Type targetType = tar.getType();
        if (this.edgeTypeGraphObjects != null && (targets = this.edgeTypeGraphObjects.get(sourceType)) != null && (subType = targets.get(targetType)) != null && subType.doesTypeGraphObjectExist()) {
            int count;
            int sourceMax = subType.getSourceMax();
            if (sourceMax != -1 && (count = tar.getNumberOfIncomingArcs(this, sourceType)) + 1 > sourceMax) {
                String isOrAre = "is";
                if (sourceMax != 1) {
                    isOrAre = "are";
                }
                return new TypeError(22, "Too many edges of type \"" + this.getName() + "\" (would) start at the node of type \"" + src.getType().getName() + "\" (green marked node).\nThere " + isOrAre + " only " + sourceMax + " allowed ( graph \"" + graphName + "\" ).", tar, this);
            }
            return null;
        }
        return null;
    }

    @Override
    public TypeError checkTargetMax(Graph g, Node src, Node tar) {
        TypeGraphArc subType;
        HashMap<Type, TypeGraphArc> targets;
        String graphName = "";
        if (g != null) {
            graphName = g.getName();
        }
        Type sourceType = src.getType();
        Type targetType = tar.getType();
        if (this.edgeTypeGraphObjects != null && (targets = this.edgeTypeGraphObjects.get(sourceType)) != null && (subType = targets.get(targetType)) != null && subType.doesTypeGraphObjectExist()) {
            int count;
            int targetMax = subType.getTargetMax();
            if (targetMax != -1 && (count = src.getNumberOfOutgoingArcs(this, targetType)) + 1 > targetMax) {
                String isOrAre = "is";
                if (targetMax != 1) {
                    isOrAre = "are";
                }
                return new TypeError(22, "Too many edges of type \"" + this.getName() + "\" (would) end at the node of type \"" + targetType.getName() + "\" (green marked node).\nThere " + isOrAre + " only " + targetMax + " allowed ( graph \"" + graphName + "\" ).", src, this);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean addTypeGraphObject(GraphObject arc) {
        Type targetType;
        Type sourceType;
        TypeGraphArc subType;
        if (arc instanceof Arc && arc.getContext().isTypeGraph() && (subType = this.getTypeGraphArc(sourceType = ((Arc)arc).getSource().getType(), targetType = ((Arc)arc).getTarget().getType())).getArc() == null) {
            subType.addTypeGraphObject((Arc)arc);
            this.typeGraphObjectDefined = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTypeGraphObject(GraphObject arc, boolean forceToRemove) {
        if (arc == null || !arc.isArc() || arc.getContext() == null || !arc.getContext().isTypeGraph()) {
            return true;
        }
        boolean allowedToRemove = false;
        allowedToRemove = arc.getContext().getTypeSet().getLevelOfTypeGraphCheck() <= 5 ? true : forceToRemove;
        if (allowedToRemove) {
            if (this.edgeTypeGraphObjects == null) {
                return true;
            }
            Type sourceType = ((Arc)arc).getSource().getType();
            Type targetType = ((Arc)arc).getTarget().getType();
            HashMap<Type, TypeGraphArc> targets = this.edgeTypeGraphObjects.get(sourceType);
            if (targets == null) {
                return true;
            }
            TypeGraphArc subType = targets.get(targetType);
            if (subType == null) {
                return true;
            }
            if (arc.getContext().getTypeSet().getLevelOfTypeGraphCheck() <= 5) {
                subType.forceRemoveTypeGraphObject();
            } else if (forceToRemove) {
                subType.forceRemoveTypeGraphObject();
            } else if (!subType.removeTypeGraphObject()) {
                return false;
            }
            targets.remove(targetType);
            if (targets.isEmpty()) {
                this.edgeTypeGraphObjects.remove(sourceType);
                if (this.edgeTypeGraphObjects.isEmpty()) {
                    this.edgeTypeGraphObjects = null;
                    this.typeGraphObjectDefined = false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTypeGraphObject(GraphObject arc) {
        return this.removeTypeGraphObject(arc, false);
    }

    @Override
    public void setSourceMin(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setSourceMin(value);
    }

    @Override
    public void setSourceMax(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setSourceMax(value);
    }

    @Override
    public void setTargetMin(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setTargetMin(value);
    }

    @Override
    public void setTargetMax(Type sourceType, Type targetType, int value) {
        this.getTypeGraphArc(sourceType, targetType).setTargetMax(value);
    }

    @Override
    public int getSourceMin(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getSourceMin();
    }

    @Override
    public int getSourceMax(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getSourceMax();
    }

    @Override
    public int getTargetMin(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getTargetMin();
    }

    @Override
    public int getTargetMax(Type sourceType, Type targetType) {
        return this.getTypeGraphArc(sourceType, targetType).getTargetMax();
    }

    @Override
    public void setVisibityOfObjectsOfTypeGraphArc(Type sourceType, Type targetType, boolean vis) {
        TypeGraphArc tgarc = this.getTypeGraphArc(sourceType, targetType);
        if (tgarc != null) {
            tgarc.setVisible(vis);
        }
    }

    @Override
    public boolean isObjectOfTypeGraphArcVisible(Type sourceType, Type targetType) {
        TypeGraphArc tgarc = this.getTypeGraphArc(sourceType, targetType);
        return tgarc == null || tgarc.isVisible();
    }

    @Override
    public Arc getTypeGraphArcObject(Type sourceType, Type targetType) {
        TypeGraphArc tgarc = this.getTypeGraphArc(sourceType, targetType);
        if (tgarc != null) {
            return tgarc.getArc();
        }
        return null;
    }

    @Override
    public TypeGraphArc getTypeGraphArc(Type sourceType, Type targetType) {
        Type mySrcType = sourceType;
        Type myTarType = targetType;
        Vector<Type> mySrcParents = sourceType.getAllParents();
        Vector<Type> myTarParents = targetType.getAllParents();
        HashMap<Type, TypeGraphArc> targets = null;
        TypeGraphArc subType = null;
        if (this.edgeTypeGraphObjects == null) {
            this.edgeTypeGraphObjects = new HashMap();
            this.typeGraphObjectDefined = true;
        }
        int i = 0;
        while (i < mySrcParents.size()) {
            mySrcType = mySrcParents.get(i);
            targets = this.edgeTypeGraphObjects.get(mySrcType);
            if (targets != null) {
                int j = 0;
                while (j < myTarParents.size()) {
                    myTarType = myTarParents.get(j);
                    subType = targets.get(myTarType);
                    if (subType != null) {
                        return subType;
                    }
                    ++j;
                }
            }
            ++i;
        }
        targets = this.edgeTypeGraphObjects.get(sourceType);
        if (targets == null) {
            targets = new HashMap();
            this.edgeTypeGraphObjects.put(sourceType, targets);
            subType = new TypeGraphArc();
            targets.put(targetType, subType);
        }
        if (subType == null) {
            subType = new TypeGraphArc();
            targets.put(targetType, subType);
        }
        return subType;
    }

    @Override
    public TypeGraphArc getSimilarTypeGraphArc(Type sourceType, Type targetType) {
        for (Type srct : this.edgeTypeGraphObjects.keySet()) {
            if (!srct.compareTo(sourceType)) continue;
            HashMap<Type, TypeGraphArc> targetsMap = this.edgeTypeGraphObjects.get(srct);
            for (Type tart : targetsMap.keySet()) {
                if (!tart.compareTo(targetType)) continue;
                TypeGraphArc subType = targetsMap.get(tart);
                return subType;
            }
        }
        return null;
    }

    @Override
    public boolean hasTypeGraphArc() {
        return this.edgeTypeGraphObjects != null;
    }

    @Override
    public boolean hasTypeGraphArc(Type sourceType, Type targetType) {
        if (this.edgeTypeGraphObjects == null) {
            return false;
        }
        Type mySrcType = sourceType;
        Type myTarType = targetType;
        Vector<Type> mySrcParents = sourceType.getAllParents();
        Vector<Type> myTarParents = targetType.getAllParents();
        TypeGraphArc subType = null;
        int i = 0;
        while (i < mySrcParents.size()) {
            mySrcType = mySrcParents.get(i);
            HashMap<Type, TypeGraphArc> targets = this.edgeTypeGraphObjects.get(mySrcType);
            if (targets != null) {
                int j = 0;
                while (j < myTarParents.size()) {
                    myTarType = myTarParents.get(j);
                    subType = targets.get(myTarType);
                    if (subType != null) break;
                    ++j;
                }
                if (subType != null) break;
            }
            ++i;
        }
        return subType != null;
    }

    @Override
    public boolean hasTypeGraphArc(GraphObject sourceType, GraphObject targetType) {
        return this.hasTypeGraphArc(sourceType.getType(), targetType.getType());
    }

    @Override
    public HashMap<Type, HashMap<Type, TypeGraphArc>> getArcTypeGraphObjects() {
        return this.edgeTypeGraphObjects;
    }

    @Override
    public boolean compareTypeGraphArcs(Type t) {
        if (this.edgeTypeGraphObjects == null && ((ArcTypeImpl)t).getArcTypeGraphObjects() == null) {
            return true;
        }
        if (this.edgeTypeGraphObjects != null && ((ArcTypeImpl)t).getArcTypeGraphObjects() != null) {
            if (!this.edgeTypeGraphObjects.isEmpty() && !((ArcTypeImpl)t).getArcTypeGraphObjects().isEmpty()) {
                for (Type srct : this.edgeTypeGraphObjects.keySet()) {
                    HashMap<Type, TypeGraphArc> targetsMap = this.edgeTypeGraphObjects.get(srct);
                    for (Type tart : targetsMap.keySet()) {
                        TypeGraphArc subType_t = ((ArcTypeImpl)t).getSimilarTypeGraphArc(srct, tart);
                        if (subType_t == null) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean compareTypeGraphArcsMultiplicity(Type t) {
        if (this.edgeTypeGraphObjects == null && ((ArcTypeImpl)t).getArcTypeGraphObjects() == null) {
            return true;
        }
        if (this.edgeTypeGraphObjects != null && ((ArcTypeImpl)t).getArcTypeGraphObjects() != null) {
            if (!this.edgeTypeGraphObjects.isEmpty() && !((ArcTypeImpl)t).getArcTypeGraphObjects().isEmpty()) {
                for (Type srct : this.edgeTypeGraphObjects.keySet()) {
                    HashMap<Type, TypeGraphArc> targetsMap = this.edgeTypeGraphObjects.get(srct);
                    for (Type tart : targetsMap.keySet()) {
                        TypeGraphArc subType = targetsMap.get(tart);
                        TypeGraphArc subType_t = ((ArcTypeImpl)t).getSimilarTypeGraphArc(srct, tart);
                        if (subType_t == null) continue;
                        if (subType.getSourceMax() != subType_t.getSourceMax()) {
                            return false;
                        }
                        if (subType.getSourceMin() != subType_t.getSourceMin()) {
                            return false;
                        }
                        if (subType.getTargetMin() != subType_t.getTargetMin()) {
                            return false;
                        }
                        return subType.getTargetMax() == subType_t.getTargetMax();
                    }
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void disableTypeGraphObject() {
        if (this.edgeTypeGraphObjects != null) {
            Iterator<HashMap<Type, TypeGraphArc>> iter = this.edgeTypeGraphObjects.values().iterator();
            while (iter.hasNext()) {
                HashMap<Type, TypeGraphArc> actMap = iter.next();
                for (TypeGraphArc subType : actMap.values()) {
                    subType.forceRemoveTypeGraphObject();
                }
                if (!actMap.isEmpty()) continue;
                iter.remove();
            }
            if (this.edgeTypeGraphObjects.isEmpty()) {
                this.edgeTypeGraphObjects = null;
                this.typeGraphObjectDefined = false;
            }
        }
    }

    @Override
    public boolean isTypeGraphObjectDefined() {
        return this.typeGraphObjectDefined;
    }

    @Override
    public TypeError checkIfRemovableFromSource(GraphObject node, Arc arc, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkSourceMin(node, arc, false, false);
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromSource(GraphObject node, Arc arc, boolean deleteSrc, boolean deleteTar, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkSourceMin(node, arc, deleteSrc, deleteTar);
        }
        return null;
    }

    private TypeError checkSourceMin(GraphObject srcnode, Arc arc, boolean deleteSrc, boolean deleteTar) {
        int count;
        int sourceMin = arc.getType().getSourceMin(this, arc.getTarget().getType());
        if (sourceMin != -1 && (count = ((Node)arc.getTarget()).getNumberOfIncomingArcs(arc.getType(), srcnode.getType())) - 1 < sourceMin && !deleteTar) {
            return new TypeError(23, "Too few edges of type \"" + arc.getType().getName() + "\"" + " (would) start at the source node  " + "\"" + arc.getSource().getType().getName() + "\"." + "\nThere are at least " + sourceMin + " needed ( graph \"" + srcnode.getContext().getName() + "\" ).", arc, this);
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromTarget(GraphObject node, Arc arc, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkTargetMin(node, arc, false, false);
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromTarget(GraphObject node, Arc arc, boolean deleteSrc, boolean deleteTar, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkTargetMin(node, arc, deleteSrc, deleteTar);
        }
        return null;
    }

    private TypeError checkTargetMin(GraphObject tarnode, Arc arc, boolean deleteSrc, boolean deleteTar) {
        int count;
        int targetMin = arc.getType().getTargetMin(arc.getSource().getType(), this);
        if (targetMin != -1 && (count = ((Node)arc.getSource()).getNumberOfOutgoingArcs(arc.getType(), tarnode.getType())) - 1 < targetMin && !deleteSrc) {
            return new TypeError(23, "Too few edges of type \"" + arc.getType().getName() + "\"" + " (would) end at the target node  " + "\"" + arc.getTarget().getType().getName() + "\"." + "\nThere are at least " + targetMin + " needed ( graph \"" + tarnode.getContext().getName() + "\" ).", arc, this);
        }
        return null;
    }

    @Override
    public boolean isParentOf(Type t) {
        return t.compareTo(this);
    }

    @Override
    public boolean isRelatedTo(Type t) {
        return t.compareTo(this);
    }

    @Override
    public void addParent(Type t) {
    }

    @Override
    public TypeError checkIfNodeCreatable(Graph basisGraph, int levelOfTypeGraphCheck) {
        return null;
    }

    @Override
    public TypeError checkIfRemovable(Node node, int level) {
        return null;
    }

    @Override
    public Vector<Type> getAllChildren() {
        return new Vector<Type>(0);
    }

    @Override
    public Vector<Type> getAllParents() {
        return new Vector<Type>(0);
    }

    @Override
    public Vector<Type> getChildren() {
        return new Vector<Type>(0);
    }

    @Override
    public List<Type> getCommonParentWith(Type t) {
        return new Vector<Type>(0);
    }

    @Override
    public String getImageFilename() {
        return "";
    }

    @Override
    public Type getParent() {
        return null;
    }

    @Override
    public Vector<Type> getParents() {
        return new Vector<Type>(0);
    }

    @Override
    public int getSourceMax() {
        return 0;
    }

    @Override
    public int getSourceMin() {
        return 0;
    }

    @Override
    public Node getTypeGraphNodeObject() {
        return null;
    }

    @Override
    public boolean hasTypeGraphNode() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isChildOf(Type t) {
        return false;
    }

    @Override
    public boolean isObjectOfTypeGraphNodeVisible() {
        return false;
    }

    @Override
    public void removeParent(Type t) {
    }

    @Override
    public void setAbstract(boolean b) {
    }

    @Override
    public void setImageFilename(String imageFilename) {
    }

    @Override
    public void setParent(Type t) {
    }

    @Override
    public void setSourceMax(int value) {
    }

    @Override
    public void setSourceMin(int value) {
    }

    @Override
    public void setVisibilityOfObjectsOfTypeGraphNode(boolean vis) {
    }

    @Override
    public boolean hasInheritedAttribute() {
        return false;
    }

    @Override
    public int getMaxMultiplicityOfAllChildren() {
        return 0;
    }

    @Override
    public int getMinMultiplicityOfAllChildren() {
        return 0;
    }

    public boolean isChildTypeGraphNodeUsed() {
        return false;
    }

    public boolean isTypeGraphNodeUsed() {
        return false;
    }

    @Override
    public void addChild(Type t) {
    }

    public Vector<Arc> getOwnIncomingArcs() {
        return new Vector<Arc>(0);
    }

    @Override
    public Vector<Type> getOwnIncomingArcTypes() {
        return new Vector<Type>(0);
    }

    @Override
    public Vector<Type> getOwnOutgoingArcTypes() {
        return new Vector<Type>(0);
    }

    public Vector<Arc> getOwnOutgoingArcs() {
        return new Vector<Arc>(0);
    }

    @Override
    public void removeChild(Type t) {
    }

    @Override
    public TypeGraphNode getTypeGraphNode() {
        return null;
    }

    @Override
    public List<Type> getClan() {
        return new Vector<Type>(0);
    }

    @Override
    public boolean hasCommonParentWith(Type t) {
        return false;
    }

    @Override
    public boolean isInClanOf(Type t) {
        return false;
    }

    @Override
    public boolean hasChild() {
        return false;
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public boolean isParentAttrTypeEmpty() {
        return true;
    }
}

