/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ocl.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.ocl.Activator;
import org.eclipse.emf.search.ocl.l10n.Messages;
import org.eclipse.emf.search.ocl.services.TargetMetaModelDescriptor;

public final class TargetMetaModelExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String MODELING_TARGET_METAMODEL_EXT_POINT_ID = String.valueOf(bundleId) + ".targetMetaModel";
    private static TargetMetaModelExtensionManager manager;
    private SortedSet<TargetMetaModelDescriptor> searchEngineContributions = new TreeSet<TargetMetaModelDescriptor>(new Comparator<TargetMetaModelDescriptor>(){

        @Override
        public int compare(TargetMetaModelDescriptor o1, TargetMetaModelDescriptor o2) {
            return o1.getNsURI().compareTo(o2.getNsURI());
        }
    });

    protected TargetMetaModelExtensionManager() {
        super(MODELING_TARGET_METAMODEL_EXT_POINT_ID);
        this.readRegistry();
    }

    public static TargetMetaModelExtensionManager getInstance() {
        return manager == null ? (manager = new TargetMetaModelExtensionManager()) : manager;
    }

    public TargetMetaModelDescriptor find(String id) {
        for (TargetMetaModelDescriptor desc : this.searchEngineContributions) {
            if (!id.equals(desc.getNsURI())) continue;
            return desc;
        }
        return null;
    }

    public TargetMetaModelDescriptor[] getModelSearchEngines() {
        return this.searchEngineContributions.toArray(new TargetMetaModelDescriptor[this.searchEngineContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement confElt = elements[i];
            try {
                this.searchEngineContributions.add(new TargetMetaModelDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ModelExtensibleSearchEngineExtensionManager.addExtensionErrorMessage"), (Throwable)ce));
            }
            ++i;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement confElt = elements[i];
            String id = confElt.getAttribute("nsURI");
            TargetMetaModelDescriptor descriptor = this.find(id);
            this.searchEngineContributions.remove(descriptor);
            ++i;
        }
    }
}

