/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.common.migrate.FeatureKey;
import org.eclipse.gmf.internal.common.migrate.MigrationResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationConfig {
    private final String metamodelURI;
    private Set<String> backwardSupportedURIs = Collections.emptySet();
    private final LinkedHashMap<FeatureKey, EClass> addedERefTypes = new LinkedHashMap();
    private final Map<String, Set<EClass>> deletedAttributes = new HashMap<String, Set<EClass>>();

    public MigrationConfig(String metamodelNsURI, String[] backwardSupportedURIs) {
        if (metamodelNsURI == null) {
            throw new IllegalArgumentException("null metamodel");
        }
        this.metamodelURI = metamodelNsURI;
        int i = 0;
        while (i < backwardSupportedURIs.length) {
            this.addBackwardSupportedNsURIs(backwardSupportedURIs[i]);
            ++i;
        }
    }

    public String getMetamodelNsURI() {
        return this.metamodelURI;
    }

    public Set<String> backwardSupportedNsURIs() {
        return Collections.unmodifiableSet(this.backwardSupportedURIs);
    }

    public void registerDeletedAttribute(EClass attributeOwner, String attrName) {
        assert (attributeOwner != null && attrName != null);
        Set<EClass> known = this.deletedAttributes.get(attrName);
        if (known == null) {
            known = new HashSet<EClass>();
            this.deletedAttributes.put(attrName, known);
        }
        known.add(attributeOwner);
    }

    public boolean shouldIgnoreAttribute(EObject object, String attrName) {
        Set<EClass> known = this.deletedAttributes.get(attrName);
        if (known == null) {
            return false;
        }
        EClass objClass = object.eClass();
        for (EClass c : known) {
            if (!c.isSuperTypeOf(objClass)) continue;
            return true;
        }
        return false;
    }

    public void addNarrowReferenceType(EReference reference, EClass oldReferenceType) {
        if (reference == null || oldReferenceType == null) {
            throw new IllegalArgumentException("Null reference or old reference type");
        }
        if (!reference.getEReferenceType().isSuperTypeOf(oldReferenceType) || oldReferenceType.isAbstract() || oldReferenceType.isInterface()) {
            throw new IllegalArgumentException("Non-compliant reference types");
        }
        if (reference.getEReferenceType() == oldReferenceType) {
            throw new IllegalArgumentException("Identical reference types");
        }
        if (this.addedERefTypes.containsKey(reference)) {
            throw new IllegalArgumentException("Reference already has a migration entry");
        }
        this.addedERefTypes.put(FeatureKey.create((EStructuralFeature)reference), oldReferenceType);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.getMetamodelNsURI();
    }

    EClass getAddedTypeInfo(FeatureKey reference) {
        return this.addedERefTypes.get(reference);
    }

    private void addBackwardSupportedNsURIs(String nsURI) {
        if (nsURI == null || nsURI.equals(this.metamodelURI)) {
            throw new IllegalArgumentException();
        }
        if (this.backwardSupportedURIs.isEmpty()) {
            this.backwardSupportedURIs = new HashSet<String>();
        }
        this.backwardSupportedURIs.add(nsURI);
    }

    protected void handleResourceLoaded(Resource resource, Map<EObject, Map<String, String>> ignoredAttributes) {
    }

    protected boolean handleCreateObject(MigrationResource.MigrationHandler handler, EObject peekObject, EStructuralFeature feature) {
        return false;
    }

    protected boolean handleFeature(MigrationResource.MigrationHandler handler, String prefix, String name) {
        return false;
    }

    public static interface Registry {
        public static final Registry INSTANCE = new RegistryImpl();

        public MigrationConfig getConfig(String var1);

        public void register(Descriptor var1);
    }

    public static interface Descriptor {
        public String getExtension();

        public MigrationConfig getConfig();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistryImpl
    extends HashMap<String, Object>
    implements Registry {
        RegistryImpl() {
        }

        @Override
        public MigrationConfig getConfig(String ext) {
            Object regEntry = this.get(ext);
            if (regEntry instanceof MigrationConfig) {
                return (MigrationConfig)regEntry;
            }
            if (regEntry instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)regEntry;
                MigrationConfig migrationConfig = descriptor.getConfig();
                this.put(ext, migrationConfig);
                return migrationConfig;
            }
            return null;
        }

        @Override
        public void register(Descriptor descriptor) {
            if (descriptor == null || descriptor.getExtension() == null) {
                throw new IllegalArgumentException("null extension or descriptor");
            }
            this.put(descriptor.getExtension(), descriptor);
        }
    }
}

