/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.ecore.navigator.EcoreAbstractNavigatorItem;
import org.eclipse.gmf.ecore.navigator.EcoreNavigatorGroup;
import org.eclipse.gmf.ecore.navigator.EcoreNavigatorItem;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorInput;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public class EcoreNavigatorLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (!(aSelection.getFirstElement() instanceof EcoreAbstractNavigatorItem)) {
            return;
        }
        EcoreAbstractNavigatorItem navigatorItem = (EcoreAbstractNavigatorItem)aSelection.getFirstElement();
        View navigatorView = null;
        if (navigatorItem instanceof EcoreNavigatorItem) {
            navigatorView = ((EcoreNavigatorItem)navigatorItem).getView();
        } else if (navigatorItem instanceof EcoreNavigatorGroup) {
            EcoreNavigatorGroup group = (EcoreNavigatorGroup)navigatorItem;
            if (group.getParent() instanceof EcoreNavigatorItem) {
                navigatorView = ((EcoreNavigatorItem)group.getParent()).getView();
            } else if (group.getParent() instanceof IAdaptable) {
                navigatorView = (View)((IAdaptable)group.getParent()).getAdapter(View.class);
            }
        }
        if (navigatorView == null) {
            return;
        }
        DiagramEditorInput editorInput = new DiagramEditorInput(navigatorView.getDiagram());
        IEditorPart editor = aPage.findEditor((IEditorInput)editorInput);
        if (editor == null) {
            return;
        }
        aPage.bringToTop((IWorkbenchPart)editor);
        if (editor instanceof DiagramEditor) {
            DiagramEditor diagramEditor = (DiagramEditor)editor;
            Resource diagramResource = diagramEditor.getDiagram().eResource();
            EObject selectedView = diagramResource.getEObject(navigatorView.eResource().getURIFragment((EObject)navigatorView));
            if (selectedView == null) {
                return;
            }
            EditPart selectedEditPart = (EditPart)diagramEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(selectedView);
            if (selectedEditPart != null) {
                diagramEditor.getDiagramGraphicalViewer().select(selectedEditPart);
            }
        }
    }
}

